/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.MenuElement;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.JSONDataGuideObserver;
import oracle.dmt.dataminer.controls.JSONHelper;
import oracle.dmt.dataminer.controls.JSONStructurePanel;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.JSONDataGuideExportPreferences;
import oracle.dmt.dataminer.workflow.dialog.data.JSONDataGuideImportPreferences;
import oracle.dmt.dataminer.workflow.dialog.data.JSONDataSourceDataPanel;
import oracle.dmt.dataminer.workflow.dialog.data.JSONDataSourceStructurePanel;
import oracle.dmt.dataminer.workflow.dialog.data.JSONImportDataGuide;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideGenEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.JMultiLineLabel;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class EditDataGuidePanel
extends AbstractPanel<AbstractDataNode>
implements DataConsumerPanel,
JSONDataGuideObserver {
    private static final Logger LOGGER = Logger.getLogger(DatabaseMetadataUtils.class.getName());
    private static String _empty_string = "";
    private static String _utf8 = "UTF-8";
    private static String _csv = "csv";
    private static String _stardotcsv = "*.csv";
    private static String _dotcsv = ".csv";
    private static String _dotcsv_description = "CSV(Comma delimited)";
    public static String import_from_workflow = ControlsLrb.get("JSON_DATA_GUIDE_GENERATION_COMBO_IMPORT_FROM_WF");
    public static String import_from_file = ControlsLrb.get("JSON_DATA_GUIDE_GENERATION_COMBO_IMPORT_FROM_FILE");
    public static String default_data_gen = ControlsLrb.get("JSON_DATA_GUIDE_GENERATION_COMBO_DEFAULT");
    public static String on_data_gen = ControlsLrb.get("JSON_DATA_GUIDE_GENERATION_COMBO_ON");
    public static String off_data_gen = ControlsLrb.get("JSON_DATA_GUIDE_GENERATION_COMBO_OFF");
    public static String[] dataGuideGenerationOptions = new String[]{default_data_gen, on_data_gen, off_data_gen, import_from_workflow, import_from_file};
    private static final String SHOW_EXPORT_SUCCESS = "show_export_completed_successfully";
    private static final String STRUCTURE_TAB = DataDialogsLrb.get("EDIT_DATA_GUIDE_PANEL_STRUCTURE_TAB");
    private static final String DATA_TAB = DataDialogsLrb.get("EDIT_DATA_GUIDE_PANEL_DATA_TAB");
    private AttributeType editedAttribute;
    private JSONColumnsType.Attribute copyJSONAttributeMetadata;
    private JSONColumnsType.Attribute referenceJSONAttributeMetadata;
    private JSONStructurePanel dataGuideStructurePanel;
    private JSONDataSourceDataPanel dataGuideDataPanel;
    boolean readOnlyMode = false;
    private JMultiLineLabel jLblValuesProcessedValue = new JMultiLineLabel();
    private JTabbedPane jGuideTabPane;
    private JLabel jLblValuesProcessedLabel;
    private JScrollPane jScrollPaneLabel;

    public static String linefeforeSeparator() {
        return dataGuideGenerationOptions[2];
    }

    public EditDataGuidePanel(Context context, AbstractDataNode abstractDataNode, AttributeType attributeType, JSONColumnsType.Attribute attribute, boolean bl) {
        super(context, abstractDataNode);
        this.readOnlyMode = bl;
        this.editedAttribute = attributeType;
        this.copyJSONAttributeMetadata = JSONHelper.copyJSONColumnsTypeAttribute(attribute);
        this.referenceJSONAttributeMetadata = JSONHelper.copyJSONColumnsTypeAttribute(this.copyJSONAttributeMetadata);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jGuideTabPane = new JTabbedPane();
        this.jLblValuesProcessedLabel = new JLabel();
        this.jScrollPaneLabel = new JScrollPane();
        this.jLblValuesProcessedLabel.setText("Number of Values Processed:");
        this.jScrollPaneLabel.setBorder(null);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGuideTabPane, GroupLayout.Alignment.TRAILING, -1, 611, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLblValuesProcessedLabel, -2, 167, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPaneLabel).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblValuesProcessedLabel).addComponent(this.jScrollPaneLabel, -2, 34, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jGuideTabPane, -1, 397, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        this.jLblValuesProcessedLabel.setText(DataDialogsLrb.get("EDIT_DATA_GUIDE_PANEL_VALUES_PROCESSED"));
    }

    @Override
    public void initUI() {
        this.jScrollPaneLabel.getViewport().add((Component)this.jLblValuesProcessedValue);
        this.dataGuideStructurePanel = new JSONDataSourceStructurePanel(this.getContext(), (AbstractDataNode)this.getData(), this.editedAttribute, this.copyJSONAttributeMetadata, this.readOnlyMode);
        this.jGuideTabPane.addTab(STRUCTURE_TAB, this.dataGuideStructurePanel);
        this.dataGuideDataPanel = new JSONDataSourceDataPanel(this.getContext(), (AbstractDataNode)this.getData(), this.copyJSONAttributeMetadata, this.readOnlyMode);
        this.dataGuideStructurePanel.registerDataGuideObserver(this);
        this.dataGuideDataPanel.registerDataGuideObserver(this);
        this.jGuideTabPane.addTab(DATA_TAB, this.dataGuideDataPanel);
        if (null != this.copyJSONAttributeMetadata && null != this.copyJSONAttributeMetadata.getDataGuideInfo()) {
            List list;
            DataGuideInfoType.System system = this.copyJSONAttributeMetadata.getDataGuideInfo().getSystem();
            if (null != system && null != system.getNumValuesProcessed()) {
                BigInteger bigInteger = system.getNumValuesProcessed();
                this.jLblValuesProcessedValue.setText(String.valueOf(bigInteger.intValue()));
                return;
            }
            if (null != this.copyJSONAttributeMetadata.getDataGuideInfo().getMessages() && null != (list = this.copyJSONAttributeMetadata.getDataGuideInfo().getMessages().getMessage()) && !list.isEmpty()) {
                this.jLblValuesProcessedValue.setText(((MessageType)list.get(0)).getErrorDetail());
                return;
            }
        }
        this.jLblValuesProcessedLabel.setVisible(false);
        this.jLblValuesProcessedValue.setVisible(false);
    }

    @Override
    public void dataGuideAvailable(List<NameValuePair> list, String string) {
        this.dataGuideDataPanel.dataGuideAvailable(list);
    }

    @Override
    public void setLoadingStatus() {
        this.dataGuideDataPanel.setLoadingStatus();
    }

    @Override
    public void importDataGuide(String string) {
        boolean bl;
        DataGuideInfoType dataGuideInfoType = this.copyJSONAttributeMetadata.getDataGuideInfo();
        boolean bl2 = bl = null == dataGuideInfoType || null != dataGuideInfoType.getCustom() || null != dataGuideInfoType.getSystem() && null != dataGuideInfoType.getSystem().getDataGuideTable();
        if (bl && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("IMPORT_FILE_WARNING_TEXT"), (String)DataDialogsLrb.get("DATA_GUIDE_WARNING_TITLE"), null)) {
            this.dataGuideStructurePanel.importDataGuide(string);
        }
    }

    public static boolean overwriteCustom(DataGuideInfoType dataGuideInfoType, DataGuideGenEnumType dataGuideGenEnumType) {
        if (dataGuideInfoType == null || null == dataGuideInfoType.getCustom()) {
            return true;
        }
        if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("IMPORT_FILE_WARNING_TEXT"), (String)DataDialogsLrb.get("DATA_GUIDE_WARNING_TITLE"), null)) {
            dataGuideInfoType.setCustom(null);
            dataGuideInfoType.setSystem(new DataGuideInfoType.System());
            dataGuideInfoType.setGenerate(dataGuideGenEnumType);
            return true;
        }
        return false;
    }

    public static boolean isCustom(DataGuideInfoType dataGuideInfoType) {
        return dataGuideInfoType != null && null != dataGuideInfoType.getCustom();
    }

    @Override
    public boolean doWork() {
        DataGuideInfoType dataGuideInfoType;
        boolean bl = true;
        DataGuideInfoType dataGuideInfoType2 = this.referenceJSONAttributeMetadata.getDataGuideInfo();
        if (JSONHelper.equalDataGuideInfoType(dataGuideInfoType2, dataGuideInfoType = this.copyJSONAttributeMetadata.getDataGuideInfo())) {
            this.copyJSONAttributeMetadata = null;
        }
        return bl;
    }

    public JSONColumnsType.Attribute getCopyJSONAttributeMetadata() {
        return this.copyJSONAttributeMetadata;
    }

    public static String getDataGuideInitialSelection(JSONColumnsType.Attribute attribute) {
        String string = default_data_gen;
        if (null != attribute.getDataGuideInfo()) {
            DataGuideGenEnumType dataGuideGenEnumType = attribute.getDataGuideInfo().getGenerate();
            if (dataGuideGenEnumType.equals((Object)DataGuideGenEnumType.DEFAULT)) {
                string = default_data_gen;
            } else if (dataGuideGenEnumType.equals((Object)DataGuideGenEnumType.ON)) {
                string = on_data_gen;
            } else if (dataGuideGenEnumType.equals((Object)DataGuideGenEnumType.OFF)) {
                string = off_data_gen;
            }
        }
        return string;
    }

    public static void setUpDataGenerationControl(final DropDownMenuButton dropDownMenuButton, JSONColumnsType.Attribute attribute, final JSONImportDataGuide jSONImportDataGuide) {
        String string = EditDataGuidePanel.getDataGuideInitialSelection(attribute);
        dropDownMenuButton.removeAllPopupItems();
        for (String string2 : dataGuideGenerationOptions) {
            boolean bl = string.equals(string2);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction(string2){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jSONImportDataGuide.editDataGuide(actionEvent);
                }
            });
            jCheckBoxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (jSONImportDataGuide.isBusy()) {
                        return;
                    }
                    AbstractButton abstractButton = (AbstractButton)itemEvent.getItem();
                    String string = abstractButton.getText();
                    if (itemEvent.getStateChange() == 1) {
                        jSONImportDataGuide.setBusy(true);
                        MenuElement[] menuElementArray = dropDownMenuButton.getPopupMenu().getSubElements();
                        boolean bl = import_from_workflow.equals(string) || import_from_file.equals(string);
                        for (MenuElement menuElement : menuElementArray) {
                            boolean bl2 = false;
                            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)menuElement;
                            String string2 = jCheckBoxMenuItem.getText();
                            if (string2.equals(default_data_gen)) {
                                bl2 = string.equals(string2);
                            } else if (string2.equals(on_data_gen)) {
                                bl2 = string.equals(string2);
                            } else if (string2.equals(off_data_gen)) {
                                bl2 = string.equals(string2) || bl;
                            } else if (string2.equals(import_from_workflow) || string2.equals(import_from_file)) {
                                bl2 = false;
                            }
                            jCheckBoxMenuItem.setSelected(bl2);
                            jSONImportDataGuide.setPeerMenuSelection(jCheckBoxMenuItem);
                        }
                        jSONImportDataGuide.setBusy(false);
                    }
                }
            });
            jCheckBoxMenuItem.setSelected(bl);
            dropDownMenuButton.addPopupItem((JMenuItem)jCheckBoxMenuItem);
            if (!string2.equals(off_data_gen)) continue;
            dropDownMenuButton.addPopupSeparator();
        }
    }

    public static void setMenuItemSelection(DropDownMenuButton dropDownMenuButton, JCheckBoxMenuItem jCheckBoxMenuItem) {
        MenuElement[] menuElementArray;
        for (MenuElement menuElement : menuElementArray = dropDownMenuButton.getPopupMenu().getSubElements()) {
            JCheckBoxMenuItem jCheckBoxMenuItem2 = (JCheckBoxMenuItem)menuElement;
            if (!jCheckBoxMenuItem2.getText().equals(jCheckBoxMenuItem.getText())) continue;
            jCheckBoxMenuItem2.setSelected(jCheckBoxMenuItem.isSelected());
            break;
        }
    }

    public static JCheckBoxMenuItem getMenuItemSelection(DropDownMenuButton dropDownMenuButton) {
        MenuElement[] menuElementArray = dropDownMenuButton.getPopupMenu().getSubElements();
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        for (MenuElement menuElement : menuElementArray) {
            JCheckBoxMenuItem jCheckBoxMenuItem2 = (JCheckBoxMenuItem)menuElement;
            if (!jCheckBoxMenuItem2.isSelected()) continue;
            jCheckBoxMenuItem = jCheckBoxMenuItem2;
            break;
        }
        return jCheckBoxMenuItem;
    }

    public DataGuideType convertToDataGuide(List<NameValuePair> list) {
        DataGuideType dataGuideType = new DataGuideType();
        for (NameValuePair nameValuePair : list) {
            String string = nameValuePair.getName();
            NameValuePair nameValuePair2 = (NameValuePair)nameValuePair.getValue();
            DataGuideType.Item item = new DataGuideType.Item();
            item.setPath(string);
            item.setType((String)nameValuePair2.getValue());
            dataGuideType.getItem().add(item);
        }
        return dataGuideType;
    }

    @Override
    public void resetMenu() {
        this.dataGuideDataPanel.resetMenuSelection();
        this.dataGuideStructurePanel.resetMenuSelection();
    }

    @Override
    public void removeDataGuide() {
        String string;
        DataGuideInfoType dataGuideInfoType = this.copyJSONAttributeMetadata.getDataGuideInfo();
        if (dataGuideInfoType == null) {
            return;
        }
        if (null != dataGuideInfoType && null == dataGuideInfoType.getCustom() && null == dataGuideInfoType.getSystem()) {
            return;
        }
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("REMOVE_DATA_GUIDE_WARNING_TEXT"), (String)DataDialogsLrb.get("DATA_GUIDE_WARNING_TITLE"), null)) {
            return;
        }
        DataGuideInfoType.Custom custom = dataGuideInfoType.getCustom();
        if (custom != null) {
            if (null != custom.getDataGuide() && null != custom.getDataGuide().getItem() && !custom.getDataGuide().getItem().isEmpty()) {
                custom.getDataGuide().getItem().clear();
                dataGuideInfoType.setCustom(null);
                this.copyJSONAttributeMetadata.setDataGuideInfo(dataGuideInfoType);
                this.dataGuideStructurePanel.updateTreeWithNewDataGuide();
            }
        } else if (null != dataGuideInfoType.getSystem() && null != (string = dataGuideInfoType.getSystem().getDataGuideTable())) {
            try {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
                DatabaseMetadataUtils.dropTable(connectionFolder, null, string);
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
            dataGuideInfoType.setSystem(null);
            this.copyJSONAttributeMetadata.setDataGuideInfo(dataGuideInfoType);
            this.dataGuideStructurePanel.updateTreeWithNewDataGuide();
        }
    }

    @Override
    public void updateJsonStructureTree() {
        this.dataGuideStructurePanel.updateTreeWithNewDataGuide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean importDataGuideFromFile() {
        boolean bl;
        boolean bl2 = true;
        DataGuideInfoType dataGuideInfoType = this.copyJSONAttributeMetadata.getDataGuideInfo();
        boolean bl3 = bl = null == dataGuideInfoType || null != dataGuideInfoType.getCustom() || null != dataGuideInfoType.getSystem() && null != dataGuideInfoType.getSystem().getDataGuideTable();
        if (bl && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("IMPORT_FILE_WARNING_TEXT"), (String)DataDialogsLrb.get("DATA_GUIDE_WARNING_TITLE"), null)) {
            return false;
        }
        DataGuideType dataGuideType = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            DataGuideType.Item item;
            Object object;
            String string;
            File file;
            Preferences preferences = Preferences.getPreferences();
            JSONDataGuideImportPreferences jSONDataGuideImportPreferences = JSONDataGuideImportPreferences.getInstance((PropertyStorage)preferences);
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(_dotcsv_description + "(" + _stardotcsv + ")", _csv);
            URLFileChooser uRLFileChooser = new URLFileChooser();
            String string2 = jSONDataGuideImportPreferences.getDataLocation();
            if (string2 != null && !string2.equals(_empty_string) && (file = new File(string2)).exists()) {
                uRLFileChooser.setCurrentDirectory(new File(string2));
            }
            uRLFileChooser.setFileFilter((FileFilter)fileNameExtensionFilter);
            uRLFileChooser.setSelectionMode(0);
            int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow());
            if (n != 0) {
                boolean bl4 = false;
                return bl4;
            }
            String string3 = uRLFileChooser.getSelectedFile().getAbsolutePath();
            if (string3.trim().length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("IMPORT_DATAGUIDE_FROM_FILE_FAILURE_TITLE"), (String)DataDialogsLrb.get("IMPORT_DATA_GUIDE_EMPTY_FILE"), null);
                boolean bl5 = false;
                return bl5;
            }
            File file2 = new File(string3);
            String string4 = file2.getName();
            if (string4.length() != 0 && !FileHelper.isFileNameWithSuffix(string4)) {
                string = string3 + _dotcsv;
                file2 = new File(string);
            }
            if (file2 == null || !file2.exists()) {
                string = MessageFormat.format(DataDialogsLrb.get("IMPORT_DATA_GUIDE_NOT_EXIST"), file2.getAbsolutePath());
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)DataDialogsLrb.get("IMPORT_DATAGUIDE_FROM_FILE_TITLE"), null);
                boolean bl6 = false;
                return bl6;
            }
            fileInputStream = new FileInputStream(file2);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, _utf8);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                object = string.split(",");
                if (object != null && 2 == ((String[])object).length) {
                    if (dataGuideType == null) {
                        dataGuideType = new DataGuideType();
                    }
                    item = new DataGuideType.Item();
                    item.setPath(object[0]);
                    item.setType(object[1]);
                    dataGuideType.getItem().add(item);
                    continue;
                }
                bl2 = false;
                throw new Exception(DataDialogsLrb.get("IMPORT_DATAGUIDE_FROM_FILE_UNSUPPORTED_FORMAT"));
            }
            object = uRLFileChooser.getCurrentDirectory();
            if (object.isFile()) {
                object = object.getParentFile();
            }
            jSONDataGuideImportPreferences.setDataLocation(object.getAbsolutePath());
            if (dataGuideType == null) return bl2;
            item = new DataGuideInfoType();
            DataGuideInfoType.Custom custom = new DataGuideInfoType.Custom();
            custom.setDataGuide(dataGuideType);
            item.setCustom(custom);
            item.setStatus(ModelStatusType.COMPLETE);
            item.setGenerate(DataGuideGenEnumType.OFF);
            this.copyJSONAttributeMetadata.setDataGuideInfo((DataGuideInfoType)item);
            this.dataGuideStructurePanel.updateTreeWithNewDataGuide();
            return bl2;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
            return bl2;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void exportDataGuide(List<NameValuePair> list) {
        DataGuideType dataGuideType = this.convertToDataGuide(list);
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        Writer writer = null;
        try {
            CharSequence charSequence;
            Object object;
            Preferences preferences = Preferences.getPreferences();
            JSONDataGuideExportPreferences jSONDataGuideExportPreferences = JSONDataGuideExportPreferences.getInstance((PropertyStorage)preferences);
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(_dotcsv_description, _stardotcsv);
            URLFileChooser uRLFileChooser = new URLFileChooser();
            String string = jSONDataGuideExportPreferences.getDataLocation();
            if (string != null && !string.equals(_empty_string)) {
                object = new File(string);
                if (((File)object).isFile()) {
                    object = ((File)object).getParentFile();
                }
                if (((File)object).exists()) {
                    uRLFileChooser.setCurrentDirectory((File)object);
                    string = ((File)object).getAbsolutePath();
                } else {
                    string = uRLFileChooser.getCurrentDirectory().getAbsolutePath();
                }
            }
            Object object2 = object = this.editedAttribute.getAlias() != null ? this.editedAttribute.getAlias() : this.editedAttribute.getName();
            File file = new File(string + File.separator + (String)object + _dotcsv);
            int n = 1;
            while (file.exists()) {
                object = (String)object2 + n;
                file = new File(string + File.separator + (String)object + _dotcsv);
                ++n;
            }
            uRLFileChooser.setSelectedFile(file);
            uRLFileChooser.setFileFilter((FileFilter)fileNameExtensionFilter);
            int n2 = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n2 != 0) return;
            String string2 = uRLFileChooser.getSelectedFile().getAbsolutePath();
            if (string2.trim().length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("EXPORT_DATA_GUIDE_EMPTY_FILE"), (String)DataDialogsLrb.get("EXPORT_DATA_GUIDE_TITLE"), null);
                return;
            }
            File file2 = new File(string2);
            String string3 = file2.getName();
            if (string3.length() != 0 && !FileHelper.isFileNameWithSuffix(string3)) {
                charSequence = string2 + _dotcsv;
                file2 = new File((String)charSequence);
            }
            if (file2 != null && file2.exists() && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("EXPORT_DATA_EXPORT_FILE_OVERWRITE"), (String)DataDialogsLrb.get("EXPORT_DATA_GUIDE_TITLE"), null, (boolean)true)) {
                return;
            }
            if (dataGuideType == null) return;
            charSequence = new StringBuilder();
            for (DataGuideType.Item item : dataGuideType.getItem()) {
                String string4 = item.getPath();
                String string5 = item.getType();
                ((StringBuilder)charSequence).append(string4);
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(string5);
                ((StringBuilder)charSequence).append("\n");
            }
            fileOutputStream = new FileOutputStream(file2);
            writer = new OutputStreamWriter((OutputStream)fileOutputStream, _utf8);
            writer.write(((StringBuilder)charSequence).toString());
            jSONDataGuideExportPreferences.setDataLocation(file2.getParentFile().getAbsolutePath());
            MessageDialog.optionalInformation((String)SHOW_EXPORT_SUCCESS, (Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("EXPORT_DATA_EXPORT_COMPLETE"), (String)DataDialogsLrb.get("EXPORT_DATA_GUIDE_TITLE"), null);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)fileNotFoundException.getLocalizedMessage(), (String)DataDialogsLrb.get("EXPORT_DATA_EXPORT_ERROR_TITLE"), null);
            return;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void setPeerComboSelection(AbstractPanel abstractPanel, String string) {
        if (abstractPanel.equals(this.dataGuideStructurePanel)) {
            this.dataGuideDataPanel.setComboSelectionFromPeer(string);
        } else if (abstractPanel.equals(this.dataGuideDataPanel)) {
            this.dataGuideStructurePanel.setComboSelectionFromPeer(string);
        }
    }

    @Override
    public void setPeerMenuSelection(AbstractPanel abstractPanel, JCheckBoxMenuItem jCheckBoxMenuItem) {
        if (abstractPanel.equals(this.dataGuideStructurePanel)) {
            this.dataGuideDataPanel.setMenuSelectionFromPeer(jCheckBoxMenuItem);
        } else if (abstractPanel.equals(this.dataGuideDataPanel)) {
            this.dataGuideStructurePanel.setMenuSelectionFromPeer(jCheckBoxMenuItem);
        }
    }
}

