/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.JSONStructureDefaultTreeTableModel;
import oracle.dmt.dataminer.controls.JSONStructurePanel;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.data.EditDataGuidePanel;
import oracle.dmt.dataminer.workflow.dialog.data.ImportDataGuidePanel;
import oracle.dmt.dataminer.workflow.dialog.data.JSONImportDataGuide;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideGenEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.ide.Context;
import oracle.ide.controls.DropDownMenuButton;
import oracle.javatools.icons.OracleIcons;

public class JSONDataSourceStructurePanel
extends JSONStructurePanel
implements JSONImportDataGuide {
    private DropDownMenuButton menuDatataGuideGen;
    private JButton removeBtn;
    private JButton exportBtn;
    private boolean peerInvocation;
    private boolean readOnlyMode;
    private JCheckBoxMenuItem previousMenuSelectedItem;
    private boolean busy;

    public JSONDataSourceStructurePanel(Context context, AbstractDataNode abstractDataNode, AttributeType attributeType, JSONColumnsType.Attribute attribute, boolean bl) {
        super(context, abstractDataNode, attributeType, attribute, false);
        this.readOnlyMode = bl;
    }

    @Override
    protected void setPanelTitle() {
        this.titleLabel.setText("");
    }

    private void initComponents() {
        this.menuDatataGuideGen = new DropDownMenuButton();
        this.menuDatataGuideGen.setIcon((Icon)DataMinerIcons.get(Icons.GENERATE_DATA_GUIDE));
        this.menuDatataGuideGen.setToolTipText(ControlsLrb.get("JSON_DATA_GUIDE_GENERATION_LABEL"));
        this.menuDatataGuideGen.setEnabled(false);
        this.removeBtn = new JButton();
        this.exportBtn = new JButton();
    }

    @Override
    public void initRes() {
        this.initComponents();
        this.removeBtn.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.removeBtn.setToolTipText(ControlsLrb.get("JSON_TOOLBAR_REMOVE_DATA_GUIDE_TOOLTIP"));
        this.exportBtn.setIcon(OracleIcons.getIcon((String)"export.png"));
        this.exportBtn.setToolTipText(ControlsLrb.get("JSON_TOOLBAR_EXPORT_DATA_GUIDE_TOOLTIP"));
    }

    public void setComboSelection(String string) {
        this.dataGuideObserver.setPeerComboSelection(this, string);
    }

    @Override
    public void setComboSelectionFromPeer(String string) {
        this.peerInvocation = false;
    }

    @Override
    public void setupControlBar() {
        this.setUpDataGenerationCombo();
        this.controlBar.add((Component)this.menuDatataGuideGen);
        this.controlBar.add((Component)this.removeBtn);
        this.controlBar.add((Component)this.exportBtn);
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONDataSourceStructurePanel.this.dataGuideObserver.removeDataGuide();
                JSONDataSourceStructurePanel.this.editedJSONColumn.getDataGuideInfo().setGenerate(DataGuideGenEnumType.ON);
                JSONDataSourceStructurePanel.this.peerInvocation = true;
                JSONDataSourceStructurePanel.this.setComboSelection(EditDataGuidePanel.on_data_gen);
                JSONDataSourceStructurePanel.this.peerInvocation = false;
            }
        });
        this.exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONDataSourceStructurePanel.this.dataGuideObserver.exportDataGuide(JSONDataSourceStructurePanel.this.dataGuideInfo);
            }
        });
        this.removeBtn.setEnabled(false);
        super.setupControlBar();
    }

    private boolean enableRemoveButton() {
        if (this.readOnlyMode) {
            return false;
        }
        DataGuideInfoType dataGuideInfoType = this.editedJSONColumn.getDataGuideInfo();
        if (dataGuideInfoType == null) {
            return false;
        }
        if (null == dataGuideInfoType.getCustom() && (null == dataGuideInfoType.getSystem() || null == dataGuideInfoType.getSystem().getDataGuideTable())) {
            return false;
        }
        boolean bl = dataGuideInfoType.getMessages() == null || dataGuideInfoType.getMessages().getMessage().isEmpty();
        return bl;
    }

    @Override
    protected int getMaxNumberOfDocuments() {
        DataSourceNode dataSourceNode = (DataSourceNode)this.getData();
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
        DataGuideSettingsType dataGuideSettingsType = dataSourceNodeType.getDataGuideSettings();
        if (dataGuideSettingsType != null) {
            return dataGuideSettingsType.getNumberOfRows().intValue();
        }
        return super.getMaxNumberOfDocuments();
    }

    @Override
    protected int getMaxNumberOfValuesPerDocument() {
        DataSourceNode dataSourceNode = (DataSourceNode)this.getData();
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
        DataGuideSettingsType dataGuideSettingsType = dataSourceNodeType.getDataGuideSettings();
        if (dataGuideSettingsType != null) {
            return dataGuideSettingsType.getNumberOfValues().intValue();
        }
        return super.getMaxNumberOfValuesPerDocument();
    }

    @Override
    protected void enableComponents(boolean bl) {
        if (this.readOnlyMode) {
            this.exportBtn.setEnabled(bl);
            this.removeBtn.setEnabled(false);
        } else {
            boolean bl2 = this.enableRemoveButton();
            this.exportBtn.setEnabled(bl && bl2);
            this.removeBtn.setEnabled(bl && bl2);
        }
        this.menuDatataGuideGen.setEnabled(bl);
    }

    @Override
    public void importDataGuide(String string) {
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        jSONStructureDefaultTreeTableModel.setLoadingStatus();
        this.dataGuideObserver.setLoadingStatus();
        this.reload(string);
        this.updateUI();
        this.enableComponents(false);
    }

    private void setUpDataGenerationCombo() {
        EditDataGuidePanel.setUpDataGenerationControl(this.menuDatataGuideGen, this.editedJSONColumn, this);
    }

    @Override
    public void savePreviousMenuSelectionFromPeer(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.previousMenuSelectedItem = jCheckBoxMenuItem;
    }

    @Override
    public void setPeerMenuSelection(JCheckBoxMenuItem jCheckBoxMenuItem) {
        if (this.dataGuideObserver != null) {
            this.dataGuideObserver.setPeerMenuSelection(this, jCheckBoxMenuItem);
        }
    }

    @Override
    public void setMenuSelectionFromPeer(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.setBusy(true);
        EditDataGuidePanel.setMenuItemSelection(this.menuDatataGuideGen, jCheckBoxMenuItem);
        this.setBusy(false);
    }

    @Override
    public void resetMenuSelection() {
        this.previousMenuSelectedItem.setSelected(true);
    }

    @Override
    public void editDataGuide(ActionEvent actionEvent) {
        if (this.peerInvocation) {
            return;
        }
        boolean bl = false;
        String string = actionEvent.getActionCommand();
        if (string.equals(EditDataGuidePanel.import_from_workflow)) {
            ImportDataGuidePanel importDataGuidePanel = new ImportDataGuidePanel(this.getContext(), (AbstractDataNode)this.getData());
            if (importDataGuidePanel.showAsDialog(this)) {
                String string2 = importDataGuidePanel.getDataGuideTableName();
                this.importDataGuide(string2);
                this.setComboSelection(EditDataGuidePanel.off_data_gen);
                bl = true;
            } else {
                this.dataGuideObserver.resetMenu();
            }
        } else if (string.equals(EditDataGuidePanel.import_from_file)) {
            if (this.dataGuideObserver.importDataGuideFromFile()) {
                this.setComboSelection(EditDataGuidePanel.off_data_gen);
                bl = true;
            } else {
                this.dataGuideObserver.resetMenu();
            }
        } else if (string.equals(EditDataGuidePanel.default_data_gen)) {
            boolean bl2 = EditDataGuidePanel.isCustom(this.editedJSONColumn.getDataGuideInfo());
            if (!EditDataGuidePanel.overwriteCustom(this.editedJSONColumn.getDataGuideInfo(), DataGuideGenEnumType.DEFAULT)) {
                this.dataGuideObserver.resetMenu();
            } else {
                if (bl2) {
                    this.updateTreeWithNewDataGuide();
                    this.updateUI();
                }
                this.setComboSelection(EditDataGuidePanel.default_data_gen);
                this.editedJSONColumn.getDataGuideInfo().setGenerate(DataGuideGenEnumType.DEFAULT);
                bl = true;
            }
        } else if (string.equals(EditDataGuidePanel.off_data_gen)) {
            this.editedJSONColumn.getDataGuideInfo().setGenerate(DataGuideGenEnumType.OFF);
            bl = true;
        } else if (string.equals(EditDataGuidePanel.on_data_gen)) {
            boolean bl3 = EditDataGuidePanel.isCustom(this.editedJSONColumn.getDataGuideInfo());
            if (!EditDataGuidePanel.overwriteCustom(this.editedJSONColumn.getDataGuideInfo(), DataGuideGenEnumType.ON)) {
                this.dataGuideObserver.resetMenu();
            } else {
                if (bl3) {
                    this.updateTreeWithNewDataGuide();
                    this.updateUI();
                }
                this.setComboSelection(EditDataGuidePanel.on_data_gen);
                this.editedJSONColumn.getDataGuideInfo().setGenerate(DataGuideGenEnumType.ON);
                bl = true;
            }
        }
        if (bl) {
            this.previousMenuSelectedItem = EditDataGuidePanel.getMenuItemSelection(this.menuDatataGuideGen);
        }
    }

    @Override
    public void setBusy(boolean bl) {
        this.busy = bl;
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }
}

