/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.join;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.CollectionsUtils;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.join.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.join.JoinEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.join.ResolverPanel;
import oracle.dmt.dataminer.workflow.inspect.JoinNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowJoinNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinKeyColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinSourceNodesType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefDBColumnType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.HyperlinkButton;

public class JoinColumnPanel
extends DialogDisplayer<JoinNode> {
    private WorkflowJoinNodePropertyProxyModel _propertyModel;
    private JoinEditorPanel _parent;
    private boolean joinColumnDialog;
    private boolean _isCartesianJoin;
    private JoinSourceNodesType _sourceNodes;
    private JoinKeyColumnsType _keyColumns;
    private JoinOutputColumnsType _outputColumns;
    private AbstractNode _selectSrcNode1;
    private AbstractNode _selectSrcNode2;
    private AttributeType _selAttr1;
    private AttributeType _selAttr2;
    private List<AbstractNode> _dataNodes;
    private boolean _loading = false;
    private boolean _dirty;
    private boolean _updateOutputColumn;
    private boolean _isEditMode;
    private JButton _addBtn;
    private JButton _removeBtn;
    private HyperlinkButton _resolveIssuesLink;
    private JoinNode.JoinOutputColumnNameGenerator _outputColumnNameGenerator;
    private CollectionsUtils.Filter<AttributeType> atributesfilter;
    private static final String SELECT_A_NODE = DialogsLrb.get("JOIN_SELECT_NODE");
    private JButton jAddButton;
    private JCheckBox jCartesianChkBox;
    private JLabel jFillerLabel1;
    private JLabel jFillerLabel2;
    private JComboBox<String> jSrcComboBox1;
    private JComboBox<String> jSrcComboBox2;
    private JLabel jSrcLabel1;
    private JLabel jSrcLabel2;
    private DataMinerTablePanel keysTablePanel;
    private DataMinerTablePanel sourceTablePanel1;
    private DataMinerTablePanel sourceTablePanel2;

    public JoinColumnPanel(boolean bl, PropertyModel propertyModel) {
        super((Context)null, null);
        assert (propertyModel != null) : "PropertyModel for join node is null.";
        this.joinColumnDialog = bl;
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        if (bl) {
            this.addAncestorListener(new PIAncestorListener(this));
        }
        this.init((JoinNode)this._data, propertyModel);
    }

    public JoinColumnPanel(boolean bl, Context context, JoinNode joinNode, JoinEditorPanel joinEditorPanel) {
        super(context, joinNode);
        assert (context != null) : "Context must not be null.";
        assert (joinNode != null) : "Join node must not be null.";
        this.joinColumnDialog = bl;
        this._parent = joinEditorPanel;
        this.init(joinNode, this._parent.getModel());
    }

    public JoinColumnPanel(PropertyModel propertyModel) {
        this(false, propertyModel);
    }

    public JoinColumnPanel(Context context, JoinNode joinNode, JoinEditorPanel joinEditorPanel) {
        this(false, context, joinNode, joinEditorPanel);
    }

    private boolean isPIMode() {
        return this._propertyModel != null && !this.joinColumnDialog;
    }

    private boolean isPIDialogMode() {
        return this._propertyModel != null && this.joinColumnDialog;
    }

    private boolean isEditMode() {
        return this._propertyModel == null && this._isEditMode && !this.joinColumnDialog;
    }

    private void init(JoinNode joinNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        this._updateOutputColumn = false;
        this._dataNodes = joinNode.findJoinDataNode();
        this.atributesfilter = new CollectionsUtils.Filter<AttributeType>(){

            @Override
            public boolean accept(AttributeType attributeType) {
                return DatabaseMetadataUtils.isKeyDataTypeSupported(DatabaseMetadataUtils.getJSONDataType(attributeType.getDataType(), attributeType.getDataTypeQualifier()));
            }
        };
        if (this.isPIMode() || this.isPIDialogMode()) {
            this._isCartesianJoin = ((JoinNodeType)joinNode.getData()).isUseCartesian();
            this._sourceNodes = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(((JoinNodeType)joinNode.getData()).getSourceNodes());
            this._keyColumns = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(((JoinNodeType)joinNode.getData()).getKeyColumns());
            this._outputColumns = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(((JoinNodeType)joinNode.getData()).getOutputColumns());
            this._outputColumnNameGenerator = new JoinNode.JoinOutputColumnNameGenerator(this._context, this._outputColumns);
        } else if (!this.joinColumnDialog) {
            this._isCartesianJoin = this._parent.isCartesianJoin();
            this._sourceNodes = this._parent.getSourceNodes();
            this._keyColumns = this._parent.getKeyColumns();
            this._outputColumns = this._parent.getOutputColumns();
            this._outputColumnNameGenerator = this._parent.getOutputColumnNameGenerator();
            this._isEditMode = true;
        } else {
            this._isCartesianJoin = this._parent.getKeyPanel().isCartesianJoin();
            this._sourceNodes = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(this._parent.getKeyPanel().getKeyNodes());
            this._keyColumns = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(this._parent.getKeyPanel().getKeyColumns());
            this._outputColumns = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(this._parent.getKeyPanel().getJoinOutputColumns());
            this._outputColumnNameGenerator = new JoinNode.JoinOutputColumnNameGenerator(this._context, this._outputColumns);
        }
        this._selectSrcNode1 = null;
        this._selectSrcNode2 = null;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        JoinNode joinNode = (JoinNode)workflowNodeInspectorElement.getNode();
        if (joinNode == null) {
            return;
        }
        this._propertyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = joinNode;
        this._dirty = false;
        this._updateOutputColumn = false;
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        this._isCartesianJoin = joinNodeType.isUseCartesian();
        this._sourceNodes = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(joinNodeType.getSourceNodes());
        this._keyColumns = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getKeyColumns());
        this._outputColumns = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getOutputColumns());
        this._outputColumnNameGenerator = new JoinNode.JoinOutputColumnNameGenerator(context, joinNodeType.getOutputColumns());
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null || !(propertyModel instanceof WorkflowJoinNodePropertyProxyModel)) {
            return null;
        }
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private JoinNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null || !(propertyModel instanceof WorkflowJoinNodePropertyProxyModel)) {
            return null;
        }
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof JoinNodeType) {
            return (JoinNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateNode() {
        JoinNode joinNode = (JoinNode)this.getData();
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        ComplexProperty complexProperty = new ComplexProperty("joinKeyColumns", this._keyColumns);
        complexProperty.setOldData(joinNodeType.getKeyColumns());
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(JoinNodePropertyModel.JOIN_KEY_COLUMNS.index), null, complexProperty, null, null));
        ComplexProperty complexProperty2 = new ComplexProperty("joinKeyNodes", this._sourceNodes);
        complexProperty2.setOldData(joinNodeType.getSourceNodes());
        arrayList.add(new Property(String.valueOf(JoinNodePropertyModel.JOIN_KEY_NODES.index), null, complexProperty2, null, null));
        if (this._updateOutputColumn) {
            ComplexProperty complexProperty3 = new ComplexProperty("joinOutputColumns", this._outputColumns);
            complexProperty3.setOldData(joinNodeType.getOutputColumns());
            arrayList.add(new Property(String.valueOf(JoinNodePropertyModel.JOIN_OUTPUT_COLUMNS.index), null, complexProperty3, null, null));
        }
        this._propertyModel.setValueAt(PropertyLrb.get("PI_JOIN_GROUP_COLUMNS_ATTRIBUTE_OUTPUT_COLUMN_CHANGED"), (AbstractNode)this.getData(), (List<Property>)arrayList);
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        if (!(this._isCartesianJoin || JoinNode.areAllNodesUsedInKeys((JoinNode)this.getData(), this._keyColumns) || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_NODE_NOT_USED_IN_KEY"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true))) {
            return false;
        }
        if (this.isDirty()) {
            if (this.isPIMode() || this.isPIDialogMode()) {
                this.updateNode();
            } else {
                if (this._isCartesianJoin) {
                    this._parent.getKeyPanel().setKeyNodes(this._sourceNodes);
                    this._parent.getKeyPanel().setKeyColumns(null);
                } else {
                    this._parent.getKeyPanel().setKeyNodes(null);
                    this._parent.getKeyPanel().setKeyColumns(this._keyColumns);
                }
                this._parent.getKeyPanel().setDirty(true);
                this._parent.getKeyPanel().initUI();
                this._parent.getDataPanel().setOutputColumns(this._outputColumns);
                this._parent.getDataPanel().setDirty(true);
                this._parent.getDataPanel().reloadModel();
            }
        }
        return bl;
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jSrcLabel1, this.jSrcComboBox1, (String)DialogsLrb.get("JOIN_KEY_SOURCE_NAME1"));
        ResourceUtils.resLabel((JLabel)this.jSrcLabel2, this.jSrcComboBox2, (String)DialogsLrb.get("JOIN_KEY_SOURCE_NAME2"));
        ResourceUtils.resButton((AbstractButton)this.jAddButton, (String)DialogsLrb.get("JOIN_KEY_ADD_BTN"));
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("JOIN_KEY_CARTESIAN_SETTING"), this.jCartesianChkBox);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        Object object;
        Object object3;
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this._loading = true;
        boolean bl = !this.isPIMode() && !this.isEditMode();
        this.jSrcLabel1.setVisible(bl);
        this.jSrcComboBox1.setVisible(bl);
        this.sourceTablePanel1.setVisible(bl);
        this.jSrcLabel2.setVisible(bl);
        this.jSrcComboBox2.setVisible(bl);
        this.sourceTablePanel2.setVisible(bl);
        this.jFillerLabel1.setVisible(bl);
        this.jFillerLabel2.setVisible(bl);
        this.jAddButton.setIcon(OracleIcons.getIcon((String)"down.png"));
        this.jAddButton.setVisible(bl);
        this.jCartesianChkBox.setVisible(!bl);
        this.keysTablePanel.removeControlBarButtons();
        if (bl) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            object3 = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(SELECT_A_NODE);
            ((DefaultComboBoxModel)object3).addElement(SELECT_A_NODE);
            for (AbstractNode object22 : this._dataNodes) {
                defaultComboBoxModel.addElement(object22.getData().getName());
                ((DefaultComboBoxModel)object3).addElement(object22.getData().getName());
            }
            this.jSrcComboBox1.setModel(defaultComboBoxModel);
            this.jSrcComboBox1.setSelectedItem(SELECT_A_NODE);
            this.jSrcComboBox2.setModel((ComboBoxModel<String>)object3);
            this.jSrcComboBox2.setSelectedItem(SELECT_A_NODE);
            AttrsTableModel attrsTableModel = new AttrsTableModel(null);
            this.sourceTablePanel1.setup((TableModel)((Object)attrsTableModel), DialogsLrb.get("JOIN_SOURCE_TABLE_TITLE"), 0, true);
            this.sourceTablePanel1.getTable().setSortColumn(0, true);
            this.sourceTablePanel1.getTable().setSelectionMode(0);
            this.sourceTablePanel1.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    JoinColumnPanel.this.enableControls();
                }
            });
            TableColumn tableColumn = this.sourceTablePanel1.getTable().getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new CustomCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png")));
            this.sourceTablePanel2.setup((TableModel)((Object)attrsTableModel), DialogsLrb.get("JOIN_SOURCE_TABLE_TITLE"), 0, true);
            this.sourceTablePanel2.getTable().setSortColumn(0, true);
            this.sourceTablePanel2.getTable().setSelectionMode(0);
            this.sourceTablePanel2.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    JoinColumnPanel.this.enableControls();
                }
            });
            tableColumn = this.sourceTablePanel2.getTable().getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new CustomCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png")));
        }
        int n = 0;
        n = this._isCartesianJoin ? JoinNode.getUnResolveNodes(this._sourceNodes).size() : JoinNode.getUnResolveNodes(this._keyColumns).size();
        if (n > 0) {
            this._resolveIssuesLink = new HyperlinkButton();
            this._resolveIssuesLink.setText(DialogsLrb.get("JOIN_RESOLVE_ISSUES"));
            this._resolveIssuesLink.setToolTipText(DialogsLrb.get("JOIN_RESOLVE_TOOLTIP"));
            this._resolveIssuesLink.setAlwaysUnderlined(true);
            this._resolveIssuesLink.setIcon(OracleIcons.getIcon((String)"warning.png"));
            this.keysTablePanel.addControlBarComponents(new Component[]{this._resolveIssuesLink});
            this._resolveIssuesLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JoinNode joinNode = (JoinNode)JoinColumnPanel.this.getData();
                    JoinNodeType joinNodeType = (JoinNodeType)MetaDataHelper.copyMetadataObject(joinNode.getData());
                    joinNodeType.setKeyColumns(JoinColumnPanel.this._keyColumns);
                    joinNodeType.setSourceNodes(JoinColumnPanel.this._sourceNodes);
                    joinNodeType.setOutputColumns(JoinColumnPanel.this._outputColumns);
                    ResolverPanel resolverPanel = new ResolverPanel(JoinColumnPanel.this.getContext(), joinNode, joinNodeType);
                    if (resolverPanel.showAsDialog(JoinColumnPanel.this)) {
                        JoinColumnPanel.this._sourceNodes = joinNodeType.getSourceNodes();
                        JoinColumnPanel.this._keyColumns = joinNodeType.getKeyColumns();
                        JoinColumnPanel.this._outputColumns = joinNodeType.getOutputColumns();
                        if (JoinColumnPanel.this.isPIMode()) {
                            JoinColumnPanel.this._updateOutputColumn = true;
                            JoinColumnPanel.this.updateNode();
                        } else if (!JoinColumnPanel.this.joinColumnDialog) {
                            if (JoinColumnPanel.this._isCartesianJoin) {
                                JoinColumnPanel.this._parent.getKeyPanel().setKeyNodes(JoinColumnPanel.this._sourceNodes);
                                JoinColumnPanel.this._parent.getKeyPanel().setKeyColumns(null);
                            } else {
                                JoinColumnPanel.this._parent.getKeyPanel().setKeyNodes(null);
                                JoinColumnPanel.this._parent.getKeyPanel().setKeyColumns(JoinColumnPanel.this._keyColumns);
                            }
                            JoinColumnPanel.this._parent.getKeyPanel().setDirty(true);
                            JoinColumnPanel.this._parent.getKeyPanel().initUI();
                            JoinColumnPanel.this._parent.getDataPanel().setOutputColumns(JoinColumnPanel.this._outputColumns);
                            JoinColumnPanel.this._parent.getDataPanel().setDirty(true);
                            JoinColumnPanel.this._parent.getDataPanel().reloadModel();
                        }
                    }
                }
            });
        }
        if (this._isCartesianJoin) {
            object3 = new KeyNodeTableModel(this, this._sourceNodes);
            this.keysTablePanel.setup((TableModel)object3, DialogsLrb.get("JOIN_NODE_TABLE_TITLE"), 0, true);
            object = this.keysTablePanel.getTable().getColumnModel().getColumn(0);
            ((TableColumn)object).setCellRenderer(new CustomCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png")));
        } else {
            object3 = new KeyColumnTableModel(this, this._keyColumns, true);
            if (this.isPIMode() || this.isEditMode()) {
                this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
                this._addBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JoinColumnPanel.this.processAdd();
                    }
                });
                this._addBtn.setEnabled(true);
                this._addBtn.setToolTipText(DialogsLrb.get("JOIN_ADD_BTN_TOOLTIP"));
            }
            this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
            this._removeBtn.setEnabled(false);
            this._removeBtn.setToolTipText(DialogsLrb.get("JOIN_REMOVE_BTN_TOOLTIP"));
            this.keysTablePanel.setup((TableModel)object3, DialogsLrb.get("JOIN_KEY_TABLE_TITLE"), 0, true);
            if (this._addBtn != null) {
                this.keysTablePanel.addControlBarComponents(this._addBtn, this._removeBtn);
            } else {
                this.keysTablePanel.addControlBarComponents(this._removeBtn);
            }
            object = this.keysTablePanel.getTable().getColumnModel().getColumn(0);
            ((TableColumn)object).setCellRenderer(new CustomCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png")));
            object = this.keysTablePanel.getTable().getColumnModel().getColumn(1);
            ((TableColumn)object).setCellRenderer(new CustomCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png")));
            TableColumn tableColumn = this.keysTablePanel.getTable().getColumnModel().getColumn(2);
            tableColumn.setCellEditor(new JoinTypeEditor());
            this._removeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_REMOVE_KEY"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                        return;
                    }
                    JoinColumnPanel.this.processRemove();
                }
            });
            this.keysTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    JoinColumnPanel.this.enableControls();
                }
            });
        }
        this.enableControls();
        this._loading = false;
    }

    private void enableControls() {
        this.jCartesianChkBox.setSelected(this._isCartesianJoin);
        this.jCartesianChkBox.setEnabled(this.isWritable());
        if (this._removeBtn != null) {
            this._removeBtn.setEnabled(this.isWritable() && this.keysTablePanel.getTable().getSelectedRowCount() > 0);
        }
        if (this._addBtn != null) {
            this._addBtn.setEnabled(this.isWritable());
        }
        if (this._resolveIssuesLink != null) {
            int n = 0;
            n = this._isCartesianJoin ? JoinNode.getUnResolveNodes(this._sourceNodes).size() : JoinNode.getUnResolveNodes(this._keyColumns).size();
            this._resolveIssuesLink.setVisible(n > 0);
            this._resolveIssuesLink.setEnabled(n > 0 && this.isWritable());
        }
        if (this.sourceTablePanel1.isVisible() && this.sourceTablePanel2.isVisible()) {
            this.jAddButton.setEnabled(this.sourceTablePanel1.getTable().getSelectedRowsInModel().length > 0 && this.sourceTablePanel2.getTable().getSelectedRowsInModel().length > 0);
        }
    }

    private void processAdd() {
        JoinColumnPanel joinColumnPanel = null;
        joinColumnPanel = this.isPIMode() ? new JoinColumnPanel(true, (PropertyModel)this._propertyModel) : new JoinColumnPanel(true, this._context, (JoinNode)this._data, this._parent);
        joinColumnPanel.showAsDialog(this);
    }

    private void processRemove() {
        int[] nArray = this.keysTablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<JoinKeyColumnsType.JoinColumn> arrayList = new ArrayList<JoinKeyColumnsType.JoinColumn>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            JoinKeyColumnsType.JoinColumn joinColumn = (JoinKeyColumnsType.JoinColumn)this._keyColumns.getJoinColumn().get(n);
            arrayList.add(joinColumn);
        }
        JoinNode.removeKey(this._keyColumns, arrayList);
        if (this.isPIMode() || this.isPIDialogMode()) {
            this._updateOutputColumn = true;
        } else {
            this._parent.getDataPanel().setDirty(true);
            this._parent.getDataPanel().reloadModel();
        }
        KeyColumnTableModel keyColumnTableModel = new KeyColumnTableModel(this, this._keyColumns, true);
        this.keysTablePanel.getTable().setModel((TableModel)((Object)keyColumnTableModel));
        this._dirty = true;
        if (this.isPIMode()) {
            this.updateNode();
        }
    }

    private void initComponents() {
        this.jSrcLabel1 = new JLabel();
        this.jSrcComboBox1 = new JComboBox();
        this.jFillerLabel1 = new JLabel();
        this.jSrcLabel2 = new JLabel();
        this.jSrcComboBox2 = new JComboBox();
        this.jFillerLabel2 = new JLabel();
        this.jAddButton = new JButton();
        this.jCartesianChkBox = new JCheckBox();
        this.sourceTablePanel1 = new DataMinerTablePanel();
        this.sourceTablePanel2 = new DataMinerTablePanel();
        this.keysTablePanel = new DataMinerTablePanel();
        this.jSrcLabel1.setText("Source:");
        this.jSrcLabel1.setName("jSrcLabel1");
        this.jSrcComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"src 11", "src 12", "src 13", "src 14"}));
        this.jSrcComboBox1.setName("jSrcComboBox1");
        this.jSrcComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinColumnPanel.this.jSrcComboBox1ActionPerformed(actionEvent);
            }
        });
        this.jFillerLabel1.setName("jFillerLabel1");
        this.jSrcLabel2.setText("Source:");
        this.jSrcLabel2.setName("jSrcLabel2");
        this.jSrcComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"src 21", "src 22", "src 23", "src 24"}));
        this.jSrcComboBox2.setName("jSrcComboBox2");
        this.jSrcComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinColumnPanel.this.jSrcComboBox2ActionPerformed(actionEvent);
            }
        });
        this.jFillerLabel2.setName("jFillerLabel2");
        this.jAddButton.setText("Add");
        this.jAddButton.setName("jAddButton");
        this.jAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinColumnPanel.this.jAddButtonActionPerformed(actionEvent);
            }
        });
        this.jCartesianChkBox.setText("Cartesian Join");
        this.jCartesianChkBox.setName("jCartesianChkBox");
        this.jCartesianChkBox.setOpaque(false);
        this.jCartesianChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinColumnPanel.this.jCartesianChkBoxActionPerformed(actionEvent);
            }
        });
        this.sourceTablePanel1.setName("sourceTablePanel1");
        this.sourceTablePanel2.setName("sourceTablePanel2");
        this.keysTablePanel.setName("keysTablePanel");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(249, 249, 249).addComponent(this.jFillerLabel1, -1, 77, Short.MAX_VALUE)).addComponent(this.jSrcLabel1).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.sourceTablePanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jSrcComboBox1, 0, 324, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAddButton, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFillerLabel2, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.sourceTablePanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSrcLabel2).addComponent(this.jSrcComboBox2, 0, 324, Short.MAX_VALUE))).addContainerGap()))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keysTablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCartesianChkBox, -2, 364, -2).addGap(0, 424, Short.MAX_VALUE))).addContainerGap()))));
        groupLayout.linkSize(0, this.jSrcComboBox1, this.jSrcComboBox2);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSrcLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSrcComboBox1, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceTablePanel1, -2, 218, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSrcLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSrcComboBox2, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sourceTablePanel2, -2, 0, Short.MAX_VALUE))).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFillerLabel2, -2, 29, -2).addComponent(this.jFillerLabel1, -2, 29, -2))).addComponent(this.jAddButton, GroupLayout.Alignment.TRAILING)).addGap(10, 10, 10).addComponent(this.jCartesianChkBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keysTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jSrcComboBox1ActionPerformed(ActionEvent actionEvent) {
        this.sourceComboChange(this.jSrcComboBox1, this.sourceTablePanel1.getTable(), 1);
    }

    private void jSrcComboBox2ActionPerformed(ActionEvent actionEvent) {
        this.sourceComboChange(this.jSrcComboBox2, this.sourceTablePanel2.getTable(), 2);
    }

    private void sourceComboChange(JComboBox jComboBox, DataMinerTable dataMinerTable, int n) {
        if (this._loading) {
            return;
        }
        AbstractNode object2 = null;
        String string = (String)jComboBox.getSelectedItem();
        if (!SELECT_A_NODE.equals(string)) {
            jComboBox.removeItem(SELECT_A_NODE);
        }
        block4: for (AbstractNode object3 : this._dataNodes) {
            if (!object3.getData().getName().equals(string)) continue;
            switch (n) {
                case 1: {
                    this._selectSrcNode1 = object3;
                    object2 = object3;
                    continue block4;
                }
                case 2: {
                    this._selectSrcNode2 = object3;
                    object2 = object3;
                    continue block4;
                }
            }
            assert (false) : "Invalid option";
        }
        DataProvider dataProvider = (DataProvider)((Object)object2);
        List list = dataProvider.getAttributes().getAttribute();
        List<AttributeType> list2 = CollectionsUtils.filter(list, this.atributesfilter);
        AttrsTableModel attrsTableModel = new AttrsTableModel(list2);
        dataMinerTable.setModel((TableModel)((Object)attrsTableModel));
        dataMinerTable.setSortColumn(0, true);
    }

    private void jAddButtonActionPerformed(ActionEvent actionEvent) {
        DataProvider dataProvider = (DataProvider)((Object)this._selectSrcNode1);
        int[] nArray = this.sourceTablePanel1.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        TableModel tableModel = this.sourceTablePanel1.getTable().getModel();
        this._selAttr1 = (AttributeType)((AttrsTableModel)((Object)tableModel)).getValueAt(nArray[0], 4);
        dataProvider = (DataProvider)((Object)this._selectSrcNode2);
        nArray = this.sourceTablePanel2.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        tableModel = this.sourceTablePanel2.getTable().getModel();
        this._selAttr2 = (AttributeType)((AttrsTableModel)((Object)tableModel)).getValueAt(nArray[0], 4);
        if (this.validateKeys()) {
            Object object;
            JoinType joinType = null;
            int n = this.keysTablePanel.getTable().getModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                object = (JoinKeyColumnsType.JoinColumn)this._keyColumns.getJoinColumn().get(i);
                if (object.getLeftColumn().getNodeId().compareTo(this._selectSrcNode1.getMetadataId()) != 0 || object.getRightColumn().getNodeId().compareTo(this._selectSrcNode2.getMetadataId()) != 0) continue;
                joinType = object.getType();
                break;
            }
            if (joinType == null) {
                joinType = JoinType.INNER;
            }
            JoinNode.addKey(this._keyColumns, this._selectSrcNode1, this._selAttr1, this._selectSrcNode2, this._selAttr2, joinType);
            if (this._outputColumns.getAutoSpec().equals((Object)AutoSpecType.YES)) {
                JoinNode.addOutputAttrs(this._outputColumns, this._selectSrcNode1, this._outputColumnNameGenerator);
                JoinNode.addOutputAttrs(this._outputColumns, this._selectSrcNode2, this._outputColumnNameGenerator);
                if (this.isPIMode() || this.isPIDialogMode()) {
                    this._updateOutputColumn = true;
                } else {
                    this._parent.getDataPanel().setDirty(true);
                    this._parent.getDataPanel().reloadModel();
                }
            }
            KeyColumnTableModel keyColumnTableModel = new KeyColumnTableModel(this, this._keyColumns, true);
            this.keysTablePanel.getTable().setModel((TableModel)((Object)keyColumnTableModel));
            object = this.keysTablePanel.getTable().getColumnModel().getColumn(2);
            ((TableColumn)object).setCellEditor(new JoinTypeEditor());
            this._dirty = true;
        }
    }

    private boolean isNumeric(String string) {
        return DatabaseMetadataUtils.isBinaryNumericType(string) || DatabaseMetadataUtils.isNumericType(string);
    }

    private boolean isString(String string) {
        return string.equals("CHAR") || string.equals("VARCHAR2") || string.equals("NCHAR") || string.equals("NVARCHAR2");
    }

    private boolean validateKeys() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this._selectSrcNode1.getID().compareTo(this._selectSrcNode2.getID()) == 0) {
            bl3 = true;
        } else if (this._selAttr1.getDataType().compareTo(this._selAttr2.getDataType()) != 0) {
            bl2 = this.isString(this._selAttr1.getDataType()) && this.isString(this._selAttr2.getDataType()) ? false : !this.isNumeric(this._selAttr1.getDataType()) || !this.isNumeric(this._selAttr2.getDataType());
        }
        if (!bl2 && !bl3) {
            for (JoinKeyColumnsType.JoinColumn joinColumn : this._keyColumns.getJoinColumn()) {
                RefDBColumnType refDBColumnType = joinColumn.getLeftColumn();
                RefDBColumnType refDBColumnType2 = joinColumn.getRightColumn();
                if (refDBColumnType.getNodeId().compareTo(this._selectSrcNode1.getMetadataId()) == 0 && refDBColumnType.getName().compareTo(this._selAttr1.getName()) == 0 && refDBColumnType2.getNodeId().compareTo(this._selectSrcNode2.getMetadataId()) == 0 && refDBColumnType2.getName().compareTo(this._selAttr2.getName()) == 0) {
                    bl = true;
                    break;
                }
                if (refDBColumnType.getNodeId().compareTo(this._selectSrcNode2.getMetadataId()) != 0 || refDBColumnType.getName().compareTo(this._selAttr2.getName()) != 0 || refDBColumnType2.getNodeId().compareTo(this._selectSrcNode1.getMetadataId()) != 0 || refDBColumnType2.getName().compareTo(this._selAttr1.getName()) != 0) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_KEY_DUPLICATE"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (bl2) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_KEY_INCOMPATIBLE"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (bl3) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_KEY_NO_SELF_JOIN"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        return true;
    }

    private void jCartesianChkBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jCartesianChkBox.isSelected();
        if (bl) {
            if (this._keyColumns != null && this._keyColumns.getJoinColumn().size() > 0 && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_CARTESIAN_SETTING_ON"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jCartesianChkBox.setSelected(false);
                return;
            }
            this._isCartesianJoin = true;
            this._keyColumns = null;
            this._sourceNodes = new JoinSourceNodesType();
            JoinNode.removeOutputAttrsFromNodes(this._outputColumns, null, this._outputColumnNameGenerator);
            JoinNode.addKey(this._sourceNodes, ((JoinNode)this.getData()).findJoinDataNode());
            if (this._outputColumns.getAutoSpec().equals((Object)AutoSpecType.YES)) {
                for (AbstractNode abstractNode : ((JoinNode)this.getData()).findJoinDataNode()) {
                    JoinNode.addOutputAttrs(this._outputColumns, abstractNode, this._outputColumnNameGenerator);
                }
            }
        } else {
            if (this._sourceNodes != null && this._sourceNodes.getSourceNode().size() > 0 && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_CARTESIAN_SETTING_ON"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jCartesianChkBox.setSelected(false);
                return;
            }
            this._isCartesianJoin = false;
            this._sourceNodes = null;
            this._keyColumns = new JoinKeyColumnsType();
            this._keyColumns.setAutoSpec(AutoSpecType.NO);
            JoinNode.removeOutputAttrsFromNodes(this._outputColumns, null, this._outputColumnNameGenerator);
        }
        if (this.isPIMode() || this.isPIDialogMode()) {
            this._updateOutputColumn = true;
        } else {
            this._parent.getDataPanel().setOutputColumns(this._outputColumns);
            this._parent.getDataPanel().setDirty(true);
            this._parent.getDataPanel().reloadModel();
        }
        this._dirty = true;
        if (this.isPIMode()) {
            this.updateNode();
        } else {
            this.initUI();
        }
        this.enableControls();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public JoinKeyColumnsType getKeyColumns() {
        return this._keyColumns;
    }

    public JoinOutputColumnsType getJoinOutputColumns() {
        return this._outputColumns;
    }

    public void setKeyColumns(JoinKeyColumnsType joinKeyColumnsType) {
        this._keyColumns = joinKeyColumnsType;
    }

    public JoinSourceNodesType getKeyNodes() {
        return this._sourceNodes;
    }

    public void setKeyNodes(JoinSourceNodesType joinSourceNodesType) {
        this._sourceNodes = joinSourceNodesType;
    }

    public boolean isCartesianJoin() {
        return this._isCartesianJoin;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("EDIT_COLUMN_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "join_keys";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMinimumSize(new Dimension(860, 600));
    }

    private static class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private Icon validIcon;
        private Icon invalidIcon;

        public CustomCellRenderer(Icon icon, Icon icon2) {
            this.validIcon = icon;
            this.invalidIcon = icon2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertRowIndexToModel(n);
            TableModel tableModel = jTable.getModel();
            AttributeStatus attributeStatus = AttributeStatus.VALID;
            if (tableModel instanceof AttrsTableModel) {
                attributeStatus = (AttributeStatus)((AttrsTableModel)((Object)tableModel)).getValueAt(n3, 3);
            } else if (tableModel instanceof KeyNodeTableModel) {
                if (n2 == 0) {
                    attributeStatus = (AttributeStatus)((KeyNodeTableModel)((Object)tableModel)).getValueAt(n3, 2);
                }
            } else if (tableModel instanceof KeyColumnTableModel) {
                if (n2 == 0) {
                    attributeStatus = (AttributeStatus)((KeyColumnTableModel)((Object)tableModel)).getValueAt(n3, 4);
                } else if (n2 == 1) {
                    attributeStatus = (AttributeStatus)((KeyColumnTableModel)((Object)tableModel)).getValueAt(n3, 5);
                }
            }
            if (attributeStatus == AttributeStatus.VALID) {
                this.setIcon(this.validIcon);
            } else {
                this.setIcon(this.invalidIcon);
            }
            return component;
        }
    }

    private class JoinTypeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        String currentValue;
        JComboBox<String> comboComponent = new JComboBox();
        protected static final String EDIT = "edit";

        public JoinTypeEditor() {
            this.comboComponent.setActionCommand(EDIT);
            this.comboComponent.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.currentValue = (String)this.comboComponent.getSelectedItem();
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)object;
            this.comboComponent.removeAllItems();
            JoinType joinType = null;
            JoinKeyColumnsType.JoinColumn joinColumn = (JoinKeyColumnsType.JoinColumn)JoinColumnPanel.this._keyColumns.getJoinColumn().get(n);
            for (int i = 0; i < JoinColumnPanel.this._keyColumns.getJoinColumn().size(); ++i) {
                JoinKeyColumnsType.JoinColumn joinColumn2 = (JoinKeyColumnsType.JoinColumn)JoinColumnPanel.this._keyColumns.getJoinColumn().get(i);
                if (i == n || joinColumn2.getLeftColumn().getNodeId().compareTo(joinColumn.getLeftColumn().getNodeId()) != 0 || joinColumn2.getRightColumn().getNodeId().compareTo(joinColumn.getRightColumn().getNodeId()) != 0) continue;
                joinType = joinColumn2.getType();
                break;
            }
            this.comboComponent.addItem(JoinType.INNER.value());
            this.comboComponent.addItem(JoinType.LEFT_OUTER.value());
            this.comboComponent.addItem(JoinType.RIGHT_OUTER.value());
            this.comboComponent.addItem(JoinType.FULL_OUTER.value());
            this.comboComponent.setSelectedItem(string);
            return this.comboComponent;
        }
    }

    private static class KeyColumnTableModel
    extends SimpleBaseTableModel {
        private static String[] COLUMN_NAMES = new String[]{DialogsLrb.get("JOIN_KEY_COLUMN_NAME1"), DialogsLrb.get("JOIN_KEY_COLUMN_NAME2"), DialogsLrb.get("JOIN_KEY_COLUMN_JOIN")};
        private static final int LEFT_ATTR_NAME = 0;
        private static final int RIGHT_ATTR_NAME = 1;
        private static final int KEY_JOIN = 2;
        private static final int COLUMN_COUNT = 3;
        private static final int LEFT_ATTR_STATUS = 4;
        private static final int RIGHT_ATTR_STATUS = 5;
        private JoinKeyColumnsType _srcData;
        private JoinColumnPanel _parent;
        private boolean _allowEdit;

        public KeyColumnTableModel(JoinColumnPanel joinColumnPanel, JoinKeyColumnsType joinKeyColumnsType, boolean bl) {
            this._parent = joinColumnPanel;
            this._srcData = joinKeyColumnsType;
            this._allowEdit = bl;
            this.setColumnIdentifiers(COLUMN_NAMES);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.getJoinColumn().size() : 0;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2 ? this._allowEdit : false;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (n2 != 2) {
                return;
            }
            JoinKeyColumnsType.JoinColumn joinColumn = (JoinKeyColumnsType.JoinColumn)this._srcData.getJoinColumn().get(n);
            joinColumn.setType(JoinType.fromValue((String)((String)object)));
            this._parent.setDirty(true);
            if (this._parent.isPIMode()) {
                this._parent._updateOutputColumn = true;
                this._parent.updateNode();
            }
        }

        public Object getValueAt(int n, int n2) {
            if (n >= this.getRowCount()) {
                return null;
            }
            JoinKeyColumnsType.JoinColumn joinColumn = (JoinKeyColumnsType.JoinColumn)this._srcData.getJoinColumn().get(n);
            String string = null;
            String string2 = null;
            switch (n2) {
                case 0: {
                    string = ((JoinNode)this._parent.getData()).getDataNodeName(joinColumn.getLeftColumn().getNodeId());
                    string = string == null ? joinColumn.getLeftColumn().getNodeName() : string;
                    string2 = string + "." + joinColumn.getLeftColumn().getName();
                    break;
                }
                case 1: {
                    string = ((JoinNode)this._parent.getData()).getDataNodeName(joinColumn.getRightColumn().getNodeId());
                    string = string == null ? joinColumn.getRightColumn().getNodeName() : string;
                    string2 = string + "." + joinColumn.getRightColumn().getName();
                    break;
                }
                case 2: {
                    string2 = joinColumn.getType().value();
                    break;
                }
                case 4: {
                    string2 = joinColumn.getLeftColumn().getStatus();
                    break;
                }
                case 5: {
                    string2 = joinColumn.getRightColumn().getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string2;
        }
    }

    private static class KeyNodeTableModel
    extends SimpleBaseTableModel {
        private static final String[] COLUMN_NAMES = new String[]{DialogsLrb.get("JOIN_KEY_NODE_NAME")};
        private static final int NODE_NAME = 0;
        private static final int COLUMN_COUNT = 1;
        private static final int NODE_STATUS = 2;
        private JoinSourceNodesType _srcData;
        private JoinColumnPanel _parent;

        public KeyNodeTableModel(JoinColumnPanel joinColumnPanel, JoinSourceNodesType joinSourceNodesType) {
            this._parent = joinColumnPanel;
            this._srcData = joinSourceNodesType;
            this.setColumnIdentifiers(COLUMN_NAMES);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(1);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.getSourceNode().size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            JoinSourceNodesType.SourceNode sourceNode = (JoinSourceNodesType.SourceNode)this._srcData.getSourceNode().get(n);
            String string = null;
            Object object = null;
            switch (n2) {
                case 0: {
                    string = ((JoinNode)this._parent.getData()).getDataNodeName(sourceNode.getNodeId());
                    string = string == null ? sourceNode.getNodeName() : string;
                    object = string;
                    break;
                }
                case 2: {
                    object = sourceNode.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }

    private static class AttrsTableModel
    extends SimpleBaseTableModel {
        private static final String[] _columnNames = new String[]{DialogsLrb.get("JOIN_ATTR_NAME"), DialogsLrb.get("JOIN_DATA_TYPE")};
        private static final int ATTR_COLUMN = 0;
        private static final int DATA_TYPE = 1;
        private static final int COLUMN_COUNT = 2;
        private static final int ATTR_STATUS = 3;
        private static final int SEL_OBJECT = 4;
        private List<AttributeType> _srcData;

        public AttrsTableModel(List<AttributeType> list) {
            this._srcData = list;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(2);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AttributeType attributeType = this._srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = attributeType.getName();
                    break;
                }
                case 1: {
                    object = DatabaseMetadataUtils.getJSONDataType(attributeType.getDataType(), attributeType.getDataTypeQualifier());
                    break;
                }
                case 3: {
                    object = attributeType.getStatus();
                    break;
                }
                case 4: {
                    object = attributeType;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }
}

