/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;

public class GLMTargetValuesPanel
extends JPanel
implements DataminerGUIPanel,
ActionListener,
ListSelectionListener {
    private JLabel jLabelTarget;
    private JRadioButton jRadioAuto;
    private JRadioButton jRadioCustom;
    private JScrollPane jScrollPane1;
    private DataMinerTable niceTableTargets;
    private static SystemDefaultTableAttributesModel _sysDefault;
    private ModelPropertiesState _state;
    private static String _TARGET_VALUE;
    static String[] _columnNames;

    public GLMTargetValuesPanel(ModelPropertiesState modelPropertiesState) {
        this._state = modelPropertiesState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jRadioAuto = new JRadioButton();
        this.jRadioCustom = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.niceTableTargets = new DataMinerTable();
        this.jLabelTarget = new JLabel();
        buttonGroup.add(this.jRadioAuto);
        buttonGroup.add(this.jRadioCustom);
        this.jRadioAuto.setText("Auto");
        this.jRadioAuto.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAuto.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioCustom.setText("Custom");
        this.jRadioCustom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioCustom.setMargin(new Insets(0, 0, 0, 0));
        this.niceTableTargets.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)((Object)this.niceTableTargets));
        this.jLabelTarget.setText("Target");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioAuto, -2, 125, -2).addComponent(this.jRadioCustom).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLabelTarget, -2, 180, -2)))).addGroup(groupLayout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.jScrollPane1, -1, 308, Short.MAX_VALUE))).addGap(30, 30, 30)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.jRadioAuto).addGap(18, 18, 18).addComponent(this.jRadioCustom).addGap(15, 15, 15).addComponent(this.jLabelTarget).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 182, -2).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.jRadioAuto.setText(DialogsLrb.get("GLMS_REFERENCE_CLASS_DLG_AUTO"));
        this.jRadioCustom.setText(DialogsLrb.get("GLMS_REFERENCE_CLASS_DLG_CUSTOM"));
        this.jLabelTarget.setText(DialogsLrb.get("GLMS_REFERENCE_CLASS_DLG_TARGET"));
    }

    @Override
    public void initUI() {
        String string = this._state.getCurClassRefValue();
        boolean bl = string.equals(ModelPropertiesState.DEFAULT_CLASS_REF_NAME);
        this.jRadioAuto.setSelected(bl);
        this.jRadioCustom.setSelected(!bl);
        int n = 0;
        TableAttributesModel tableAttributesModel = null;
        if (!bl && this._state.isGlmClassRefValuesLoaded()) {
            tableAttributesModel = new TableAttributesModel(this._state.getGlmClassRefValues());
            n = tableAttributesModel.getDataList().indexOf(this._state.getCurClassRefValue());
        } else {
            _sysDefault = new SystemDefaultTableAttributesModel();
            tableAttributesModel = _sysDefault;
        }
        this.setupTable(tableAttributesModel, n);
        this.jRadioAuto.addActionListener(this);
        if (this._state.isDataSourcePresent() && this._state.isTargetSelected()) {
            this.jRadioCustom.addActionListener(this);
        } else {
            this.jRadioCustom.setEnabled(false);
        }
    }

    private void setupTable(TableAttributesModel tableAttributesModel, int n) {
        this.niceTableTargets.setModel((TableModel)((Object)tableAttributesModel));
        this.niceTableTargets.setSelectionMode(0);
        if (n != -1) {
            this.niceTableTargets.setSelectedRowsInModel(new int[]{n});
        }
        ListSelectionModel listSelectionModel = this.niceTableTargets.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.niceTableTargets.getSelectedRow();
        if (n == -1) {
            return;
        }
        TableAttributesModel tableAttributesModel = (TableAttributesModel)((Object)this.niceTableTargets.getModel());
        String string = tableAttributesModel.getDataList().get(n);
        this._state.setCurClassRefValue(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)object;
            if (jRadioButton.equals(this.jRadioCustom)) {
                if (!this._state.isGlmClassRefValuesLoaded()) {
                    this.launch();
                }
                if (this._state.isGlmClassRefValuesLoaded()) {
                    this.setupTable(new TableAttributesModel(this._state.getGlmClassRefValues()), -1);
                } else {
                    this.niceTableTargets.setModel((TableModel)((Object)new FailedLoadingTableAttributesModel()));
                }
            } else if (jRadioButton.equals(this.jRadioAuto)) {
                this.niceTableTargets.setModel((TableModel)((Object)_sysDefault));
            }
        }
    }

    private boolean launch() {
        GLMClassRefLoader gLMClassRefLoader = new GLMClassRefLoader();
        gLMClassRefLoader.setTitle(DialogsLrb.get("GLMS_RETRIEVING_AVAILABLE_REFERENCE_CLASS_VALUES"));
        gLMClassRefLoader.setMessage(DialogsLrb.get("GLMS_RETRIEVING_AVAILABLE_REFERENCE_CLASS_VALUES_DETAILS"));
        boolean bl = true;
        try {
            gLMClassRefLoader.start(true);
        }
        catch (ProgressException progressException) {
            bl = false;
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)progressException, (String)DialogsLrb.get("GLMS_ERROR_RETRIEVING_AVAILABLE_REFERENCE_APP_ERROR"), (String)DialogsLrb.get("GLMS_ERROR_RETRIEVING_AVAILABLE_REFERENCE_CLASS_VALUES"), null);
        }
        return bl;
    }

    public boolean doWork() {
        int n = this.niceTableTargets.getSelectedRow();
        return -1 != n;
    }

    static {
        _TARGET_VALUE = DialogsLrb.get("GLMS_REFERENCE_CLASS_DLG_TARGET_VALUE");
        _columnNames = new String[]{_TARGET_VALUE};
    }

    class GLMClassRefLoader
    extends ProgressRunnable {
        private boolean _canceled;
        List<String> _values;

        GLMClassRefLoader() {
        }

        protected Object doWork() throws Exception {
            LoadingTableAttributesModel loadingTableAttributesModel = new LoadingTableAttributesModel();
            GLMTargetValuesPanel.this.niceTableTargets.setModel((TableModel)((Object)loadingTableAttributesModel));
            this._values = GLMTargetValuesPanel.this._state.getGlmClassRefValues();
            return this._values;
        }

        protected void finish(Object object) {
            TableAttributesModel tableAttributesModel = new TableAttributesModel(this._values);
            GLMTargetValuesPanel.this.setupTable(tableAttributesModel, -1);
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    class TableAttributesModel
    extends SimpleBaseTableModel {
        protected List<String> _data = new ArrayList<String>();
        protected final int COLUMN_COUNT = 1;
        public static final int VALUE = 0;

        protected TableAttributesModel(String string) {
            this.setColumnIdentifiers(_columnNames);
            this._data = new ArrayList<String>();
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        protected TableAttributesModel(List<String> list) {
            this.setColumnIdentifiers(_columnNames);
            this._data = new ArrayList<String>(list.size());
            this._data.addAll(list);
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            String string = null;
            switch (n2) {
                case 0: {
                    string = this._data.get(n);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public List<String> getDataList() {
            return this._data;
        }
    }

    class LoadingTableAttributesModel
    extends TableAttributesModel {
        public LoadingTableAttributesModel() {
            super(DialogsLrb.get("GLMS_REFERENCE_CLASS_LOADING"));
        }
    }

    class FailedLoadingTableAttributesModel
    extends TableAttributesModel {
        public FailedLoadingTableAttributesModel() {
            super(DialogsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAILED"));
        }
    }

    class SystemDefaultTableAttributesModel
    extends TableAttributesModel {
        public SystemDefaultTableAttributesModel() {
            super(ModelPropertiesState.DEFAULT_CLASS_REF_NAME);
        }
    }
}

