/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.modeldetails;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.AvailableRefModelType;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelOutputColumnsListPanel;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelsTableModel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowModelDetailsNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.ExtractQueryFactory;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class EditModelDetailsPanel
extends DialogDisplayer<ModelDetailsDataNode> {
    private static final Logger logger = Logger.getLogger(EditModelDetailsPanel.class.getName());
    private static final String UNDEFINED = ModelDetailsLrb.get("UNDEFINED_SELECTION");
    private String _ownerName;
    private boolean _dirty = false;
    private ModelDetailsOutputType _modelOutputType;
    private ModelDetailsOutputType _updatedModelOutputType = null;
    private List<RefModelType> _models;
    private ModelDetailsDataNode _node;
    private ModelsTableModel _selectedModelsTableModel;
    private ModelsTableModel _availableModelsTableModel;
    private MiningFunctions _currentMiningFunction;
    private MiningAlgorithmOptions _currentAlgorithmOption;
    private MiningDetailsOutputType _currentMiningDetailOutputType;
    private List<OutputAttributeType> _currentOutputColumns;
    private ModelDetailType _modelDetailType;
    private Version _dbVersion;
    private DefaultComboBoxModel<MiningAlgorithmOptions> algorithmComboModel;
    private DataMinerTablePanel availableModelsTablePanel;
    private JButton jDisplayColumnsButton;
    private JLabel jMiningAlgorithmSelectedLabel;
    private JLabel jMiningAlgorithmValue;
    private JLabel jMiningFunctionLabel;
    private JLabel jMiningFunctionSelectedLabel;
    private JLabel jMiningFunctionSelectedValue;
    private JLabel jMiningFunctionValue;
    private JComboBox<MiningAlgorithmOptions> jModelAlgorithmCombo;
    private JLabel jModelAlgorithmLabel;
    private JComboBox<MiningDetailsOutputType> jOutputTypeCombo;
    private JLabel jOutputTypeLabel;
    private JLabel jOutputTypeSelectedLabel;
    private JLabel jOutputTypeSelectedValue;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTablePanel selectedModelsTablePanel;
    private JPanel tablesPanel;
    private JPanel topPanel;

    public EditModelDetailsPanel(Context context, ModelDetailsDataNode modelDetailsDataNode, ModelDetailsOutputType modelDetailsOutputType) {
        super(context, modelDetailsDataNode);
        assert (context != null) : "Context must not be null.";
        assert (modelDetailsDataNode != null) : "Model details data node must not be null.";
        this._context = context;
        this._node = modelDetailsDataNode;
        this._modelOutputType = modelDetailsOutputType;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        this._dbVersion = connectionFolder.getDbVersion();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.jMiningFunctionValue = new JLabel();
        this.jMiningFunctionSelectedValue = new JLabel();
        this.jOutputTypeSelectedValue = new JLabel();
        this.jMiningAlgorithmValue = new JLabel();
        this.jMiningFunctionSelectedLabel = new JLabel();
        this.jMiningFunctionLabel = new JLabel();
        this.jDisplayColumnsButton = new JButton();
        this.jMiningAlgorithmSelectedLabel = new JLabel();
        this.jOutputTypeSelectedLabel = new JLabel();
        this.jModelAlgorithmLabel = new JLabel();
        this.jModelAlgorithmCombo = new JComboBox();
        this.jOutputTypeLabel = new JLabel();
        this.jOutputTypeCombo = new JComboBox();
        this.tablesPanel = new JPanel();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.availableModelsTablePanel = new DataMinerTablePanel();
        this.selectedModelsTablePanel = new DataMinerTablePanel();
        this.setLayout(new BorderLayout());
        this.jMiningFunctionValue.setText("Classification");
        this.jMiningFunctionSelectedValue.setText("Classification");
        this.jOutputTypeSelectedValue.setText("Full Tree");
        this.jMiningAlgorithmValue.setText("Decision Tree");
        this.jMiningFunctionSelectedLabel.setText("Function:");
        this.jMiningFunctionLabel.setText("Model Function:");
        this.jDisplayColumnsButton.setText("Columns...");
        this.jMiningAlgorithmSelectedLabel.setText("Algorithm:");
        this.jOutputTypeSelectedLabel.setText("Output:");
        this.jModelAlgorithmLabel.setText("Model Type:");
        this.jOutputTypeLabel.setText("Output Type:");
        GroupLayout groupLayout = new GroupLayout(this.topPanel);
        this.topPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jOutputTypeLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jModelAlgorithmLabel, GroupLayout.Alignment.LEADING, -2, 81, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jOutputTypeCombo, GroupLayout.Alignment.LEADING, -2, 194, -2).addComponent(this.jModelAlgorithmCombo, GroupLayout.Alignment.LEADING, -2, 194, -2)).addGap(10, 10, 10).addComponent(this.jDisplayColumnsButton, -2, 101, -2)).addComponent(this.jMiningFunctionValue, -2, 279, -2)).addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jMiningFunctionSelectedLabel, -1, 78, Short.MAX_VALUE).addComponent(this.jMiningAlgorithmSelectedLabel, -1, 78, Short.MAX_VALUE).addComponent(this.jOutputTypeSelectedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jMiningAlgorithmValue, GroupLayout.Alignment.LEADING, -1, 270, Short.MAX_VALUE).addComponent(this.jMiningFunctionSelectedValue, -1, -1, Short.MAX_VALUE).addComponent(this.jOutputTypeSelectedValue, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(0, this.jMiningAlgorithmSelectedLabel, this.jMiningFunctionSelectedLabel, this.jOutputTypeSelectedLabel);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMiningFunctionLabel).addComponent(this.jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jModelAlgorithmLabel).addComponent(this.jModelAlgorithmCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOutputTypeCombo, -2, -1, -2).addComponent(this.jDisplayColumnsButton)).addComponent(this.jOutputTypeLabel))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMiningFunctionSelectedLabel).addComponent(this.jMiningFunctionSelectedValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMiningAlgorithmSelectedLabel).addComponent(this.jMiningAlgorithmValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOutputTypeSelectedLabel).addComponent(this.jOutputTypeSelectedValue)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jMiningFunctionLabel, this.jMiningFunctionSelectedLabel, this.jMiningFunctionSelectedValue, this.jMiningFunctionValue);
        groupLayout.linkSize(1, this.jMiningAlgorithmSelectedLabel, this.jMiningAlgorithmValue, this.jModelAlgorithmCombo, this.jModelAlgorithmLabel);
        groupLayout.linkSize(1, this.jOutputTypeCombo, this.jOutputTypeLabel, this.jOutputTypeSelectedLabel, this.jOutputTypeSelectedValue);
        this.add((Component)this.topPanel, "North");
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveAllBtn.setText("<<");
        this.jRemoveBtn.setText("<");
        GroupLayout groupLayout2 = new GroupLayout(this.tablesPanel);
        this.tablesPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.availableModelsTablePanel, -1, 340, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -2, 49, -2)).addGap(18, 18, 18).addComponent(this.selectedModelsTablePanel, -1, 341, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(53, 53, 53).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.selectedModelsTablePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.availableModelsTablePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        this.add((Component)this.tablesPanel, "Center");
    }

    @Override
    public void initRes() {
        this.initIcons();
        ResourceUtils.resLabel((JLabel)this.jMiningFunctionLabel, (Component)this.jMiningFunctionValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jModelAlgorithmLabel, this.jModelAlgorithmCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE"));
        this.jModelAlgorithmCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        this.jModelAlgorithmCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jOutputTypeLabel, this.jOutputTypeCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this.jOutputTypeCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this.jOutputTypeCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMiningFunctionSelectedLabel, (Component)this.jMiningFunctionSelectedValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_FUNCTION"));
        this.jMiningFunctionSelectedValue.setText(UNDEFINED);
        ResourceUtils.resLabel((JLabel)this.jMiningAlgorithmSelectedLabel, (Component)this.jMiningAlgorithmValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_ALGORITHM"));
        this.jMiningAlgorithmValue.setText(UNDEFINED);
        ResourceUtils.resLabel((JLabel)this.jOutputTypeSelectedLabel, (Component)this.jOutputTypeSelectedValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this.jOutputTypeSelectedValue.setText(UNDEFINED);
        this.jMiningAlgorithmSelectedLabel.setVisible(false);
        this.jMiningAlgorithmValue.setVisible(false);
        this.jMiningFunctionSelectedLabel.setVisible(false);
        this.jMiningFunctionSelectedValue.setVisible(false);
        this.jOutputTypeSelectedLabel.setVisible(false);
        this.jOutputTypeSelectedValue.setVisible(false);
        ResourceUtils.resButton((AbstractButton)this.jDisplayColumnsButton, (String)ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON"));
        this.jDisplayColumnsButton.getAccessibleContext().setAccessibleDescription(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
        this.jDisplayColumnsButton.setToolTipText(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
        HelpUtils.setHelpID((JComponent)this, (String)"edit_selection_details");
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        if (!this._dirty) {
            return true;
        }
        ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
        try {
            this._updatedModelOutputType = bl ? modelDetailsOutputType : null;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
        }
        return bl;
    }

    private ModelDetailsOutputType generateModelOutputType() {
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        Attributes attributes = new Attributes();
        ModelDetailsOutputType.Models models = this._selectedModelsTableModel.getRowCount() == 0 ? new ModelDetailsOutputType.Models() : this._selectedModelsTableModel.generateModelsCollection();
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setAttributes(attributes);
        MiningDetailsOutputType miningDetailsOutputType = MiningDetailsOutputType.fromString(this._currentMiningDetailOutputType.toString());
        MiningAlgorithmOptions miningAlgorithmOptions = MiningAlgorithmOptions.fromString(this._currentAlgorithmOption.toString());
        MiningFunctions miningFunctions = MiningFunctions.fromString(this._currentMiningFunction.toString());
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setType(MiningDetailsOutputType.getMiningDetailType(miningDetailsOutputType, miningAlgorithmOptions, miningFunctions));
        modelDetailsOutputType.setAutoSpec(AutoSpecType.fromValue((String)"No"));
        modelDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(this._currentOutputColumns));
        return modelDetailsOutputType;
    }

    private void initIcons() {
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    @Override
    public void initUI() {
        ModelDetailsDataNode modelDetailsDataNode = this._node;
        if (modelDetailsDataNode == null) {
            return;
        }
        this._ownerName = ConnectionFolder.getUserAccountName(this._context);
        this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        this._dbVersion = connectionFolder.getDbVersion();
        this.loadData();
        this.loadTables();
        this.initComboBoxes();
        this.initOutputColumns();
        this.jDisplayColumnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelOutputColumnsListPanel modelOutputColumnsListPanel = new ModelOutputColumnsListPanel(EditModelDetailsPanel.this.getContext(), EditModelDetailsPanel.this._currentOutputColumns, (ModelDetailsDataNode)EditModelDetailsPanel.this.getData());
                modelOutputColumnsListPanel.showAsDialog(EditModelDetailsPanel.this);
            }
        });
        this.jModelAlgorithmCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this.processAlgorithmComboAction();
            }
        });
        this.jOutputTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this.processOutputTypeComboAction();
            }
        });
        this.jSelectBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this.moveAvailableRows();
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this.availableModelsTablePanel.getTable().selectAll();
                EditModelDetailsPanel.this.moveAvailableRows();
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this.moveSelectedRows();
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this.selectedModelsTablePanel.getTable().selectAll();
                EditModelDetailsPanel.this.moveSelectedRows();
            }
        });
    }

    private void moveSelectedRows() {
        int[] nArray = this.selectedModelsTablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        this.moveItems(this.selectedModelsTablePanel.getTable(), this.availableModelsTablePanel.getTable());
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.selectedModelsTablePanel.getTable().getModel());
        modelsTableModel.setOwnerOnly(!modelsTableModel.isModelsFromOtherSchemas());
        this.filterAvailableBasedOnSelected();
    }

    private void moveAvailableRows() {
        int[] nArray = this.availableModelsTablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this.availableModelsTablePanel.getTable().getSelectedRowsInModel();
        this.moveItems(this.availableModelsTablePanel.getTable(), this.selectedModelsTablePanel.getTable());
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.selectedModelsTablePanel.getTable().getModel());
        modelsTableModel.setOwnerOnly(!modelsTableModel.isModelsFromOtherSchemas());
        this.setSelectionOnInsertedRows(this.selectedModelsTablePanel.getTable(), nArray2.length);
        this.filterAvailableBasedOnSelected();
    }

    private void filterAvailableBasedOnSelected() {
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.selectedModelsTablePanel.getTable().getModel());
        if (modelsTableModel.getRowCount() > 0) {
            this.jMiningFunctionSelectedValue.setText(this._currentMiningFunction.toString());
            this.jMiningAlgorithmValue.setText(this._currentAlgorithmOption.toString());
            this.jModelAlgorithmCombo.setEnabled(false);
            this.jOutputTypeSelectedValue.setText(this._currentMiningDetailOutputType.toString());
        } else {
            this.jMiningFunctionSelectedValue.setText(UNDEFINED);
            this.jMiningAlgorithmValue.setText(UNDEFINED);
            this.jModelAlgorithmCombo.setEnabled(true);
            this.jOutputTypeSelectedValue.setText(UNDEFINED);
        }
    }

    private void setSelectionOnInsertedRows(GenericTable genericTable, int n) {
        genericTable.setRowSelectionInterval(genericTable.getModel().getRowCount() - n, genericTable.getModel().getRowCount() - 1);
        genericTable.scrollToSelection();
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2) {
        int[] nArray = genericTable.getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)genericTable.getModel());
        ModelsTableModel modelsTableModel2 = (ModelsTableModel)((Object)genericTable2.getModel());
        modelsTableModel2.addSelection(modelsTableModel, nArray);
        if (modelsTableModel2.isFilteredTableModel()) {
            this._availableModelsTableModel.addSelection(modelsTableModel, nArray);
        }
        if (genericTable2.equals((Object)this.selectedModelsTablePanel.getTable())) {
            this.setSelectionOnInsertedRows(genericTable2, nArray.length);
        }
        if (modelsTableModel.isFilteredTableModel()) {
            this._availableModelsTableModel.removeDuplicateRows(modelsTableModel.getSrcData(), nArray);
        }
        modelsTableModel.removeSelectedRows(nArray);
    }

    private void processOutputTypeComboAction() {
        MiningDetailsOutputType miningDetailsOutputType = (MiningDetailsOutputType)((Object)this.jOutputTypeCombo.getSelectedItem());
        if (this._currentMiningDetailOutputType != miningDetailsOutputType) {
            this._currentMiningDetailOutputType = miningDetailsOutputType;
            this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
            if (this.selectedModelsTablePanel.getTable().getRowCount() > 0) {
                this.jOutputTypeSelectedValue.setText(this._currentMiningDetailOutputType.toString());
            }
            this.initOutputColumns();
        }
    }

    private void processAlgorithmComboAction() {
        MiningAlgorithmOptions miningAlgorithmOptions = (MiningAlgorithmOptions)((Object)this.jModelAlgorithmCombo.getSelectedItem());
        if (this._currentAlgorithmOption != miningAlgorithmOptions) {
            this._currentAlgorithmOption = miningAlgorithmOptions;
            this.setupOutputTypeCombo(this._currentMiningFunction, this._currentAlgorithmOption);
        }
    }

    private void setupOutputTypeCombo(MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions) {
        this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._dbVersion, miningFunctions, miningAlgorithmOptions)));
        this._currentMiningDetailOutputType = MiningDetailsOutputType.getPreferredOutputTypeForModelDetailsNode(miningFunctions, miningAlgorithmOptions);
        this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        this.initOutputColumns();
    }

    private void loadTables() {
        try {
            this._selectedModelsTableModel = new ModelsTableModel(this._models, this._ownerName, this._node, true);
            this.setupModelsTable(this.selectedModelsTablePanel, ModelDetailsLrb.get("SELECTED_MODELS"), this._selectedModelsTableModel);
            this._availableModelsTableModel = new ModelsTableModel(this._ownerName, this._node);
            this._availableModelsTableModel.removeDuplicateRowsBasedOnMatch(this._selectedModelsTableModel.getSrcData());
            this.setupModelsTable(this.availableModelsTablePanel, ModelDetailsLrb.get("AVAILABLE_MODELS"), this._availableModelsTableModel);
            if (this.availableModelsTablePanel.getTable().getRowCount() > 0) {
                this.availableModelsTablePanel.getTable().setSelectedRowsInModel(new int[]{0});
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("ERROR_TITLE"), (String)ModelDetailsLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void setupModelsTable(DataMinerTablePanel dataMinerTablePanel, String string, ModelsTableModel modelsTableModel) {
        dataMinerTablePanel.setup((TableModel)((Object)modelsTableModel), string, 0, true);
        dataMinerTablePanel.getTable().setSortColumn(0, true);
        dataMinerTablePanel.getTable().setUpdateSelectionOnSort(true);
        dataMinerTablePanel.getTable().getTableHeader().setReorderingAllowed(false);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                GenericTable genericTable = (GenericTable)jTable;
                int n3 = genericTable.convertRowIndexToModel(n);
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)genericTable.getModel());
                AvailableRefModelType availableRefModelType = (AvailableRefModelType)((Object)modelsTableModel.getSrcData().get(n3));
                if (availableRefModelType.getStatus() == RefModelStatusType.VALID && modelsTableModel.isModelBuilt(n3)) {
                    return DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT);
                }
                if (availableRefModelType.getStatus() == RefModelStatusType.VALID && !modelsTableModel.isModelBuilt(n3)) {
                    return DataMinerIcons.getNullIcon();
                }
                return OracleIcons.getIcon((String)"database_error.png");
            }
        });
        TableColumn tableColumn = dataMinerTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
    }

    private void initOutputColumns() {
        if (this._currentMiningDetailOutputType != null && this._currentAlgorithmOption != null && this._currentMiningFunction != null) {
            this._currentOutputColumns = ExtractQueryFactory.getModelColumnList(this._node, MiningDetailsOutputType.getMiningDetailType(this._currentMiningDetailOutputType, this._currentAlgorithmOption, this._currentMiningFunction), this._dbVersion);
        }
    }

    private void initComboBoxes() {
        this.jMiningFunctionValue.setText(this._currentMiningFunction.toString());
        this.jMiningFunctionSelectedValue.setText(this._currentMiningFunction.toString());
        this.algorithmComboModel = new DefaultComboBoxModel();
        MiningAlgorithmOptions.getMiningAlgorithmOptions(this._dbVersion, this._currentMiningFunction).forEach(miningAlgorithmOptions -> this.algorithmComboModel.addElement((MiningAlgorithmOptions)((Object)miningAlgorithmOptions)));
        this.jModelAlgorithmCombo.setModel(this.algorithmComboModel);
        if (!this._models.isEmpty()) {
            this.jModelAlgorithmCombo.setEnabled(false);
        } else {
            this.jModelAlgorithmCombo.setEnabled(true);
        }
        this.algorithmComboModel.setSelectedItem((Object)this._currentAlgorithmOption);
        this.jMiningAlgorithmValue.setText(this._currentAlgorithmOption.toString());
        this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._dbVersion, this._currentMiningFunction, this._currentAlgorithmOption)));
        this.jOutputTypeCombo.setEnabled(true);
        this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        this.jOutputTypeSelectedValue.setText(this._currentMiningDetailOutputType.toString());
    }

    private void loadData() {
        if (this._modelOutputType != null) {
            this._models = this._modelOutputType.getModels().getModel();
            this._modelDetailType = this._modelOutputType.getType();
            this._currentMiningDetailOutputType = MiningDetailsOutputType.getMiningDetailsOutputType(this._modelDetailType);
            this._currentMiningFunction = MiningFunctions.getMiningFunctionsFromType(this._modelOutputType.getMiningFunction());
            this._currentAlgorithmOption = MiningAlgorithmOptions.getMiningAlgorithmOption(this._modelOutputType.getMiningAlgorithm());
            this._currentOutputColumns = OutputAttributeType.convertAttributes((Attributes)this._modelOutputType.getAttributes());
        } else {
            this._models = null;
            this._currentMiningDetailOutputType = null;
            this._currentMiningFunction = null;
            this._currentAlgorithmOption = null;
            this._currentOutputColumns = null;
        }
    }

    protected ModelDetailsDataNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowModelDetailsNodePropertyProxyModel)) {
            return null;
        }
        WorkflowModelDetailsNodePropertyProxyModel workflowModelDetailsNodePropertyProxyModel = (WorkflowModelDetailsNodePropertyProxyModel)propertyModel;
        Context context = workflowModelDetailsNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ModelDetailsDataNodeType) {
            return (ModelDetailsDataNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    public void setUpdatedModelOutputType(ModelDetailsOutputType modelDetailsOutputType) {
        this._updatedModelOutputType = modelDetailsOutputType;
    }

    public ModelDetailsOutputType getUpdatedModelOutputType() {
        return this._updatedModelOutputType;
    }

    @Override
    protected String getDialogTitle() {
        return ModelDetailsLrb.get("EDIT_DIALOG_MODEL_SELECTIONS_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "edit_selection_details";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMaximumInitialSize(new Dimension(920, 400));
    }
}

