/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.modeldetails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.AvailableRefModelType;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class ModelsTableModel
extends ODMrTableModel<AvailableRefModelType> {
    private Map<String, AvailableRefModelType> _svmLinearModels = new HashMap<String, AvailableRefModelType>();
    private boolean _ownerOnly = true;
    private String _ownerName;
    private boolean _filteredTableModel = false;
    private ModelDetailsDataNode _modelDetailsDataNode = null;
    private static final String[] _columnNames_12_2_And_Up = new String[]{PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_MODEL"), PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_NODE"), PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_ALGORITHM"), DialogsLrb.get("MODEL_NODE_PARTITION_KEYS")};
    private static final String[] _columnNames = new String[]{PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_MODEL"), PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_NODE"), PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_ALGORITHM")};
    public static final int MODEL_NAME = 0;
    public static final int NODE_NAME = 1;
    public static final int ALGORITHM = 2;
    public static final int PARTITION_KEY = 3;
    public static final int FILTER_MODEL_NAME = 1;
    public static final int FILTER_NODE_NAME = 2;
    public static final int FILTER_MODEL_ALGORITHM = 3;
    public static final int FILTER_MODEL_PARTITION_KEY = 4;

    public ModelsTableModel() {
        super(_columnNames_12_2_And_Up);
        this.setRowCount(this.srcData.size());
    }

    public ModelsTableModel(String string, ModelDetailsDataNode modelDetailsDataNode) throws Exception {
        super(_columnNames);
        this._modelDetailsDataNode = modelDetailsDataNode;
        this._ownerName = string;
        this.addParentRefModels(modelDetailsDataNode);
        Version version = ConnectionFolder.getConnectionFolder(this._modelDetailsDataNode.getContext()).getDbVersion();
        if (DbVersionHelper.isDB122Up((Version)version)) {
            this.setColumnIdentifiers(_columnNames_12_2_And_Up);
        } else {
            this.setColumnIdentifiers(_columnNames);
        }
        this.setRowCount(this.srcData.size());
        this.isModelsFromOtherSchemas();
    }

    public ModelsTableModel(List<? extends RefModelType> list, String string, ModelDetailsDataNode modelDetailsDataNode, boolean bl) {
        super(_columnNames);
        this._modelDetailsDataNode = modelDetailsDataNode;
        this._ownerName = string;
        if (bl) {
            this.addRefModels(list);
        } else {
            this.srcData.addAll(list);
        }
        Version version = ConnectionFolder.getConnectionFolder(this._modelDetailsDataNode.getContext()).getDbVersion();
        if (DbVersionHelper.isDB122Up((Version)version)) {
            this.setColumnIdentifiers(_columnNames_12_2_And_Up);
        } else {
            this.setColumnIdentifiers(_columnNames);
        }
        this.setRowCount(this.srcData.size());
        this.isModelsFromOtherSchemas();
    }

    private void addParentRefModels(ModelDetailsDataNode modelDetailsDataNode) throws Exception {
        AvailableRefModelType availableRefModelType;
        List<RefModelType> list;
        ModelProvider modelProvider;
        List<AbstractNode> list2 = modelDetailsDataNode.findParentNodes();
        for (AbstractNode abstractNode : list2) {
            modelProvider = (ModelProvider)((Object)abstractNode);
            list = modelProvider.getOutputModels();
            for (RefModelType refModelType : list) {
                availableRefModelType = new AvailableRefModelType();
                availableRefModelType.setRefModelType(refModelType, null);
                availableRefModelType.setNodeName(abstractNode.getData().getName());
                this.srcData.add(availableRefModelType);
            }
        }
        for (AbstractNode abstractNode : list2) {
            modelProvider = (ModelProvider)((Object)abstractNode);
            list = modelProvider.getSVMLinearModels();
            if (list == null) continue;
            for (RefModelType refModelType : list) {
                availableRefModelType = new AvailableRefModelType();
                availableRefModelType.setRefModelType(refModelType, null);
                availableRefModelType.setNodeName(abstractNode.getData().getName());
                this._svmLinearModels.put(refModelType.getSchema() + "." + refModelType.getName(), availableRefModelType);
            }
        }
    }

    public void reload(List<RefModelType> list) {
        this.srcData.clear();
        this.addRefModels(list);
        this.fireTableDataChanged();
    }

    private void addRefModels(List<RefModelType> list) {
        for (RefModelType refModelType : list) {
            AvailableRefModelType availableRefModelType = new AvailableRefModelType();
            availableRefModelType.setRefModelType(refModelType, null);
            availableRefModelType.setPartitionKey(this._modelDetailsDataNode.getModelPartitionKey(availableRefModelType.getNodeId(), availableRefModelType.getName(), availableRefModelType.getSchema()));
            availableRefModelType.setNodeName(this.getNodeName(availableRefModelType.getNodeId()));
            this.srcData.add(availableRefModelType);
        }
    }

    public boolean containsModelsWithAlgorithm(MiningAlgorithmType miningAlgorithmType) {
        boolean bl = false;
        for (RefModelType refModelType : this.srcData) {
            if (!refModelType.getMiningAlgorithm().equals((Object)miningAlgorithmType)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean containsModelsWithMortThanOneAlgorithm() {
        boolean bl = false;
        MiningAlgorithmType miningAlgorithmType = null;
        for (RefModelType refModelType : this.srcData) {
            if (miningAlgorithmType == null) {
                miningAlgorithmType = refModelType.getMiningAlgorithm();
            }
            if (refModelType.getMiningAlgorithm().equals((Object)miningAlgorithmType)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public MiningAlgorithmType getCommonAlgorithm() {
        MiningAlgorithmType miningAlgorithmType = null;
        boolean bl = true;
        for (RefModelType refModelType : this.srcData) {
            if (miningAlgorithmType == null) {
                miningAlgorithmType = refModelType.getMiningAlgorithm();
            }
            if (refModelType.getMiningAlgorithm().equals((Object)miningAlgorithmType)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return miningAlgorithmType;
        }
        return null;
    }

    public void refreshModelStatus(List<AvailableRefModelType> list) {
        HashMap<String, AvailableRefModelType> hashMap = new HashMap<String, AvailableRefModelType>();
        for (AvailableRefModelType availableRefModelType : list) {
            hashMap.put(availableRefModelType.getFullModelName(), availableRefModelType);
        }
        for (AvailableRefModelType availableRefModelType : this.srcData) {
            AvailableRefModelType availableRefModelType2 = (AvailableRefModelType)((Object)hashMap.get(availableRefModelType.getFullModelName()));
            if (this.doModelsMatch(availableRefModelType2, availableRefModelType)) {
                availableRefModelType.setStatus(RefModelStatusType.INVALID);
                continue;
            }
            availableRefModelType.setStatus(RefModelStatusType.VALID);
        }
    }

    public void removeDuplicateRowsBasedOnMatch(List<AvailableRefModelType> list) {
        HashMap<String, AvailableRefModelType> hashMap = new HashMap<String, AvailableRefModelType>();
        for (AvailableRefModelType availableRefModelType : list) {
            hashMap.put(availableRefModelType.getFullModelName(), availableRefModelType);
        }
        Iterator<AvailableRefModelType> iterator = this.srcData.iterator();
        while (iterator.hasNext()) {
            AvailableRefModelType availableRefModelType;
            availableRefModelType = iterator.next();
            AvailableRefModelType availableRefModelType2 = (AvailableRefModelType)((Object)hashMap.get(availableRefModelType.getFullModelName()));
            if (!this.doModelsMatch(availableRefModelType2, availableRefModelType)) continue;
            iterator.remove();
        }
        this.setRowCount(this.srcData.size());
        this.fireTableDataChanged();
    }

    public List<AvailableRefModelType> createMissingRowsBasedOnMatch(List<AvailableRefModelType> list) {
        HashMap<String, AvailableRefModelType> hashMap = new HashMap<String, AvailableRefModelType>();
        ArrayList<AvailableRefModelType> arrayList = new ArrayList<AvailableRefModelType>();
        for (AvailableRefModelType availableRefModelType : this.srcData) {
            hashMap.put(availableRefModelType.getFullModelName(), availableRefModelType);
        }
        for (AvailableRefModelType availableRefModelType : list) {
            AvailableRefModelType availableRefModelType2;
            if (this.doModelsMatch(availableRefModelType, availableRefModelType2 = (AvailableRefModelType)((Object)hashMap.get(availableRefModelType.getFullModelName())))) continue;
            arrayList.add(availableRefModelType);
        }
        return arrayList;
    }

    private boolean doModelsMatch(AvailableRefModelType availableRefModelType, AvailableRefModelType availableRefModelType2) {
        return availableRefModelType != null && availableRefModelType2 != null && availableRefModelType.getMiningAlgorithm().equals((Object)availableRefModelType2.getMiningAlgorithm()) && availableRefModelType.getMiningFunction().equals((Object)availableRefModelType2.getMiningFunction());
    }

    public MiningFunctionType getCommonFunction() {
        MiningFunctionType miningFunctionType = null;
        boolean bl = true;
        for (RefModelType refModelType : this.srcData) {
            if (miningFunctionType == null) {
                miningFunctionType = refModelType.getMiningFunction();
            }
            if (refModelType.getMiningFunction().equals((Object)miningFunctionType)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return miningFunctionType;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.srcData != null ? this.srcData.size() : 0;
    }

    public boolean isModelBuilt(int n) {
        AvailableRefModelType availableRefModelType = (AvailableRefModelType)((Object)this.srcData.get(n));
        return availableRefModelType.isIsModelBuilt();
    }

    public Object getValueAt(int n, int n2) {
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
        AvailableRefModelType availableRefModelType = (AvailableRefModelType)((Object)this.srcData.get(n));
        String string = null;
        switch (n2) {
            case 0: {
                if (this._ownerOnly) {
                    string = availableRefModelType.getName();
                    break;
                }
                string = availableRefModelType.getSchema() + "." + availableRefModelType.getName();
                break;
            }
            case 1: {
                string = availableRefModelType.getNodeName();
                break;
            }
            case 2: {
                string = MetaDataHelper.getAlgorithmName(availableRefModelType.getMiningAlgorithm());
                break;
            }
            case 3: {
                string = availableRefModelType.getPartitionKey();
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return string;
    }

    public String getNodeName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        List<AbstractNode> list = this._modelDetailsDataNode.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (abstractNode.getMetadataId().compareTo(string) != 0) continue;
            string2 = abstractNode.getData().getName();
        }
        return string2;
    }

    public void removeDuplicateRows(List<AvailableRefModelType> list, int[] nArray) {
        AvailableRefModelType availableRefModelType = null;
        for (int n : nArray) {
            availableRefModelType = list.get(n);
            this.srcData.remove((Object)availableRefModelType);
        }
        this.setRowCount(this.srcData.size());
        this.isModelsFromOtherSchemas();
        this.fireTableDataChanged();
    }

    public boolean isModelsFromOtherSchemas() {
        boolean bl = false;
        for (AvailableRefModelType availableRefModelType : this.srcData) {
            if (availableRefModelType.getSchema().compareTo(this._ownerName) == 0) continue;
            bl = true;
            break;
        }
        this._ownerOnly = !bl;
        return bl;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void addSelection(ModelsTableModel modelsTableModel, int[] nArray) {
        List list = modelsTableModel.getSrcData();
        AvailableRefModelType availableRefModelType = null;
        for (int n : nArray) {
            availableRefModelType = (AvailableRefModelType)((Object)list.get(n));
            this.srcData.add(availableRefModelType);
        }
        this.setRowCount(this.srcData.size());
        this.isModelsFromOtherSchemas();
        this.fireTableDataChanged();
    }

    public boolean isFilteredTableModel() {
        return this._filteredTableModel;
    }

    public void setFilteredTableModel(boolean bl) {
        this._filteredTableModel = bl;
    }

    public void setOwnerOnly(boolean bl) {
        if (bl != this._ownerOnly) {
            this._ownerOnly = bl;
            this.fireTableDataChanged();
        }
    }

    public void removeSelectedRows(int[] nArray) {
        ArrayList<AvailableRefModelType> arrayList = new ArrayList<AvailableRefModelType>();
        AvailableRefModelType availableRefModelType = null;
        for (int i = 0; i < nArray.length; ++i) {
            availableRefModelType = (AvailableRefModelType)((Object)this.srcData.get(nArray[i]));
            arrayList.add(availableRefModelType);
        }
        this.srcData.removeAll(arrayList);
        this.setRowCount(this.srcData.size());
        this.isModelsFromOtherSchemas();
        this.fireTableDataChanged();
    }

    public boolean isModelInvalid(int n) {
        AvailableRefModelType availableRefModelType = (AvailableRefModelType)((Object)this.srcData.get(n));
        return availableRefModelType.getStatus().equals((Object)RefModelStatusType.INVALID);
    }

    public String getInvalidMessage(int n) {
        AvailableRefModelType availableRefModelType = (AvailableRefModelType)((Object)this.srcData.get(n));
        if (availableRefModelType.getStatus().equals((Object)RefModelStatusType.INVALID)) {
            return availableRefModelType.getError() != null ? availableRefModelType.getError().toString() : "Unknown Error Type";
        }
        return "";
    }

    public ModelDetailsOutputType.Models generateModelsCollection() {
        ModelDetailsOutputType.Models models = new ModelDetailsOutputType.Models();
        List list = models.getModel();
        list.clear();
        for (AvailableRefModelType availableRefModelType : this.srcData) {
            RefModelType refModelType = new RefModelType();
            refModelType.setSchema(availableRefModelType.getSchema());
            refModelType.setName(availableRefModelType.getName());
            refModelType.setMiningAlgorithm(availableRefModelType.getMiningAlgorithm());
            refModelType.setMiningFunction(availableRefModelType.getMiningFunction());
            refModelType.setModelId(availableRefModelType.getModelId());
            refModelType.setNodeId(availableRefModelType.getNodeId());
            refModelType.setStatus(availableRefModelType.getStatus());
            refModelType.setIsModelBuilt(availableRefModelType.isIsModelBuilt());
            refModelType.setUseForOutput(availableRefModelType.isUseForOutput());
            list.add(refModelType);
        }
        return models;
    }
}

