/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.tests;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.tests.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.TestLiftProfitDialogPanel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowTestNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;

public class TargetPanel
extends AbstractPanel<TestNode> {
    private static final Logger LOGGER = Logger.getLogger(TargetPanel.class.getName());
    private static final String TEST_NONE = DialogsLrb.get("TEST_NONE");
    private static final String UNKNOWN = DialogsLrb.get("TEST_UNKNOWN");
    private PropertyModel _propertyModel;
    private TestModelType _models;
    private AttributeType _caseAttr;
    private boolean _caseIdDirty;
    private boolean _loading = false;
    private HashMap<String, AttributeType> _caseIdLookupMap = new HashMap();
    private JCheckBox jAccuracyMetricsCheckBox;
    private DataMinerCombBox jCaseIdComboBox;
    private JLabel jCaseIdLabel;
    private JCheckBox jConfusionMatrixCheckBox;
    private JButton jEditTargetsButton;
    private JCheckBox jLiftProfitCheckBox;
    private JLabel jLiftProfitTargetSelectionLabel;
    private JLabel jMiningFunctionLabel;
    private JLabel jMiningFunctionValue;
    private JCheckBox jROCCheckBox;
    private JCheckBox jResidualsCheckBox;
    private JLabel jTargetLabel;
    private JLabel jTargetTypeLabel;
    private JLabel jTargetTypeValue;
    private JLabel jTargetValue;
    private JLabel jTestResultsLabel;
    private JLabel jWarnIcon;

    public TargetPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for test node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.init((TestNode)this._data, propertyModel);
    }

    private void init(TestNode testNode, PropertyModel propertyModel) {
        this._propertyModel = propertyModel;
        this._caseIdDirty = false;
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        this._models = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            this._caseAttr = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getCaseAttributes().getAttribute().get(0));
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        TestNode testNode = (TestNode)workflowNodeInspectorElement.getNode();
        if (testNode == null) {
            return;
        }
        this._propertyModel = propertyModel;
        this._context = context;
        this._data = testNode;
        this._caseIdDirty = false;
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        this._models = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            this._caseAttr = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getCaseAttributes().getAttribute().get(0));
        }
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTestNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private TestNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTestNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof TestNodeType) {
            return (TestNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private TestNodeType.Results getResults() {
        TestNodeType.Results results = null;
        Context context = this.getContext(this._propertyModel);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof TestNodeType) {
            TestNodeType testNodeType = (TestNodeType)nodeType;
            results = testNodeType.getResults();
        }
        return results;
    }

    private ClassificationTestSettingsType getClassificationTestSettings() {
        ClassificationTestSettingsType classificationTestSettingsType = null;
        Context context = this.getContext(this._propertyModel);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof TestNodeType) {
            TestNodeType testNodeType = (TestNodeType)nodeType;
            classificationTestSettingsType = testNodeType.getTestSettings();
        }
        return classificationTestSettingsType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGenAccuracyMetrics(Boolean bl) {
        try {
            CommandProcessor.getInstance().beginTrans(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ACCURACY_METRICS"));
            TestNode testNode = (TestNode)this.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("genAccuracyMetrics", null, bl, null, null));
            if (Boolean.FALSE.equals(bl)) {
                if (this._models.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                    arrayList.add(new Property("genResiduals", null, bl, null, null));
                } else {
                    arrayList.add(new Property("genConfusionMatrix", null, bl, null, null));
                    arrayList.add(new Property("genROC", null, bl, null, null));
                    arrayList.add(new Property("genLiftProfit", null, bl, null, null));
                }
            }
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((TestNode)this.getData()).getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
            testNode.validate(true);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGenConfusionMatrix(Boolean bl) {
        try {
            CommandProcessor.getInstance().beginTrans(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_CONFUSION_MATRIX"));
            TestNode testNode = (TestNode)this.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(new Property("genAccuracyMetrics", null, bl, null, null));
            }
            arrayList.add(new Property("genConfusionMatrix", null, bl, null, null));
            if (Boolean.FALSE.equals(bl)) {
                arrayList.add(new Property("genROC", null, bl, null, null));
                arrayList.add(new Property("genLiftProfit", null, bl, null, null));
            }
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((TestNode)this.getData()).getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
            testNode.validate(true);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGenROC(Boolean bl) {
        try {
            CommandProcessor.getInstance().beginTrans(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ROC_CURVE"));
            TestNode testNode = (TestNode)this.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(new Property("genAccuracyMetrics", null, bl, null, null));
                arrayList.add(new Property("genConfusionMatrix", null, bl, null, null));
            }
            arrayList.add(new Property("genROC", null, bl, null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((TestNode)this.getData()).getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
            testNode.validate(true);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGenLiftAndProfit(Boolean bl) {
        try {
            CommandProcessor.getInstance().beginTrans(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_LIFT_AND_PROFIT"));
            TestNode testNode = (TestNode)this.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(new Property("genAccuracyMetrics", null, bl, null, null));
                arrayList.add(new Property("genConfusionMatrix", null, bl, null, null));
            }
            arrayList.add(new Property("genLiftProfit", null, bl, null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((TestNode)this.getData()).getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
            testNode.validate(true);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGenResiduals(Boolean bl) {
        try {
            CommandProcessor.getInstance().beginTrans(PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_RESIDUALS"));
            TestNode testNode = (TestNode)this.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(new Property("genAccuracyMetrics", null, bl, null, null));
            }
            arrayList.add(new Property("genResiduals", null, bl, null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((TestNode)this.getData()).getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(ClassificationTestSettingsType classificationTestSettingsType) {
        try {
            CommandProcessor.getInstance().beginTrans(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"));
            TestNode testNode = (TestNode)this.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("testSettingsChanged", null, classificationTestSettingsType, null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((TestNode)this.getData()).getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
            testNode.validate(true);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        if (this._caseIdDirty) {
            try {
                CommandProcessor.getInstance().beginTrans(DialogsLrb.get("TEST_NODE_EDIT_TRANSACTION_NAME"));
                TestNode testNode = (TestNode)this.getData();
                ArrayList<Property> arrayList = new ArrayList<Property>();
                arrayList.add(new Property("CaseAttributes", null, this._caseAttr, null, null));
                OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((TestNode)this.getData()).getUndoFilter();
                odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
                testNode.validate(true);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                CommandProcessor.getInstance().abortTrans();
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jMiningFunctionLabel, (Component)this.jMiningFunctionValue, (String)DialogsLrb.get("TEST_MODEL_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jTargetLabel, (Component)this.jTargetValue, (String)DialogsLrb.get("TEST_MODEL_TARGET"));
        ResourceUtils.resLabel((JLabel)this.jTargetTypeLabel, (Component)this.jTargetTypeValue, (String)DialogsLrb.get("TEST_MODEL_TARGET_TYPE"));
        ResourceUtils.resLabel((JLabel)this.jCaseIdLabel, (Component)this.jCaseIdComboBox, (String)DialogsLrb.get("TEST_MODEL_CASE_ID"));
        this.jTestResultsLabel.setText(PropertyLrb.get("PI_BUILD_GROUP_TEST_TEST_RESULTS"));
        this.jAccuracyMetricsCheckBox.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_PERFORMANCE_METRICS"));
        this.jConfusionMatrixCheckBox.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_PERFORMANCE_MATRIX"));
        this.jROCCheckBox.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ROC"));
        this.jLiftProfitCheckBox.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_N_PROFIT"));
        ResourceUtils.resButton((AbstractButton)this.jEditTargetsButton, (String)PropertyLrb.get("PI_BUILD_GROUP_TEST_EDIT"));
        this.jEditTargetsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationTestSettingsType classificationTestSettingsType;
                TestLiftProfitDialogPanel testLiftProfitDialogPanel = new TestLiftProfitDialogPanel(TargetPanel.this.getContext(), TargetPanel.this._propertyModel);
                if (testLiftProfitDialogPanel.showAsDialog(TargetPanel.this) && (classificationTestSettingsType = testLiftProfitDialogPanel.collectData()) != null) {
                    TargetPanel.this.setValue(classificationTestSettingsType);
                }
            }
        });
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"test_target");
        this.jWarnIcon.setIcon(DataMinerIcons.get(Icons.WARNING_STATUS));
        this.jWarnIcon.setText(DialogsLrb.get("TEST_MODEL_CASE_ID_WARN"));
        this._loading = true;
        this.jAccuracyMetricsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestNodeType.Results results = TargetPanel.this.getResults();
                boolean bl = TargetPanel.this.jAccuracyMetricsCheckBox.isSelected();
                Boolean bl2 = results.isGenAccuracyMetrics();
                if (bl2 == null || bl2 != bl) {
                    TargetPanel.this.setGenAccuracyMetrics(bl);
                }
            }
        });
        this.jConfusionMatrixCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestNodeType.Results results = TargetPanel.this.getResults();
                boolean bl = TargetPanel.this.jConfusionMatrixCheckBox.isSelected();
                Boolean bl2 = results.isGenConfusionMatrix();
                if (bl2 == null || bl2 != bl) {
                    TargetPanel.this.setGenConfusionMatrix(bl);
                }
            }
        });
        this.jROCCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestNodeType.Results results = TargetPanel.this.getResults();
                boolean bl = TargetPanel.this.jROCCheckBox.isSelected();
                Boolean bl2 = results.isGenROC();
                if (bl2 == null || bl2 != bl) {
                    TargetPanel.this.setGenROC(bl);
                }
            }
        });
        this.jLiftProfitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestNodeType.Results results = TargetPanel.this.getResults();
                boolean bl = TargetPanel.this.jLiftProfitCheckBox.isSelected();
                Boolean bl2 = results.isGenLift();
                if (bl2 == null || bl2 != bl) {
                    TargetPanel.this.setGenLiftAndProfit(bl);
                }
            }
        });
        this.jLiftProfitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestNodeType.Results results = TargetPanel.this.getResults();
                boolean bl = TargetPanel.this.jLiftProfitCheckBox.isSelected();
                Boolean bl2 = results.isGenLift();
                if (bl2 == null || bl2 != bl) {
                    TargetPanel.this.setGenLiftAndProfit(bl);
                }
            }
        });
        this.jResidualsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestNodeType.Results results = TargetPanel.this.getResults();
                boolean bl = TargetPanel.this.jResidualsCheckBox.isSelected();
                Boolean bl2 = results.isGenResiduals();
                if (bl2 == null || bl2 != bl) {
                    TargetPanel.this.setGenResiduals(bl);
                }
            }
        });
        TestNode testNode = (TestNode)this.getData();
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        AttributeType attributeType = null;
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            attributeType = (AttributeType)testNodeType.getCaseAttributes().getAttribute().get(0);
        }
        AttributeType attributeType2 = testNodeType.getTargetAttribute();
        if (MiningFunctionType.CLASSIFICATION.equals((Object)this._models.getMiningFunction()) || MiningFunctionType.REGRESSION.equals((Object)this._models.getMiningFunction())) {
            this.jCaseIdLabel.setVisible(true);
            this.jCaseIdComboBox.setVisible(true);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(TEST_NONE);
            List<AttributeType> list = testNode.findCaseIds();
            this._caseIdLookupMap.clear();
            for (AttributeType attributeType3 : list) {
                defaultComboBoxModel.addElement(attributeType3.getName());
                this._caseIdLookupMap.put(attributeType3.getName(), attributeType3);
            }
            this.jCaseIdComboBox.setModel(defaultComboBoxModel);
            if (attributeType == null) {
                this.jWarnIcon.setVisible(true);
                this.jCaseIdComboBox.setSelectedItem(TEST_NONE);
            } else {
                this.jWarnIcon.setVisible(false);
                this.jCaseIdComboBox.setSelectedItem(attributeType.getName());
            }
        } else {
            this.jCaseIdLabel.setVisible(false);
            this.jCaseIdComboBox.setVisible(false);
            this.jWarnIcon.setVisible(false);
        }
        if (this._models.getMiningFunction() == null) {
            this.jMiningFunctionValue.setText(UNKNOWN);
            this.jTargetValue.setText(UNKNOWN);
            this.jTargetTypeValue.setText(UNKNOWN);
        } else {
            this.jMiningFunctionValue.setText(this._models.getMiningFunction().value());
            this.jTargetValue.setText(attributeType2.getName());
            this.jTargetValue.setToolTipText(this.jTargetValue.getText());
            this.jTargetTypeValue.setText(attributeType2.getDataType());
        }
        this.initTestOption();
        this._loading = false;
    }

    private void initTestOption() {
        TestNodeType.Results results;
        if (this._models.getMiningFunction() != null && (results = this.getResults()) != null) {
            this.jAccuracyMetricsCheckBox.setSelected(results.isGenAccuracyMetrics() == null || results.isGenAccuracyMetrics() != false);
            if (this._models.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                this.jResidualsCheckBox.setSelected(results.isGenResiduals() == null || results.isGenResiduals() != false);
            } else {
                this.jConfusionMatrixCheckBox.setSelected(results.isGenConfusionMatrix() == null || results.isGenConfusionMatrix() != false);
                this.jROCCheckBox.setSelected(results.isGenROC() == null || results.isGenROC() != false);
                this.jLiftProfitCheckBox.setSelected(results.isGenLift() == null || results.isGenLift() != false);
                ClassificationTestSettingsType classificationTestSettingsType = this.getClassificationTestSettings();
                if (classificationTestSettingsType.getTopNTargets() != null) {
                    String string = MessageFormat.format(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TOP_N_TARGETS"), classificationTestSettingsType.getTopNTargets().getValue().intValue());
                    this.jLiftProfitTargetSelectionLabel.setText(string);
                } else if (classificationTestSettingsType.getBottomNTargets() != null) {
                    String string = MessageFormat.format(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_BTN_N_TARGETS"), classificationTestSettingsType.getTopNTargets().getValue().intValue());
                    this.jLiftProfitTargetSelectionLabel.setText(string);
                } else {
                    this.jLiftProfitTargetSelectionLabel.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SPECIFIC_TARGETS"));
                }
            }
        }
        this.enableControls();
    }

    private void enableControls() {
        boolean bl = this.isWritable();
        boolean bl2 = false;
        boolean bl3 = false;
        if (this._models.getMiningFunction() != null) {
            bl2 = this._models.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION);
            bl3 = this._models.getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION);
        }
        this.jCaseIdLabel.setEnabled(bl);
        this.jCaseIdComboBox.setEnabled(bl);
        this.jTestResultsLabel.setVisible(bl2 || bl3);
        this.jAccuracyMetricsCheckBox.setVisible(bl2 || bl3);
        this.jConfusionMatrixCheckBox.setVisible(bl3);
        this.jROCCheckBox.setVisible(bl3);
        this.jLiftProfitCheckBox.setVisible(bl3);
        this.jResidualsCheckBox.setVisible(bl2);
        this.jLiftProfitTargetSelectionLabel.setVisible(bl3);
        this.jEditTargetsButton.setVisible(bl3);
        this.jAccuracyMetricsCheckBox.setEnabled(bl && (bl2 || bl3));
        this.jResidualsCheckBox.setEnabled(bl && bl2);
        this.jConfusionMatrixCheckBox.setEnabled(bl && bl3);
        this.jROCCheckBox.setEnabled(bl && bl3);
        this.jLiftProfitCheckBox.setEnabled(bl && bl3);
        boolean bl4 = this.jLiftProfitCheckBox.isSelected();
        this.jLiftProfitTargetSelectionLabel.setEnabled(bl && bl3 && bl4);
        this.jEditTargetsButton.setEnabled(bl && bl3 && bl4);
    }

    private void initComponents() {
        this.jMiningFunctionLabel = new JLabel();
        this.jMiningFunctionValue = new JLabel();
        this.jTargetLabel = new JLabel();
        this.jTargetValue = new JLabel();
        this.jTargetTypeLabel = new JLabel();
        this.jTargetTypeValue = new JLabel();
        this.jCaseIdLabel = new JLabel();
        this.jCaseIdComboBox = new DataMinerCombBox();
        this.jTestResultsLabel = new JLabel();
        this.jAccuracyMetricsCheckBox = new JCheckBox();
        this.jConfusionMatrixCheckBox = new JCheckBox();
        this.jROCCheckBox = new JCheckBox();
        this.jLiftProfitCheckBox = new JCheckBox();
        this.jResidualsCheckBox = new JCheckBox();
        this.jEditTargetsButton = new JButton();
        this.jLiftProfitTargetSelectionLabel = new JLabel();
        this.jWarnIcon = new JLabel();
        this.jMiningFunctionLabel.setText("Function:");
        this.jMiningFunctionValue.setText("Classification");
        this.jTargetLabel.setText("Target:");
        this.jTargetValue.setText("AFFINITY_CARD");
        this.jTargetTypeLabel.setText("Data Type:");
        this.jTargetTypeValue.setText("DM_NESTED_CATEGORICAL");
        this.jCaseIdLabel.setText("Case Id:");
        this.jCaseIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item56789012345678901234567890", "Item 2", "Item 3", "Item 4"}));
        this.jCaseIdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetPanel.this.jCaseIdComboBoxActionPerformed(actionEvent);
            }
        });
        this.jTestResultsLabel.setText("Test Results");
        this.jAccuracyMetricsCheckBox.setText("Accuracy Metrics");
        this.jAccuracyMetricsCheckBox.setOpaque(false);
        this.jConfusionMatrixCheckBox.setText("Confusion Matrix");
        this.jConfusionMatrixCheckBox.setOpaque(false);
        this.jROCCheckBox.setText("ROC Curve (Binary Class Only)");
        this.jROCCheckBox.setOpaque(false);
        this.jLiftProfitCheckBox.setText("Lift and Profit");
        this.jLiftProfitCheckBox.setOpaque(false);
        this.jResidualsCheckBox.setText("Residuals");
        this.jResidualsCheckBox.setOpaque(false);
        this.jEditTargetsButton.setText("Edit...");
        this.jLiftProfitTargetSelectionLabel.setText("Top 5 target class values by frequency");
        this.jWarnIcon.setText("waningIcon");
        this.jWarnIcon.setHorizontalTextPosition(4);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTestResultsLabel, -2, 140, -2).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLiftProfitTargetSelectionLabel, -2, 275, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jEditTargetsButton)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jAccuracyMetricsCheckBox, -2, 286, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLiftProfitCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jROCCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jConfusionMatrixCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jResidualsCheckBox, GroupLayout.Alignment.LEADING, -2, 286, -2)))))).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTargetLabel).addComponent(this.jMiningFunctionLabel, -2, 54, -2).addComponent(this.jTargetTypeLabel, -2, 64, -2).addComponent(this.jCaseIdLabel)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMiningFunctionValue, -2, 203, -2).addComponent(this.jTargetValue, -2, 203, -2).addComponent(this.jTargetTypeValue, -2, 147, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCaseIdComboBox, -2, 216, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jWarnIcon))).addContainerGap(64, Short.MAX_VALUE)))));
        groupLayout.linkSize(0, this.jAccuracyMetricsCheckBox, this.jConfusionMatrixCheckBox, this.jLiftProfitCheckBox, this.jROCCheckBox, this.jResidualsCheckBox);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMiningFunctionLabel).addComponent(this.jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetTypeLabel).addComponent(this.jTargetTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseIdLabel).addComponent(this.jCaseIdComboBox, -2, -1, -2).addComponent(this.jWarnIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTestResultsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAccuracyMetricsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jConfusionMatrixCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jROCCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLiftProfitCheckBox).addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLiftProfitTargetSelectionLabel).addComponent(this.jEditTargetsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jResidualsCheckBox).addContainerGap(19, Short.MAX_VALUE)));
    }

    private void jCaseIdComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jCaseIdComboBox.getSelectedItem();
        if (!TEST_NONE.equals(string)) {
            AttributeType attributeType = this._caseIdLookupMap.get(string);
            if (this._caseAttr == null || !this._caseAttr.equals(attributeType)) {
                this.jWarnIcon.setVisible(false);
                this._caseAttr = attributeType;
                this._caseIdDirty = true;
                if (this._propertyModel != null) {
                    this.updateNode();
                }
            }
        } else if (this._caseAttr != null) {
            this.jWarnIcon.setVisible(true);
            this._caseAttr = null;
            this._caseIdDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }
}

