/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.expressionbuilder.DialogsLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsPanelAbstract;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.MissingValuesPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.NormalizationPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.OutlierPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.UseExistingColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformNulls;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;

public class AddEditTransformsPanelNoStats
extends AddEditTransformsPanelAbstract {
    protected AttributeTypeHelper.ExTransformationSourceAttribute _selSourceColumn;
    protected TransformationOutputAttribute _editedColumn;
    protected String newColumnName;
    protected String _customDataType;
    protected TransformationType _resultTransformationType;
    protected String _selectedTransformation;
    protected boolean bEditingMode = false;
    protected int datatype = 0;
    protected AddEditTransformsPanelAbstract peer;
    private Map<String, Boolean> _mapAutoGenerate;
    private JCheckBox jCheckBoxAuto;
    private JComboBox jComboBoxSourceColumn;
    private JComboBox jComboBoxXformType;
    private JLabel jLabelOutputColumn;
    private JLabel jLabelSourceColumn;
    private JLabel jLabelXformType;
    private JPanel jPanelXformDetails;
    private JTextField jTextFieldOutput;
    protected BinningPanel binningPanel;
    protected MissingValuesPanel missValuesPanel;
    protected OutlierPanel outlierPanel;
    protected NormalizationPanel normalizationPanel;
    protected UseExistingColumnPanel useExistingColumnPanel;

    @Override
    public AttributeTypeHelper.ExTransformationSourceAttribute getSelectedSourceColumn() {
        return this._selSourceColumn;
    }

    @Override
    protected TransformationOutputAttribute getEditedColumn() {
        return this._editedColumn;
    }

    public void setNewColumnName(String string) {
        this.newColumnName = string;
    }

    @Override
    public String getNewColumnName() {
        return this.newColumnName;
    }

    @Override
    public String getCustomDataType() {
        return this._customDataType;
    }

    @Override
    protected TransformationType getResultTransformationType() {
        return this._resultTransformationType;
    }

    public String getSelectedTransformation() {
        return this._selectedTransformation;
    }

    @Override
    public boolean isEditingMode() {
        return this.bEditingMode;
    }

    public AddEditTransformsPanelNoStats(AddEditTransformsPanelAbstract addEditTransformsPanelAbstract, Context context, TransformationStatisticsState transformationStatisticsState, TransformationNodeType transformationNodeType, Map<String, TransformationSourceAttribute> map, List<TransformationSourceAttribute> list, List<TransformationSourceAttribute> list2, Map<String, Boolean> map2) {
        super(context, transformationStatisticsState, transformationNodeType, map, list, list2);
        this.peer = addEditTransformsPanelAbstract;
        this._mapAutoGenerate = map2;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public AddEditTransformsPanelNoStats(Context context, TransformationStatisticsState transformationStatisticsState, TransformationNodeType transformationNodeType, Map<String, TransformationSourceAttribute> map, List<TransformationSourceAttribute> list, List<TransformationSourceAttribute> list2, Map<String, Boolean> map2) {
        super(context, transformationStatisticsState, transformationNodeType, map, list, list2);
        this._mapAutoGenerate = map2;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelSourceColumn = new JLabel();
        this.jComboBoxSourceColumn = new DataMinerCombBox();
        this.jLabelXformType = new JLabel();
        this.jComboBoxXformType = new JComboBox();
        this.jLabelOutputColumn = new JLabel();
        this.jPanelXformDetails = new JPanel();
        this.jCheckBoxAuto = new JCheckBox();
        this.jTextFieldOutput = new JTextField();
        this.jLabelSourceColumn.setText("Source Column:");
        this.jLabelXformType.setText("Transform Type:");
        this.jLabelOutputColumn.setText("Output Column:");
        this.jPanelXformDetails.setBorder(BorderFactory.createTitledBorder("Binning"));
        this.jPanelXformDetails.setLayout(new CardLayout());
        this.jCheckBoxAuto.setText("Auto");
        this.jTextFieldOutput.setText("            ");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPanelXformDetails, -1, 482, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabelOutputColumn, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelXformType, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelSourceColumn, -1, 122, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldOutput, GroupLayout.Alignment.TRAILING, -1, 237, Short.MAX_VALUE).addComponent(this.jComboBoxXformType, 0, 237, Short.MAX_VALUE).addComponent(this.jComboBoxSourceColumn, 0, 237, Short.MAX_VALUE)).addGap(24, 24, 24).addComponent(this.jCheckBoxAuto).addGap(51, 51, 51)))));
        groupLayout.linkSize(0, this.jLabelOutputColumn, this.jLabelSourceColumn, this.jLabelXformType);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSourceColumn).addComponent(this.jComboBoxSourceColumn, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelXformType).addComponent(this.jComboBoxXformType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldOutput, -2, -1, -2).addComponent(this.jLabelOutputColumn).addComponent(this.jCheckBoxAuto)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelXformDetails, -1, 295, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelSourceColumn, (Component)this.jComboBoxSourceColumn, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_SOURCE_COLUMN"));
        ResourceUtils.resLabel((JLabel)this.jLabelXformType, (Component)this.jComboBoxXformType, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_XFORM_TYPE"));
        ResourceUtils.resLabel((JLabel)this.jLabelOutputColumn, (Component)this.jTextFieldOutput, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_OUTPUT_COLUMN"));
        this.jCheckBoxAuto.setText(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_AUTO"));
    }

    @Override
    public void initUI() {
        Object object;
        TransformationOutputAttribute transformationOutputAttribute;
        Collections.sort(this._xformationSourceAttrList, new Comparator<TransformationSourceAttribute>(){

            @Override
            public int compare(TransformationSourceAttribute transformationSourceAttribute, TransformationSourceAttribute transformationSourceAttribute2) {
                return transformationSourceAttribute.getName().compareTo(transformationSourceAttribute2.getName());
            }
        });
        DefaultComboBoxModel<AttributeTypeHelper.ExTransformationSourceAttribute> defaultComboBoxModel = new DefaultComboBoxModel<AttributeTypeHelper.ExTransformationSourceAttribute>(AttributeTypeHelper.toExTransformationSourceAttributes(this._xformationSourceAttrList.toArray(new TransformationSourceAttribute[this._xformationSourceAttrList.size()])));
        this.jComboBoxSourceColumn.setModel(defaultComboBoxModel);
        if (this._selectedSourceColumns != null && !this._selectedSourceColumns.isEmpty()) {
            if (this._selectedSourceColumns.get(0) instanceof TransformationOutputAttribute) {
                this.bEditingMode = true;
                transformationOutputAttribute = (TransformationOutputAttribute)this._selectedSourceColumns.get(0);
                MapTransformedSource mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(this._nodeData.getTransformedAttributes(), (AttributeType)transformationOutputAttribute);
                object = mapTransformedSource.getStringCollectionNames();
                if (!object.getValue().isEmpty()) {
                    String string = (String)object.getValue().get(0);
                    this._selSourceColumn = new AttributeTypeHelper.ExTransformationSourceAttribute((TransformationSourceAttribute)this._xformationSourceAttrMap.get(string));
                }
                this._editedColumn = new TransformationOutputAttribute();
                AttributeTypeHelper.copyTransformationOutputAttribute(this._editedColumn, transformationOutputAttribute);
            } else {
                this._selSourceColumn = new AttributeTypeHelper.ExTransformationSourceAttribute((TransformationSourceAttribute)this._selectedSourceColumns.get(0));
            }
        } else {
            this._selSourceColumn = (AttributeTypeHelper.ExTransformationSourceAttribute)this.jComboBoxSourceColumn.getItemAt(0);
        }
        this.jComboBoxSourceColumn.setSelectedItem(this._selSourceColumn);
        if (this.bEditingMode) {
            this.jComboBoxSourceColumn.addActionListener(new ComboListener(this.jComboBoxSourceColumn));
            this.jComboBoxSourceColumn.setRenderer(new ComboRenderer());
        }
        this.jComboBoxSourceColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                if (AddEditTransformsPanelNoStats.this.bEditingMode) {
                    return;
                }
                if (AddEditTransformsPanelNoStats.this.isCustomTransformation()) {
                    return;
                }
                AddEditTransformsPanelNoStats.this._selSourceColumn = (AttributeTypeHelper.ExTransformationSourceAttribute)AddEditTransformsPanelNoStats.this.jComboBoxSourceColumn.getSelectedItem();
                AddEditTransformsPanelNoStats.this.fillTransformationTypeCombo();
                TransformedAttributes transformedAttributes = new TransformedAttributes();
                AttributeTypeHelper.copyTransformedAttributes(transformedAttributes, AddEditTransformsPanelNoStats.this._nodeData.getTransformedAttributes());
                AddEditTransformsPanelNoStats.this.newColumnName = string = AddEditTransformsPanelNoStats.this.generateOutputName(transformedAttributes);
                AddEditTransformsPanelNoStats.this.setOutputName(AddEditTransformsPanelNoStats.this.newColumnName);
                if (AddEditTransformsPanelNoStats.this.peer != null) {
                    AddEditTransformsPanelNoStats.this.peer.notifyPeer();
                }
            }
        });
        this.fillTransformationTypeCombo();
        this.jComboBoxXformType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                AddEditTransformsPanelNoStats.this._selectedTransformation = (String)AddEditTransformsPanelNoStats.this.jComboBoxXformType.getSelectedItem();
                if (!AddEditTransformsPanelNoStats.this.bEditingMode) {
                    object = new TransformedAttributes();
                    AttributeTypeHelper.copyTransformedAttributes(object, AddEditTransformsPanelNoStats.this._nodeData.getTransformedAttributes());
                    AddEditTransformsPanelNoStats.this.newColumnName = AddEditTransformsPanelNoStats.this.generateOutputName(object);
                    AddEditTransformsPanelNoStats.this.setOutputName(AddEditTransformsPanelNoStats.this.newColumnName);
                }
                if (AddEditTransformsPanelNoStats.this.isCustomTransformation()) {
                    object = new DefaultComboBoxModel<String>(new String[]{TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION_SELECTION()});
                    AddEditTransformsPanelNoStats.this.jComboBoxSourceColumn.setModel(object);
                    AddEditTransformsPanelNoStats.this.jComboBoxSourceColumn.setSelectedItem(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION_SELECTION());
                } else {
                    object = new DefaultComboBoxModel<AttributeTypeHelper.ExTransformationSourceAttribute>(AttributeTypeHelper.toExTransformationSourceAttributes(AddEditTransformsPanelNoStats.this._xformationSourceAttrList.toArray(new TransformationSourceAttribute[AddEditTransformsPanelNoStats.this._xformationSourceAttrList.size()])));
                    AddEditTransformsPanelNoStats.this.jComboBoxSourceColumn.setModel(object);
                    AddEditTransformsPanelNoStats.this.jComboBoxSourceColumn.setSelectedItem(AddEditTransformsPanelNoStats.this._selSourceColumn);
                }
                AddEditTransformsPanelNoStats.this.showPanel();
                if (AddEditTransformsPanelNoStats.this.peer != null) {
                    AddEditTransformsPanelNoStats.this.peer.notifyPeer();
                }
            }
        });
        transformationOutputAttribute = new TransformedAttributes();
        AttributeTypeHelper.copyTransformedAttributes((TransformedAttributes)transformationOutputAttribute, this._nodeData.getTransformedAttributes());
        this.newColumnName = !this.bEditingMode ? this.generateOutputName((TransformedAttributes)transformationOutputAttribute) : this._editedColumn.getName();
        this.setOutputName(this.newColumnName);
        boolean bl = true;
        if (this.bEditingMode && null != this._mapAutoGenerate && null != (object = this._mapAutoGenerate.get(this.newColumnName))) {
            bl = (Boolean)object;
        }
        this.jCheckBoxAuto.setSelected(bl);
        this.jTextFieldOutput.setEditable(!bl);
        this.jCheckBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddEditTransformsPanelNoStats.this.jTextFieldOutput.setEditable(!AddEditTransformsPanelNoStats.this.jCheckBoxAuto.isSelected());
                if (AddEditTransformsPanelNoStats.this.jCheckBoxAuto.isSelected()) {
                    TransformedAttributes transformedAttributes = new TransformedAttributes();
                    AttributeTypeHelper.copyTransformedAttributes(transformedAttributes, AddEditTransformsPanelNoStats.this._nodeData.getTransformedAttributes());
                    AddEditTransformsPanelNoStats.this.newColumnName = AddEditTransformsPanelNoStats.this.generateOutputName(transformedAttributes);
                    AddEditTransformsPanelNoStats.this.setOutputName(AddEditTransformsPanelNoStats.this.newColumnName);
                }
            }
        });
    }

    public boolean isCustomTransformation() {
        return this._selectedTransformation != null && TransformationTypes.isCustomXform(this._selectedTransformation);
    }

    public String getCustomOutputName() {
        return this.jTextFieldOutput.getText();
    }

    private void fillTransformationTypeCombo() {
        Serializable serializable;
        Object object6;
        Object object2;
        String string;
        Object object3;
        Object object4;
        Object object5;
        TransformationOutputAttribute transformationOutputAttribute = this.isEditingMode() ? this.getEditedColumn() : this.getSelectedSourceColumn().getTransformationSourceAttribute();
        ArrayList<Object> arrayList = null;
        ArrayList<Object> arrayList2 = null;
        ArrayList<Object> arrayList3 = null;
        ArrayList<Object> arrayList4 = null;
        TransformedAttributes transformedAttributes = this._nodeData.getTransformedAttributes();
        if (transformedAttributes != null && (object5 = transformedAttributes.getMapTransformedSourceType()) != null && !object5.isEmpty()) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (MapTransformedSource)object4.next();
                StringCollection stringCollection = object3.getStringCollectionNames();
                if (null == stringCollection || null == stringCollection.getValue() || stringCollection.getValue().isEmpty()) continue;
                string = (String)stringCollection.getValue().get(0);
                object2 = null;
                for (Object object6 : this._xformationSourceAttrList) {
                    if (null != object6.getName() && string.equals(object6.getName())) {
                        object2 = object6.getDataType();
                        break;
                    }
                    if (null == object6.getAlias() || !string.equals(object6.getAlias())) continue;
                    object2 = object6.getDataType();
                    break;
                }
                if ("NUMBER".equals(object2) || "FLOAT".equals(object2) || "BINARY_DOUBLE".equals(object2) || "BINARY_FLOAT".equals(object2)) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(object3);
                }
                if ("VARCHAR2".equals(object2) || "CHAR".equals(object2) || "NVARCHAR2".equals(object2) || "NCHAR".equals(object2)) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<Object>();
                    }
                    arrayList2.add(object3);
                }
                if ("DATE".equals(object2) || DatabaseMetadataUtils.isTimestamp((String)object2)) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<Object>();
                    }
                    arrayList3.add(object3);
                    continue;
                }
                if (!DatabaseMetadataUtils.isTimestampWithTimeZone((String)object2)) continue;
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList<Object>();
                }
                arrayList4.add(object3);
            }
        }
        object5 = "";
        object4 = this.getSelectedSourceColumn();
        if (object4 != null && null != ((AttributeTypeHelper.ExTransformationSourceAttribute)object4).getTransformationSourceAttribute()) {
            object5 = this.getSelectedSourceColumn().getTransformationSourceAttribute().getDataType();
        }
        object3 = null;
        if ("NUMBER".equals(object5) || "FLOAT".equals(object5) || "BINARY_DOUBLE".equals(object5) || "BINARY_FLOAT".equals(object5)) {
            boolean bl = true;
            if (arrayList != null) {
                if (this._selectedSourceColumns.size() == 1) {
                    string = ((TransformationSourceAttribute)this._selectedSourceColumns.get(0)).getName();
                    if (null != arrayList && arrayList.size() == 1 && string.equals(((MapTransformedSource)arrayList.get(0)).getKey().getName())) {
                        bl = false;
                    }
                }
            } else {
                bl = false;
            }
            object3 = new DefaultComboBoxModel<String>(TransformationTypes.numericTransformationValues(bl));
            this.datatype = 1;
        } else if ("VARCHAR2".equals(object5) || "CHAR".equals(object5) || "NVARCHAR2".equals(object5) || "NCHAR".equals(object5)) {
            object3 = new DefaultComboBoxModel<String>(TransformationTypes.categoricTransformationValues(arrayList2 != null));
            this.datatype = 2;
        } else if ("DATE".equals(object5) || DatabaseMetadataUtils.isTimestamp((String)object5) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone((String)object5)) {
            object3 = new DefaultComboBoxModel<String>(TransformationTypes.dateTransformationValues(arrayList3 != null));
            this.datatype = 3;
        } else if (DatabaseMetadataUtils.isTimestampWithTimeZone((String)object5)) {
            object3 = new DefaultComboBoxModel<String>(TransformationTypes.dateTransformationValues(arrayList4 != null));
            this.datatype = 6;
        } else {
            object3 = new DefaultComboBoxModel<String>(TransformationTypes.customTransformationValues());
        }
        TransformationOutputAttribute transformationOutputAttribute2 = transformationOutputAttribute instanceof TransformationOutputAttribute ? transformationOutputAttribute : null;
        Object object7 = string = transformationOutputAttribute2 != null ? transformationOutputAttribute2.getTransformationElementType() : null;
        if (transformationOutputAttribute2 != null && string != null) {
            this._selectedTransformation = TransformationTypes.transformationTypeToString((TransformationType)string);
            if (this.isCustomTransformation()) {
                object2 = new DefaultComboBoxModel<String>(new String[]{TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION_SELECTION()});
                this.jComboBoxSourceColumn.setModel(object2);
                this.jComboBoxSourceColumn.setSelectedItem(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION_SELECTION());
            }
        }
        object2 = (String)this.jComboBoxXformType.getSelectedItem();
        if (null != this._selectedTransformation && -1 == ((DefaultComboBoxModel)object3).getIndexOf(this._selectedTransformation)) {
            this._selectedTransformation = null;
        }
        if (null != object2 && -1 == ((DefaultComboBoxModel)object3).getIndexOf(object2)) {
            object2 = null;
        }
        this.jComboBoxXformType.setModel(object3);
        if (transformationOutputAttribute2 != null && string != null && TransformationTypes.isBinning((TransformationType)string)) {
            this.binningPanel = new BinningPanel(this._state.getContext(), this._selSourceColumn.getTransformationSourceAttribute().getName(), this._selSourceColumn.getTransformationSourceAttribute().getDataType(), this._state, TransformationTypes.binningToString((TransformationType)string), TransformationTypes.getBinCount((TransformationType)string), this.datatype, TransformationTypes.getBinGeneration((TransformationType)string), TransformationTypes.getBinLabels((TransformationType)string), TransformationTypes.getCustomBinningSpec((TransformationType)string), TransformationTypes.getTransformNulls((TransformationType)string));
        } else {
            serializable = this._selSourceColumn.getTransformationSourceAttribute() != null ? this._selSourceColumn.getTransformationSourceAttribute().getName() : null;
            object6 = this._selSourceColumn.getTransformationSourceAttribute() != null ? this._selSourceColumn.getTransformationSourceAttribute().getDataType() : null;
            this.binningPanel = new BinningPanel(this._state.getContext(), (String)((Object)serializable), (String)object6, this._state, this.datatype);
        }
        this.jPanelXformDetails.add(TransformationTypes.BINNING_PANEL, this.binningPanel);
        this.missValuesPanel = new MissingValuesPanel(this._state.getContext(), (TransformationSourceAttribute)transformationOutputAttribute, this._state.getMissingValuesDefaultReplacementValue((TransformationSourceAttribute)transformationOutputAttribute), this.missValuesPanel != null ? this.missValuesPanel.getMissigValueXformType() : null, this.missValuesPanel != null ? this.missValuesPanel.getSelectedStats() : null);
        this.jPanelXformDetails.add(TransformationTypes.MISS_VALUES_PANEL, this.missValuesPanel);
        if (this.datatype == 1) {
            this.outlierPanel = new OutlierPanel((TransformationSourceAttribute)transformationOutputAttribute, this._state.getStd((TransformationSourceAttribute)transformationOutputAttribute), this._state.getAvg((TransformationSourceAttribute)transformationOutputAttribute), this.outlierPanel != null ? this.outlierPanel.getSelectedOutlierType() : null);
            this.jPanelXformDetails.add(TransformationTypes.OUTLIER_PANEL, this.outlierPanel);
        } else if (this.outlierPanel != null) {
            serializable = (CardLayout)this.jPanelXformDetails.getLayout();
            ((CardLayout)serializable).first(this.jPanelXformDetails);
            ((CardLayout)serializable).removeLayoutComponent(this.outlierPanel);
            this.jPanelXformDetails.remove(this.outlierPanel);
        }
        if (this.datatype == 1) {
            serializable = null;
            object6 = null;
            if (transformationOutputAttribute instanceof TransformationOutputAttribute) {
                MapTransformedSource mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(this._nodeData.getTransformedAttributes(), (AttributeType)transformationOutputAttribute);
                String string2 = (String)mapTransformedSource.getStringCollectionNames().getValue().get(0);
                serializable = this._state.getMin(string2);
                object6 = this._state.getMax(string2);
            } else {
                serializable = this._state.getMin(transformationOutputAttribute.getName());
                object6 = this._state.getMax(transformationOutputAttribute.getName());
            }
            this.normalizationPanel = new NormalizationPanel((TransformationSourceAttribute)transformationOutputAttribute, (Double)serializable, (Double)object6, this.normalizationPanel != null ? this.normalizationPanel.getSelectedNormalizationType() : null);
            this.jPanelXformDetails.add(TransformationTypes.NORMALIZATION_PANEL, this.normalizationPanel);
        } else if (this.normalizationPanel != null) {
            serializable = (CardLayout)this.jPanelXformDetails.getLayout();
            ((CardLayout)serializable).first(this.jPanelXformDetails);
            ((CardLayout)serializable).removeLayoutComponent(this.normalizationPanel);
            this.jPanelXformDetails.remove(this.normalizationPanel);
        }
        serializable = null;
        if (this.datatype == 1) {
            serializable = arrayList;
        } else if (this.datatype == 2) {
            serializable = arrayList2;
        } else if (this.datatype == 3 || this.datatype == 4 || this.datatype == 5) {
            serializable = arrayList3;
        } else if (this.datatype == 6) {
            serializable = arrayList4;
        }
        if (serializable != null) {
            this.useExistingColumnPanel = new UseExistingColumnPanel(this._context, (TransformationSourceAttribute)transformationOutputAttribute, this._state, (List<MapTransformedSource>)((Object)serializable), this);
            this.jPanelXformDetails.add(TransformationTypes.EXISTING_PANEL, this.useExistingColumnPanel);
        } else if (this.useExistingColumnPanel != null) {
            object6 = (CardLayout)this.jPanelXformDetails.getLayout();
            ((CardLayout)object6).first(this.jPanelXformDetails);
            ((CardLayout)object6).removeLayoutComponent(this.useExistingColumnPanel);
            this.jPanelXformDetails.remove(this.useExistingColumnPanel);
        }
        if (this._selectedTransformation == null) {
            this._selectedTransformation = object2 != null ? object2 : (String)this.jComboBoxXformType.getItemAt(0);
        }
        this.jComboBoxXformType.setSelectedItem(this._selectedTransformation);
        this.showPanel();
    }

    private void showPanel() {
        this.jPanelXformDetails.setBorder(BorderFactory.createTitledBorder(this._selectedTransformation));
        CardLayout cardLayout = (CardLayout)this.jPanelXformDetails.getLayout();
        cardLayout.show(this.jPanelXformDetails, this._selectedTransformation);
    }

    public boolean validateAttributeName(String string) {
        boolean bl = true;
        String string2 = null;
        try {
            String string3;
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
            if (string == null || string.isEmpty() || string.trim().isEmpty()) {
                string2 = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_INVALID_NAME");
            } else if (StringUtils.isGreater32BytesInDB(string, connectionFolder)) {
                string2 = XformDialogsLrb.get("TRANSFORMATION_ERROR_ATTRIBUTE_TOOLONG");
            } else if (StringUtils.containsDoubleQuote(string)) {
                string2 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_HASDBLQUOTE");
            } else if (!StringUtils.containsSingleQuote(string) && StringUtils.isGreater32BytesInDB(string3 = StringUtils.escapeSingleQuotesForSQL(string), connectionFolder)) {
                string2 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_TOOLONG");
            }
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        if (string2 != null) {
            throw new DataMinerException(string2);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doWork() {
        Object object;
        if (!this.jCheckBoxAuto.isSelected()) {
            TransformedAttributes transformedAttributes = new TransformedAttributes();
            AttributeTypeHelper.copyTransformedAttributes(transformedAttributes, this._nodeData.getTransformedAttributes());
            object = this.jTextFieldOutput.getText();
            object = StringUtils.isDoubleQuotedString((String)object) ? StringUtils.trimDoubleQuotes((String)object) : ((String)object).toUpperCase();
            if (!this.validateAttributeName((String)object)) {
                return false;
            }
            if (!((String)object).equals(this.newColumnName)) {
                if (!AttributeTypeHelper.isUniqueTransformationOutputName((String)object, this._xformationSourceAttrList, transformedAttributes.getMapTransformedSourceType())) {
                    throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_DUPLICATE_NAME"));
                }
                this.newColumnName = object;
            }
        }
        if (null != this._mapAutoGenerate) {
            this._mapAutoGenerate.put(this.newColumnName, this.jCheckBoxAuto.isSelected());
        }
        boolean bl = false;
        if (TransformationTypes.isBinning(this._selectedTransformation)) {
            object = this.binningPanel.getSelectedBinngType();
            Integer n = this.binningPanel.getBincount();
            if (n == null) throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_BIN_COUNT_INVALID_2"));
            if (n < 2) {
                throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_BIN_COUNT_INVALID_2"));
            }
            if (!(((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_DATE()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_TIMESTAMP_WITH_TIMEZONE()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE()))) {
                if (n == null) throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_BIN_COUNT_INVALID"));
                if (n < 3) {
                    throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_BIN_COUNT_INVALID"));
                }
            }
            if (((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP()) || ((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE())) {
                String string;
                if (((String)object).equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC())) {
                    string = this.binningPanel.getOtherName();
                    if (string == null) throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_OTHER_MISSING"));
                    if (string.trim().isEmpty()) {
                        throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_OTHER_MISSING"));
                    }
                }
                if (this.binningPanel.isCustomNumericBinning() && this.binningPanel.isInvalidRange()) {
                    throw new DataMinerException(XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"));
                }
                string = this.binningPanel.getTransformNulls();
                if (string == null) {
                    throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_EMPTY_BIN_NUMBER"));
                }
                if (string.isIncludeNulls() && string.getLabel().isEmpty()) {
                    throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_EMPTY_LABEL"));
                }
                this._resultTransformationType = TransformationTypes.initCustomBinning((String)object, this.binningPanel.getCustomBinning(), (TransformNulls)string);
                return true;
            } else {
                TransformNulls transformNulls = this.binningPanel.getTransformNulls();
                if (transformNulls == null) {
                    throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_EMPTY_BIN_NUMBER"));
                }
                if (transformNulls.isIncludeNulls() && transformNulls.getLabel().isEmpty()) {
                    throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_EMPTY_LABEL"));
                }
                this._resultTransformationType = TransformationTypes.initBinning((String)object, this.binningPanel.getBincount(), this.binningPanel.isAuto(), this.binningPanel.isLabels(), transformNulls);
            }
            return true;
        }
        if (TransformationTypes.isMissingValues(this._selectedTransformation)) {
            object = null;
            String string = this.missValuesPanel.getMissigValueXformType();
            if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS())) {
                object = this.missValuesPanel.getSelectedStats();
            } else {
                Object object2 = null;
                try {
                    object2 = this.missValuesPanel.getReplacementValue();
                }
                catch (Exception exception) {
                    throw new DataMinerException(exception.getMessage());
                }
                if (object2 == null) throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_MISS_VALUE_INVALID"));
                if (object2.toString().isEmpty()) {
                    throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_MISS_VALUE_INVALID"));
                }
                if (this.datatype == 1) {
                    try {
                        object = Double.valueOf(object2.toString());
                    }
                    catch (Exception exception) {
                        throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_MISS_VALUE_INVALID"));
                    }
                } else {
                    object = object2;
                }
            }
            this._resultTransformationType = TransformationTypes.initMissValues(this.datatype, this.missValuesPanel.getMissigValueXformType(), object);
            return true;
        }
        if (TransformationTypes.isNormalization(this._selectedTransformation)) {
            try {
                Double d;
                object = this.normalizationPanel.getResults();
                TransformationType.Normalization.Manual manual = object.getManual();
                if (null != manual && (d = manual.getScale()) == 0.0) {
                    throw new DataMinerException(XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_ERROR"));
                }
                if (object == null) return bl;
                this._resultTransformationType = new TransformationType();
                this._resultTransformationType.setNormalization((TransformationType.Normalization)object);
                return true;
            }
            catch (Exception exception) {
                throw new DataMinerException(exception.getMessage());
            }
        }
        if (TransformationTypes.isOutlier(this._selectedTransformation)) {
            try {
                object = this.outlierPanel.getResults();
                if (object == null) return bl;
                this._resultTransformationType = new TransformationType();
                this._resultTransformationType.setOutlier((TransformationType.Outlier)object);
                return true;
            }
            catch (Exception exception) {
                throw new DataMinerException(exception.getMessage());
            }
        }
        if (!TransformationTypes.isExistingColumn(this._selectedTransformation)) return bl;
        this._resultTransformationType = this.useExistingColumnPanel.getResultTransformatonType(this.useExistingColumnPanel.getSelectedTransformedColumn().getKey().getName());
        if (this._resultTransformationType == null) return false;
        return true;
    }

    private String generateOutputName(TransformedAttributes transformedAttributes) {
        Object object;
        if (this._selectedTransformation == null) {
            return "";
        }
        String string = null;
        if (this._selectedTransformation.equals(TransformationTypes.getTRANSFORMATION_TYPE_EXISTNG_COLUMN()) && this.useExistingColumnPanel != null) {
            object = this.useExistingColumnPanel.getSelectedTransformedColumn().getKey().getTransformationElementType();
            string = TransformationTypes.getXformAbbreviatedName(TransformationTypes.transformationTypeToString(object));
        }
        if (string == null) {
            string = TransformationTypes.getXformAbbreviatedName(this._selectedTransformation);
        }
        object = AttributeTypeHelper.createUniqueTransformationOutputName(this._context, this._selSourceColumn.getTransformationSourceAttribute().getName(), string, this._xformationSourceAttrList, transformedAttributes.getMapTransformedSourceType());
        return object;
    }

    public void updateOutputName(MapTransformedSource mapTransformedSource) {
        String string;
        TransformationType transformationType = mapTransformedSource.getKey().getTransformationElementType();
        String string2 = TransformationTypes.getXformAbbreviatedName(TransformationTypes.transformationTypeToString(transformationType));
        this.newColumnName = string = AttributeTypeHelper.createUniqueTransformationOutputName(this._context, this._selSourceColumn.getTransformationSourceAttribute().getName(), string2, this._xformationSourceAttrList, this._nodeData.getTransformedAttributes().getMapTransformedSourceType());
        this.setOutputName(this.newColumnName);
    }

    public void setOutputName(String string) {
        this.jTextFieldOutput.setText(string);
    }

    @Override
    protected void selectionChanged() {
    }

    private static class ComboRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBackground(jList.getBackground());
            this.setForeground(UIManager.getColor("Label.disabledForeground"));
            this.setFont(jList.getFont());
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }

    private static class ComboListener
    implements ActionListener {
        JComboBox combo;
        Object currentItem;

        ComboListener(JComboBox jComboBox) {
            this.combo = jComboBox;
            this.currentItem = jComboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.combo.setSelectedItem(this.currentItem);
        }
    }
}

