/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.util.Locale;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.workflow.dialog.transformations.CustomBinningType;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class EditCustomNumericBinningPanel
extends DialogDisplayer {
    private NameValuePair nameValuePair;
    private Vector<NameValuePair> allData;
    private int editedRowNumber = -1;
    private CustomBinningType binningType;
    private boolean allowEditing;
    private boolean isLabels;
    private JLabel jlblLabel;
    private JLabel jlblValue;
    private JTextField jnumtxtValue;
    private JTextField jtxtLabel;

    public EditCustomNumericBinningPanel(Context context, CustomBinningType customBinningType, int n, Vector<NameValuePair> vector, boolean bl) {
        super(context);
        NameValuePair nameValuePair = vector.get(n);
        this.nameValuePair = new NameValuePair(nameValuePair.getName(), nameValuePair.getValue());
        this.editedRowNumber = n;
        this.allData = vector;
        this.binningType = customBinningType;
        this.allowEditing = bl;
        this.isLabels = customBinningType.isLabels();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jlblLabel = new JLabel();
        this.jlblValue = new JLabel();
        this.jtxtLabel = this.isLabels ? new JTextField() : new NumberTextField();
        this.jnumtxtValue = this.editedRowNumber > 0 ? new NumberTextField() : new JTextField();
        this.jlblLabel.setText("Bin Label:");
        this.jlblValue.setText("Bin Value:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jlblValue, -2, 87, -2).addComponent(this.jlblLabel, -2, 87, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jtxtLabel, -1, 198, Short.MAX_VALUE).addComponent(this.jnumtxtValue)).addGap(21, 21, 21)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlblLabel).addComponent(this.jtxtLabel, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlblValue).addComponent(this.jnumtxtValue, -2, -1, -2)).addContainerGap(17, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        this.jlblLabel.setText(XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_LABEL"));
        this.jlblValue.setText(XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_VALUE"));
        this.jlblLabel.setLabelFor(this.jtxtLabel);
        this.jlblValue.setLabelFor(this.jnumtxtValue);
    }

    @Override
    protected String getDialogTitle() {
        return XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_TITLE");
    }

    @Override
    public void initUI() {
        Number number;
        if (this.isLabels) {
            this.jtxtLabel.setText(this.nameValuePair.getName());
        } else {
            ((NumberTextField)this.jtxtLabel).setDataType(Integer.class);
            ((NumberTextField)this.jtxtLabel).setSigned(false);
            this.jtxtLabel.setLocale(Locale.getDefault());
            number = Integer.parseInt(this.nameValuePair.getName());
            ((NumberTextField)this.jtxtLabel).setNumber(number);
        }
        this.jtxtLabel.setEditable(this.allowEditing);
        if (!this.allowEditing) {
            this.jtxtLabel.setFocusable(false);
        }
        if (this.editedRowNumber == 0) {
            this.jnumtxtValue.setText(this.nameValuePair.getValue().toString());
            this.jnumtxtValue.setEditable(false);
        } else {
            ((NumberTextField)this.jnumtxtValue).setDataType(Double.class);
            ((NumberTextField)this.jnumtxtValue).setSigned(false);
            this.jnumtxtValue.setLocale(Locale.getDefault());
            number = Double.parseDouble(this.nameValuePair.getValue().toString());
            ((NumberTextField)this.jnumtxtValue).setNumber(number);
        }
    }

    @Override
    protected String getHelpTopic() {
        return "";
    }

    @Override
    protected int getDialogButtonMask() {
        return 3;
    }

    @Override
    protected boolean doWork() {
        Object object;
        if (this.isLabels) {
            object = this.jtxtLabel.getText();
            if (((String)object).isEmpty()) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_INVALID_LABEL"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_ERROR_TITLE"), null);
                return false;
            }
            if (!((String)object).equals(this.nameValuePair.getName())) {
                for (NameValuePair nameValuePair : this.allData) {
                    if (!nameValuePair.getName().equals(object)) continue;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_DUPLICATE_LABEL"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_ERROR_TITLE"), null);
                    return false;
                }
                this.nameValuePair.setName((String)object);
            }
        } else {
            object = ((NumberTextField)this.jtxtLabel).getNumber();
            if (object == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_INVALID_LABEL"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_ERROR_TITLE"), null);
                return false;
            }
            if (!object.equals(Integer.parseInt(this.nameValuePair.getName()))) {
                for (NameValuePair nameValuePair : this.allData) {
                    Integer n = Integer.parseInt(nameValuePair.getName());
                    if (!n.equals(object)) continue;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_DUPLICATE_LABEL"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_ERROR_TITLE"), null);
                    return false;
                }
                this.nameValuePair.setName(object.toString());
            }
        }
        if (this.editedRowNumber > 0) {
            object = ((NumberTextField)this.jnumtxtValue).getNumber();
            if (object == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_INVALID_VALUE"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_ERROR_TITLE"), null);
                return false;
            }
            double d = ((Number)object).doubleValue();
            if (!this.isValidateBinValue(d)) {
                return false;
            }
            this.nameValuePair.setValue((Object)String.valueOf(d));
        }
        return true;
    }

    public NameValuePair getEditedValue() {
        return this.nameValuePair;
    }

    private boolean isValidateBinValue(Object object) {
        Object object2;
        NameValuePair nameValuePair = this.allData.get(this.editedRowNumber - 1);
        NameValuePair nameValuePair2 = this.editedRowNumber == this.allData.size() - 1 ? null : this.allData.get(this.editedRowNumber + 1);
        Object object3 = nameValuePair.getValue();
        Object object4 = object2 = nameValuePair2 != null ? nameValuePair2.getValue() : TransformationStatisticsState.UNBOUNDED;
        if (this.binningType.isCustomNumericBinning()) {
            Double d = null;
            if (object instanceof Double) {
                d = (Double)object;
            } else if (object instanceof String) {
                d = Double.valueOf(object.toString());
            }
            Double d2 = null;
            Double d3 = object3.equals(TransformationStatisticsState.NO_LOWER_BOUND) ? null : (d2 = object3 instanceof String ? Double.valueOf(object3.toString()) : (Double)object3);
            Double d4 = object2.equals(TransformationStatisticsState.UNBOUNDED) ? null : (object2 instanceof String ? Double.valueOf(object2.toString()) : (Double)object2);
            boolean bl = false;
            if (d2 != null && d4 != null) {
                if (d <= d2 || d >= d4) {
                    bl = true;
                }
            } else if (d2 == null && d4 != null) {
                if (d >= d4) {
                    bl = true;
                }
            } else if (d2 != null && d4 == null && d <= d2) {
                bl = true;
            }
            if (bl) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return false;
            }
        }
        return true;
    }
}

