/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.dynamic;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.expressionbuilder.AbstractExpressionBuilderContext;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderMainPanel;
import oracle.dmt.dataminer.expressionbuilder.PartitionExpressionBuilderContext;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.AddPartitionColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionTableModel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.dynamic.DynamicLrb;
import oracle.dmt.dataminer.workflow.inspect.dynamic.DynamicNodeUtility;
import oracle.dmt.dataminer.workflow.inspect.dynamic.Helper;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicAnomalyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicClusterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetAttributes;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class DynamicNodePartitionPanel
extends PIComponentPanel {
    private static Helper _helper = new Helper();
    private ComponentWithTitlebar<JComponent> jPartitionComponent;
    private DynamicNode _targetNode;
    private DynamicNodeBaseSettingsType _baseSettings;
    private TargetAttributes _targetAttrs = new TargetAttributes();
    private DataMinerTable _jPartitionsTable = new DataMinerTable();
    private JButton editPartitionExprBtn;
    private JButton addPartitionColumnBtn;
    private JButton addPartitionExprBtn;
    private JButton removePartitionExprBtn;
    private static Icon _editIcon;
    private static Icon _removeIcon;

    public DynamicNodePartitionPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jPartitionComponent = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 512, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jPartitionComponent, -1, 492, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jPartitionComponent, -1, 289, Short.MAX_VALUE))));
    }

    public void initRes() {
        if (null != _editIcon) {
            return;
        }
        _editIcon = InspectorArb.getIcon((int)24);
        _removeIcon = OracleIcons.getIcon((String)"delete.png");
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        this._targetNode = (DynamicNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (nodeType instanceof DynamicPredictionNodeType) {
            this._baseSettings = ((DynamicPredictionNodeType)nodeType).getDynamicNodeBaseSettings();
            this._targetAttrs = ((DynamicPredictionNodeType)nodeType).getPredictionAttributes().getTargetAttributes();
        } else if (nodeType instanceof DynamicClusterNodeType) {
            this._baseSettings = ((DynamicClusterNodeType)nodeType).getDynamicNodeBaseSettings();
        } else if (nodeType instanceof DynamicAnomalyNodeType) {
            this._baseSettings = ((DynamicAnomalyNodeType)nodeType).getDynamicNodeBaseSettings();
        } else if (nodeType instanceof DynamicFeatureNodeType) {
            this._baseSettings = ((DynamicFeatureNodeType)nodeType).getDynamicNodeBaseSettings();
        }
        assert (this._baseSettings != null);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jPartitionsTable));
        this.jPartitionComponent.setComponent((JComponent)jScrollPane);
        this.jPartitionComponent.setLabel(new JLabel(PartitionLrb.get("PARTITION_EDITOR_PANEL_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.addPartitionColumnBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addPartitionColumnBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_ADD_PARTITION_COLUMN"));
        this.addPartitionColumnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicNodePartitionPanel.this.hanldeAddPartitionColumns();
            }
        });
        controlBar.add((Component)this.addPartitionColumnBtn);
        this.addPartitionExprBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_VALUE_ADD_EXPRESSION));
        this.addPartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_ADD_PARTITION_EXPR"));
        this.addPartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicNodePartitionPanel.this.hanldeAddPartitionExpression();
            }
        });
        controlBar.add((Component)this.addPartitionExprBtn);
        this.editPartitionExprBtn = new JButton(_editIcon);
        this.editPartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_EDIT_PARTITION_EXPR"));
        this.editPartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicNodePartitionPanel.this.hanldeEditPartitionExpression();
            }
        });
        controlBar.add((Component)this.editPartitionExprBtn);
        this.removePartitionExprBtn = new JButton(_removeIcon);
        this.removePartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_REMOVE_PARTITION"));
        this.removePartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicNodePartitionPanel.this.hanldeRemovePartition();
            }
        });
        controlBar.add((Component)this.removePartitionExprBtn);
        this.jPartitionComponent.setControlBar(controlBar);
        this._jPartitionsTable.setFillsViewportHeight(true);
        boolean bl = this.isWritable();
        this._jPartitionsTable.setEnabled(bl);
        this.addPartitionColumnBtn.setEnabled(bl);
        this.addPartitionExprBtn.setEnabled(bl);
        this.editPartitionExprBtn.setEnabled(false);
        this.removePartitionExprBtn.setEnabled(false);
        this.setupPartitionsTable();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DynamicNodePartitionPanel.this._jPartitionsTable.getSelectedRowInModel();
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    DynamicNodePartitionPanel.this.hanldeEditPartitionExpression();
                }
            }
        };
        this._jPartitionsTable.addMouseListener(mouseAdapter);
    }

    public void updateUI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        this._targetNode = (DynamicNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (nodeType instanceof DynamicPredictionNodeType) {
            this._baseSettings = ((DynamicPredictionNodeType)nodeType).getDynamicNodeBaseSettings();
            this._targetAttrs = ((DynamicPredictionNodeType)nodeType).getPredictionAttributes().getTargetAttributes();
        } else if (nodeType instanceof DynamicClusterNodeType) {
            this._baseSettings = ((DynamicClusterNodeType)nodeType).getDynamicNodeBaseSettings();
        } else if (nodeType instanceof DynamicAnomalyNodeType) {
            this._baseSettings = ((DynamicAnomalyNodeType)nodeType).getDynamicNodeBaseSettings();
        } else if (nodeType instanceof DynamicFeatureNodeType) {
            this._baseSettings = ((DynamicFeatureNodeType)nodeType).getDynamicNodeBaseSettings();
        }
        assert (this._baseSettings != null);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jPartitionsTable));
        this.jPartitionComponent.setComponent((JComponent)jScrollPane);
        this.jPartitionComponent.setLabel(new JLabel(PartitionLrb.get("PARTITION_EDITOR_PANEL_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.addPartitionColumnBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addPartitionColumnBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_ADD_PARTITION_COLUMN"));
        this.addPartitionColumnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicNodePartitionPanel.this.hanldeAddPartitionColumns();
            }
        });
        controlBar.add((Component)this.addPartitionColumnBtn);
        this.addPartitionExprBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_VALUE_ADD_EXPRESSION));
        this.addPartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_ADD_PARTITION_EXPR"));
        this.addPartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicNodePartitionPanel.this.hanldeAddPartitionExpression();
            }
        });
        controlBar.add((Component)this.addPartitionExprBtn);
        this.editPartitionExprBtn = new JButton(_editIcon);
        this.editPartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_EDIT_PARTITION_EXPR"));
        this.editPartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicNodePartitionPanel.this.hanldeEditPartitionExpression();
            }
        });
        controlBar.add((Component)this.editPartitionExprBtn);
        this.removePartitionExprBtn = new JButton(_removeIcon);
        this.removePartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_REMOVE_PARTITION"));
        this.removePartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicNodePartitionPanel.this.hanldeRemovePartition();
            }
        });
        controlBar.add((Component)this.removePartitionExprBtn);
        this.jPartitionComponent.setControlBar(controlBar);
        this._jPartitionsTable.setFillsViewportHeight(true);
        boolean bl = this.isWritable();
        this._jPartitionsTable.setEnabled(bl);
        this.addPartitionColumnBtn.setEnabled(bl);
        this.addPartitionExprBtn.setEnabled(bl);
        this.editPartitionExprBtn.setEnabled(false);
        this.removePartitionExprBtn.setEnabled(false);
        this.setupPartitionsTable();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DynamicNodePartitionPanel.this._jPartitionsTable.getSelectedRowInModel();
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    DynamicNodePartitionPanel.this.hanldeEditPartitionExpression();
                }
            }
        };
        this._jPartitionsTable.addMouseListener(mouseAdapter);
    }

    private void hanldeAddPartitionColumns() {
        AddPartitionColumnPanel addPartitionColumnPanel = new AddPartitionColumnPanel(this.getContext((PropertyModel)this._model), this._targetNode, this._baseSettings.getMiningAttributes(), this._baseSettings.getPartitionExpressions(), this._targetAttrs.getMiningAttribute(), this._baseSettings.getCaseAttributes());
        if (addPartitionColumnPanel.showAsDialog(this) && addPartitionColumnPanel.isDirty()) {
            List<MiningAttributeType> list = addPartitionColumnPanel.getSelectedAttrsCache();
            PartitionExpressions partitionExpressions = new PartitionExpressions();
            PartitionExpressions partitionExpressions2 = new PartitionExpressions();
            List list2 = _helper.makeListCopies(this._baseSettings.getPartitionExpressions().getPartitionExpression(), 2);
            partitionExpressions.getPartitionExpression().addAll(list2.get(0));
            partitionExpressions2.getPartitionExpression().addAll(list2.get(0));
            List<PartitionExpressionType> list3 = this.getListOfPartitionColumnsToRemove(partitionExpressions2.getPartitionExpression(), list);
            partitionExpressions2.getPartitionExpression().removeAll(list3);
            List<PartitionExpressionType> list4 = this.getListOfPartitionColumnsToAdd(partitionExpressions2.getPartitionExpression(), list);
            partitionExpressions2.getPartitionExpression().addAll(list4);
            SupplementalAttributesType supplementalAttributesType = DynamicNodeUtility.getUpdatedAutoSupplementals(this._baseSettings.getSupplementalAttributes(), this._targetAttrs, this._baseSettings.getCaseAttributes(), this._baseSettings.getSupplementalAttributes().getAutoSpec().equals((Object)AutoSpecType.NO) ? this._baseSettings.getPartitionExpressions() : partitionExpressions2);
            supplementalAttributesType.setAutoSpec(this._baseSettings.getSupplementalAttributes().getAutoSpec());
            SupplementalAttributesType supplementalAttributesType2 = new SupplementalAttributesType();
            List list5 = _helper.makeListCopies(this._baseSettings.getSupplementalAttributes().getAttribute(), 1);
            supplementalAttributesType2.getAttribute().addAll(list5.get(0));
            supplementalAttributesType2.setAutoSpec(this._baseSettings.getSupplementalAttributes().getAutoSpec());
            this.modifyPartitions(partitionExpressions2, partitionExpressions, supplementalAttributesType, supplementalAttributesType2, false);
        }
    }

    private void modifyPartitions(PartitionExpressions partitionExpressions, PartitionExpressions partitionExpressions2, SupplementalAttributesType supplementalAttributesType, SupplementalAttributesType supplementalAttributesType2, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("partition expressions attributes", partitionExpressions);
        hashMap.put("partition expressions derived supplementals", supplementalAttributesType);
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("partition expressions attributes", partitionExpressions2);
        hashMap2.put("partition expressions derived supplementals", supplementalAttributesType2);
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_EXPRESSIONS", hashMap);
        complexProperty.setOldData(hashMap2);
        arrayList.add(new Property(String.valueOf(this._model.getRowMapping("PARTITIONS_EXPRESSIONS")), null, complexProperty, null, null));
        String string = bl ? DynamicLrb.get("PI_ADD_PARTITION_COLUMN") : DynamicLrb.get("PI_ADD_PARTITION_COLUMNS");
        this._model.setValueAt(string, this._targetNode, arrayList);
    }

    private void editPartitions(PartitionExpressions partitionExpressions, PartitionExpressions partitionExpressions2) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_EXPRESSION_EDIT", partitionExpressions);
        complexProperty.setOldData(partitionExpressions2);
        arrayList.add(new Property(String.valueOf(this._model.getRowMapping("PARTITIONS_EXPRESSION_EDIT")), null, complexProperty, null, null));
        String string = DynamicLrb.get("PI_EDIT_PARTITION_COLUMN");
        this._model.setValueAt(string, this._targetNode, arrayList);
    }

    public List<PartitionExpressionType> getListOfPartitionColumnsToAdd(List<PartitionExpressionType> list, List<MiningAttributeType> list2) {
        ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
        if (list2 == null || list2.isEmpty()) {
            return arrayList;
        }
        HashMap<String, PartitionExpressionType> hashMap = new HashMap<String, PartitionExpressionType>();
        for (PartitionExpressionType partitionExpressionType : list) {
            if (null != partitionExpressionType.getSQLExpression()) continue;
            hashMap.put(partitionExpressionType.getPartitionAttribute().getName(), partitionExpressionType);
        }
        for (MiningAttributeType miningAttributeType : list2) {
            if (null != hashMap.get(miningAttributeType.getName())) continue;
            PartitionExpressionType partitionExpressionType = new PartitionExpressionType();
            partitionExpressionType.setPartitionAttribute(MetaDataHelper.createAttributeFrom(miningAttributeType));
            arrayList.add(partitionExpressionType);
        }
        return arrayList;
    }

    private List<PartitionExpressionType> getListOfPartitionColumnsToRemove(List<PartitionExpressionType> list, List<MiningAttributeType> list2) {
        ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
        ArrayList<PartitionExpressionType> arrayList2 = new ArrayList<PartitionExpressionType>();
        for (PartitionExpressionType object : list) {
            if (null != object.getSQLExpression()) continue;
            arrayList2.add(object);
        }
        if (list2 == null || list2.isEmpty()) {
            return arrayList2;
        }
        HashMap hashMap = new HashMap();
        for (MiningAttributeType miningAttributeType : list2) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (PartitionExpressionType partitionExpressionType : arrayList2) {
            if (null != hashMap.get(partitionExpressionType.getPartitionAttribute().getName())) continue;
            arrayList.add(partitionExpressionType);
        }
        return arrayList;
    }

    private void hanldeEditPartitionExpression() {
        Object object2;
        int[] nArray = this._jPartitionsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        List<PartitionExpressionType> list = this.getTableModelPartitions();
        PartitionExpressionType partitionExpressionType = list.get(nArray[0]);
        AbstractNode abstractNode = this._targetNode.findParentNode();
        String string = partitionExpressionType.getPartitionAttribute().getName();
        String string2 = partitionExpressionType.getSQLExpression();
        PartitionExpressions partitionExpressions = this._baseSettings.getPartitionExpressions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : partitionExpressions.getPartitionExpression()) {
            arrayList.add(object2.getPartitionAttribute().getName());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        object2 = new PartitionExpressionBuilderContext(((DataProvider)((Object)abstractNode)).getInputSQL(), abstractNode, string, string2, stringArray);
        ExpressionBuilderMainPanel expressionBuilderMainPanel = new ExpressionBuilderMainPanel(this.getContext((PropertyModel)this._model), (AbstractExpressionBuilderContext)object2);
        DialogHelper dialogHelper = new DialogHelper(expressionBuilderMainPanel);
        if (dialogHelper.showAsDialog(this)) {
            string2 = expressionBuilderMainPanel.getExpression();
            string = expressionBuilderMainPanel.getAttributeName();
            partitionExpressionType.setSQLExpression(string2);
            String string3 = expressionBuilderMainPanel.getExpressionDataType();
            partitionExpressionType.getPartitionAttribute().setDataType(string3);
            partitionExpressionType.getPartitionAttribute().setName(string);
            PartitionExpressions partitionExpressions2 = new PartitionExpressions();
            PartitionExpressions partitionExpressions3 = new PartitionExpressions();
            List list2 = _helper.makeListCopies(this._baseSettings.getPartitionExpressions().getPartitionExpression(), 2);
            partitionExpressions2.getPartitionExpression().addAll(list2.get(0));
            partitionExpressions3.getPartitionExpression().addAll(list2.get(0));
            for (PartitionExpressionType partitionExpressionType2 : partitionExpressions3.getPartitionExpression()) {
                if (!partitionExpressionType2.getPartitionAttribute().getName().equals(partitionExpressionType.getPartitionAttribute().getName())) continue;
                partitionExpressionType2 = partitionExpressionType;
                break;
            }
            this.editPartitions(partitionExpressions3, partitionExpressions2);
        }
    }

    private void hanldeRemovePartition() {
        Object object;
        PartitionExpressionType partitionExpressionType3;
        Object object2;
        PartitionExpressionType partitionExpressionType2;
        int[] nArray = this._jPartitionsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        List<PartitionExpressionType> list = this.getTableModelPartitions();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < nArray.length; ++i) {
            partitionExpressionType2 = list.get(nArray[i]);
            object2 = partitionExpressionType2.getPartitionAttribute().getName();
            hashMap.put((String)object2, (String)object2);
        }
        PartitionExpressions partitionExpressions = new PartitionExpressions();
        partitionExpressionType2 = new PartitionExpressions();
        object2 = _helper.makeListCopies(this._baseSettings.getPartitionExpressions().getPartitionExpression(), 2);
        partitionExpressions.getPartitionExpression().addAll((Collection)object2.get(0));
        partitionExpressionType2.getPartitionExpression().addAll((Collection)object2.get(0));
        ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
        for (PartitionExpressionType partitionExpressionType3 : partitionExpressionType2.getPartitionExpression()) {
            object = partitionExpressionType3.getPartitionAttribute().getName();
            if (null == hashMap.get(object)) continue;
            arrayList.add(partitionExpressionType3);
        }
        partitionExpressionType2.getPartitionExpression().removeAll(arrayList);
        SupplementalAttributesType supplementalAttributesType = DynamicNodeUtility.getUpdatedAutoSupplementals(this._baseSettings.getSupplementalAttributes(), this._targetAttrs, this._baseSettings.getCaseAttributes(), (PartitionExpressions)(this._baseSettings.getSupplementalAttributes().getAutoSpec().equals((Object)AutoSpecType.NO) ? this._baseSettings.getPartitionExpressions() : partitionExpressionType2));
        supplementalAttributesType.setAutoSpec(this._baseSettings.getSupplementalAttributes().getAutoSpec());
        partitionExpressionType3 = new SupplementalAttributesType();
        object = _helper.makeListCopies(this._baseSettings.getSupplementalAttributes().getAttribute(), 1);
        partitionExpressionType3.getAttribute().addAll((Collection)object.get(0));
        partitionExpressionType3.setAutoSpec(this._baseSettings.getSupplementalAttributes().getAutoSpec());
        this.modifyPartitions((PartitionExpressions)partitionExpressionType2, partitionExpressions, supplementalAttributesType, (SupplementalAttributesType)partitionExpressionType3, nArray.length == 1);
    }

    private void hanldeAddPartitionExpression() {
        Object object2;
        AbstractNode abstractNode = this._targetNode.findParentNode();
        PartitionExpressionType partitionExpressionType = new PartitionExpressionType();
        String string = this.generatePartitionExpressionName(this._baseSettings.getPartitionExpressions(), partitionExpressionType);
        PartitionExpressions partitionExpressions = this._baseSettings.getPartitionExpressions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : partitionExpressions.getPartitionExpression()) {
            arrayList.add(object2.getPartitionAttribute().getName());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        object2 = new PartitionExpressionBuilderContext(((DataProvider)((Object)abstractNode)).getInputSQL(), abstractNode, string, "", stringArray);
        ExpressionBuilderMainPanel expressionBuilderMainPanel = new ExpressionBuilderMainPanel(this.getContext((PropertyModel)this._model), (AbstractExpressionBuilderContext)object2);
        DialogHelper dialogHelper = new DialogHelper(expressionBuilderMainPanel);
        if (dialogHelper.showAsDialog(this)) {
            String string2 = expressionBuilderMainPanel.getExpression();
            string = expressionBuilderMainPanel.getAttributeName();
            partitionExpressionType.setSQLExpression(string2);
            String string3 = expressionBuilderMainPanel.getExpressionDataType();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(string);
            attributeType.setDataType(string3);
            attributeType.setStatus(AttributeStatus.VALID);
            partitionExpressionType.setPartitionAttribute(attributeType);
            PartitionExpressions partitionExpressions2 = new PartitionExpressions();
            PartitionExpressions partitionExpressions3 = new PartitionExpressions();
            List list = _helper.makeListCopies(this._baseSettings.getPartitionExpressions().getPartitionExpression(), 2);
            partitionExpressions2.getPartitionExpression().addAll(list.get(0));
            partitionExpressions3.getPartitionExpression().addAll(list.get(0));
            partitionExpressions3.getPartitionExpression().add(partitionExpressionType);
            SupplementalAttributesType supplementalAttributesType = DynamicNodeUtility.getUpdatedAutoSupplementals(this._baseSettings.getSupplementalAttributes(), this._targetAttrs, this._baseSettings.getCaseAttributes(), this._baseSettings.getSupplementalAttributes().getAutoSpec().equals((Object)AutoSpecType.NO) ? this._baseSettings.getPartitionExpressions() : partitionExpressions3);
            supplementalAttributesType.setAutoSpec(this._baseSettings.getSupplementalAttributes().getAutoSpec());
            SupplementalAttributesType supplementalAttributesType2 = new SupplementalAttributesType();
            List list2 = _helper.makeListCopies(this._baseSettings.getSupplementalAttributes().getAttribute(), 1);
            supplementalAttributesType2.getAttribute().addAll(list2.get(0));
            supplementalAttributesType2.setAutoSpec(this._baseSettings.getSupplementalAttributes().getAutoSpec());
            this.modifyPartitions(partitionExpressions3, partitionExpressions2, supplementalAttributesType, supplementalAttributesType2, true);
        }
    }

    private String generatePartitionExpressionName(PartitionExpressions partitionExpressions, PartitionExpressionType partitionExpressionType) {
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object2 : partitionExpressions.getPartitionExpression()) {
            if (null == object2.getSQLExpression() && !object2.getPartitionAttribute().getName().startsWith(DynamicState.PARTITION_EXPRESSION_TEMPLATE)) continue;
            hashMap.put(object2.getPartitionAttribute().getName(), object2);
        }
        int n = 0;
        object2 = new StringBuilder(DynamicState.PARTITION_EXPRESSION_TEMPLATE);
        if (!hashMap.isEmpty()) {
            for (Object object3 : hashMap.keySet()) {
                Object object4 = ((String)object3).substring(DynamicState.TEMPLATE_LENGTH, ((String)object3).length());
                n = Math.max(n, Integer.parseInt((String)object4));
            }
        }
        MiningAttributes miningAttributes = this._baseSettings.getMiningAttributes();
        for (Object object4 : miningAttributes.getMiningAttribute()) {
            if (!object4.getName().startsWith(DynamicState.PARTITION_EXPRESSION_TEMPLATE)) continue;
            String string = object4.getName();
            String string2 = string.substring(DynamicState.TEMPLATE_LENGTH, string.length());
            n = Math.max(n, Integer.parseInt(string2));
        }
        ((StringBuilder)object2).append(n + 1);
        hashMap.put(((StringBuilder)object2).toString(), partitionExpressionType);
        return ((StringBuilder)object2).toString();
    }

    private void setupPartitionsTable() {
        PartitionTableModel partitionTableModel = new PartitionTableModel(this._baseSettings.getPartitionExpressions());
        this._jPartitionsTable.setModel((TableModel)((Object)partitionTableModel));
        this._jPartitionsTable.setShowGrid(true);
        this._jPartitionsTable.setSorted(true);
        this._jPartitionsTable.setSortColumn(0, true);
        this._jPartitionsTable.getSelectionModel().addListSelectionListener(new PartitionSelectionHandler());
    }

    public List<PartitionExpressionType> getTableModelPartitions() {
        PartitionTableModel partitionTableModel = (PartitionTableModel)((Object)this._jPartitionsTable.getModel());
        return partitionTableModel.getSrcData();
    }

    class PartitionSelectionHandler
    implements ListSelectionListener {
        PartitionSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = DynamicNodePartitionPanel.this.isWritable();
            int[] nArray = DynamicNodePartitionPanel.this._jPartitionsTable.getSelectedRowsInModel();
            boolean bl2 = nArray != null && nArray.length > 0;
            DynamicNodePartitionPanel.this.removePartitionExprBtn.setEnabled(bl2 && bl);
            boolean bl3 = nArray != null && nArray.length == 1;
            boolean bl4 = false;
            if (bl3) {
                List<PartitionExpressionType> list = DynamicNodePartitionPanel.this.getTableModelPartitions();
                PartitionExpressionType partitionExpressionType = list.get(nArray[0]);
                bl4 = null != partitionExpressionType.getSQLExpression();
            }
            DynamicNodePartitionPanel.this.editPartitionExprBtn.setEnabled(bl4 && bl);
        }
    }
}

