/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileInputType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;

public class DataProfileAttributesPanel
extends DataSourceAttributesPanel {
    private static final Logger theLogger = Logger.getLogger(DataProfileAttributesPanel.class.getName());

    public DataProfileAttributesPanel(Context context, DataProfileNode dataProfileNode, List<AttributeType> list) {
        super(context, dataProfileNode, list);
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataProfileNode.getData();
        boolean bl = "Yes".equals(dataProfileNodeType.getAutoSpec().value());
        this.enableShuttleButtons(!bl);
    }

    @Override
    protected boolean isAutoSpec() {
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData().getData();
        boolean bl = "Yes".equals(dataProfileNodeType.getAutoSpec().value());
        return bl;
    }

    @Override
    protected List<AttributeType> getSelectedAttributes() {
        AbstractNode abstractNode = this.getData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)abstractNode.getData();
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        List list = dataProfileInputType.getAttributes().getAttribute();
        return list;
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        DataProfileNode dataProfileNode = (DataProfileNode)this.getData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataProfileNode.getData();
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        DataProfileInputType dataProfileInputType2 = new DataProfileInputType();
        Attributes attributes = new Attributes();
        dataProfileInputType2.setAttributes(attributes);
        dataProfileInputType2.setGroupByAttribute(dataProfileInputType.getGroupByAttribute());
        List list = attributes.getAttribute();
        list.addAll(this.selectedAttrsCache);
        try {
            CommandProcessor.getInstance().beginTrans(DataProfileNode.DATAPROFILE_INPUT);
            dataProfileNode.setState(NodeStatusType.READY);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(DataProfileNode.DATAPROFILE_INPUT, null, dataProfileInputType2, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            odmrSDMUndoFilter.prepareUndoPropertyList(dataProfileNode, this.getContext(), arrayList);
            dataProfileNode.validate(true);
            CommandProcessor.getInstance().endTrans();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
            bl = false;
        }
        return bl;
    }
}

