/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JTabbedPane;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.workflow.preferences.SchedulerPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.preferences.WorkflowSchedulerPreferencesNotificationPanel;
import oracle.dmt.dataminer.workflow.preferences.WorkflowSchedulerPreferencesSettingsPanel;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public class WorkflowSchedulerPreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private SchedulerPreferencesPanelSettings model;
    private WorkflowSchedulerPreferencesSettingsPanel settingsPanel;
    private WorkflowSchedulerPreferencesNotificationPanel notificationPanel;
    private static String NOTIFICATION_TAB = DialogsLrb.get("SCHEDULER_ADVANCED_NOTIFICATION_TAB");
    private static String SETTINGS_TAB = DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_TAB");
    private JTabbedPane jTabbedPane1;

    public WorkflowSchedulerPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this.setHelpID("preferences_workflow_scheduler_editor");
    }

    @Override
    public void initUI() {
        this.settingsPanel = new WorkflowSchedulerPreferencesSettingsPanel(this);
        this.notificationPanel = new WorkflowSchedulerPreferencesNotificationPanel(this);
        this.jTabbedPane1.add(NOTIFICATION_TAB, this.notificationPanel);
        this.jTabbedPane1.add(SETTINGS_TAB, this.settingsPanel);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 414, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 349, Short.MAX_VALUE).addContainerGap()));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.model = WorkflowSchedulerPreferencesPanel.getPreferences(traversableContext);
        this.notificationPanel.updateUI(this.model);
        this.settingsPanel.updateUI(this.model);
    }

    public void onExit(TraversableContext traversableContext) {
        this.model = WorkflowSchedulerPreferencesPanel.getPreferences(traversableContext);
        this.model.setUseNotification(this.notificationPanel.isUseNotification());
        this.model.setEmailRecipients(this.notificationPanel.getRecipients());
        this.model.setEmailSubject(this.notificationPanel.getSubject());
        this.model.setEmailComment(this.notificationPanel.getComment());
        this.model.setEventFailed(this.notificationPanel.isUseEventFailed());
        this.model.setEventStarted(this.notificationPanel.isUseEventStarted());
        this.model.setEventStopped(this.notificationPanel.isUseEventStopped());
        this.model.setEventSucceeded(this.notificationPanel.isUseEventSucceeded());
        this.model.setTimeZone(this.settingsPanel.getTimeZone());
        this.model.setJobPriority(this.settingsPanel.getJobPriority());
        this.model.setUseMaxFailures(this.settingsPanel.isUseMaxFailures());
        this.model.setMaxFailures(this.settingsPanel.getMaxFailures());
        this.model.setUseMaxRunDuration(this.settingsPanel.isUseMaxRunDuration());
        this.model.setMaxRunDurationDays(this.settingsPanel.getMaxRunDurationDays());
        this.model.setMaxRunDurationHours(this.settingsPanel.getMaxRunDurationHours());
        this.model.setMaxRunDurationMins(this.settingsPanel.getMaxRunDurationMins());
        this.model.setUseScheduleLimit(this.settingsPanel.isUseScheduleLimit());
        this.model.setScheduleLimitDays(this.settingsPanel.getScheduleLimitDays());
        this.model.setScheduleLimitHours(this.settingsPanel.getScheduleLimitHours());
        this.model.setScheduleLimitMins(this.settingsPanel.getScheduleLimitMins());
    }

    private static SchedulerPreferencesPanelSettings getPreferences(TraversableContext traversableContext) {
        return SchedulerPreferencesPanelSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

