/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import oracle.ideimpl.Arguments;

public final class IdeArgs {
    private final String[] _args;
    private boolean _bCreateUI;
    private String role;
    private oracle.ideimpl.Arguments<Arguments> _arguments = null;

    public IdeArgs() {
        this(new String[0]);
    }

    public IdeArgs(String[] args) {
        String value;
        this._args = (String[])args.clone();
        this._arguments = new oracle.ideimpl.Arguments(new Arguments.IArgumentManager<Arguments>(){

            @Override
            public void setup(EnumSet options, EnumMap<Arguments, Arguments> argumentsMap, EnumMap<Arguments, String> nameOverrides, EnumMap<Arguments, Arguments> mutuallyExclusive) {
                options.add(Arguments.ROLE);
                options.add(Arguments.PLATFORMFILE);
                options.add(Arguments.MIGRATE);
                argumentsMap.put(Arguments.PLATFORMFILE, Arguments.PF);
                nameOverrides.put(Arguments.TRACEFS, "TracesFS");
                mutuallyExclusive.put(Arguments.NOMIGRATE, Arguments.MIGRATE);
                mutuallyExclusive.put(Arguments.NONAG, Arguments.NOMIGRATE);
            }

            @Override
            public void postSetup(EnumSet<Arguments> set, EnumMap<Arguments, String> values) {
                if (System.getProperty("nomigrate", null) != null) {
                    set.add(Arguments.NOMIGRATE);
                }
            }

            @Override
            public Class getEnumClass() {
                return Arguments.class;
            }
        });
        this._arguments.processArguments(args);
        if (this._arguments.contains(Arguments.ROLE) && (value = this._arguments.getOption(Arguments.ROLE)) != null) {
            this.setRole(value);
        }
    }

    public final String[] getArgs() {
        ArrayList<String> rgs = new ArrayList<String>();
        if (!this._bCreateUI) {
            rgs.add("-headless");
        }
        for (String a : this._args) {
            rgs.add(a);
        }
        return rgs.toArray(new String[rgs.size()]);
    }

    public boolean hasArg(String argName) {
        if (this._args != null && argName != null) {
            for (int i = 0; i < this._args.length; ++i) {
                if (!argName.equals(this._args[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getCreateUI() {
        return this._bCreateUI;
    }

    public void setCreateUI(boolean bCreateUI) {
        this._bCreateUI = bCreateUI;
    }

    public String getPlatformFileName() {
        String result = null;
        if (this._arguments.contains(Arguments.PLATFORMFILE) && this._arguments.hasOption(Arguments.PLATFORMFILE)) {
            result = this._arguments.getOption(Arguments.PLATFORMFILE);
        }
        return result;
    }

    public boolean isMigrate() {
        return this._arguments.contains(Arguments.MIGRATE);
    }

    public String getRole() {
        return this.role;
    }

    public final void setRole(String role) {
        if (role != null && "".equals(role = role.trim())) {
            role = null;
        }
        this.role = role;
    }

    public boolean contains(Arguments argument) {
        return this._arguments.contains(argument);
    }

    public boolean hasOption(Arguments argument) {
        return this._arguments.hasOption(argument);
    }

    public String getOption(Arguments argument) {
        return this._arguments.getOption(argument);
    }

    public static enum Arguments {
        MIGRATE,
        NOMIGRATE,
        NONAG,
        ROLE,
        PLATFORMFILE,
        PF,
        TRACEFS;

    }
}

