/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;

public class IdeRunStatus
extends Properties {
    private static IdeRunStatus instance;
    private File runStatusFile;
    private Properties runStatus = new Properties();
    private static final String RUN_STATUS_FILE = "runStatus.xml";
    private static final String IDE_EXTENSION_ID = "oracle.ide";
    private final String COMMENT = "Ide Run Time Status Persistance";
    private final String MIGRATED = "_migrated";
    private final String DATA_COPIED = "_dataCopyied";
    private final String MIGRATION_DECISION = "migrationStatus.lastDecision";
    private final String MIGRATION_SOURCE = "migrationStatus.lastSource";
    private final String MIGRATION_ATTEMPTED = "migration.attempted";
    private final String TRUE = "true";
    private final String FALSE = "false";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized IdeRunStatus getInstance() {
        if (instance == null) {
            ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
            File extensiondir = new File(extReg.getSystemDirectory(IDE_EXTENSION_ID).getFile());
            instance = new IdeRunStatus();
            IdeRunStatus.instance.runStatusFile = new File(extensiondir, RUN_STATUS_FILE);
            if (IdeRunStatus.instance.runStatusFile.exists()) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(IdeRunStatus.instance.runStatusFile);
                    instance.loadFromXML(fileInputStream);
                }
                catch (IOException ex) {
                    try {
                        ex.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IdeUtil.close(fileInputStream);
                        throw throwable;
                    }
                    IdeUtil.close(fileInputStream);
                }
                IdeUtil.close(fileInputStream);
            }
        }
        return instance;
    }

    private IdeRunStatus() {
    }

    public void setExtensionMigratorExecuted(Extension e, String migrator) {
        String key = e.getID() + migrator + "_migrated";
        this.addProperty(key, "true");
    }

    public boolean isExtensionMigratorExecuted(Extension e, String migrator) {
        String key = e.getID() + migrator + "_migrated";
        return super.containsKey(key);
    }

    public void setExtensionDataCopied(Extension e, String path) {
        this.addProperty(e.getID() + "." + e.getVersion() + path + "_dataCopyied", "true");
    }

    public boolean isExtensionDataCopied(Extension e, String path) {
        String key = e.getID() + "." + e.getVersion() + path + "_dataCopyied";
        return super.containsKey(key);
    }

    public void setUserMigrationChoice(String value) {
        this.addProperty("migrationStatus.lastDecision", value);
    }

    public void setPreviousMigrationSource(String value) {
        this.addProperty("migrationStatus.lastSource", value);
    }

    public String getUserMigrationChoice() {
        return this.getProperty("migrationStatus.lastDecision");
    }

    public String getPreviousMigrationSource() {
        return this.getProperty("migrationStatus.lastSource");
    }

    public void setMigrationAttemptedOnce() {
        this.addProperty("migration.attempted", "true");
    }

    public boolean migrationAttemptedOnce() {
        String v = this.getProperty("migration.attempted");
        return v != null && v.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProperty(String key, String value) {
        if (super.containsKey(key)) {
            return;
        }
        super.put(key, value);
        FileOutputStream fileOutputStream = null;
        try {
            if (this.runStatusFile.getParentFile().exists() || URLFileSystem.mkdir((URL)URLFactory.newDirURL((File)this.runStatusFile.getParentFile()))) {
                FileOutputStream os = fileOutputStream = new FileOutputStream(this.runStatusFile);
                super.storeToXML(os, "Ide Run Time Status Persistance");
            }
            IdeUtil.close(fileOutputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            IdeUtil.close(fileOutputStream);
        }
    }
}

