/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.resource.IdeArb;
import oracle.javatools.icons.OracleIcons;

public final class IdeActions {
    private static final LabelUpdater m_removeFromDiskLabelUpdater = new LabelUpdater(){

        @Override
        public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
            return this.getLabelForCurrentElement(context);
        }

        @Override
        public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
            return this.getLabelForCurrentElement(context);
        }

        @Override
        public void setEnabledFormat(String format) {
        }

        @Override
        public void setDisabledFormat(String format) {
        }

        private String getLabelForCurrentElement(Context context) {
            if (context.getElement() instanceof Project) {
                return DeleteDialogArb.getString(42);
            }
            if (context.getElement() instanceof Workspace) {
                return DeleteDialogArb.getString(43);
            }
            return IdeArb.getString(101);
        }
    };

    private static IdeAction findOrCreateAction(int cmdID, String cmdStr, String label, String actionCategory, Integer labelMnemonic, Icon icon, Object data, boolean enabled) {
        IdeAction action = IdeAction.get(cmdID, cmdStr, label, actionCategory, labelMnemonic, null, null, data, enabled);
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
        action.putValue("CanBePlacedOnMainToolbar", Boolean.TRUE);
        if (cmdStr != null) {
            action.setCommand(new MetaClass(IdeActions.class.getClassLoader(), cmdStr));
        }
        return action;
    }

    public static IdeAction getFileOpenAction() {
        IdeAction action = IdeActions.findOrCreateAction(9, "oracle.ide.cmd.OpenCommand", StringUtils.stripMnemonic((String)IdeArb.getString(52)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(52)), OracleIcons.getIcon((String)"open.png"), null, true);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.OpenCommand"));
        return action;
    }

    public static IdeAction getFileCloseAction() {
        IdeAction action = IdeActions.findOrCreateAction(48, "oracle.ide.cmd.CloseNodeCommand", StringUtils.stripMnemonic((String)IdeArb.getString(281)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(281)), null, null, true);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.CloseNodeCommand"));
        return action;
    }

    public static IdeAction getFileCloseAllAction() {
        return IdeActions.findOrCreateAction(39, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(195)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(195)), null, null, true);
    }

    public static IdeAction getFileSaveAction() {
        return IdeActions.findOrCreateAction(11, "oracle.ide.cmd.SaveCommand", StringUtils.stripMnemonic((String)IdeArb.getString(58)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(58)), OracleIcons.getIcon((String)"filesave.png"), null, false);
    }

    public static IdeAction getFileSaveAsAction() {
        IdeAction action = IdeActions.findOrCreateAction(12, "oracle.ide.cmd.SaveAsCommand", StringUtils.stripMnemonic((String)IdeArb.getString(61)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(61)), null, null, false);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.SaveAsCommand"));
        return action;
    }

    public static IdeAction getFileSaveAllAction() {
        IdeAction action = IdeActions.findOrCreateAction(13, "oracle.ide.cmd.SaveAllCommand", StringUtils.stripMnemonic((String)IdeArb.getString(64)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(64)), OracleIcons.getIcon((String)"saveall.png"), null, true);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.SaveAllCommand"));
        return action;
    }

    public static IdeAction getFileRenameAction() {
        IdeAction action = IdeActions.findOrCreateAction(14, "oracle.ide.cmd.RenameCommand", StringUtils.stripMnemonic((String)IdeArb.getString(67)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(67)), null, null, false);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.RenameCommand"));
        return action;
    }

    public static IdeAction getFileRemoveFromIDEAction() {
        IdeAction action = IdeActions.findOrCreateAction(21, "oracle.ide.cmd.RemoveFileCommand", StringUtils.stripMnemonic((String)IdeArb.getString(222)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(222)), OracleIcons.getIcon((String)"remove_file.png"), null, false);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.RemoveFileCommand"));
        return action;
    }

    public static IdeAction getFileRemoveFromIDENoConfirmAction() {
        IdeAction action = IdeActions.findOrCreateAction(90, "oracle.ide.cmd.RemoveFileCommandNoConfirm", StringUtils.stripMnemonic((String)IdeArb.getString(222)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(222)), OracleIcons.getIcon((String)"remove_file.png"), null, false);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.RemoveFileCommandNoConfirm"));
        return action;
    }

    public static IdeAction getFileRemoveFromDiskAction() {
        IdeAction removeFromDiskAction = IdeActions.findOrCreateAction(47, "oracle.ide.cmd.RemoveFromDiskCommand", StringUtils.stripMnemonic((String)IdeArb.getString(101)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(101)), OracleIcons.getIcon((String)"delete.png"), null, false);
        removeFromDiskAction.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.RemoveFromDiskCommand"));
        if (removeFromDiskAction.getLabelUpdater() == null) {
            removeFromDiskAction.setLabelUpdater(m_removeFromDiskLabelUpdater);
        }
        return removeFromDiskAction;
    }

    public static IdeAction getFileExitAction() {
        IdeAction action = IdeActions.findOrCreateAction(4, "oracle.ide.cmd.ExitCommand", StringUtils.stripMnemonic((String)IdeArb.getString(76)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(76)), null, Ide.getMainWindow(), true);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.ExitCommand"));
        return action;
    }

    public static IdeAction getFileReloadNodesAction() {
        return IdeActions.findOrCreateAction(72, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(230)), IdeMainWindow.ACTION_CATEGORY_FILE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(230)), null, null, true);
    }

    public static IdeAction getEditUndoAction() {
        String undoMenuLabel = StringUtils.stripMnemonic((String)IdeArb.format(80, ""));
        IdeAction action = IdeActions.findOrCreateAction(5, "oracle.ide.cmd.UndoCommand", undoMenuLabel, IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(80)), OracleIcons.getIcon((String)"undo.png"), CommandProcessor.getInstance(), false);
        action.putValue("NoCtxName", undoMenuLabel);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.UndoCommand"));
        return action;
    }

    public static IdeAction getEditRedoAction() {
        String redoMenuLabel = StringUtils.stripMnemonic((String)IdeArb.format(83, ""));
        IdeAction action = IdeActions.findOrCreateAction(6, "oracle.ide.cmd.RedoCommand", redoMenuLabel, IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(83)), OracleIcons.getIcon((String)"redo.png"), CommandProcessor.getInstance(), false);
        action.putValue("NoCtxName", redoMenuLabel);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.RedoCommand"));
        return action;
    }

    public static IdeAction getEditCutAction() {
        return IdeActions.findOrCreateAction(17, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(86)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(86)), OracleIcons.getIcon((String)"cut.png"), null, false);
    }

    public static IdeAction getEditCopyAction() {
        return IdeActions.findOrCreateAction(18, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(89)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(89)), OracleIcons.getIcon((String)"copy.png"), null, false);
    }

    public static IdeAction getEditCopyPathAction() {
        IdeAction action = IdeActions.findOrCreateAction(77, "oracle.ide.cmd.CopyPath", StringUtils.stripMnemonic((String)IdeArb.getString(92)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(92)), null, null, false);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.CopyPath"));
        return action;
    }

    public static IdeAction getEditPasteAction() {
        return IdeActions.findOrCreateAction(19, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(95)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(95)), OracleIcons.getIcon((String)"paste.png"), null, false);
    }

    public static IdeAction getEditExtendedPasteAction() {
        return IdeActions.findOrCreateAction(78, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(98)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(98)), null, null, false);
    }

    public static IdeAction getEditDeleteAction() {
        return IdeActions.findOrCreateAction(20, null, StringUtils.stripMnemonic((String)IdeArb.getString(101)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(101)), OracleIcons.getIcon((String)"delete.png"), null, false);
    }

    public static IdeAction getEditSelectAllAction() {
        return IdeActions.findOrCreateAction(22, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(369)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(369)), null, null, false);
    }

    public static IdeAction getEditPropertiesAction() {
        return IdeActions.findOrCreateAction(56, null, StringUtils.stripMnemonic((String)IdeArb.getString(350)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(350)), OracleIcons.getIcon((String)"properties.png"), null, false);
    }

    public static IdeAction getEditDuplicateSelectionAction() {
        IdeAction action = IdeActions.findOrCreateAction(82, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(106)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(106)), null, null, true);
        return action;
    }

    public static IdeAction getEditSelectWrapAction() {
        IdeAction action = IdeActions.findOrCreateAction(81, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(104)), IdeMainWindow.ACTION_CATEGORY_EDIT, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(104)), OracleIcons.getIcon((String)"block_selection.png"), null, true);
        action.putValue("Check", Boolean.TRUE);
        action.setState(false);
        action.putValue("CanBePlacedOnMainToolbar", Boolean.FALSE);
        return action;
    }

    public static IdeAction getViewNewViewAction() {
        return IdeActions.findOrCreateAction(67, null, StringUtils.stripMnemonic((String)IdeArb.getString(25)), IdeMainWindow.ACTION_CATEGORY_VIEW, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(25)), OracleIcons.getIcon((String)"navigator.png"), null, false);
    }

    public static IdeAction getViewFreezeAction() {
        IdeAction action = IdeActions.findOrCreateAction(68, null, StringUtils.stripMnemonic((String)IdeArb.getString(28)), IdeMainWindow.ACTION_CATEGORY_VIEW, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(28)), null, null, false);
        action.putValue("Check", Boolean.TRUE);
        if (null == action.getValue("State")) {
            action.putValue("State", Boolean.FALSE);
        }
        action.putValue("CanBePlacedOnMainToolbar", Boolean.FALSE);
        return action;
    }

    public static IdeAction getViewMainToolbarAction() {
        IdeAction action = IdeActions.findOrCreateAction(36, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(3)), IdeMainWindow.ACTION_CATEGORY_VIEW, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(3)), null, null, true);
        action.putValue("Check", Boolean.TRUE);
        action.putValue("CanBePlacedOnMainToolbar", Boolean.FALSE);
        return action;
    }

    public static IdeAction getViewStatusBarAction() {
        IdeAction action = IdeActions.findOrCreateAction(69, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(6)), IdeMainWindow.ACTION_CATEGORY_VIEW, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(6)), null, null, true);
        action.putValue("Check", Boolean.TRUE);
        return action;
    }

    public static IdeAction getViewRefreshAction() {
        return IdeActions.findOrCreateAction(51, null, StringUtils.stripMnemonic((String)IdeArb.getString(325)), IdeMainWindow.ACTION_CATEGORY_VIEW, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(325)), OracleIcons.getIcon((String)"refresh.png"), null, false);
    }

    public static IdeAction getSearchFindAction() {
        return IdeActions.findOrCreateAction(23, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(109)), IdeMainWindow.ACTION_CATEGORY_SEARCH, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(109)), OracleIcons.getIcon((String)"find.png"), null, false);
    }

    public static IdeAction getSearchFindNextAction() {
        IdeAction action = IdeActions.findOrCreateAction(25, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(115)), IdeMainWindow.ACTION_CATEGORY_SEARCH, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(115)), null, null, false);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.NotImplementedCommand"));
        return action;
    }

    public static IdeAction getSearchFindPreviousAction() {
        return IdeActions.findOrCreateAction(53, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(118), IdeMainWindow.ACTION_CATEGORY_SEARCH, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(118)), null, null, false);
    }

    public static IdeAction getSearchIncrementalFindForwardAction() {
        return IdeActions.findOrCreateAction(26, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(124)), IdeMainWindow.ACTION_CATEGORY_SEARCH, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(124)), null, null, false);
    }

    public static IdeAction getSearchIncrementalFindBackwardAction() {
        return IdeActions.findOrCreateAction(27, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(127)), IdeMainWindow.ACTION_CATEGORY_SEARCH, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(127)), null, null, false);
    }

    public static IdeAction getSearchReplaceAction() {
        return IdeActions.findOrCreateAction(24, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(112)), IdeMainWindow.ACTION_CATEGORY_SEARCH, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(112)), null, null, false);
    }

    public static IdeAction getNavigateGoToLineAction() {
        return IdeActions.findOrCreateAction(29, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(130)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(130)), null, null, false);
    }

    public static IdeAction getNavigateGoToClassAction() {
        return IdeActions.findOrCreateAction(32, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(139)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(139)), null, null, true);
    }

    public static IdeAction getNavigateGoToDocAction() {
        return IdeActions.findOrCreateAction(83, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(142)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, null, null, null, true);
    }

    public static IdeAction getNavigateGoToNextMessageAction() {
        return IdeActions.findOrCreateAction(30, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(133)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(133)), OracleIcons.getIcon((String)"next_message.png"), null, false);
    }

    public static IdeAction getNavigateGoToPreviousMessageAction() {
        return IdeActions.findOrCreateAction(31, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(136)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(136)), OracleIcons.getIcon((String)"previous_message.png"), null, false);
    }

    public static IdeAction getToolsProjectPropertiesAction() {
        return IdeActions.findOrCreateAction(35, "oracle.ide.cmd.NotImplementedCommand", StringUtils.stripMnemonic((String)IdeArb.getString(174)), IdeMainWindow.ACTION_CATEGORY_APPLICATION, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(174)), OracleIcons.getIcon((String)"settings.png"), null, false);
    }

    public static IdeAction getToolsDefaultProjectPropertiesAction() {
        return IdeAction.find(37);
    }

    public static IdeAction getToolsPreferencesAction() {
        IdeAction action = IdeActions.findOrCreateAction(38, "oracle.ide.cmd.IdeSettingsCommand", StringUtils.stripMnemonic((String)IdeArb.getString(181)), IdeMainWindow.ACTION_CATEGORY_TOOLS, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(181)), null, null, true);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.IdeSettingsCommand"));
        return action;
    }

    public static IdeAction getHelpAboutAction() {
        IdeAction action = IdeActions.findOrCreateAction(79, "oracle.ide.cmd.AboutCommand", StringUtils.stripMnemonic((String)IdeArb.getString(425)), IdeMainWindow.ACTION_CATEGORY_HELP, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(425)), null, null, true);
        action.setCommand(new MetaClass(Ide.class.getClassLoader(), "oracle.ide.cmd.AboutCommand"));
        return action;
    }

    public static IdeAction getGoToDeclarationAction() {
        return IdeActions.findOrCreateAction(Ide.findOrCreateCmdID("ojjb.BrowseSymbol"), null, StringUtils.stripMnemonic((String)IdeArb.getString(144)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(144)), null, null, true);
    }

    public static IdeAction getFullScreenAction() {
        IdeAction action = IdeActions.findOrCreateAction(Ide.findOrCreateCmdID("oracle.ide.docking.FullScreenAction"), null, StringUtils.stripMnemonic((String)IdeArb.getString(543)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(543)), null, null, true);
        action.putValue("Check", Boolean.TRUE);
        action.setState(false);
        action.putValue("CanBePlacedOnMainToolbar", Boolean.FALSE);
        return action;
    }
}

