/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.util.ModelUtil;

public class ProgressBar
implements ActionListener,
Runnable {
    private Component _parent;
    protected final JLabel _progressLabel = new JLabel();
    private String _progressText;
    private final JLabel _stepLabel = new JLabel();
    private String _stepText;
    private JProgressBar _progressBar;
    private boolean _useBusyBar;
    protected DetailDialog _statusDialog;
    private String _dialogTitle;
    private String _dialogName;
    private boolean _dialogResizable;
    private int _completionStatus;
    private final Timer _labelTimer = new Timer(1, null);
    private final Timer _completionTimer = new Timer(1, null);
    private boolean _userCancelled;
    private Runnable _runnable;
    private long _current = 0L;
    private long _lastPause = 0L;
    private boolean _done = false;
    private boolean _canCancel = true;
    private final JPanel _statusPanel = new JPanel(new GridBagLayout());
    private int _customButtonMask = -1;
    private JButton _customButton;
    private boolean _customButtonPressed;
    private boolean _okButtonPressed;
    private Component _detailsContent;
    private String _showDetailsText;
    private String _hideDetailsText;
    private boolean _initialDetailsButtonState;
    private String _okButtonText;

    public ProgressBar(Component parent, String dialogTitle, Runnable runnable, boolean useBusyBar) {
        this._parent = parent;
        this._dialogTitle = dialogTitle;
        this._runnable = runnable;
        this._useBusyBar = useBusyBar;
    }

    public void setRunnable(Runnable runnable) {
        this._runnable = runnable;
    }

    public void setDialogName(String dialogName) {
        this._dialogName = dialogName;
    }

    public void setDialogResizable(boolean resizable) {
        this._dialogResizable = resizable;
    }

    public void setProgressDetailContent(Component customContent, String okButtonText, boolean initialButtonState) {
        this._detailsContent = customContent;
        this._okButtonText = okButtonText;
        this._initialDetailsButtonState = initialButtonState;
    }

    public void setShowDetailsText(String showDetailsText) {
        this._showDetailsText = showDetailsText;
    }

    public void setOKButtonText(String okButtonText) {
        this._okButtonText = okButtonText;
        if (this._statusDialog != null) {
            this._statusDialog.setOKButtonText(this._okButtonText);
        }
    }

    public void setHideDetailsText(String hideDetailsText) {
        this._hideDetailsText = hideDetailsText;
    }

    public void setCustomButton(JButton customButton) {
        this._customButton = customButton;
    }

    public void setCustomButtonEnabled(boolean enabled) {
        if (this._customButton != null) {
            this._customButton.setEnabled(enabled);
        }
    }

    public void setDetailsButtonEnabled(boolean enabled) {
        if (this._statusDialog != null) {
            this._statusDialog.setDetailsButtonEnabled(enabled);
        }
    }

    public void setCustomDialogButtonMask(int mask) {
        this._customButtonMask = mask;
    }

    public void setCancelable(boolean canCancel) {
        this._canCancel = canCancel;
    }

    public boolean isCancelable() {
        return this._canCancel;
    }

    public void start(String initialText, String stepText) {
        this.start(initialText, stepText, 0, 100);
    }

    public void start(String initialText, String stepText, int delay) {
        this.start(initialText, stepText, 0, 100, delay);
    }

    public void start(String initialText, String stepText, int min, int max) {
        this.start(initialText, stepText, min, max, 0);
    }

    public void start(String initialText, String stepText, int min, int max, int delay) {
        this.start(initialText, stepText, min, max, -1, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final String initialText, final String stepText, final int min, final int max, final int wcDelay, final int delay) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBar.this.start(initialText, stepText, min, max, wcDelay, delay);
                }
            });
            this.waitUntilDone();
            return;
        }
        ProgressBar progressBar = this;
        synchronized (progressBar) {
            this._done = false;
        }
        this._progressText = initialText;
        this._stepText = stepText;
        this._progressLabel.setText(this._progressText);
        this._progressLabel.setLabelFor(this._progressBar);
        this._stepLabel.setText(this._stepText);
        this._progressBar = new JProgressBar(min, max);
        if (!this._useBusyBar) {
            this._progressBar.setValue(0);
        }
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._statusPanel.add((Component)this._progressLabel, constraints);
        constraints.gridy = 1;
        this._statusPanel.add((Component)this._progressBar, constraints);
        if (this._useBusyBar) {
            this._progressBar.setIndeterminate(true);
        } else {
            this._progressBar.setIndeterminate(false);
        }
        constraints.gridy = 2;
        this._statusPanel.add((Component)this._stepLabel, constraints);
        constraints.gridy = 3;
        this._statusPanel.add(Box.createHorizontalStrut(300), constraints);
        if (this._detailsContent != null) {
            constraints.gridx = 0;
            constraints.gridy = 4;
            this._statusPanel.add(this._detailsContent, constraints);
        }
        this._labelTimer.addActionListener(this);
        this._labelTimer.setRepeats(true);
        this._completionTimer.addActionListener(this);
        this._completionTimer.setRepeats(false);
        this._userCancelled = false;
        Thread thread = new Thread((Runnable)this, "ProgressBarThread");
        thread.setPriority(5);
        thread.start();
        boolean done = false;
        if (delay > 0) {
            ProgressBar progressBar2 = this;
            synchronized (progressBar2) {
                WaitCursor wc = null;
                try {
                    if (wcDelay >= 0 && delay >= wcDelay) {
                        wc = new WaitCursor(this._parent);
                        wc.show(wcDelay);
                    }
                    this.wait(delay);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    if (wc != null) {
                        wc.hide();
                    }
                }
                done = this._done;
            }
        }
        JEWTDialog dialog = null;
        if (!done) {
            dialog = this.createStatusDialog();
            if (this._statusDialog != null) {
                this._statusDialog.setResizable(this._dialogResizable);
            }
            if (!done && dialog != null) {
                this._userCancelled = !dialog.runDialog();
                this._okButtonPressed = dialog.isOked();
            }
        }
        if (this._userCancelled && thread.isAlive()) {
            thread.interrupt();
        }
        this.setDoneStatus();
        this._statusPanel.removeAll();
        if (dialog != null) {
            dialog.dispose();
        }
    }

    private JEWTDialog createStatusDialog() {
        try {
            this._statusDialog = ProgressDialog.createDialog(this._parent, this._dialogTitle, this._canCancel, this._dialogName, this._customButtonMask);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this._statusDialog == null) {
            return null;
        }
        this._statusDialog.setContent((Component)this._statusPanel);
        if (this._customButton != null) {
            this._statusDialog.addCustomButton((Component)this._customButton);
            this._customButton.addActionListener(this);
        }
        this._statusDialog.setDetailContent(this._detailsContent);
        if (this._detailsContent != null) {
            if (this._showDetailsText != null) {
                this._statusDialog.setButtonTextWhenDetailsHidden(this._showDetailsText, true);
            }
            if (this._hideDetailsText != null) {
                this._statusDialog.setButtonTextWhenDetailsShown(this._hideDetailsText, false);
            }
            if (this._okButtonText != null) {
                this._statusDialog.setOKButtonText(this._okButtonText);
            }
            this._statusDialog.setDetailsButtonEnabled(this._initialDetailsButtonState);
        }
        this._statusDialog.setName("ProgressBar " + UUID.randomUUID());
        this._statusDialog.addWindowListener((WindowListener)new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowOpened(WindowEvent e) {
                DetailDialog dialog = ProgressBar.this._statusDialog;
                ProgressBar progressBar = ProgressBar.this;
                synchronized (progressBar) {
                    if (ProgressBar.this._done && dialog != null) {
                        dialog.setVisible(false);
                    }
                }
                e.getWindow().removeWindowListener(this);
            }
        });
        return this._statusDialog;
    }

    public void updateProgress(int completionStatus, String progressText, String stepText) {
        if (this._userCancelled) {
            return;
        }
        if (this._progressBar == null) {
            return;
        }
        this._completionStatus = completionStatus;
        if (ModelUtil.hasLength((String)progressText)) {
            this._progressText = progressText;
        }
        if (ModelUtil.hasLength((String)stepText)) {
            this._stepText = stepText;
        }
        this._labelTimer.start();
    }

    public int getCompletionStatus() {
        return this._completionStatus;
    }

    public String getStepText() {
        return this._stepText;
    }

    public String getProgressText() {
        return this._progressText;
    }

    public void updateProgress(String progressText, String stepText) {
        if (!this._userCancelled) {
            if (ModelUtil.hasLength((String)progressText)) {
                this._progressText = progressText;
            }
            if (ModelUtil.hasLength((String)stepText)) {
                this._stepText = stepText;
            }
            this._labelTimer.start();
        }
    }

    public boolean hasUserCancelled() {
        if (this._userCancelled) {
            this.setDoneStatus();
        }
        return this._userCancelled;
    }

    public boolean hasUserPressedCustomButton() {
        if (this._customButtonPressed) {
            this.setDoneStatus();
        }
        return this._customButtonPressed;
    }

    public boolean hasUserPressedOkButton() {
        return this._okButtonPressed;
    }

    public void sleepForUIToRepaint() {
        if (this._lastPause == 0L) {
            this._current = this._lastPause = System.currentTimeMillis();
        } else {
            this._current = System.currentTimeMillis();
            long elapsed = this._current - this._lastPause;
            if (elapsed > 1000L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this._lastPause = this._current;
            }
        }
    }

    public synchronized void waitUntilDone() {
        while (!this._done) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.notifyAll();
    }

    public synchronized void setDoneStatus() {
        this._done = true;
        this.notifyAll();
        this.end();
    }

    @Override
    @Deprecated
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._labelTimer) {
            if (ModelUtil.hasLength((String)this._progressText)) {
                this._progressLabel.setText(this._progressText);
            }
            if (ModelUtil.hasLength((String)this._stepText)) {
                this._stepLabel.setText(this._stepText);
            }
            if (this._progressBar != null) {
                this._progressBar.setValue(this._completionStatus);
            }
        } else if (source == this._completionTimer) {
            if (this._statusDialog != null && this._statusDialog.isVisible()) {
                if (this._statusDialog.hasVisibleDetails()) {
                    this._progressBar.setIndeterminate(false);
                    this._progressBar.setValue(100);
                    this._stepLabel.setText(" ");
                    this.runPostCompletionTasks();
                } else {
                    this._statusDialog.setVisible(false);
                }
            }
            this.stopAndDetach(this._labelTimer);
            this.stopAndDetach(this._completionTimer);
        } else if (source == this._customButton && this._statusDialog != null && this._statusDialog.isVisible()) {
            this._customButtonPressed = true;
            this._statusDialog.setVisible(false);
        }
    }

    protected void runPostCompletionTasks() {
    }

    private void stopAndDetach(Timer timer) {
        timer.stop();
        timer.removeActionListener(this);
    }

    @Override
    @Deprecated
    public void run() {
        if (this._userCancelled) {
            return;
        }
        this._runnable.run();
    }

    private void end() {
        this._completionTimer.start();
    }

    private static class ProgressDialog
    extends DetailDialog {
        static ProgressDialog createDialog(Component parent, String title, boolean canCancel, String dialogName, int customMask) {
            ProgressDialog dlg = null;
            Dialog dialog = DialogUtil.getAncestorDialog(parent);
            if (dialog != null) {
                dlg = customMask != -1 ? new ProgressDialog(dialog, title, canCancel, customMask) : new ProgressDialog(dialog, title, canCancel);
            } else {
                Frame frame = DialogUtil.getAncestorFrame(parent);
                if (frame != null) {
                    dlg = customMask != -1 ? new ProgressDialog(frame, title, canCancel, customMask) : new ProgressDialog(frame, title, canCancel);
                }
            }
            if (dialogName != null) {
                dlg.setName(dialogName);
            }
            return dlg;
        }

        private static int _getButtonMask(boolean canCancel) {
            return canCancel ? 2 : 0;
        }

        private ProgressDialog(Dialog dlg, String title, boolean canCancel) {
            super(dlg, title, ProgressDialog._getButtonMask(canCancel));
            this._init(canCancel, -1);
        }

        private ProgressDialog(Dialog dlg, String title, boolean canCancel, int customMask) {
            super(dlg, title, customMask);
            this._init(canCancel, customMask);
        }

        private ProgressDialog(Frame frame, String title, boolean canCancel) {
            super(frame, title, ProgressDialog._getButtonMask(canCancel));
            this._init(canCancel, -1);
        }

        private ProgressDialog(Frame frame, String title, boolean canCancel, int customMask) {
            super(frame, title, customMask);
            this._init(canCancel, customMask);
        }

        private void _init(boolean canCancel, int customMask) {
            if (customMask == -1) {
                this.setDefaultButton(ProgressDialog._getButtonMask(canCancel));
            }
            if (!canCancel) {
                this.setDefaultCloseOperation(0);
            }
        }

        protected void dismissDialog(boolean cancelled) {
            if (this.getDefaultCloseOperation() != 0) {
                super.dismissDialog(cancelled);
            }
        }

        public void dispose() {
            super.dispose();
        }

        public void removeNotify() {
            super.removeNotify();
        }
    }
}

