/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.MenuElement;
import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.Layout;
import oracle.ide.util.BitField;
import oracle.ide.util.GraphicsUtils;

public final class DockUtil {
    private static final boolean SMART_BEHAVIOR = true;

    public static void showDockableWindow(DockableView dw) {
        dw.show();
        DockStation ds = DockStation.getDockStation();
        ds.activateDockable(dw);
    }

    public static void hideDockableWindow(DockableView dw) {
        if (GraphicsUtils.isAncestorOfFocusedComponent((Component)dw.getGUI())) {
            EditorManager em = EditorManager.getEditorManager();
            em.activateCurrentEditorFrame();
        }
        dw.close();
    }

    public static void toggleDockableWindow(DockableView dw) {
        if (dw.isVisible()) {
            DockUtil.hideDockableWindow(dw);
        } else {
            DockUtil.showDockableWindow(dw);
        }
    }

    public static void smartToggleDockableWindow(DockableView dw, Context context) {
        Object src;
        EventObject event;
        boolean bFromMenu = true;
        if (context != null && (event = context.getEvent()) != null && (src = event.getSource()) != null && !(src instanceof MenuElement)) {
            bFromMenu = false;
        }
        if (bFromMenu) {
            DockUtil.toggleDockableWindow(dw);
        } else if (!dw.isVisible()) {
            DockUtil.showDockableWindow(dw);
        } else {
            Component c = dw.getGUI();
            if (GraphicsUtils.isAncestorOfFocusedComponent((Component)c)) {
                DockUtil.hideDockableWindow(dw);
            } else {
                DockStation ds = DockStation.getDockStation();
                ds.activateDockable(dw);
            }
        }
    }

    public static boolean isShowingByDefault(Dockable dockable, Layout layout) {
        int visibility = dockable.getDefaultVisibility(layout);
        return BitField.isSet(visibility, 1);
    }

    public static boolean isMinimizedByDefault(Dockable dockable, Layout layout) {
        int visibility = dockable.getDefaultVisibility(layout);
        return BitField.isSet(visibility, 2);
    }

    public static boolean isRaisedByDefault(Dockable dockable, Layout layout) {
        int visibility = dockable.getDefaultVisibility(layout);
        return BitField.isSet(visibility, 4);
    }
}

