/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyboardDockable;
import oracle.ide.layout.IdeProperties;
import oracle.ide.util.Assert;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public final class KeyStrokeOptions
extends ChangeEventSource
implements Copyable {
    static final boolean DEBUG = false;
    public static final String KEY_SETTINGS = KeyStrokeOptions.class.getName();
    private ArrayList<KeyStrokeContext> _postponedContexts = new ArrayList(20);
    private String _presetName;
    private boolean _bModifiedPreset;
    private KeyStrokeMap _ksmGlobal;
    private HashMap<String, KeyStrokeMap> _mapKsmLocal;
    private final ArrayList<String> _knownContexts = new ArrayList(20);
    private ActionListener _keyboardPanelEventDispatcher;

    @Override
    public Object copyTo(Object target) {
        Assert.printStackTrace((this == target ? 1 : 0) != 0, (String)"Cannot copy to self! See bug 10329786.");
        KeyStrokeOptions copy = target != null && target != this ? (KeyStrokeOptions)((Object)target) : new KeyStrokeOptions();
        this.copyToImpl(copy);
        return copy;
    }

    private final void copyToImpl(KeyStrokeOptions copy) {
        copy.assign(this, true);
    }

    public KeyStrokeOptions cloneObject(boolean bDeepCopy) {
        KeyStrokeOptions clone = new KeyStrokeOptions();
        clone.assign(this, bDeepCopy);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assign(KeyStrokeOptions source, boolean bDeepCopy) {
        ArrayList<KeyStrokeContext> arrayList = this._postponedContexts;
        synchronized (arrayList) {
            this._presetName = source._presetName;
            this._bModifiedPreset = source._bModifiedPreset;
            this._keyboardPanelEventDispatcher = source._keyboardPanelEventDispatcher;
            if (bDeepCopy) {
                this._ksmGlobal = source._ksmGlobal.cloneObject();
                if (source._mapKsmLocal != null) {
                    this._mapKsmLocal = new HashMap(source._mapKsmLocal.size());
                    for (Map.Entry<String, KeyStrokeMap> entry : source._mapKsmLocal.entrySet()) {
                        KeyStrokeMap ksm = entry.getValue();
                        this._mapKsmLocal.put(entry.getKey(), ksm.cloneObject());
                    }
                } else {
                    this._mapKsmLocal = new HashMap();
                }
                this._knownContexts.clear();
                this._knownContexts.addAll(source._knownContexts);
                this._postponedContexts.clear();
                if (!source._postponedContexts.isEmpty()) {
                    this._postponedContexts.addAll(source._postponedContexts);
                }
            } else {
                this._ksmGlobal = source._ksmGlobal;
                this._mapKsmLocal = source._mapKsmLocal;
                this._postponedContexts.addAll(source._postponedContexts);
            }
            this.fireChangeEvent();
        }
    }

    public String getPresetName() {
        if (this._presetName == null) {
            this._presetName = Ide.getProperty("DefaultKeyMapping", "Default");
        }
        return this._presetName;
    }

    public void setPresetName(String sName) {
        this._presetName = sName;
    }

    public boolean isModifiedPreset() {
        return this._bModifiedPreset;
    }

    public void setModifiedPreset(boolean bModified) {
        this._bModifiedPreset = bModified;
    }

    public KeyStrokeMap getLocalKeyMap(KeyStrokeContext ksc) {
        KeyStrokeMap ksm = null;
        if (this._mapKsmLocal != null && ksc != null) {
            ksm = this._mapKsmLocal.get(ksc.getName());
        }
        return ksm;
    }

    void loadPreset(KeyStrokeContextRegistry kscr, String sPreset) {
        this._ksmGlobal.removeAll();
        Iterator i = kscr.getAllContexts();
        while (i.hasNext()) {
            KeyStrokeMap ksmNew;
            KeyStrokeContext ksc = (KeyStrokeContext)i.next();
            String sName = ksc.getName();
            Object kscPreset = KeyStrokeContextRegistry.searchPreset(ksc, sPreset);
            if (kscPreset == null) continue;
            KeyStrokeMap ksmNewGlobal = ksc.getPresetKeyStrokeMap(kscPreset, true);
            if (ksmNewGlobal != null) {
                this._ksmGlobal.putAll(ksmNewGlobal);
            }
            if ((ksmNew = ksc.getPresetKeyStrokeMap(kscPreset, false)) != null) {
                this._mapKsmLocal.put(sName, ksmNew);
                continue;
            }
            this._mapKsmLocal.remove(sName);
        }
        this.setPresetName(sPreset);
        this._bModifiedPreset = false;
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(KeyStrokeContext ksc) {
        ArrayList<KeyStrokeContext> arrayList = this._postponedContexts;
        synchronized (arrayList) {
            this._postponedContexts.add(ksc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solvePostponedMaps() {
        ArrayList<KeyStrokeContext> arrayList = this._postponedContexts;
        synchronized (arrayList) {
            if (this._postponedContexts.isEmpty()) {
                return;
            }
            this.checkShowKeyboardDockable();
            String sPreset = this.getPresetName();
            int n = this._postponedContexts.size();
            if (this._mapKsmLocal == null) {
                this._mapKsmLocal = new HashMap();
            }
            for (int i = 0; i < n; ++i) {
                KeyStrokeContext ksc = this._postponedContexts.get(i);
                if (this._knownContexts.contains(ksc.getName())) continue;
                this._knownContexts.add(ksc.getName());
                Object kscPreset = KeyStrokeContextRegistry.searchPreset(ksc, sPreset);
                KeyStrokeMap ksm = ksc.getPresetKeyStrokeMap(kscPreset, true);
                if (ksm != null) {
                    KeyStrokeMap ksmGlobal = this.getGlobalKeyMap();
                    ksmGlobal.putAll(ksm);
                }
                if ((ksm = ksc.getPresetKeyStrokeMap(kscPreset, false)) == null) continue;
                this._mapKsmLocal.put(ksc.getName(), ksm);
            }
            this._postponedContexts.clear();
            if (this._ksmGlobal != null) {
                this._ksmGlobal.solvePostponedLoad();
            }
            for (KeyStrokeMap ksm : this._mapKsmLocal.values()) {
                ksm.solvePostponedLoad();
            }
            this.fireChangeEvent();
        }
    }

    private void checkShowKeyboardDockable() {
        IdeProperties ideProperties = Ide.getIdeProperties();
        String property = ideProperties.getProperty("SHOW_KEYBOARD_DOCKABLE", "false");
        if (Boolean.valueOf(property).booleanValue()) {
            KeyboardDockable.initialize();
        }
    }

    public void removeContext(KeyStrokeContext ksc) {
        KeyStrokeMap ksm;
        if (this._mapKsmLocal != null) {
            this._mapKsmLocal.remove(ksc.getName());
        }
        if ((ksm = ksc.getPresetKeyStrokeMap(KeyStrokeContextRegistry.searchPreset(ksc, this.getPresetName()), true)) != null) {
            KeyStrokeMap ksmGlobal = this.getGlobalKeyMap();
            ksmGlobal.removeAll(ksm);
        }
        this._knownContexts.remove(ksc.getName());
        this.fireChangeEvent();
    }

    public void setKeyboardPanelEventDispatcher(ActionListener actionListener) throws TransientMarker {
        this._keyboardPanelEventDispatcher = actionListener;
    }

    public ActionListener getKeyboardPanelEventDispatcher() throws TransientMarker {
        return this._keyboardPanelEventDispatcher;
    }

    public KeyStrokeMap getGlobalKeyMap() {
        if (this._ksmGlobal == null) {
            this._ksmGlobal = new KeyStrokeMap();
        }
        return this._ksmGlobal;
    }

    public void setGlobalKeyMap(KeyStrokeMap ksm) {
        this._ksmGlobal = ksm;
    }

    public void setLocalKeyMaps(HashMap mapKsmLocal) {
        this._mapKsmLocal = mapKsmLocal;
    }

    public HashMap getLocalKeyMaps() {
        return this._mapKsmLocal;
    }

    public ArrayList getRegisteredContexts() {
        return this._knownContexts;
    }

    public void setRegisteredContexts(ArrayList list) {
        this._knownContexts.addAll(list);
    }
}

