/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;

public abstract class AbstractFileContentRecognizerTemplate
extends Recognizer {
    protected final RandomAccessFile fileFrom(URL url) throws FileNotFoundException {
        File file = new File(url.getFile());
        return new RandomAccessFile(file, "r");
    }

    protected final MetaClass<? extends Node> recognizeURL(URL url, RandomAccessFile file, FileContentRule rule) throws IOException {
        if (rule == null) {
            return null;
        }
        if (rule.protocol != null && rule.protocol.length() > 0 && !rule.protocol.equals(url.getProtocol())) {
            return null;
        }
        if (rule.fileExtension != null) {
            String extension = URLFileSystem.getSuffix((URL)url);
            if (extension == null || extension.length() == 0) {
                return null;
            }
            File fileExtension = new File(extension);
            if (!rule.fileExtension.equals(fileExtension)) {
                return null;
            }
        }
        if (rule.contents.isEmpty()) {
            return null;
        }
        boolean noMatch = false;
        for (ContentToLookFor content : rule.contents) {
            file.seek(content.position);
            byte[] buffer = new byte[content.text.length()];
            file.read(buffer);
            String read = new String(buffer);
            if (content.text.equals(read)) continue;
            noMatch = true;
            break;
        }
        return noMatch ? null : rule.nodeType;
    }

    public static class ContentToLookFor
    implements Comparable<ContentToLookFor> {
        final String text;
        final int position;

        public ContentToLookFor(String text, int position) {
            this.text = text;
            this.position = position;
        }

        @Override
        public int compareTo(ContentToLookFor o) {
            if (this.position < o.position) {
                return -1;
            }
            if (this.position == o.position) {
                return 0;
            }
            return 1;
        }
    }

    public static class FileContentRule {
        final String protocol;
        final File fileExtension;
        final List<ContentToLookFor> contents;
        final MetaClass<Node> nodeType;

        public FileContentRule(String protocol, File fileExtension, List<ContentToLookFor> contents, MetaClass<Node> nodeType) {
            this.protocol = protocol;
            this.fileExtension = fileExtension;
            this.contents = new ArrayList<ContentToLookFor>(contents);
            Collections.sort(contents);
            this.nodeType = nodeType;
        }
    }
}

