/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.migration.NodeMigratorHelperReference;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.VersionNumber;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ListUtil;

abstract class HashStructureNodeMigrator
extends NodeMigrator {
    private static String IDE_VERSION;
    private static String forcedMigrators;

    HashStructureNodeMigrator() {
        this.addHelper(new NodeMigratorHelper(){

            @Override
            public void migrate(MigrationInfo[] infos, TraversableContext tc) {
            }

            @Override
            public String getNodeMigratorHelperKey() {
                return "oracle.ide.model.Project";
            }

            @Override
            public String getNodeMigratorHelperVersion() {
                return IDE_VERSION;
            }
        });
    }

    @Override
    public MigrationInfo getMigrationInfo(Node node) {
        return new HSNodeMigrationInfo(node, this.getHelperReferences(), this.getRootQname());
    }

    abstract String getRootQname();

    @Override
    @Deprecated
    protected NodeMigratorHelper[] getHelpers(MigrationInfo info) {
        ArrayList<NodeMigratorHelper> helpers = new ArrayList<NodeMigratorHelper>();
        if (info instanceof HSNodeMigrationInfo) {
            HSNodeMigrationInfo hsInfo = (HSNodeMigrationInfo)info;
            helpers.addAll(hsInfo.getActiveHelpers());
        }
        return helpers.toArray(new NodeMigratorHelper[helpers.size()]);
    }

    @Override
    protected NodeMigratorHelperReference[] getHelperReferences(MigrationInfo info) {
        ArrayList<NodeMigratorHelperReference> helpers = new ArrayList<NodeMigratorHelperReference>();
        if (info instanceof HSNodeMigrationInfo) {
            HSNodeMigrationInfo hsInfo = (HSNodeMigrationInfo)info;
            helpers.addAll(hsInfo.getActiveHelperReferences());
        }
        return helpers.toArray(new NodeMigratorHelperReference[helpers.size()]);
    }

    private static boolean isForced(String migratorName) {
        String[] fms;
        if (forcedMigrators == null || migratorName == null) {
            return false;
        }
        for (String fm : fms = forcedMigrators.split(":")) {
            if (!migratorName.equals(fm)) continue;
            HashStructureNodeMigrator.reportMigration("--> Migrator %s forced to run by option", migratorName);
            return true;
        }
        return false;
    }

    private static boolean isSkipMigration(HashStructure hash) {
        ProjectVersion jwsVersion;
        VersionNumber ideVersionNumber;
        if (hash.getBoolean("doNoMigration")) {
            return true;
        }
        return hash.getBoolean("doLimitedMigration") && (ideVersionNumber = new VersionNumber(Version.VER)).isBefore((jwsVersion = new ProjectVersion(hash)).getCurrentVersion(), true);
    }

    static {
        int lastDot = Ide.getProductVersion().lastIndexOf(46);
        IDE_VERSION = lastDot == -1 ? Ide.getProductVersion() : Ide.getProductVersion().substring(0, lastDot);
        forcedMigrators = System.getProperty("ide.migration.force.new");
    }

    static class HSNodeMigrationInfo
    extends MigrationInfo {
        private final Collection<NodeMigratorHelperReference> helperReferences = new TreeSet<NodeMigratorHelperReference>();
        private final String _rootQname;

        HSNodeMigrationInfo(Node node, NodeMigratorHelperReference[] helpers, String rootQname) {
            super(node);
            if (helpers != null) {
                for (NodeMigratorHelperReference helper : helpers) {
                    this.helperReferences.add(helper);
                }
            }
            this._rootQname = rootQname;
        }

        @Override
        protected void ensureVersionInfo() {
            if (this.getVersionDirectly() == null) {
                this.ensureVersionInfoImpl(true);
            }
        }

        void ensureVersionInfoImpl(boolean deepWorkspaceScan) {
            block31: {
                ArrayList<NodeMigratorHelperReference> removed = new ArrayList<NodeMigratorHelperReference>();
                this.setVersionStatusDirectly(VERSION_UNKNOWN);
                this.setMigrationStatus(MIGRATION_NOT_POSSIBLE);
                this.setVersionDirectly("");
                try {
                    Node node = this.getNode();
                    URL url = node.getURL();
                    StartElementPacket sep = XMLUtil.getXMLRootElement((URL)url);
                    if (sep != null && sep.namespaceURI != null && sep.namespaceURI.length() > 0) {
                        String uriVersion = HSNodeMigrationInfo.getVersionFromNamespaceURI(sep.namespaceURI);
                        if (uriVersion == null) break block31;
                        if (uriVersion.equals("10130") || !uriVersion.matches("^\\d+$")) {
                            Iterator<NodeMigratorHelperReference> hi;
                            Object helper;
                            HashStructure hash = null;
                            try {
                                HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/project", this._rootQname);
                                hash = (HashStructure)io.load(url);
                            }
                            catch (Exception e) {
                                String msg = IdeArb.format(509, node.getLongLabel(), this.getErrorMessage(e, e));
                                this.addError(new MigrationInfo.ErrorInformation(msg));
                                return;
                            }
                            ProjectVersion hashVersion = new ProjectVersion(hash);
                            Iterator<NodeMigratorHelperReference> helpersIter = this.helperReferences.iterator();
                            VersionNumber newer = this.isWorkspaceOrProjectAlreadyMigrated(node, hashVersion);
                            if (newer != null) {
                                this.setMigrationStatus(MIGRATION_PENDING);
                                this.setVersionStatusDirectly(VERSION_NEWER);
                                this.setVersionDirectly(newer.toString());
                                this.addError(new MigrationInfo.ErrorInformation(IdeArb.format(415, node.getShortLabel(), newer.toString()), MigrationInfo.ErrorInformation.ActionType.ABORT));
                                return;
                            }
                            boolean useMissingMigrators = this.useMissingMigrators(hashVersion, this.helperReferences);
                            TechnologyScope nodeTechScope = this.getTechScope(hash);
                            while (helpersIter.hasNext()) {
                                NodeMigratorHelperReference helper2 = helpersIter.next();
                                VersionNumber migratorVersion = new VersionNumber(helper2.version());
                                String migratorKey = helper2.key();
                                VersionNumber versionInHash = migratorKey != null ? hashVersion.getCurrentVersion(migratorKey) : hashVersion.getCurrentVersion();
                                if (versionInHash == null) {
                                    if (useMissingMigrators || HashStructureNodeMigrator.isForced(helper2.key())) {
                                        HashStructureNodeMigrator.reportMigration("--> Migration of %s due to missing breadcrumb for %s", new Object[]{URLFileSystem.getFileName((URL)url), helper2.key()});
                                        continue;
                                    }
                                    helpersIter.remove();
                                    removed.add(helper2);
                                    continue;
                                }
                                int compare = migratorVersion.compareTo(versionInHash);
                                if (!this.isInScope(helper2, nodeTechScope)) {
                                    helpersIter.remove();
                                    removed.add(helper2);
                                    continue;
                                }
                                if (compare > 0) {
                                    if ("oracle.ide.model.Project".equals(helper2.key())) continue;
                                    HashStructureNodeMigrator.reportMigration("--> Migration of %s specifically requested by %s", new Object[]{URLFileSystem.getFileName((URL)url), helper2.key()});
                                    continue;
                                }
                                if (compare == 0) {
                                    helpersIter.remove();
                                    removed.add(helper2);
                                    continue;
                                }
                                helpersIter.remove();
                                removed.add(helper2);
                            }
                            this.removeHelpersInDeprecatedList(removed);
                            if (this.helperReferences.size() == 1 && "oracle.ide.model.Project".equals(((NodeMigratorHelperReference)(helper = (hi = this.helperReferences.iterator()).next())).key())) {
                                hi.remove();
                            }
                            boolean skipMigration = false;
                            if (node instanceof Workspace) {
                                skipMigration = HashStructureNodeMigrator.isSkipMigration(hash);
                            }
                            if (this.helperReferences.size() > 0 && !skipMigration) {
                                for (NodeMigratorHelperReference nmhr : this.helperReferences) {
                                    if ("oracle.ide.model.Project".equals(nmhr.key()) || !nodeTechScope.contains(nmhr.getTechnologyScope()) && !nmhr.getTechnologyScope().isEmpty() && !this.isTechnologyPresent(nodeTechScope, nmhr.getTechnologyScope())) continue;
                                    this.setMigrationStatus(MIGRATION_PENDING);
                                    this.setVersionStatusDirectly(VERSION_OLDER);
                                    this.setVersionDirectly("10.1.3");
                                    break block31;
                                }
                                break block31;
                            }
                            if (node instanceof Workspace && deepWorkspaceScan) {
                                ListStructure listOfChildren;
                                ArrayList<String> missingProjects = new ArrayList<String>();
                                boolean atLeastOneProjectNeedsMigration = false;
                                if (!skipMigration && (listOfChildren = hash.getListStructure("listOfChildren")) != null) {
                                    for (Object childObj : listOfChildren) {
                                        if (!(childObj instanceof HashStructure)) continue;
                                        HashStructure child = (HashStructure)childObj;
                                        URL projectURL = child.getURL("URL");
                                        if (url == null || !URLFileSystem.hasSuffix((URL)projectURL, (String)".jpr")) continue;
                                        HashStructureIO projectIO = new HashStructureIO("http://xmlns.oracle.com/ide/project", "jpr:project");
                                        try {
                                            NodeMigratorHelperReference[] projectHelpers;
                                            NodeMigrator projectMigrator;
                                            HashStructure projectHash = (HashStructure)projectIO.load(projectURL);
                                            TechnologyScope childTs = this.getTechScope(projectHash);
                                            if (HashStructureNodeMigrator.isSkipMigration(projectHash)) continue;
                                            ProjectVersion projectVersion = new ProjectVersion(projectHash);
                                            if (projectVersion.getCurrentVersion() == null && !URLFileSystem.exists((URL)projectURL)) {
                                                missingProjects.add(URLFileSystem.getPlatformPathName((URL)projectURL));
                                                continue;
                                            }
                                            if (atLeastOneProjectNeedsMigration || (projectMigrator = NodeMigrator.getNodeMigrator(Project.class.getName())) == null || (projectHelpers = projectMigrator.getHelperReferences()).length <= 0) continue;
                                            boolean useMissingMigratorsInChild = this.useMissingMigrators(projectVersion, Arrays.asList(projectHelpers));
                                            for (int i = 0; i < projectHelpers.length; ++i) {
                                                int compare;
                                                NodeMigratorHelperReference projectHelper = projectHelpers[i];
                                                VersionNumber migratorVersion = new VersionNumber(projectHelper.version());
                                                String migratorKey = projectHelper.key();
                                                VersionNumber versionInProject = migratorKey != null ? projectVersion.getCurrentVersion(migratorKey) : projectVersion.getCurrentVersion();
                                                if (!useMissingMigratorsInChild && versionInProject == null && !HashStructureNodeMigrator.isForced(migratorKey) || !this.isInScope(projectHelper, childTs) || (compare = migratorVersion.compareTo(versionInProject)) <= 0 || "oracle.ide.model.Project".equals(migratorKey)) continue;
                                                atLeastOneProjectNeedsMigration = true;
                                            }
                                        }
                                        catch (Exception e) {
                                            String msg = IdeArb.format(510, URLFileSystem.getPlatformPathName((URL)projectURL), this.getErrorMessage(e, e));
                                            this.addError(new MigrationInfo.ErrorInformation(msg));
                                            return;
                                        }
                                    }
                                }
                                if (atLeastOneProjectNeedsMigration) {
                                    this.setMigrationStatus(MIGRATION_PENDING);
                                    this.setVersionStatusDirectly(VERSION_OLDER);
                                    this.setVersionDirectly("10.1.3");
                                    if (!missingProjects.isEmpty()) {
                                        this.addError(new MigrationInfo.ErrorInformation(IdeArb.format(missingProjects.size() == 1 ? 505 : 506, node.getShortLabel(), ListUtil.join(missingProjects, (String)"\n")), MigrationInfo.ErrorInformation.ActionType.PROMPT));
                                    }
                                } else if (!missingProjects.isEmpty()) {
                                    this.setVersionStatusDirectly(VERSION_CURRENT);
                                    this.setMigrationStatus(MIGRATION_PENDING);
                                    this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                                    this.addError(new MigrationInfo.ErrorInformation(IdeArb.format(missingProjects.size() == 1 ? 505 : 506, node.getShortLabel(), ListUtil.join(missingProjects, (String)"\n")), MigrationInfo.ErrorInformation.ActionType.PROMPT));
                                } else {
                                    this.setVersionStatusDirectly(VERSION_CURRENT);
                                    this.setMigrationStatus(MIGRATION_NOT_NEEDED);
                                    this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                                }
                            } else {
                                this.setVersionStatusDirectly(VERSION_CURRENT);
                                this.setMigrationStatus(MIGRATION_NOT_NEEDED);
                                this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                            }
                            break block31;
                        }
                        this.setMigrationStatus(MIGRATION_PENDING);
                        this.setVersionStatusDirectly(VERSION_OLDER);
                        this.setVersionDirectly(uriVersion);
                        break block31;
                    }
                    this.setMigrationStatus(MIGRATION_PENDING);
                    this.setVersionStatusDirectly(VERSION_OLDER);
                    this.setVersionDirectly("900");
                }
                catch (FileNotFoundException e) {
                    this.setVersionStatusDirectly(VERSION_CURRENT);
                    this.setMigrationStatus(MIGRATION_NOT_NEEDED);
                    this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private boolean useMissingMigrators(ProjectVersion projectVersion, Collection<NodeMigratorHelperReference> helpers) {
            VersionNumber phv = projectVersion.getCurrentVersion(ProjectMigrator.MIGRATOR_NAME);
            if (phv == null) {
                return true;
            }
            VersionNumber ihv = null;
            for (NodeMigratorHelperReference nhmr : helpers) {
                if (!ProjectMigrator.MIGRATOR_NAME.equals(nhmr.key())) continue;
                ihv = new VersionNumber(nhmr.version());
                break;
            }
            if (ihv == null) {
                return true;
            }
            int compare = ihv.compareTo(phv);
            if (compare > 0) {
                return true;
            }
            if (compare == 0) {
                return false;
            }
            return false;
        }

        private VersionNumber isWorkspaceOrProjectAlreadyMigrated(Node node, ProjectVersion projectVersion) {
            if (!(node instanceof Workspace) && !(node instanceof Project)) {
                return null;
            }
            VersionNumber phv = projectVersion.getCurrentVersion(ProjectMigrator.MIGRATOR_NAME);
            if (phv == null) {
                return null;
            }
            VersionNumber ihv = null;
            for (NodeMigratorHelperReference ref : this.helperReferences) {
                NodeMigratorHelper nhm = ref.migrator();
                if (!ProjectMigrator.MIGRATOR_NAME.equals(nhm.getNodeMigratorHelperKey())) continue;
                ihv = new VersionNumber(nhm.getNodeMigratorHelperVersion());
                break;
            }
            if (ihv == null) {
                return null;
            }
            int compare = ihv.compareTo(phv);
            if (compare < 0) {
                return phv;
            }
            return null;
        }

        private TechnologyScope getTechScope(final HashStructure hs) {
            TechnologyScope ts = TechnologyScopeConfiguration.getInstance(new PropertyStorage(){

                public HashStructure getProperties() {
                    return hs;
                }
            }).getTechnologyScope();
            return ts;
        }

        private boolean isInScope(NodeMigratorHelperReference hr, TechnologyScope nodeTs) {
            TechnologyScope hrTs = hr.getTechnologyScope();
            if (hrTs.isEmpty()) {
                return true;
            }
            for (TechId tis : hrTs.toArray()) {
                if (!nodeTs.contains(tis)) continue;
                return true;
            }
            return false;
        }

        Collection<NodeMigratorHelper> getActiveHelpers() {
            TreeSet<NodeMigratorHelper> helpers = new TreeSet<NodeMigratorHelper>();
            for (NodeMigratorHelperReference ref : this.helperReferences) {
                helpers.add(ref.migrator());
            }
            return helpers;
        }

        Collection<NodeMigratorHelperReference> getActiveHelperReferences() {
            return this.helperReferences;
        }

        private String getErrorMessage(Exception orig, Throwable e) {
            String msg = e.getMessage();
            if (msg == null || msg.trim().length() == 0) {
                if (e.getCause() != null) {
                    return this.getErrorMessage(orig, e.getCause());
                }
                orig.printStackTrace();
                return e.toString() + "\nSee console log";
            }
            return msg;
        }

        @Override
        @Deprecated
        public NodeMigratorHelper[] getHelpers() {
            ArrayList<NodeMigratorHelper> helpers = new ArrayList<NodeMigratorHelper>();
            for (NodeMigratorHelperReference ref : this.helperReferences) {
                helpers.add(ref.migrator());
            }
            return helpers.toArray(new NodeMigratorHelper[helpers.size()]);
        }

        @Override
        public NodeMigratorHelperReference[] getHelperReferences() {
            return this.helperReferences.toArray(new NodeMigratorHelperReference[this.helperReferences.size()]);
        }

        private void removeHelpersInDeprecatedList(List<NodeMigratorHelperReference> removed) {
        }

        private boolean isTechnologyPresent(TechnologyScope nodeScope, TechnologyScope migratorScope) {
            if (nodeScope == null || nodeScope.isEmpty() || migratorScope == null || migratorScope.isEmpty()) {
                return false;
            }
            List<String> nodeScopeList = Arrays.asList(nodeScope.getTechnologyKeys());
            for (String keyTechnology : migratorScope.getTechnologyKeys()) {
                if (!nodeScopeList.contains(keyTechnology)) continue;
                return true;
            }
            return false;
        }
    }
}

