/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class ResourcePaths
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.ide.model.ResourcePaths";
    public static final String RESOURCES_CONTENT_SET_LOCAL_KEY = "resourcesContentSet";
    public static final String RESOURCES_CONTENT_SET_KEY = "oracle.ide.model.ResourcePaths/resourcesContentSet";
    private static final PatternFilter[] INCLUDE_ALL_FILTER = new PatternFilter[]{PatternFilter.newInclude("**")};
    public static final String PROJECT_RESOURCES_PATH = "resourcesContentSet/url-path";

    private ResourcePaths(HashStructure hash) {
        super(hash);
    }

    public static ResourcePaths getInstance(PropertyStorage storage) {
        HashStructure properties = storage.getProperties();
        return new ResourcePaths(properties.getOrCreateHashStructure(DATA_KEY));
    }

    public ContentSet getResourcesContentSet() {
        return new ContentSet(this._hash.getOrCreateHashStructure(RESOURCES_CONTENT_SET_LOCAL_KEY));
    }

    public URLPath getProjectResourcesPath() {
        return this.getResourcesContentSet().getAllRootDirs();
    }

    public boolean setProjectResourcesPath(URLPath newPath) {
        boolean modified = false;
        URLPath urlPath = new URLPath(newPath);
        URLPath existingPath = this.getProjectResourcesPath();
        for (URL entry : existingPath) {
            if (urlPath.contains(entry)) continue;
            this.removeFromContentSet(entry);
            modified = true;
        }
        if (urlPath.size() > 0) {
            urlPath.remove(this.getProjectResourcesPath());
        }
        ContentSet resourcesContentSet = this.getResourcesContentSet();
        if (urlPath.size() > 0) {
            for (URL url : urlPath) {
                ContentSet newContentSet = new ContentSet(HashStructure.newInstance());
                newContentSet.getURLPath().setEntries(new URL[]{url});
                newContentSet.getPatternFilters().setFilters(INCLUDE_ALL_FILTER);
                resourcesContentSet.addContentSet(newContentSet);
            }
            ContentSetHelper.postProcess(resourcesContentSet);
            modified = true;
        }
        return modified;
    }

    private void removeFromContentSet(URL url) {
        if (this.getProjectResourcesPath().contains(url)) {
            this.getResourcesContentSet().getURLPath().remove(url);
            if (this.getProjectResourcesPath().contains(url)) {
                ContentSet resourcesContentSet = this.getResourcesContentSet();
                for (int i = resourcesContentSet.countContentSets() - 1; i >= 0; --i) {
                    ContentSet contentSet = resourcesContentSet.getContentSet(i);
                    if (!this.removeURL(contentSet, url) || contentSet.getURLPath().size() != 0) continue;
                    resourcesContentSet.removeContentSet(i);
                    break;
                }
            }
        }
    }

    private boolean removeURL(ContentSet set, URL url) {
        URLPath urlPath = set.getURLPath();
        if (urlPath.contains(url)) {
            urlPath.remove(url);
            return true;
        }
        return false;
    }
}

