/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public final class WorkingSet
extends HashStructureAdapter {
    private final String _workingSetName;
    private final PatternFilters _patternFilters;
    @Deprecated
    private static final String EXCLUDE_PROJECT_URLS_KEY = "exclude-project-urls";
    private static final String INCLUDED_PROJECTS_KEY = "include-project-urls";
    private static final String PROJECT_WORKING_SETS_KEY = "project-working-sets";

    WorkingSet(HashStructure hash, String workingSetName) {
        super(hash);
        this._workingSetName = workingSetName;
        this._patternFilters = PatternFilters.getInstance(hash);
    }

    static WorkingSet getInstance(final HashStructure workingSetsHash, final String workingSetName) {
        final WorkingSet[] workingSetVar = new WorkingSet[1];
        workingSetsHash.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                boolean isNew = !workingSetsHash.containsKey(workingSetName);
                HashStructure workingSetHash = workingSetsHash.getOrCreateHashStructure(workingSetName);
                WorkingSet workingSet = new WorkingSet(workingSetHash, workingSetName);
                if (isNew) {
                    PatternFilters filters = workingSet.getPatternFilters();
                    filters.addInclude("**");
                }
                workingSetVar[0] = workingSet;
            }
        });
        return workingSetVar[0];
    }

    @Deprecated
    public ListStructure getExcludedProjectList() {
        return null;
    }

    private ListStructure getIncludedProjectsList() {
        return this._hash.getListStructure(INCLUDED_PROJECTS_KEY);
    }

    public boolean isExcluded(Project project) {
        return !this.isIncluded(project);
    }

    public boolean isIncluded(Project project) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        ListStructure projects = this.getIncludedProjectsList();
        return projects == null || projects.contains((Object)project.getURL());
    }

    public boolean includeProject(Project project) {
        if (!this.isIncluded(project)) {
            ListStructure projectURLs = this._hash.getListStructure(INCLUDED_PROJECTS_KEY);
            return projectURLs.add((Object)project.getURL());
        }
        return false;
    }

    public PatternFilters includeChildren(Project project, List<URL> children, boolean addChildrenExclusively) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        PatternFilters pfs = this.getPatternFilters(project);
        if (pfs == null) {
            if (addChildrenExclusively) {
                pfs = this.getOrCreatePatternFilters(project);
                pfs.setFilters(new PatternFilter[0]);
            } else {
                return pfs;
            }
        }
        if (children == null || children.isEmpty()) {
            pfs.setFilters(new PatternFilter[0]);
        } else {
            ProjectContent content = ProjectContent.getInstance(project);
            Iterator iterator = content.getContentSetList().iterator();
            while (iterator.hasNext()) {
                ContentSet cs = content.getContentSet(iterator.next().toString());
                if (cs == null) continue;
                List urls = cs.getAllRootDirs().asList();
                for (URL path : urls) {
                    URLPath nextPath = new URLPath(path);
                    for (URL url : children) {
                        String relPath = nextPath.toRelativePath(url);
                        if (relPath == null || relPath.isEmpty()) continue;
                        pfs.addInclude(relPath);
                    }
                }
            }
        }
        return pfs;
    }

    public PatternFilters excludeChildren(Project project, List<URL> children) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        Assert.precondition((boolean)this.isEditable(), (String)"Cannot modify the 'All Files' working set");
        PatternFilters pfs = this.getOrCreatePatternFilters(project);
        if (children == null || children.isEmpty()) {
            pfs.setFilters(new PatternFilter[0]);
        } else {
            ProjectContent content = ProjectContent.getInstance(project);
            Iterator iterator = content.getContentSetList().iterator();
            while (iterator.hasNext()) {
                ContentSet cs = content.getContentSet(iterator.next().toString());
                if (cs == null) continue;
                List urls = cs.getAllRootDirs().asList();
                for (URL path : urls) {
                    URLPath nextPath = new URLPath(path);
                    for (URL url : children) {
                        String relPath = nextPath.toRelativePath(url);
                        if (relPath == null || relPath.isEmpty()) continue;
                        pfs.addExclude(relPath);
                    }
                }
            }
        }
        return pfs;
    }

    @Deprecated
    public boolean excludeProject(Project project) {
        return false;
    }

    public boolean excludeProject(Project project, Set<URL> workspaceChildren) {
        if (this.isIncluded(project)) {
            ListStructure included = this.getIncludedProjectsList();
            if (included != null) {
                return included.remove((Object)project.getURL());
            }
            workspaceChildren.remove(project.getURL());
            return this._hash.getOrCreateListStructure(INCLUDED_PROJECTS_KEY).addAll(workspaceChildren);
        }
        return false;
    }

    public void excludeAllProjects() {
        this._hash.putListStructure(INCLUDED_PROJECTS_KEY, ListStructure.newInstance());
    }

    public void includeAllProjects() {
        this._hash.remove(INCLUDED_PROJECTS_KEY);
    }

    public void includeOnly(List<Project> projects) {
        ListStructure list = ListStructure.newInstance();
        this._hash.putListStructure(INCLUDED_PROJECTS_KEY, list);
        for (Project project : projects) {
            this.includeProject(project);
        }
    }

    @Deprecated
    public static PatternFilters getCurrentWorkingSetFilters(Project project) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        if (activeWorkspace != null) {
            WorkingSets workingSets = WorkingSets.getInstance(activeWorkspace);
            return workingSets.getCurrentWorkingSet().getPatternFilters(project);
        }
        return PatternFilters.getInstance(HashStructure.newInstance());
    }

    public PatternFilters getPatternFilters() {
        return this._patternFilters;
    }

    public PatternFilters getPatternFilters(Project project) {
        String key;
        WorkingSets projectWorkingSets;
        List namedProjectLevelWorkingSets;
        HashStructure hash;
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        if (this._hash.containsKey(PROJECT_WORKING_SETS_KEY) && (hash = this._hash.getHashStructure(PROJECT_WORKING_SETS_KEY)) != null && (namedProjectLevelWorkingSets = (projectWorkingSets = WorkingSets.projectWorkingSets(hash)).getWorkingSetNames()).contains(key = this.key(project.getURL()))) {
            return projectWorkingSets.getWorkingSet(key).getPatternFilters();
        }
        return null;
    }

    public PatternFilters getOrCreatePatternFilters(Project project) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        if (WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(this.getName())) {
            return PatternFilters.getInstance(HashStructure.newInstance());
        }
        WorkingSet ws = this.getWorkingSet(project);
        return ws.getPatternFilters();
    }

    public String getName() {
        return this._workingSetName;
    }

    public String toString() {
        return "WorkingSet \"" + this._workingSetName + "\"";
    }

    public final boolean isEditable() {
        return !WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(this.getName());
    }

    static boolean validateName(String workingSetName) {
        return workingSetName != null && !workingSetName.trim().isEmpty() && !WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(workingSetName) && workingSetName.indexOf(47) == -1;
    }

    boolean preMigrateFromExcludeList() {
        ListStructure excluded;
        return this._hash.containsKey(EXCLUDE_PROJECT_URLS_KEY) && (excluded = this._hash.getListStructure(EXCLUDE_PROJECT_URLS_KEY)) != null && !excluded.isEmpty();
    }

    boolean hasProjectLevelFilters() {
        HashStructure hash;
        return this._hash.containsKey(PROJECT_WORKING_SETS_KEY) && (hash = this._hash.getHashStructure(PROJECT_WORKING_SETS_KEY)) != null;
    }

    void migrateFromExcludeListToIncludeList(Set<URL> projectURLs) {
        ListStructure excluded;
        if (!projectURLs.isEmpty() && (excluded = this._hash.getListStructure(EXCLUDE_PROJECT_URLS_KEY)) != null && !excluded.isEmpty()) {
            ListStructure included = this._hash.getOrCreateListStructure(INCLUDED_PROJECTS_KEY);
            included.addAll(projectURLs);
            included.removeAll((Collection)excluded);
        }
        this._hash.remove(EXCLUDE_PROJECT_URLS_KEY);
    }

    private WorkingSet getWorkingSet(Project project) {
        WorkingSets projectWorkingSets = this.getProjectWorkingSets();
        String key = this.key(project.getURL());
        return projectWorkingSets.getWorkingSet(key);
    }

    private WorkingSets getProjectWorkingSets() {
        HashStructure hash = this._hash.getOrCreateHashStructure(PROJECT_WORKING_SETS_KEY);
        WorkingSets projectWorkingSets = WorkingSets.projectWorkingSets(hash);
        return projectWorkingSets;
    }

    private String key(URL url) {
        String key = url.toString();
        return key.replaceAll("/", "_");
    }
}

