/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessagePanel;

public class ActionDescriptionPanel
extends JPanel {
    private final JPanel m_additionalContent;
    private JComponent m_additionalContent_top;
    private JComponent m_additionalContent_bottom;
    private final MessagePanel m_messagePanel;
    private final ButtonGroup m_optionsButtonGroup;
    private int m_selectedOptionIndex = -1;
    private String m_selectedOptionText = null;
    private ActionListener m_selectionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionDescriptionPanel.this.setNewSelectionAndFireSelectionEvent(Integer.parseInt(e.getActionCommand()), ((JRadioButton)e.getSource()).getText());
        }
    };
    private static final GridBagConstraints TOP_CONSTRAINTS = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
    private static final GridBagConstraints ADDITIONAL_CONTENT_TOP_CONSTRAINTS = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
    private static final GridBagConstraints ADDITIONAL_CONTENT_BOTTOM_CONSTRAINTS = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
    private static final GridBagConstraints OPTIONS_CONSTRAINTS = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
    private CopyOnWriteArrayList<OptionSelectionChangedListener> m_selectionListeners = new CopyOnWriteArrayList();

    private void setNewSelectionAndFireSelectionEvent(int selectdIndex, String selectedText) {
        this.m_selectedOptionIndex = selectdIndex;
        this.m_selectedOptionText = selectedText;
        this.fireOptionSelectionChanged(this.m_selectedOptionIndex, this.m_selectedOptionText);
    }

    public static ActionDescriptionPanel build(String headerMessage, String descriptionMessage, String ... optionsMessages) {
        return ActionDescriptionPanel.build((JComponent)null, (JComponent)null, 4, headerMessage, descriptionMessage, optionsMessages);
    }

    public static ActionDescriptionPanel build(int messageType, String headerMessage, String descriptionMessage, String ... optionsMessages) {
        return ActionDescriptionPanel.build((JComponent)null, (JComponent)null, messageType, headerMessage, descriptionMessage, optionsMessages);
    }

    public static ActionDescriptionPanel build(JComponent additionalTopContent, JComponent additionalBottomContent, String headerMessage, String descriptionMessage, String ... optionsMessages) {
        return ActionDescriptionPanel.build(additionalTopContent, additionalBottomContent, 4, headerMessage, descriptionMessage, optionsMessages);
    }

    public static ActionDescriptionPanel build(JComponent additionalTopContent, JComponent additionalBottomContent, int messageType, String headerMessage, String descriptionMessage, String ... optionsMessages) {
        ActionDescriptionPanel panel = new ActionDescriptionPanel(headerMessage, descriptionMessage, optionsMessages);
        panel.setAdditionalTopContent(additionalTopContent);
        panel.setAdditionalBottomContent(additionalBottomContent);
        panel.setMessageType(messageType);
        return panel;
    }

    private ActionDescriptionPanel(String headerMessage, String descriptionMessage, String ... optionsMessages) {
        if (optionsMessages.length == 1) {
            throw new IllegalArgumentException("Options count should be 0, 2, or more. Not 1");
        }
        this.setLayout(new GridBagLayout());
        this.m_messagePanel = new MessagePanel();
        this.m_messagePanel.setTitle(headerMessage);
        JTextArea pane = new JTextArea();
        pane.setText(StringUtils.stripMnemonic((String)descriptionMessage));
        pane.setEditable(false);
        pane.setLineWrap(true);
        pane.setWrapStyleWord(true);
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.setBackground(this.m_messagePanel.getBackground());
        pane.setForeground(this.m_messagePanel.getForeground());
        this.m_messagePanel.setMessage((Object)pane);
        this.m_optionsButtonGroup = new ButtonGroup();
        JPanel buttonContainer = new JPanel();
        buttonContainer.setLayout(new GridBagLayout());
        for (int i = 0; i < optionsMessages.length; ++i) {
            String optionMessage = optionsMessages[i];
            JRadioButton nextOption = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)nextOption, (String)optionMessage);
            this.m_optionsButtonGroup.add(nextOption);
            buttonContainer.add((Component)nextOption, new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 0, 0, 0), 0, 0));
            nextOption.setName(nextOption.getText());
            nextOption.setActionCommand(String.valueOf(i));
            nextOption.addActionListener(this.m_selectionListener);
        }
        this.m_additionalContent = new JPanel(new GridBagLayout());
        this.m_additionalContent.add((Component)buttonContainer, OPTIONS_CONSTRAINTS);
        this.m_messagePanel.addMessageComponent((Component)this.m_additionalContent);
        this.add((Component)this.m_messagePanel, TOP_CONSTRAINTS);
    }

    public void setAdditionalTopContent(JComponent content) {
        if (content != null) {
            if (this.m_additionalContent_top != null) {
                this.m_additionalContent.remove(this.m_additionalContent_top);
            }
            this.m_additionalContent_top = content;
            this.m_additionalContent.add((Component)this.m_additionalContent_top, ADDITIONAL_CONTENT_TOP_CONSTRAINTS);
        }
    }

    public void setAdditionalBottomContent(JComponent content) {
        if (content != null) {
            if (this.m_additionalContent_bottom != null) {
                this.m_additionalContent.remove(this.m_additionalContent_bottom);
            }
            this.m_additionalContent_bottom = content;
            this.m_additionalContent.add((Component)this.m_additionalContent_bottom, ADDITIONAL_CONTENT_BOTTOM_CONSTRAINTS);
        }
    }

    public JComponent getAdditionalTopContent() {
        return this.m_additionalContent_top;
    }

    public JComponent getAdditionalBottomContent() {
        return this.m_additionalContent_bottom;
    }

    private void setMessageType(int type) {
        this.m_messagePanel.setMessageType(type);
    }

    public String getSelectedOptionText() {
        return this.m_selectedOptionText;
    }

    public int getSelectedOptionIndex() {
        return this.m_selectedOptionIndex;
    }

    public void setSelectedOption(int index) {
        if (index >= 0 && index < this.m_optionsButtonGroup.getButtonCount()) {
            Enumeration<AbstractButton> allButtons = this.m_optionsButtonGroup.getElements();
            int i = 0;
            do {
                AbstractButton nextButton = allButtons.nextElement();
                if (i == index) {
                    nextButton.setSelected(true);
                    this.setNewSelectionAndFireSelectionEvent(Integer.parseInt(nextButton.getActionCommand()), nextButton.getText());
                    return;
                }
                ++i;
            } while (allButtons.hasMoreElements());
        } else {
            throw new IndexOutOfBoundsException("Selected index should be between 0 and " + this.m_optionsButtonGroup.getButtonCount() + ". Found " + index);
        }
    }

    public void clearSelectedOption() {
        this.m_optionsButtonGroup.clearSelection();
        this.setNewSelectionAndFireSelectionEvent(-1, null);
    }

    public int getOptionsCount() {
        return this.m_optionsButtonGroup.getButtonCount();
    }

    public boolean addSelectionChangedListener(OptionSelectionChangedListener optionSelectionChangedListener) {
        return this.m_selectionListeners.addIfAbsent(optionSelectionChangedListener);
    }

    public boolean removeSelectionChangedListener(OptionSelectionChangedListener optionSelectionChangedListener) {
        return this.m_selectionListeners.remove(optionSelectionChangedListener);
    }

    private void fireOptionSelectionChanged(int selectedIndex, String selectedText) {
        OptionSelectionChangedEvent optionSelectionEvent = new OptionSelectionChangedEvent(selectedIndex, selectedText);
        for (OptionSelectionChangedListener listener : this.m_selectionListeners) {
            listener.selectionChanged(optionSelectionEvent);
        }
    }

    public static class OptionSelectionChangedEvent {
        private final int m_selectedIndex;
        private final String m_selectedText;

        private OptionSelectionChangedEvent(int index, String text) {
            this.m_selectedIndex = index;
            this.m_selectedText = text;
        }

        public int getSelectedIndex() {
            return this.m_selectedIndex;
        }

        public String getSelectedText() {
            return this.m_selectedText;
        }
    }

    public static abstract class OptionSelectionChangedListener
    implements EventListener {
        public abstract void selectionChanged(OptionSelectionChangedEvent var1);
    }
}

