/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class InflaterInputStreamPatch
extends FilterInputStream {
    int initAvail;
    int avail;

    public InflaterInputStreamPatch(InputStream is, ZipEntry ze) {
        super(is);
        this.initAvail = this.avail = (int)ze.getSize();
    }

    @Override
    public int available() throws IOException {
        return this.avail;
    }

    @Override
    public int read() throws IOException {
        int red = super.read();
        if (red >= 0) {
            --this.avail;
        }
        return red;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int totalRed = super.read(b, off, len);
        this.avail -= totalRed;
        return totalRed;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.avail = (int)((long)this.avail - skipped);
        return skipped;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.avail = this.initAvail;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

