/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.GraphicsUtils;

public final class MenuSpec {
    public final String label;
    public final Integer mnemonic;
    private Icon icon;
    private ResourceBundle bundle;
    private int key = -1;
    private String strKey;

    public MenuSpec(String label, Icon icon) {
        this.label = StringUtils.stripMnemonic((String)label);
        this.mnemonic = StringUtils.getMnemonicIndex((String)label);
        this.icon = icon;
    }

    public MenuSpec(String label, Integer mnemonic, Icon icon) {
        this.label = label;
        this.mnemonic = mnemonic;
        this.icon = icon;
    }

    public MenuSpec(String label, Integer mnemonic, ArrayResourceBundle bundle, int key) {
        this.label = label;
        this.mnemonic = mnemonic;
        this.bundle = key >= 0 ? bundle : null;
        this.key = key;
    }

    public MenuSpec(String label, Integer mnemonic, ResourceBundle bundle, String key) {
        this.label = label;
        this.mnemonic = mnemonic;
        this.bundle = key != null ? bundle : null;
        this.strKey = key;
    }

    public Icon getIcon() {
        if (this.icon == null && this.bundle != null) {
            if (this.key >= 0) {
                try {
                    this.icon = ((ArrayResourceBundle)this.bundle).getIconImpl(this.key);
                }
                catch (Exception e) {
                    this.icon = null;
                }
            } else if (this.strKey != null) {
                try {
                    ImageIcon imageIcon;
                    Image image;
                    URL url = this.bundle.getClass().getResource(this.strKey);
                    if (url != null && (image = Toolkit.getDefaultToolkit().createImage(url)) != null && (imageIcon = GraphicsUtils.createImageIcon((Image)image)).getImageLoadStatus() == 8) {
                        this.icon = imageIcon;
                    }
                }
                catch (Exception e) {
                    this.icon = null;
                }
            }
            this.resetBundle();
        }
        return this.icon;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public Object getBundleKey() {
        if (this.key >= 0) {
            return this.key;
        }
        return this.strKey;
    }

    private void resetBundle() {
        this.bundle = null;
        this.key = -1;
        this.strKey = null;
    }
}

