/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;
import oracle.ideimpl.editor.DynamicEditorHookRegistration;

public class DeclarativeDynamicEditorAddin
extends EditorAddin {
    private final MetaClass<Editor> _editorClass;
    private final MenuSpec _menuSpec;
    private final boolean _isDefault;
    private final boolean _isDuplicable;
    private final boolean _isRestoreAtStartup;
    private final boolean _isMultifile;
    private final float _weight;
    private final boolean _isCloneable;
    private static final Logger LOG = Logger.getLogger(DeclarativeDynamicEditorAddin.class.getName());

    DeclarativeDynamicEditorAddin(DynamicEditorHookRegistration reg) {
        this._menuSpec = new MenuSpec(reg.getLabel(), null);
        this._editorClass = reg.getEditorClass();
        this._isDefault = reg.isDefault();
        this._isDuplicable = reg.isDuplicable();
        this._isRestoreAtStartup = reg.isRestoreAtStartup();
        this._isMultifile = reg.isMultifile();
        this._weight = reg.getWeight();
        this._isCloneable = reg.isCloneable();
    }

    public MetaClass getEditorMetaClass() {
        return this._editorClass;
    }

    @Override
    public Class getEditorClass() {
        try {
            return this._editorClass.toClass();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load editor class: " + this._editorClass.getClassName(), e);
            return null;
        }
    }

    @Override
    public MenuSpec getMenuSpecification() {
        return this._menuSpec;
    }

    @Override
    public boolean isDefault() {
        return this._isDefault;
    }

    @Override
    public boolean isDuplicable() {
        return this._isDuplicable;
    }

    @Override
    public boolean restoreAtStartup() {
        return this._isRestoreAtStartup;
    }

    @Override
    public boolean isMultifile() {
        return this._isMultifile;
    }

    @Override
    public float getEditorWeight(Element element) {
        return this._weight;
    }

    public float getEditorWeight(Context context) {
        return this._weight;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DeclarativeDynamicEditorAddin)) {
            return false;
        }
        DeclarativeDynamicEditorAddin other = (DeclarativeDynamicEditorAddin)object;
        if (!(this._editorClass != null ? this._editorClass.equals(other._editorClass) : other._editorClass == null)) {
            return false;
        }
        if (this._isDefault != other._isDefault) {
            return false;
        }
        if (this._isDuplicable != other._isDuplicable) {
            return false;
        }
        if (this._isRestoreAtStartup != other._isRestoreAtStartup) {
            return false;
        }
        return this._isCloneable == other._isCloneable;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = super.hashCode();
        result = 37 * result + (this._editorClass == null ? 0 : this._editorClass.hashCode());
        result = 37 * result + (this._isDefault ? 0 : 1);
        result = 37 * result + (this._isDuplicable ? 0 : 1);
        result = 37 * result + (this._isRestoreAtStartup ? 0 : 1);
        return result;
    }

    @Override
    public boolean isCloneable() {
        return this._isCloneable;
    }
}

