/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.javatools.icons.OracleIcons;
import org.openide.util.ImageUtilities;

public final class LazyIconsCacheUtil {
    private static final URL SYS_URL = ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.ide");
    private static final Map<String, BufferedImage> iconCache = new HashMap<String, BufferedImage>();
    private static final Icon DEFAULT_ICON = OracleIcons.getIcon((String)"file.png");

    private LazyIconsCacheUtil() {
    }

    public static void saveIconCache() {
        if (!Ide.isQuitting()) {
            return;
        }
        for (String iconName : iconCache.keySet()) {
            LazyIconsCacheUtil.saveIcon(iconName);
        }
    }

    public static void removeIcon(URL iconUrl) {
        if (iconUrl == null) {
            return;
        }
        String iconName = LazyIconsCacheUtil.updateIconName(iconUrl.getFile());
        if (iconName == null) {
            return;
        }
        iconCache.remove(iconName);
        File iconFile = new File(SYS_URL.getPath(), iconName);
        if (!iconFile.exists()) {
            return;
        }
        try {
            iconFile.delete();
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().warning(e.getMessage());
        }
    }

    public static void addIcon(URL iconUrl, Icon icon, boolean saveItToFile) {
        if (icon == null || iconUrl == null) {
            return;
        }
        String iconName = LazyIconsCacheUtil.updateIconName(iconUrl.getFile());
        if (iconName == null) {
            return;
        }
        if (iconCache.get(iconName) == null) {
            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Image image = ImageUtilities.icon2Image((Icon)icon);
            bufferedImage.getGraphics().drawImage(image, 0, 0, null);
            iconCache.put(iconName, bufferedImage);
            if (saveItToFile) {
                LazyIconsCacheUtil.saveIcon(iconName);
            }
        }
    }

    public static Icon loadIcon(URL fileURL) {
        DocumentInfo di;
        if (fileURL == null) {
            return null;
        }
        Image icon = LazyIconsCacheUtil.loadIconCacheOrFile(fileURL);
        if (icon != null) {
            return ImageUtilities.image2Icon((Image)icon);
        }
        Node node = NodeFactory.find(fileURL);
        if (node != null) {
            return node.getIcon();
        }
        MetaClass<? extends Node> metaClass = Recognizer.recognizeURLAsMeta(fileURL);
        if (metaClass == null) {
            return null;
        }
        String nodeClassName = metaClass.getClassName();
        if (nodeClassName != null && !nodeClassName.contains(UnrecognizedTextNode.class.getName()) && (di = Recognizer.getDocumentInfo(nodeClassName)) != null && di.getIcon() != null) {
            return di.getIcon();
        }
        return DEFAULT_ICON;
    }

    private static String updateIconName(String iconNameDocumentPath) {
        if (iconNameDocumentPath == null || iconNameDocumentPath.length() == 0) {
            return null;
        }
        String iconName = iconNameDocumentPath.replace("/", "").replace(":", "");
        return iconName;
    }

    private static void saveIcon(String iconName) {
        if (iconName == null) {
            return;
        }
        if ((iconName = LazyIconsCacheUtil.updateIconName(iconName)) == null) {
            return;
        }
        File iconFile = new File(SYS_URL.getPath(), iconName);
        if (iconFile.exists()) {
            return;
        }
        BufferedImage imageIcon = iconCache.get(iconName);
        if (imageIcon != null) {
            try {
                ImageIO.write((RenderedImage)imageIcon, "png", iconFile);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().warning(e.getMessage());
            }
        }
    }

    private static Image loadIconCacheOrFile(URL iconUrl) {
        if (iconUrl == null) {
            return null;
        }
        String iconName = LazyIconsCacheUtil.updateIconName(iconUrl.getFile());
        if (iconName == null) {
            return null;
        }
        Image cacheIcon = LazyIconsCacheUtil.getIcon(iconName);
        if (cacheIcon != null) {
            return cacheIcon;
        }
        URL url = ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.ide");
        File iconFile = new File(url.getPath(), iconName);
        if (iconFile == null || !iconFile.exists()) {
            return null;
        }
        try {
            BufferedImage imageIcon = ImageIO.read(iconFile);
            iconCache.put(iconName, imageIcon);
            return imageIcon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Image getIcon(String iconName) {
        if (iconName == null) {
            return null;
        }
        if ((iconName = LazyIconsCacheUtil.updateIconName(iconName)) == null) {
            return null;
        }
        return iconCache.get(iconName);
    }
}

