/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import javax.ide.extension.spi.LocationAdapter;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.ExtensionRegistry;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.ide.extension.feature.FeatureType;
import oracle.ide.extension.feature.TechnologyFeatureType;
import oracle.ide.extension.preference.ManageFeaturesPanelListener;
import oracle.ide.extension.preference.ManageFeaturesPanelType;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.TriStateBoolean;
import oracle.ideimpl.extension.DisabledReason;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideimpl.extension.preference.FeatureFilter;
import oracle.ideimpl.extension.preference.FeaturesChangedMessageDialog;
import oracle.ideimpl.resource.ManageFeaturesArb;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.util.ModelUtil;

final class ManageFeaturesTreePanel
extends JPanel
implements ManageFeaturesPanelType {
    private static final Logger LOG = Logger.getLogger(ManageFeaturesTreePanel.class.getName());
    private static final Icon CATEGORY_ICON = OracleIcons.getIcon((String)"folder.png");
    private static final Icon FEATURE_ICON = OracleIcons.getIcon((String)"feature.png");
    private final CustomJTree _tree = new CustomJTree();
    private final JMutableTreeNode _root = new JMutableTreeNode("root");
    private final DefaultTreeModel _treeModel = new DefaultTreeModel((TreeNode)this._root);
    private final JEditorPane _description = new JEditorPane();
    private final SearchField _searchField = new SearchField();
    private final JButton _clearCacheButton = new JButton();
    private boolean _cacheReset;
    private transient TreeExpansionListener _nodeExpansionListener;
    private transient TreeSelectionListener _nodeSelectionListener;
    private transient NodeCheckListener _nodeCheckListener;
    private transient FeatureSearchListener _searchListener;
    private final boolean _readOnly;
    private Set _disabledIds;
    private transient FeatureFilter _filter;
    private TreeState _treeState = TreeState.COLLAPSED;
    private HyperlinkButton _collapseTreeButton;
    private HyperlinkButton _expandTreeButton;
    private Action _completionAction;
    private ManageFeaturesPanelListener _panelChangeListener;

    ManageFeaturesTreePanel() {
        this(false);
    }

    ManageFeaturesTreePanel(boolean readOnly) {
        this._readOnly = readOnly;
        try {
            this.initGui();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        HelpUtils.setHelpID((JComponent)this, (String)"f1_idedidesetextensionmanager_html");
    }

    private void initGui() {
        this._clearCacheButton.setAction(this.getClearCacheAction());
        this.configureSearchField();
        this.configureFeaturesTree();
        this.configureDescriptionPane();
        JPanel searchPanel = this.createSearchPanel();
        this._tree.setEditable(false);
        JScrollPane scrollpane = new JScrollPane((Component)this._tree);
        scrollpane.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        JPanel treePanel = new JPanel(new BorderLayout(0, 5));
        treePanel.add((Component)searchPanel, "North");
        treePanel.add((Component)scrollpane, "Center");
        JSplitPane splitPanel = new JSplitPane(1);
        splitPanel.setBorder(null);
        splitPanel.setLeftComponent(treePanel);
        splitPanel.setRightComponent(this._description);
        splitPanel.setResizeWeight(0.5);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 10);
        buttonPanel.add((Component)this.expandTreeButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        buttonPanel.add((Component)this.collapseTreeButton(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)splitPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private JPanel createSearchPanel() {
        JPanel searchPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.ipadx = 5;
        gbc.ipady = 5;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 0, 2, 0);
        searchPanel.add((Component)this._searchField, gbc);
        this._searchField.setMaximumSize(new Dimension(400, 20));
        this._searchField.setPreferredSize(new Dimension(200, this._searchField.getPreferredSize().height - 3));
        this._searchField.setMinimumSize(new Dimension(160, this._searchField.getPreferredSize().height - 3));
        gbc.weightx = 0.4;
        gbc.gridx = 1;
        gbc.anchor = 22;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        searchPanel.add((Component)this._clearCacheButton, gbc);
        return searchPanel;
    }

    private AbstractAction getClearCacheAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFeaturesTreePanel.this.resetCache();
            }
        };
        String label = ManageFeaturesArb.getString(8);
        action.putValue("Name", StringUtils.stripMnemonic((String)label));
        action.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)label));
        return action;
    }

    private void resetCache() {
        ExtensionPreferences extensionPreferences = ExtensionPreferences.getInstance();
        extensionPreferences.resetFeatureLoadingCache();
        this._cacheReset = true;
        this._clearCacheButton.setEnabled(false);
    }

    Set getDisabledIds() {
        return Collections.unmodifiableSet(this._disabledIds);
    }

    void setDisabledIds(Set set) {
        this._disabledIds = set;
    }

    void setFilter(FeatureFilter filter) {
        this._filter = filter;
    }

    private void populate(FeatureFilter filter) {
        this._filter = filter != null ? filter : new FeatureFilter(){

            @Override
            public boolean accept(Feature feature) {
                if (!feature.isEnabled() && DisabledReason.ROLE_DISABLED.equals((Object)feature.getDisabledReason())) {
                    return false;
                }
                FeatureType featureType = feature.getType();
                return featureType.canUserDisable() || "technology".equals(featureType.getTypeId());
            }
        };
        Collection<Feature> items = this.getVisibleFeatures();
        this.populateTreeModel(items);
    }

    private void populateTreeModel(Collection<Feature> visibleFeatures) {
        JMutableTreeNode root = (JMutableTreeNode)this._treeModel.getRoot();
        for (Feature f : visibleFeatures) {
            this.addFeatureNode(f);
        }
        root.sortChildren();
        root.updateNodes();
        this._treeModel.reload((TreeNode)root);
        if (root.getChildCount() > 0) {
            TreePath path = new TreePath(root).pathByAddingChild(root.getChildAt(0));
            this._tree.setSelectionPath(path);
        }
    }

    private void addFeatureNode(Feature feature) {
        JMutableTreeNode root = (JMutableTreeNode)this._treeModel.getRoot();
        List<FeatureCategory> categoryList = feature.getCategory();
        JMutableTreeNode node = root;
        if (!categoryList.isEmpty()) {
            for (int i = 0; i < categoryList.size(); ++i) {
                FeatureCategory category = categoryList.get(i);
                JMutableTreeNode found = this.searchNode(node, category);
                if (found == null) {
                    List<FeatureCategory> remainingCategories = categoryList.subList(i, categoryList.size());
                    this.addFeatureNode(node, feature, remainingCategories);
                    return;
                }
                node = found;
            }
        }
        this.addFeatureNode(node, feature, !feature.getType().canUserDisable());
    }

    private void addFeatureNode(JMutableTreeNode parent, Feature feature, List<FeatureCategory> categoryList) {
        JMutableTreeNode node = parent;
        for (FeatureCategory category : categoryList) {
            SortedFeatureNode categoryNode = new SortedFeatureNode(category);
            categoryNode.setCheckBoxEnabled(!this.isReadOnly());
            node.add((MutableTreeNode)((Object)categoryNode));
            node.sortChildren();
            node = categoryNode;
        }
        this.addFeatureNode(node, feature, !feature.getType().canUserDisable());
    }

    private void addFeatureNode(JMutableTreeNode parent, Feature feature, boolean forceReadonly) {
        TriStateBoolean checkBoxState = this.isCurrentlyEnabled(feature) ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
        SortedFeatureNode child = new SortedFeatureNode(feature, checkBoxState);
        boolean checkable = !forceReadonly && !this.isReadOnly();
        child.setCheckBoxEnabled(checkable);
        parent.add((MutableTreeNode)((Object)child));
        child.setUserObject(feature);
        parent.sortChildren();
    }

    private JMutableTreeNode searchNode(JMutableTreeNode n, FeatureCategory category) {
        Enumeration e = n.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            JMutableTreeNode node = (JMutableTreeNode)e.nextElement();
            if (!category.equals(node.getUserObject())) continue;
            return node;
        }
        return null;
    }

    private Collection<Feature> getVisibleFeatures() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        List<Feature> features = extensionRegistry.getFeatureRegistry().getFeatures();
        ArrayList<Feature> visible = new ArrayList<Feature>();
        for (Feature feature : features) {
            if (!this.isVisibleFeature(feature)) continue;
            visible.add(feature);
        }
        return visible;
    }

    private boolean isCurrentlyEnabled(Feature feature) {
        return !this._disabledIds.contains(feature.getId());
    }

    private void setCurrentlyEnabled(Feature feature, boolean enabled) {
        if (enabled) {
            this._disabledIds.remove(feature.getId());
        } else {
            this._disabledIds.add(feature.getId());
        }
    }

    private void updateDependencies(Feature feature, boolean selected) {
        FeatureRegistry featureRegistry = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry();
        if (selected) {
            Set<Feature> dependenciesOfFeature = featureRegistry.getOutgoingDependenciesOfFeature(feature);
            for (Feature f : dependenciesOfFeature) {
                if (!this._disabledIds.contains(f.getId())) continue;
                this.setCurrentlyEnabled(f, true);
            }
        } else {
            Set<Feature> dependenciesOnFeature = featureRegistry.getIncomingDependenciesOnFeature(feature);
            for (Feature f : dependenciesOnFeature) {
                if (f == null || !f.getType().canUserDisable()) continue;
                this.setCurrentlyEnabled(f, false);
            }
        }
    }

    private void refreshTree() {
        JMutableTreeNode root = (JMutableTreeNode)this._treeModel.getRoot();
        this.refreshTreeCheckedState(root, new HashSet<String>());
        root.updateNodes();
        if (this._tree.getModel() != this._treeModel) {
            this._searchField.clear();
        }
        this._tree.repaint();
    }

    private void refreshTreeCheckedState(JMutableTreeNode node, Set<String> expanded) {
        Feature feature;
        boolean enable;
        JTreeCellData cellData = node.getModel();
        TriStateBoolean checkState = cellData.getCheckBoxState();
        Object object = node.getUserObject();
        if (object instanceof Feature && (!(enable = this.isCurrentlyEnabled(feature = (Feature)object)) || !checkState.isTrue() || !enable && checkState.isFalse())) {
            cellData.setCheckBoxState(enable);
            String textForNode = node.getParent().toString();
            if (expanded.add(textForNode)) {
                ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                for (TreeNode n = node.getParent(); n != null; n = n.getParent()) {
                    list.add(n);
                }
                Collections.reverse(list);
                TreePath pathToNode = new TreePath(list.toArray());
                this._tree.expandPath(pathToNode);
            }
        }
        if (node.getChildCount() > 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                JMutableTreeNode child = (JMutableTreeNode)e.nextElement();
                this.refreshTreeCheckedState(child, expanded);
            }
        }
    }

    private boolean isVisibleFeature(Feature feature) {
        return this._filter.accept(feature);
    }

    @Override
    public Component getFirstFocusComponent() {
        return this._searchField.getTextField();
    }

    @Override
    public String[] getTreeExpansionState() {
        JMutableTreeNode root = (JMutableTreeNode)this._treeModel.getRoot();
        ArrayList<String> expandedNodes = new ArrayList<String>(root.getChildCount());
        TreePath rootPath = new TreePath(root);
        Enumeration e = root.children();
        while (e.hasMoreElements()) {
            TreeNode n;
            TreePath path;
            TreeNode groupNode = (TreeNode)e.nextElement();
            TreePath parent = rootPath.pathByAddingChild(groupNode);
            if (groupNode.getChildCount() <= 0 || !this._tree.isVisible(path = parent.pathByAddingChild(n = groupNode.getChildAt(0)))) continue;
            expandedNodes.add(groupNode.toString());
        }
        return expandedNodes.toArray(new String[expandedNodes.size()]);
    }

    void restoreTreeExpansion(String ... expandedNodes) {
        block0: for (String groupnode : expandedNodes) {
            for (int i = 0; i < this._tree.getRowCount(); ++i) {
                TreePath path = this._tree.getPathForRow(i);
                DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                String val = String.valueOf(last);
                if (!groupnode.equals(val)) continue;
                this._tree.expandPath(path);
                continue block0;
            }
        }
        this.checkExpansionState();
    }

    private void checkExpansionState() {
        this._treeState = this.checkExpansionState(new TreePath(this._tree.getModel().getRoot()), null);
        this._expandTreeButton.setEnabled(TreeState.MIXED.equals((Object)this._treeState) || TreeState.COLLAPSED.equals((Object)this._treeState));
        this._collapseTreeButton.setEnabled(TreeState.MIXED.equals((Object)this._treeState) || TreeState.EXPANDED.equals((Object)this._treeState));
    }

    private TreeState checkExpansionState(TreePath nodePath, TreeState expansionState) {
        TreeNode node = (TreeNode)nodePath.getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = nodePath.pathByAddingChild(n);
                expansionState = this.checkExpansionState(path, expansionState);
                if (TreeState.MIXED.equals((Object)expansionState)) {
                    return expansionState;
                }
                if (n.getChildCount() != 0) continue;
                break;
            }
        } else if (nodePath.getPath().length > 2) {
            boolean nodeVisible = this._tree.isVisible(nodePath);
            if (TreeState.COLLAPSED.equals((Object)expansionState) && nodeVisible || TreeState.EXPANDED.equals((Object)expansionState) && !nodeVisible) {
                return TreeState.MIXED;
            }
            return nodeVisible ? TreeState.EXPANDED : TreeState.COLLAPSED;
        }
        return expansionState;
    }

    private void configureSearchField() {
        this._searchField.setPrompt(ManageFeaturesArb.getString(7));
        this._searchField.getTextField().setColumns(30);
        this._searchField.setAllowEmptySearch(false);
        this._searchField.setStyle(SearchField.Style.FILTER);
        this._searchField.addSearchListener(this.getSearchListener());
    }

    private void configureDescriptionPane() {
        this._description.setEditorKit(new DescriptionPaneEditorKit());
        this._description.setPreferredSize(new Dimension(200, 100));
        this._description.setEditable(false);
        this._description.setFocusable(false);
        Border outer = BorderFactory.createEmptyBorder(0, -2, 0, 0);
        Border innerOuter = BorderFactory.createLineBorder(Colors.FLAT_EDITOR_BORDER);
        Border innerInner = BorderFactory.createEmptyBorder(-5, 10, 0, 10);
        CompoundBorder inner = BorderFactory.createCompoundBorder(innerOuter, innerInner);
        this._description.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        this._description.setOpaque(false);
    }

    private void configureFeaturesTree() {
        this._tree.setModel((TreeModel)this._treeModel);
        this._tree.setBorder(null);
        this._tree.setRootVisible(false);
        this._tree.setRowHeight(20);
        this._tree.setShowsRootHandles(true);
        TreeSelectionModel selectionModel = this._tree.getSelectionModel();
        selectionModel.addTreeSelectionListener(this.getTreeSelectionListener());
        this._tree.addTreeExpansionListener(this.getTreeExpansionListener());
        if (this.isReadOnly()) {
            this._tree.setEditable(false);
        } else {
            this._tree.setEditable(true);
            this._tree.addTreeCellCheckedListener((TreeCellCheckedListener)this.getTreeCheckListener());
            this._tree.addMouseListener((MouseListener)this.getTreeCheckListener());
        }
    }

    private TreeExpansionListener getTreeExpansionListener() {
        if (this._nodeExpansionListener == null) {
            this._nodeExpansionListener = new NodeExpansionListener();
        }
        return this._nodeExpansionListener;
    }

    private TreeSelectionListener getTreeSelectionListener() {
        if (this._nodeSelectionListener == null) {
            this._nodeSelectionListener = new NodeSelectionListener();
        }
        return this._nodeSelectionListener;
    }

    private NodeCheckListener getTreeCheckListener() {
        if (this._nodeCheckListener == null) {
            this._nodeCheckListener = new NodeCheckListener();
        }
        return this._nodeCheckListener;
    }

    private SearchListener getSearchListener() {
        if (this._searchListener == null) {
            this._searchListener = new FeatureSearchListener();
        }
        return this._searchListener;
    }

    boolean isReadOnly() {
        return this._readOnly;
    }

    private AbstractButton collapseTreeButton() {
        this._collapseTreeButton = new HyperlinkButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFeaturesTreePanel.this._expandTreeButton.setEnabled(true);
                ManageFeaturesTreePanel.this._collapseTreeButton.setEnabled(false);
                ManageFeaturesTreePanel.this._treeState = TreeState.COLLAPSED;
                IdeUtil.expandTreeToDepth((JTree)ManageFeaturesTreePanel.this._tree, 1);
            }
        });
        this._collapseTreeButton.setText(ManageFeaturesArb.getString(6));
        this._collapseTreeButton.setEnabled(false);
        return this._collapseTreeButton;
    }

    private AbstractButton expandTreeButton() {
        this._expandTreeButton = new HyperlinkButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFeaturesTreePanel.this._collapseTreeButton.setEnabled(true);
                ManageFeaturesTreePanel.this._expandTreeButton.setEnabled(false);
                ManageFeaturesTreePanel.this._treeState = TreeState.EXPANDED;
                IdeUtil.expandAllTreeRows((JTree)ManageFeaturesTreePanel.this._tree);
            }
        });
        this._expandTreeButton.setText(ManageFeaturesArb.getString(5));
        return this._expandTreeButton;
    }

    @Override
    public void populate() {
        this.populate(this._filter);
    }

    @Override
    public boolean hasChanges() {
        return !this._disabledIds.equals(ExtensionPreferences.getInstance().getDisabledIds());
    }

    @Override
    public void makeChanges() {
    }

    @Override
    public void setPanelChangedListener(ManageFeaturesPanelListener listener) {
        this._panelChangeListener = listener;
    }

    private static String displayPropertiesToCSS(Font font) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        rule.append(" }");
        return rule.toString();
    }

    private static enum TreeState {
        EXPANDED,
        COLLAPSED,
        MIXED;

    }

    private static class DescriptionPaneEditorKit
    extends HTMLEditorKit {
        private static StyleSheet _defaultStyles;

        private DescriptionPaneEditorKit() {
        }

        @Override
        public StyleSheet getStyleSheet() {
            if (_defaultStyles == null) {
                _defaultStyles = new StyleSheet();
                _defaultStyles.addStyleSheet(super.getStyleSheet());
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }"));
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString(ManageFeaturesTreePanel.displayPropertiesToCSS(new JLabel().getFont())));
            }
            return _defaultStyles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StyleSheet createStyleSheetFromString(String s) {
            StyleSheet ss = new StyleSheet();
            try (StringReader r = null;){
                r = new StringReader(s);
                ss.loadRules(r, null);
            }
            return ss;
        }
    }

    private class NodeSelectionListener
    implements TreeSelectionListener {
        private final HashMap<String, String> _map = new HashMap();
        private final boolean _showOrigin = Boolean.getBoolean("ide.show.feature.origin");

        private NodeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object userData;
            JMutableTreeNode node = (JMutableTreeNode)e.getPath().getLastPathComponent();
            if (this._map.containsKey(node.toString())) {
                ManageFeaturesTreePanel.this._description.setText(this._map.get(node.toString()));
            }
            if ((userData = node.getUserObject()) instanceof Feature) {
                Feature feature = (Feature)userData;
                String d = this.buildDescription(feature);
                this._map.put(node.toString(), d);
                ManageFeaturesTreePanel.this._description.setText(d);
            } else if (userData instanceof FeatureCategory) {
                FeatureCategory category = (FeatureCategory)userData;
                String d = this.buildDescription(category);
                this._map.put(node.toString(), d);
                ManageFeaturesTreePanel.this._description.setText(d);
            }
        }

        private String buildDescription(Feature feature) {
            StringBuilder b = new StringBuilder();
            b.append("<h3>");
            b.append(feature.getDisplayName());
            b.append("</h3>");
            b.append("<p>");
            b.append(ModelUtil.hasLength((String)feature.getDescription()) ? feature.getDescription() : "<No description available>");
            b.append("</p>");
            this.addOrigin(b, feature, null);
            return this.html(b.toString());
        }

        private String buildDescription(FeatureCategory category) {
            StringBuilder b = new StringBuilder();
            b.append("<h3>");
            b.append(category.getDisplayName());
            b.append("</h3>");
            b.append("<p>");
            b.append(ModelUtil.hasLength((String)category.getDescription()) ? category.getDescription() : "<No description available>");
            b.append("</p>");
            this.addOrigin(b, null, category);
            return this.html(b.toString());
        }

        private void addOrigin(StringBuilder builder, Feature feature, FeatureCategory category) {
            String extension;
            String id;
            String type;
            if (!this._showOrigin) {
                return;
            }
            String technology = null;
            Set<Feature> incoming = null;
            Set<Feature> outgoing = null;
            if (feature != null) {
                FeatureType featureType = feature.getType();
                type = featureType.getTypeId();
                id = feature.getId();
                extension = feature.getOwningExtensionId();
                LocationAdapter locator = feature.getLocator();
                if (featureType instanceof TechnologyFeatureType) {
                    technology = ((TechnologyFeatureType)featureType).getTechnologyKey();
                }
                FeatureRegistry registry = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry();
                incoming = registry.getIncomingDependenciesOnFeature(feature);
                outgoing = registry.getOutgoingDependenciesOfFeature(feature);
            } else {
                type = "category";
                id = category.getId();
                extension = category.getOwningExtensionId();
                LocationAdapter locator = category.getLocator();
            }
            builder.append("<br/><hr align='left'/><table border='0' cellpadding='0' cellspacing='0'>");
            this.appendRow("Type:", type, builder);
            this.appendRow("Identity:", id, builder);
            this.appendRow("Extension:", extension, builder);
            if (technology != null) {
                this.appendRow("Technology:", technology, builder);
            }
            if (outgoing != null) {
                this.appendRow("Uses:", outgoing, builder);
            }
            if (incoming != null) {
                this.appendRow("Used By:", incoming, builder);
            }
            builder.append("</table>");
        }

        private void appendRow(String name, String value, StringBuilder builder) {
            builder.append("<tr align='left'>");
            builder.append("<td nowrap='true'>").append(name).append("</td>");
            builder.append("<td width='10'/><td nowrap='true'>").append(value).append("</td>");
            builder.append("</tr>");
        }

        private void appendRow(String name, Set<Feature> value, StringBuilder builder) {
            builder.append("<tr align='left' valign='top'>");
            builder.append("<td nowrap='true'>").append(name).append("</td>");
            builder.append("<td width='10'/><td>");
            String separator = "";
            for (Feature feature : value) {
                builder.append(separator).append(feature);
                separator = ", ";
            }
            builder.append("</td>");
            builder.append("</tr>");
        }

        private String html(String string) {
            return "<html><body>" + string + "</body></html>";
        }
    }

    private class DependencyChecker
    implements Runnable {
        private final boolean _checked;
        private final JMutableTreeNode _node;
        private final HashSet<String> _checkedNodes;

        public DependencyChecker(JMutableTreeNode node, boolean selected, HashSet<String> checkedNodes) {
            this._node = node;
            this._checked = selected;
            this._checkedNodes = checkedNodes;
        }

        @Override
        public void run() {
            Object object = this._node.getUserObject();
            if (object instanceof Feature) {
                Feature feature = (Feature)object;
                if (feature.getType().canUserDisable()) {
                    ManageFeaturesTreePanel.this.setCurrentlyEnabled(feature, this._checked);
                    ManageFeaturesTreePanel.this.updateDependencies(feature, this._checked);
                    this._checkedNodes.add(feature.getDisplayName());
                }
            } else if (this._node.getChildCount() > 0) {
                Enumeration e = this._node.children();
                while (e.hasMoreElements()) {
                    Feature feature;
                    Object userObject = ((JMutableTreeNode)e.nextElement()).getUserObject();
                    if (!(userObject instanceof Feature) || !(feature = (Feature)userObject).getType().canUserDisable()) continue;
                    ManageFeaturesTreePanel.this.setCurrentlyEnabled(feature, this._checked);
                    ManageFeaturesTreePanel.this.updateDependencies(feature, this._checked);
                    this._checkedNodes.add(feature.getDisplayName());
                }
            }
        }
    }

    private class NodeCheckListener
    extends MouseAdapter
    implements TreeCellCheckedListener {
        private NodeCheckListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.tryShowPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.tryShowPopup(e);
            }
        }

        void tryShowPopup(MouseEvent e) {
            TreePath path = ManageFeaturesTreePanel.this._tree.getClosestPathForLocation(e.getX(), e.getY());
            Object component = path.getLastPathComponent();
            if (!(component instanceof JMutableTreeNode)) {
                return;
            }
            JMutableTreeNode selNode = (JMutableTreeNode)component;
            if (selNode.getChildCount() == 0) {
                selNode = (JMutableTreeNode)selNode.getParent();
            }
            final JMutableTreeNode parentNode = selNode;
            AbstractAction selectAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeCheckListener.this.selectDescendants(parentNode, true);
                }
            };
            String selectAllLabel = ManageFeaturesArb.getString(3);
            selectAction.putValue("Name", StringUtils.stripMnemonic((String)selectAllLabel));
            selectAction.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)selectAllLabel));
            AbstractAction deselectAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeCheckListener.this.selectDescendants(parentNode, false);
                }
            };
            String deselectLabel = ManageFeaturesArb.getString(4);
            deselectAction.putValue("Name", StringUtils.stripMnemonic((String)deselectLabel));
            deselectAction.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)deselectLabel));
            if (selNode == ManageFeaturesTreePanel.this._root) {
                deselectAction.setEnabled(false);
                selectAction.setEnabled(false);
            } else {
                TriStateBoolean state = parentNode.getModel().getCheckBoxState();
                if (state.isTriState()) {
                    int checkedNodeCount = 0;
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        JMutableTreeNode n = (JMutableTreeNode)parentNode.getChildAt(i);
                        if (!n.getModel().getCheckBoxState().isTrue() || !n.getModel().isCheckBoxEnabled()) continue;
                        ++checkedNodeCount;
                        break;
                    }
                    deselectAction.setEnabled(checkedNodeCount > 0);
                } else if (state.isTrue()) {
                    selectAction.setEnabled(false);
                    boolean canDeselectNodes = false;
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        JMutableTreeNode n = (JMutableTreeNode)parentNode.getChildAt(i);
                        if (!n.getModel().getCheckBoxState().isTrue() || !n.getModel().isCheckBoxEnabled()) continue;
                        canDeselectNodes = true;
                        break;
                    }
                    deselectAction.setEnabled(canDeselectNodes);
                } else {
                    selectAction.setEnabled(!state.isTrue());
                    deselectAction.setEnabled(!state.isFalse());
                }
            }
            JPopupMenu menu = new JPopupMenu();
            menu.add(selectAction);
            menu.add(deselectAction);
            menu.show((Component)ManageFeaturesTreePanel.this._tree, e.getX(), e.getY());
        }

        private void selectDescendants(JMutableTreeNode parentNode, boolean select) {
            parentNode.selectDescendants(select);
            this.processNodeChecked(parentNode, select);
            parentNode.updateNodes();
            ManageFeaturesTreePanel.this._tree.repaint();
        }

        public synchronized void cellChecked(TreeCellCheckedEvent event) {
            JMutableTreeNode node = (JMutableTreeNode)event.getSource();
            this.processNodeChecked(node, true);
        }

        public synchronized void cellUnchecked(TreeCellCheckedEvent event) {
            JMutableTreeNode node = (JMutableTreeNode)event.getSource();
            this.processNodeChecked(node, false);
        }

        private void processNodeChecked(final JMutableTreeNode node, final boolean checked) {
            final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor((Component)ManageFeaturesTreePanel.this, ManageFeaturesArb.getString(11), (Object)ManageFeaturesArb.getString(12), null);
            monitor.setCancellable(false);
            monitor.setCloseOnFinish(true);
            final HashSet backup = new HashSet(ManageFeaturesTreePanel.this._disabledIds);
            final HashSet<String> checkedNodes = new HashSet<String>();
            final HashMap deps = new HashMap();
            DependencyChecker runnable = new DependencyChecker(node, checked, checkedNodes);
            final FutureTask<HashSet<String>> future = new FutureTask<HashSet<String>>(runnable, checkedNodes);
            ExecutorService executor = Executors.newCachedThreadPool();
            class MonitorProgressRunnable
            implements Runnable {
                MonitorProgressRunnable() {
                }

                @Override
                public void run() {
                    monitor.start();
                    while (!monitor.isCancelled()) {
                        try {
                            Thread.sleep(500L);
                            if (monitor.isCanceled()) {
                                future.cancel(true);
                            }
                            if (!future.isDone()) continue;
                            break;
                        }
                        catch (Exception e) {
                            monitor.close();
                        }
                    }
                    try {
                        deps.putAll(NodeCheckListener.this.buildChangeMap(backup, ManageFeaturesTreePanel.this._disabledIds));
                    }
                    catch (CancellationException cancellationException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            monitor.close();
                            deps.keySet().removeAll(checkedNodes);
                            if (deps.size() > 0) {
                                NodeCheckListener.this.respondToNodeChecked(node, checked, deps, backup);
                            }
                            if (ManageFeaturesTreePanel.this._panelChangeListener != null) {
                                ManageFeaturesTreePanel.this._panelChangeListener.panelChanged(ManageFeaturesTreePanel.this);
                            }
                        }
                    });
                }
            }
            MonitorProgressRunnable showProgress = new MonitorProgressRunnable();
            executor.submit(showProgress);
            executor.submit(future);
        }

        private void respondToNodeChecked(JMutableTreeNode node, boolean checked, Map<String, Feature> deps, Set backup) {
            ArrayList<String> extensions = new ArrayList<String>(deps.keySet());
            Collections.sort(extensions);
            String extName = this.textForNode(node);
            if (FeaturesChangedMessageDialog.confirm(ManageFeaturesTreePanel.this, extName, extensions, checked)) {
                ManageFeaturesTreePanel.this.refreshTree();
            } else {
                ManageFeaturesTreePanel.this.setDisabledIds(backup);
                node.getModel().setCheckBoxState(!checked);
                if (node.getChildCount() > 0) {
                    Enumeration e = node.children();
                    while (e.hasMoreElements()) {
                        ((JMutableTreeNode)e.nextElement()).getModel().setCheckBoxState(!checked);
                    }
                } else {
                    ((JMutableTreeNode)node.getParent()).updateNodes();
                }
                ManageFeaturesTreePanel.this._tree.repaint();
            }
        }

        private Map<String, Feature> buildChangeMap(Collection backup, Collection live) {
            HashSet bigger;
            HashSet smaller;
            if (backup.size() > live.size()) {
                smaller = new HashSet(live);
                bigger = new HashSet(backup);
            } else {
                smaller = new HashSet(backup);
                bigger = new HashSet(live);
            }
            HashMap<String, Feature> deps = new HashMap<String, Feature>();
            HashSet common = new HashSet(bigger);
            boolean modified = common.retainAll(smaller);
            if (modified) {
                HashSet changes = new HashSet(bigger);
                changes.removeAll(common);
                FeatureRegistry featureRegistry = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry();
                for (Object o : changes) {
                    String id = o.toString();
                    Feature f = featureRegistry.getFeature(id);
                    if (!ManageFeaturesTreePanel.this.isVisibleFeature(f)) continue;
                    deps.put(f.getDisplayName(), f);
                }
            }
            return deps;
        }

        private String textForNode(JMutableTreeNode node) {
            if (node.getChildCount() == 0) {
                return node.getModel().getText();
            }
            return ManageFeaturesArb.getString(20);
        }
    }

    private class NodeExpansionListener
    implements TreeExpansionListener {
        private NodeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (!TreeState.EXPANDED.equals((Object)ManageFeaturesTreePanel.this._treeState)) {
                ManageFeaturesTreePanel.this.checkExpansionState();
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            if (!TreeState.COLLAPSED.equals((Object)ManageFeaturesTreePanel.this._treeState)) {
                ManageFeaturesTreePanel.this.checkExpansionState();
            }
        }
    }

    private static class SortedFeatureNode
    extends JMutableTreeNode {
        public SortedFeatureNode(Feature feature, TriStateBoolean tri) {
            super(new JTreeCellData(FEATURE_ICON, feature.getDisplayName(), true, tri));
            this.setUserObject(feature);
        }

        public SortedFeatureNode(FeatureCategory category) {
            super(new JTreeCellData(CATEGORY_ICON, category.getDisplayName(), true));
            this.setUserObject(category);
        }

        private void setCheckBoxEnabled(boolean isCheckBoxEnabled) {
            this._treeCellData.setEnabled(isCheckBoxEnabled);
            this._treeCellData.setTextEnabled(true);
        }

        public int compareTo(JMutableTreeNode otherNode) {
            if (otherNode != null) {
                if (this.getChildCount() > 0) {
                    if (otherNode.getChildCount() == 0) {
                        return -1;
                    }
                } else if (otherNode.getChildCount() > 0) {
                    return 1;
                }
            }
            return super.compareTo(otherNode);
        }
    }

    private class FeatureSearchListener
    implements SearchListener {
        private FeatureSearchListener() {
        }

        public void searchPerformed(SearchEvent se) {
            TreePath selected = ManageFeaturesTreePanel.this._tree.getSelectionPath();
            String searchText = se.getSearchText();
            DefaultTreeModel model = searchText.trim().length() > 0 ? this.buildFilteredTreeModel(ManageFeaturesTreePanel.this._treeModel, searchText, true) : ManageFeaturesTreePanel.this._treeModel;
            ManageFeaturesTreePanel.this._tree.setModel((TreeModel)model);
            JMutableTreeNode root = (JMutableTreeNode)model.getRoot();
            ManageFeaturesTreePanel.this.refreshTreeCheckedState(root, new HashSet());
            root.updateNodes();
            ManageFeaturesTreePanel.this._tree.expandAllRows();
            this.restoreSelection(selected);
            ManageFeaturesTreePanel.this.checkExpansionState();
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        private void restoreSelection(TreePath selected) {
            if (selected != null) {
                String name = String.valueOf(selected.getLastPathComponent());
                for (int i = 0; i < ManageFeaturesTreePanel.this._tree.getRowCount(); ++i) {
                    TreePath path = ManageFeaturesTreePanel.this._tree.getPathForRow(i);
                    DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                    String val = String.valueOf(last);
                    if (!name.equals(val)) continue;
                    ManageFeaturesTreePanel.this._tree.setSelectionRow(i);
                    ManageFeaturesTreePanel.this._tree.scrollRowToVisible(i);
                    break;
                }
            } else {
                ManageFeaturesTreePanel.this._tree.setSelectionRow(0);
            }
        }

        public DefaultTreeModel buildFilteredTreeModel(DefaultTreeModel treeModel, String filterText, boolean prefixMatch) {
            if (treeModel == null) {
                throw new IllegalArgumentException("treeModel cannot be null", new NullPointerException());
            }
            if (filterText == null) {
                throw new IllegalArgumentException("the filter text must be a non-null string");
            }
            Object rootObject = treeModel.getRoot();
            if (!(rootObject instanceof JMutableTreeNode)) {
                throw new IllegalArgumentException("the tree root must be a JMutableTreeNode");
            }
            JMutableTreeNode root = this.cloneTree((JMutableTreeNode)rootObject);
            SearchMatcher matcher = prefixMatch ? SearchMatcher.getPrefixMatcher((CharSequence)filterText, (boolean)true, (boolean)false) : SearchMatcher.getSubstringMatcher((CharSequence)filterText, (boolean)true);
            this.filter(root, matcher);
            return new DefaultTreeModel((TreeNode)root);
        }

        private JMutableTreeNode cloneTree(JMutableTreeNode root) {
            if (root != null) {
                JMutableTreeNode newRoot = new JMutableTreeNode(root.getModel(), root.getAllowsChildren());
                for (int i = 0; i < root.getChildCount(); ++i) {
                    JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
                    JMutableTreeNode newChild = this.cloneTree(child);
                    if (newChild == null) continue;
                    newChild.setUserObject(child.getUserObject());
                    newRoot.add((MutableTreeNode)newChild);
                }
                return newRoot;
            }
            return null;
        }

        private boolean filter(JMutableTreeNode root, SearchMatcher matcher) {
            boolean matchingChildren = false;
            ArrayList<Integer> nodesToRemove = new ArrayList<Integer>();
            for (int i = 0; i < root.getChildCount(); ++i) {
                JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
                if (this.filter(child, matcher)) {
                    matchingChildren = true;
                    continue;
                }
                nodesToRemove.add(i);
            }
            int removedCount = 0;
            Iterator iterator = nodesToRemove.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                root.remove(i - removedCount++);
            }
            if (matchingChildren) {
                return true;
            }
            return matcher.matches((CharSequence)String.valueOf(root.getModel().getText()));
        }
    }
}

