/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.peek;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.KeyNavigableTree;
import oracle.ide.peek.Peek;
import oracle.ide.peek.Peekable;

public abstract class PeekableTree
extends KeyNavigableTree
implements Peekable {
    private boolean isPeeking = false;

    public PeekableTree() {
    }

    public PeekableTree(Object[] value) {
        super(value);
    }

    public PeekableTree(Vector value) {
        super(value);
    }

    public PeekableTree(Hashtable value) {
        super(value);
    }

    public PeekableTree(TreeNode root) {
        super(root);
    }

    public PeekableTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
    }

    public PeekableTree(TreeModel newModel) {
        super(newModel);
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isPeeking) {
            return null;
        }
        return super.getToolTipText(event);
    }

    public String getToolTipText() {
        if (this.isPeeking) {
            return null;
        }
        return super.getToolTipText();
    }

    @Override
    public Peek peek(Point p) {
        TreePath tp = this.getTreePath(p);
        if (tp == null) {
            return null;
        }
        final Peek peek = this.createPeek(tp);
        if (peek != null) {
            peek.showPeek();
            if (this.getCellRenderer() instanceof JComponent) {
                ((JComponent)((Object)this.getCellRenderer())).setToolTipText(null);
            }
            this.isPeeking = true;
            peek.getGhostPointingPalette().addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    peek.getGhostPointingPalette().removeAncestorListener((AncestorListener)this);
                    PeekableTree.this.isPeeking = false;
                }
            });
        }
        return peek;
    }

    private TreePath getTreePath(Point p) {
        SwingUtilities.convertPointFromScreen(p, (Component)((Object)this));
        TreePath tp = this.getClosestPathForLocation(p.x, p.y);
        if (tp != null) {
            Rectangle rect = this.getPathBounds(tp);
            if ((rect = rect.intersection(this.getVisibleRect())).contains(p)) {
                return tp;
            }
        }
        return null;
    }

    public abstract Peek createPeek(TreePath var1);
}

