/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.addin;

import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.ide.util.MetaResource;
import javax.swing.Icon;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.actions.SaveGridAsReport;
import oracle.dbtools.raptor.report.addin.RepNav;
import oracle.dbtools.raptor.report.addin.ReportEditorAddin;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.dbtools.raptor.support.MetaPackageReference;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.dbtools.util.Resource;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class ReportAddin
implements Addin {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-reports";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-reports", "sqldev-reports-hook");
    private static final String ENTRY_ELEMENT = "report";
    private static final String PACKAGE_ATTR = "package";
    private static final String FILE_ATTR = "file";
    public static final String USER_REPORT_FILE = Resource.RAPTOR_USER.getAbsolutePath() + File.separator + "UserReports.xml";
    public static final int OPEN_REPORT = Ide.findOrCreateCmdID((String)"openReport");
    private static final String MONITOR_SESSIONS_CMD = "sqlreport.monitorSessions";
    private static final int MONITOR_SESSIONS_ID = Ide.findOrCreateCmdID((String)"sqlreport.monitorSessions");
    public static final Icon rootIcon = RepNav.getIcon("REPORT_ROOT_ICON");
    public static final Icon folderIcon = RepNav.getIcon("REPORT_FOLDER_ICON");
    public static final Icon reportIcon = RepNav.getIcon("REPORT_ICON");
    public static final Icon reportChartIcon = RepNav.getIcon("REPORT_CHART_ICON");
    public static final Icon reportCodeIcon = RepNav.getIcon("REPORT_CODE_ICON");
    public static final Icon reportDbmsIcon = RepNav.getIcon("REPORT_DBMS_ICON");
    public static final Icon reportGaugeIcon = RepNav.getIcon("REPORT_GAUGE_ICON");
    public static final Icon reportScriptIcon = RepNav.getIcon("REPORT_SCRIPT_ICON");
    public static final Icon reportTableIcon = RepNav.getIcon("REPORT_TABLE_ICON");
    public static final String menuIcon = "report2.png";
    public static final Icon navIcon = RepNav.getIcon("CREATE_REPORT_ICON");
    public static final Icon editorIcon = RepNav.getIcon("REPORT_ICON");
    private static List<MetaPackageReference> _registeredReportPackages = new ArrayList<MetaPackageReference>();
    private static List<MetaURLReference> _registeredReports = new ArrayList<MetaURLReference>();
    private static Listener s_listener;

    private static synchronized void initListener() {
        if (s_listener == null) {
            s_listener = new Listener();
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            hashStructureHook.addHashStructureHookListener((HashStructureHookListener)s_listener);
        }
    }

    public static synchronized void registerReport(URL uRL) {
        ReportAddin.registerReport(uRL, ReportAddin.class.getClassLoader());
    }

    public static synchronized void registerReport(URL uRL, ClassLoader classLoader) {
        _registeredReports.add(MetaURLReference.createURLReference((URL)uRL, (ClassLoader)classLoader));
    }

    public static synchronized void registerReport(String string) {
        ReportAddin.registerReport(string, ReportAddin.class.getClassLoader());
    }

    public static synchronized void registerReport(String string, ClassLoader classLoader) {
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(string);
                try {
                    uRL = file.toURL();
                }
                catch (MalformedURLException malformedURLException2) {
                    Logger.getLogger(ReportAddin.class.getClass().getName()).log(Level.WARNING, malformedURLException2.getStackTrace()[0].toString(), malformedURLException2);
                }
            }
        }
        if (uRL != null) {
            _registeredReports.add(MetaURLReference.createURLReference((URL)uRL, (ClassLoader)classLoader));
        } else {
            System.err.println(Messages.getString("ReportAddin.9") + string);
        }
    }

    public static synchronized void unregisterReport(URL uRL) {
        for (MetaURLReference metaURLReference : _registeredReports) {
            if (!ModelUtil.areEqual((Object)metaURLReference.getURL(), (Object)uRL)) continue;
            _registeredReports.remove(metaURLReference);
            break;
        }
    }

    public static synchronized List<MetaURLReference> getRegisterReport() {
        ReportAddin.initListener();
        return _registeredReports;
    }

    public static synchronized void registerReportPackage(String string, ClassLoader classLoader) {
        _registeredReportPackages.add(MetaPackageReference.createPackageReference((String)string, (ClassLoader)classLoader));
    }

    public static synchronized void unregisterReportPackage(String string) {
        ListIterator<MetaPackageReference> listIterator = _registeredReportPackages.listIterator();
        while (listIterator.hasNext()) {
            MetaPackageReference metaPackageReference = listIterator.next();
            if (!ModelUtil.areEqual((Object)metaPackageReference.getPackage(), (Object)string)) continue;
            listIterator.remove();
            break;
        }
    }

    public static synchronized List<MetaPackageReference> getRegisterReportPackages() {
        ReportAddin.initListener();
        return _registeredReportPackages;
    }

    public ReportAddin() {
        String string = System.getProperty("raptor.shared.reports");
        if (string != null) {
            for (String string2 : string.split("[:;]")) {
                ReportAddin.registerReport(string2);
            }
        }
        for (String string3 : DBConfig.getInstance().getExtensions("REPORT")) {
            ReportAddin.registerReport(string3);
        }
    }

    public void initialize() {
        if (Ide.getIdeArgs().getCreateUI()) {
            DisplayAdapter.setDrillActionClass((MetaClass)new MetaClass(this.getClass().getClassLoader(), "oracle.dbtools.raptor.report.addin.DrillReportAction"));
            EditorManager.getEditorManager().registerDynamic((EditorAddin)new ReportEditorAddin());
            ResultSetTable.addGridContextMenu((GridContextMenuItem)SaveGridAsReport.getInstance());
        }
    }

    public static boolean isUserDefinedReport(URL uRL) {
        String string = uRL.toString();
        return string.startsWith(RootNode.getInstance().getURL().toString()) && (string = string.substring(RootNode.getInstance().getURL().toString().length() + 1, string.length())).startsWith(RootNode.USER_DEFINED_REPORTS_NODE_NAME);
    }

    public static void showOracleOnlyReportMessage(Component component) {
        MessageDialog.information((Component)component, (Object)Messages.getString("ReportAddin.15"), (String)Messages.getString("ReportAddin.16"), (String)Messages.getString("ReportAddin.17"));
    }

    public static class MonitorSessionsController
    implements Controller {
        public boolean update(IdeAction ideAction, Context context) {
            return ideAction.getCommandId() == MONITOR_SESSIONS_ID;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (MONITOR_SESSIONS_ID == n) {
                String string = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)false);
                String string2 = (String)ideAction.getValue("REPORT_ID");
                RootNode.getInstance().open(string2, string);
                return true;
            }
            return false;
        }
    }

    private static class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processHooks(HashStructure hashStructure) {
            List list = hashStructure.getAsList(ReportAddin.ENTRY_ELEMENT);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    LazyResourceAdapter lazyResourceAdapter = LazyResourceAdapter.getInstance((HashStructure)hashStructure2);
                    MetaResource metaResource = lazyResourceAdapter.getMetaResource(ReportAddin.PACKAGE_ATTR);
                    if (metaResource != null) {
                        _registeredReportPackages.add(MetaPackageReference.createPackageReference((MetaResource)metaResource));
                        continue;
                    }
                    metaResource = lazyResourceAdapter.getMetaResource(ReportAddin.FILE_ATTR);
                    if (metaResource == null) continue;
                    _registeredReports.add(MetaURLReference.createURLReference((MetaResource)metaResource));
                }
            }
        }
    }
}

