/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.Style;
import oracle.dbtools.raptor.report.pdf.StyleLocation;

public class PreserveStyledString {
    private String m_text;
    private List<AttributeSet> m_attrs;
    private List<StyleLocation> m_styleLocs;
    private Style m_logicalStyle;

    public PreserveStyledString(String string) {
        this.m_text = string;
        this.m_attrs = new ArrayList<AttributeSet>();
        this.m_styleLocs = new ArrayList<StyleLocation>();
    }

    public void addAttributes(AttributeSet attributeSet, int n, int n2) {
        this.m_attrs.add(attributeSet);
        this.m_styleLocs.add(new StyleLocation(n, n2));
    }

    public String getText() {
        return this.m_text;
    }

    public List<AttributeSet> getAttributeSets() {
        return this.m_attrs;
    }

    public List<StyleLocation> getStyleLocations() {
        return this.m_styleLocs;
    }

    public Style getLogicalStyle() {
        return this.m_logicalStyle;
    }

    public void setLogicalStyle(Style style) {
        this.m_logicalStyle = style;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PreserveStyledString[");
        for (int i = 0; i < this.m_attrs.size(); ++i) {
            stringBuilder.append("Attributes[");
            Enumeration<?> enumeration = this.m_attrs.get(i).getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = this.m_attrs.get(i).getAttribute(obj);
                stringBuilder.append("key:" + obj + ",value:" + object + ";");
            }
            stringBuilder.append("]");
            stringBuilder.append(" for " + this.m_styleLocs.get(i));
            if (i >= this.m_attrs.size() - 1) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

