/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.token;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Tuple;

public final class Tokenizer {
    private static final Pattern s_wsPattern = Pattern.compile("\\s");
    private static final Pattern s_puncPattern = Pattern.compile("\\p{Punct}");
    private static final Pattern s_underDollarHashPattern = Pattern.compile("[_$#]");
    private static final String EMPTY_STRING = "";
    private static final String NEWLINE = "\n";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String DOUBLE_SINGLE_QUOTE = "''";
    private static final String DOUBLE_DOUBLE_QUOTE = "\"\"";
    private Config m_config;
    private Token m_startMarker;
    private Token m_endMarker;
    private Token m_first;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tokenizer(Config config) {
        try (StringReader stringReader = null;){
            Reader reader;
            this.m_config = config;
            this.m_startMarker = this.createNewToken(Token.Type.END_MARKER, -1, null);
            this.m_endMarker = this.createNewToken(Token.Type.END_MARKER, -1, this.m_startMarker);
            this.m_first = null;
            if (this.m_config.m_source != null) {
                stringReader = new StringReader(this.m_config.m_source);
                reader = stringReader;
            } else {
                reader = this.m_config.m_reader;
            }
            if (reader == null) {
                return;
            }
            int n = 0;
            char[] cArray = new char[1000];
            int n2 = reader.read(cArray);
            if (n2 <= 0) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(cArray, 0, n2);
            Token.Type type = Token.Type.UNKNOWN;
            int n3 = 0;
            boolean bl = false;
            Token token = this.m_startMarker;
            while (n3 < n2 && !bl) {
                int n4;
                String string = stringBuilder.substring(n3, n3 + 1);
                String string2 = n3 < n2 - 1 ? stringBuilder.substring(n3, n3 + 2) : EMPTY_STRING;
                String string3 = n3 < n2 - this.m_config.m_singleLineCommentStart.length() + 1 ? stringBuilder.substring(n3, n3 + this.m_config.m_singleLineCommentStart.length()) : EMPTY_STRING;
                switch (type) {
                    case UNKNOWN: {
                        n4 = 0;
                        for (Tuple tuple : this.m_config.m_userTokens) {
                            String string4 = (String)tuple.getFirst();
                            Token.Type type2 = (Token.Type)((Object)tuple.getSecond());
                            if (n3 >= n2 + 1 - string4.length() || !stringBuilder.substring(n3, n3 + string4.length()).equals(string4)) continue;
                            token = this.createNewToken(type2, n3, token);
                            this.setEnd(token, (n3 += string4.length()) - 1);
                            n4 = 1;
                            break;
                        }
                        if (n4 != 0) break;
                        if (s_wsPattern.matcher(string).matches()) {
                            type = Token.Type.WHITESPACE;
                            token = this.createNewToken(type, n3, token);
                            this.setEnd(token, ++n3 - 1);
                        } else if (string2.equals(this.m_config.m_multiLineCommentStart)) {
                            type = Token.Type.MULTI_LINE_COMMENT;
                            token = this.createNewToken(type, n3, token);
                            ++n3;
                            ++n3;
                        } else if (string3.equals(this.m_config.m_singleLineCommentStart)) {
                            type = Token.Type.SINGLE_LINE_COMMENT;
                            token = this.createNewToken(type, n3, token);
                            ++n3;
                            ++n3;
                        } else if (string.equals(DOUBLE_QUOTE)) {
                            type = Token.Type.DOUBLE_QUOTED_STRING;
                            token = this.createNewToken(type, n3, token);
                            ++n3;
                        } else if (string.equals(SINGLE_QUOTE)) {
                            type = Token.Type.SINGLE_QUOTED_STRING;
                            token = this.createNewToken(type, n3, token);
                            ++n3;
                        } else if (s_puncPattern.matcher(string).matches()) {
                            type = Token.Type.PUNCTUATION;
                            token = this.createNewToken(type, n3, token);
                            ++n3;
                        } else {
                            type = Token.Type.ALPHANUMERIC;
                            token = this.createNewToken(type, n3, token);
                            ++n3;
                        }
                        if (token.isCode() && this.m_config.m_maxTokens != null && ++n > this.m_config.m_maxTokens) {
                            bl = true;
                            break;
                        }
                        if (type != Token.Type.PUNCTUATION) break;
                        this.setEnd(token, n3 - 1);
                        type = Token.Type.UNKNOWN;
                        break;
                    }
                    case WHITESPACE: {
                        if (s_wsPattern.matcher(string).matches()) {
                            this.setEnd(token, ++n3 - 1);
                            break;
                        }
                        this.setEnd(token, n3 - 1);
                        type = Token.Type.UNKNOWN;
                        break;
                    }
                    case MULTI_LINE_COMMENT: {
                        if (n3 < stringBuilder.length() - 2 && !string2.equals(this.m_config.m_multiLineCommentEnd)) {
                            ++n3;
                            break;
                        }
                        this.setEnd(token, n3 + 1);
                        type = Token.Type.UNKNOWN;
                        ++n3;
                        ++n3;
                        break;
                    }
                    case SINGLE_LINE_COMMENT: {
                        if (!string.equals(NEWLINE)) {
                            ++n3;
                            break;
                        }
                        this.setEnd(token, n3);
                        type = Token.Type.UNKNOWN;
                        ++n3;
                        break;
                    }
                    case DOUBLE_QUOTED_STRING: {
                        if (!string.equals(DOUBLE_QUOTE)) {
                            ++n3;
                            break;
                        }
                        if (n3 < n2 - 1 && string2.equals(DOUBLE_DOUBLE_QUOTE)) {
                            ++n3;
                            ++n3;
                            break;
                        }
                        this.setEnd(token, n3);
                        type = Token.Type.UNKNOWN;
                        ++n3;
                        break;
                    }
                    case SINGLE_QUOTED_STRING: {
                        if (!string.equals(SINGLE_QUOTE)) {
                            ++n3;
                            break;
                        }
                        if (n3 < n2 - 1 && string2.equals(DOUBLE_SINGLE_QUOTE)) {
                            ++n3;
                            ++n3;
                            break;
                        }
                        this.setEnd(token, n3);
                        type = Token.Type.UNKNOWN;
                        ++n3;
                        break;
                    }
                    case ALPHANUMERIC: {
                        if (s_underDollarHashPattern.matcher(string).matches()) {
                            ++n3;
                            break;
                        }
                        if (s_wsPattern.matcher(string).matches()) {
                            this.setEnd(token, n3 - 1);
                            type = Token.Type.UNKNOWN;
                            break;
                        }
                        if (n3 < n2 - 1 && string2.equals(this.m_config.m_multiLineCommentStart)) {
                            this.setEnd(token, n3 - 1);
                            type = Token.Type.UNKNOWN;
                            break;
                        }
                        if (string3.equals(this.m_config.m_singleLineCommentStart)) {
                            this.setEnd(token, n3 - 1);
                            type = Token.Type.UNKNOWN;
                            break;
                        }
                        if (string.equals(DOUBLE_QUOTE)) {
                            this.setEnd(token, n3 - 1);
                            type = Token.Type.UNKNOWN;
                            break;
                        }
                        if (string.equals(SINGLE_QUOTE)) {
                            this.setEnd(token, n3 - 1);
                            type = Token.Type.UNKNOWN;
                            break;
                        }
                        if (s_puncPattern.matcher(string).matches()) {
                            this.setEnd(token, n3 - 1);
                            type = Token.Type.UNKNOWN;
                            break;
                        }
                        ++n3;
                        break;
                    }
                }
                if (n3 <= n2 - 10 || (n4 = reader.read(cArray)) <= 0) continue;
                stringBuilder.append(cArray, 0, n4);
                n2 += n4;
            }
            this.setEnd(token, stringBuilder.length() - 1);
            this.m_startMarker.setHeaderSourceImpl(stringBuilder.toString());
            if (((Token)this.m_startMarker.getNextToken()).getType() != Token.Type.END_MARKER) {
                this.m_first = this.m_startMarker.getNextCodeToken();
            }
        }
    }

    public final Token getFirst() {
        return this.m_first;
    }

    public final Token getStartMarker() {
        return this.m_startMarker;
    }

    public final Token getEndMarker() {
        return this.m_endMarker;
    }

    private Token createNewToken(Token.Type type, int n, Token token) {
        return this.m_config.m_factory.createToken(type, n, token);
    }

    private void setEnd(Token token, int n) {
        this.m_config.m_factory.setEnd(token, n);
    }

    private static class DefaultTokenFactory
    implements TokenFactory {
        private DefaultTokenFactory() {
        }

        @Override
        public Token createToken(Token.Type type, int n, Token token) {
            return new Token(type, n, token);
        }

        @Override
        public void setEnd(Token token, int n) {
            token.setEnd(n);
        }
    }

    public static final class Config {
        private Reader m_reader;
        private String m_source;
        private TokenFactory m_factory = new DefaultTokenFactory();
        private List<Tuple<String, Token.Type>> m_userTokens = new ArrayList<Tuple<String, Token.Type>>();
        private String m_singleLineCommentStart = "--";
        private String m_multiLineCommentStart = "/*";
        private String m_multiLineCommentEnd = "*/";
        private Integer m_maxTokens = null;

        public void setSource(String string) {
            this.m_source = string;
        }

        public void setReader(Reader reader) {
            this.m_reader = reader;
        }

        public void setFactory(TokenFactory tokenFactory) {
            this.m_factory = tokenFactory;
        }

        public void setSingleLineCommentStart(String string) {
            this.m_singleLineCommentStart = string;
        }

        public void setMultiLineCommentStart(String string) {
            this.m_multiLineCommentStart = string;
        }

        public void setMultiLineCommentEnd(String string) {
            this.m_multiLineCommentEnd = string;
        }

        public void setMaxTokens(Integer n) {
            this.m_maxTokens = n;
        }

        public void addTokens(Token.Type type, Collection<String> collection) {
            for (String string : collection) {
                this.m_userTokens.add((Tuple<String, Token.Type>)new Tuple((Object)string, (Object)type));
            }
        }
    }

    public static interface TokenFactory {
        public Token createToken(Token.Type var1, int var2, Token var3);

        public void setEnd(Token var1, int var2);
    }
}

