/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class DelConnCmd
extends MigrationCmd {
    public static final String CMDNAME = "delconn";

    public DelConnCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.m_isPersistenceManagerRequired = false;
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        DelConnCmd.deleteConnection(this.getMigrationDetails().getConnList());
    }

    public static void deleteConnection(String[] stringArray) throws CMDLineError {
        DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
        for (String string : stringArray) {
            try {
                databaseConnections.removeConnection(string);
                databaseConnections.saveConnections();
            }
            catch (ConnectionException connectionException) {
                throw new CMDLineError(CMDNAME, "Problem removing connection", (Exception)((Object)connectionException));
            }
        }
    }
}

