/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectHierarchy;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.DerivativesIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUserDefinedDataType;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllSchemasRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableMasterChildren;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.Messages;
import oracle.dbtools.migration.convert.NoCopyFoundException;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.persistence.MigrDatatypeTransformMap;
import oracle.dbtools.migration.persistence.MigrDatatypeTransformRule;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogPhase;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public final class ConvertUtils {
    private static int MAX_ORACLE_IDENTIFIER_LENGTH = 30;
    private static final String QUERY_FIND_OBJECT_COPY = "SELECT DERIVED_ID FROM MD_DERIVATIVES WHERE SRC_ID = ? AND SRC_TYPE = ? AND DERIVED_TYPE = ? AND DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_FIND_PERSISTABLE_OBJECT_COPY = "SELECT DERIVED_ID, DERIVED_TYPE FROM MD_DERIVATIVES WHERE SRC_ID = ? AND SRC_TYPE = ? AND DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_FIND_PERSISTABLE_OBJECT_ORIGIONAL = "SELECT SRC_ID, SRC_TYPE FROM MD_DERIVATIVES WHERE DERIVED_ID = ? AND DERIVED_TYPE = ? AND DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_FIND_ORIGINAL_OBJECT = "SELECT SRC_ID FROM MD_DERIVATIVES WHERE DERIVED_ID = ? AND SRC_TYPE = ? AND DERIVED_TYPE = ? AND DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_REMOVE_DERIVED_RECORD = "DELETE FROM MD_DERIVATIVES WHERE DERIVED_ID = ? AND DERIVED_TYPE = ? AND DERIVED_CONNECTION_ID_FK =?";
    private static final String QUERY_COALASCED_CATALOGS = "SELECT SRC_TYPE, ORIGINAL_IDENTIFIER, NEW_IDENTIFIER, DERIVED_ID FROM MD_DERIVATIVES WHERE DERIVED_TYPE= 'MD_SCHEMAS' AND DERIVED_CONNECTION_ID_FK = ? ORDER BY DERIVED_ID";
    private static final String QUERY_AUTO_DATAYTPE_CHANGES = "SELECT C.TABLE_NAME, COLUMN_NAME, COLUMN_TYPE, PRECISION, SCALE FROM MD_COLUMNS A, MD_DERIVATIVES B, MD_TABLES C WHERE A.ID = B.DERIVED_ID AND B.DERIVED_TYPE = 'MD_COLUMNS' AND B.DERIVATIVE_REASON = 'INVDTTYPE'  AND C.ID = A.TABLE_ID_FK AND B.DERIVED_CONNECTION_ID_FK =?";
    private static final String QUERY_DROPPED_NCLOB_INDEXES = "SELECT C.TABLE_NAME, A.INDEX_NAME FROM MD_INDEXES A, MD_DERIVATIVES B, MD_TABLES C WHERE A.ID = B.SRC_ID AND B.DERIVATIVE_REASON = 'NCLOBIND' AND C.ID = A.TABLE_ID_FK AND B.DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_DROPPED_DUPLICATE_INDEXES = "SELECT C.TABLE_NAME, A.INDEX_NAME, D.INDEX_NAME, D.ID FROM MD_INDEXES A, MD_DERIVATIVES B, MD_TABLES C, MD_INDEXES D WHERE A.ID = B.SRC_ID AND B.DERIVATIVE_REASON = 'DUPIND' AND C.ID = A.TABLE_ID_FK AND D.ID = B.DERIVED_ID AND B.DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_INDEX_CONSTRAINT_CLASHES = "SELECT A.INDEX_NAME, B.TABLE_NAME  FROM MD_INDEXES A, MD_TABLES B WHERE A.TABLE_ID_FK = B.ID AND A.TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?) AND A.ID NOT IN (SELECT SRC_ID FROM MD_DERIVATIVES WHERE SRC_TYPE = 'MD_INDEXES' AND DERIVED_CONNECTION_ID_FK = ?)";
    private static final String QUERY_NEW_IDENTIFIER = "select new_identifier from md_derivatives where original_identifier = ? and DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_DATATYPE_TRANSFORMRULE = "select source_data_type_name,source_precision,source_scale,target_data_type_name,target_precision,target_scale from migr_datatype_transform_rule where map_id_fk=?";
    private static HashMap<TranslationObjectType, String> s_dbObjectToMDTypeMap;
    private static HashMap<String, TranslationObjectType> s_mdTypeToRosettaTypeMap;

    private ConvertUtils() {
    }

    private static MigrDatatypeTransformRule persistableRule(DBObjectId dBObjectId, DataTypeMappingRule dataTypeMappingRule) {
        DataTypeSpecification dataTypeSpecification = dataTypeMappingRule.getSourceDataType();
        DataTypeSpecification dataTypeSpecification2 = dataTypeMappingRule.getTargetDataType();
        MigrDatatypeTransformRule migrDatatypeTransformRule = new MigrDatatypeTransformRule(dBObjectId, dataTypeSpecification.getName(), dataTypeSpecification2.getName());
        if (dataTypeSpecification.hasPrecision()) {
            migrDatatypeTransformRule.setSourcePrecision(dataTypeSpecification.getPrecision());
            if (dataTypeSpecification.hasScale()) {
                migrDatatypeTransformRule.setSourceScale(dataTypeSpecification.getScale());
            }
        }
        if (dataTypeSpecification2.hasPrecision()) {
            migrDatatypeTransformRule.setTargetPrecision(dataTypeSpecification2.getPrecision());
            if (dataTypeSpecification2.hasScale()) {
                migrDatatypeTransformRule.setTargetScale(dataTypeSpecification2.getScale());
            }
        }
        return migrDatatypeTransformRule;
    }

    private static void removeExistingMap(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = persistenceManager.getPreparedStatement("DELETE FROM MIGR_DATATYPE_TRANSFORM_MAP WHERE PROJECT_ID_FK = ?");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public static void removeDerivedConstraint(PersistenceManager persistenceManager, MdConstraint mdConstraint, DBObjectId dBObjectId) throws PersistenceException {
        DBObjectId dBObjectId2 = mdConstraint.getKey();
        mdConstraint.delete(persistenceManager);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = persistenceManager.getPreparedStatement(QUERY_REMOVE_DERIVED_RECORD);
            preparedStatement.setLong(1, dBObjectId2.getId());
            preparedStatement.setString(2, "MD_CONSTRAINTS");
            preparedStatement.setLong(3, dBObjectId.getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public static DBObjectId persistMap(PersistenceManager persistenceManager, DBObjectId dBObjectId, String string, DataTypeConversionMap dataTypeConversionMap) throws PersistenceException {
        MigrDatatypeTransformMap migrDatatypeTransformMap = new MigrDatatypeTransformMap(dBObjectId);
        migrDatatypeTransformMap.setMapName(string);
        ConvertUtils.removeExistingMap(persistenceManager, dBObjectId);
        migrDatatypeTransformMap.save(persistenceManager);
        for (DataTypeMappingRule dataTypeMappingRule : dataTypeConversionMap.values()) {
            MigrDatatypeTransformRule migrDatatypeTransformRule = ConvertUtils.persistableRule(migrDatatypeTransformMap.getKey(), dataTypeMappingRule);
            migrDatatypeTransformRule.save(persistenceManager);
        }
        return migrDatatypeTransformMap.getKey();
    }

    public static DataTypeConversionMap getDefaultMapFromSupportedMap(SupportedDataTypesMap supportedDataTypesMap) {
        DataTypeSpecification[] dataTypeSpecificationArray = supportedDataTypesMap.getSourceDataTypes();
        DataTypeConversionMap dataTypeConversionMap = new DataTypeConversionMap();
        for (DataTypeSpecification dataTypeSpecification : dataTypeSpecificationArray) {
            DataTypeMappingRule[] dataTypeMappingRuleArray = supportedDataTypesMap.getRulesForDataType(dataTypeSpecification);
            if (dataTypeMappingRuleArray.length <= 0) continue;
            dataTypeConversionMap.addRule(dataTypeMappingRuleArray[0]);
        }
        return dataTypeConversionMap;
    }

    public static DataTypeConversionMap getPersistedMap(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        MdConnection mdConnection;
        DataTypeConversionMap dataTypeConversionMap = new DataTypeConversionMap();
        try {
            mdConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new PersistenceException(noSuchObjectException);
        }
        MigrDatatypeTransformMap migrDatatypeTransformMap = ConvertUtils.getMapForProjectId(persistenceManager, mdConnection.getProjectId());
        if (migrDatatypeTransformMap == null) {
            return dataTypeConversionMap;
        }
        DBObjectId dBObjectId2 = migrDatatypeTransformMap.getKey();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = persistenceManager.getPreparedStatement(QUERY_DATATYPE_TRANSFORMRULE);
            preparedStatement.setLong(1, dBObjectId2.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object6 = resultSet.getInt(2);
                if (resultSet.wasNull()) {
                    object6 = null;
                }
                object5 = resultSet.getInt(3);
                if (resultSet.wasNull()) {
                    object5 = null;
                }
                object4 = resultSet.getInt(5);
                if (resultSet.wasNull()) {
                    object4 = null;
                }
                object3 = resultSet.getInt(6);
                if (resultSet.wasNull()) {
                    object3 = null;
                }
                object2 = new DataTypeSpecification(resultSet.getString(1), (Integer)object6, (Integer)object5);
                object = new DataTypeSpecification(resultSet.getString(4), (Integer)object4, (Integer)object3);
                dataTypeConversionMap.addOrReplaceRule(new DataTypeMappingRule((DataTypeSpecification)object2, (DataTypeSpecification)object));
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        try {
            object6 = PersistenceUtility.getInstance(persistenceManager);
            object5 = ((PersistenceUtility)object6).getSchemasForConnectionId(mdConnection.getKey());
            while (object5.hasNext()) {
                object4 = (MgvAllSchemasRec)object5.next();
                object3 = ((MgvAllSchemasRec)object4).getSchemaId();
                object2 = new PersistableMasterChildren(MdUserDefinedDataType.class, "SCHEMA_ID_FK", (DBObjectId)object3, persistenceManager, null);
                while (object2.hasNext()) {
                    object = (MdUserDefinedDataType)object2.next();
                    DataTypeSpecification dataTypeSpecification = new DataTypeSpecification(((MdUserDefinedDataType)object).getDataTypeName(), null, null);
                    DataTypeSpecification dataTypeSpecification2 = ConvertUtils.getUDTSpec(((MdUserDefinedDataType)object).getDefinition());
                    DataTypeSpecification dataTypeSpecification3 = dataTypeConversionMap.mapDataType(dataTypeSpecification2);
                    dataTypeConversionMap.addUDTRule(new DataTypeMappingRule(dataTypeSpecification, dataTypeSpecification3));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataTypeConversionMap;
    }

    private static DataTypeSpecification getUDTSpec(String string) {
        DataTypeSpecification dataTypeSpecification = null;
        if (string == null || string.trim().equals("")) {
            return new DataTypeSpecification(string, null, null);
        }
        try {
            int n = string.indexOf(40);
            int n2 = string.indexOf(44);
            dataTypeSpecification = n == -1 ? new DataTypeSpecification(string.trim(), null, null) : (n2 == -1 ? new DataTypeSpecification(string.substring(0, n).trim(), new Integer(string.substring(n, string.length() - 1).trim()), null) : new DataTypeSpecification(string.substring(0, n).trim(), new Integer(string.substring(n + 1, n2).trim()), new Integer(string.substring(n2 + 1, string.length() - 1).trim())));
        }
        catch (Exception exception) {
            dataTypeSpecification = new DataTypeSpecification(string.trim(), null, null);
        }
        return dataTypeSpecification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MigrDatatypeTransformMap getMapForProjectId(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException {
        MigrDatatypeTransformMap migrDatatypeTransformMap = null;
        try (PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MigrDatatypeTransformMap.class, "PROJECT_ID_FK", dBObjectId, persistenceManager, null);){
            if (persistableMasterChildren.hasNext()) {
                migrDatatypeTransformMap = (MigrDatatypeTransformMap)persistableMasterChildren.next();
            }
        }
        return migrDatatypeTransformMap;
    }

    public static String getClobAsString(ClobHelper clobHelper) throws IOException {
        if (clobHelper == null) {
            return null;
        }
        if (clobHelper.getLength() == 0L) {
            return "";
        }
        if (clobHelper.getLength() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(Messages.getString("ConvertUtils.28"));
        }
        Reader reader = clobHelper.getReader();
        CharBuffer charBuffer = CharBuffer.allocate((int)clobHelper.getLength());
        reader.read(charBuffer);
        reader.close();
        charBuffer.rewind();
        return charBuffer.toString();
    }

    public static TranslationDBObject asDBObject(String string, String string2, String string3, MdView mdView) throws IOException {
        ClobHelper clobHelper = mdView.getNativeSql();
        String string4 = ConvertUtils.getClobAsString(clobHelper);
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(string, string2, string3, mdView.getViewName(), null, TranslationObjectType.VIEW_TYPE, (Object)mdView);
        TranslationDBObject translationDBObject = new TranslationDBObject(translationDBObjectReference, string4);
        return translationDBObject;
    }

    public static TranslationDBObject asTranslationDBObject(PersistableObject persistableObject, PersistenceManager persistenceManager) throws IOException {
        if (persistableObject == null) {
            return null;
        }
        DBObjectHierarchy dBObjectHierarchy = new DBObjectHierarchy(persistableObject, persistenceManager);
        if (persistableObject.getObjectType().equalsIgnoreCase("MD_STORED_PROGRAMS")) {
            return ConvertUtils.asDBObject(dBObjectHierarchy.getConnection().getHost(), dBObjectHierarchy.getCatalog().getCatalogName(), dBObjectHierarchy.getSchema().getName(), (MdStoredProgram)dBObjectHierarchy.getObject());
        }
        if (persistableObject.getObjectType().equalsIgnoreCase("MD_TRIGGERS")) {
            return ConvertUtils.asTranslationDBObject(dBObjectHierarchy.getConnection().getHost(), dBObjectHierarchy.getCatalog().getCatalogName(), dBObjectHierarchy.getSchema().getName(), (MdTrigger)dBObjectHierarchy.getPart());
        }
        if (persistableObject.getObjectType().equalsIgnoreCase("MD_VIEWS")) {
            return ConvertUtils.asDBObject(dBObjectHierarchy.getConnection().getHost(), dBObjectHierarchy.getCatalog().getCatalogName(), dBObjectHierarchy.getSchema().getName(), (MdView)dBObjectHierarchy.getObject());
        }
        if (persistableObject.getObjectType().equalsIgnoreCase("MD_CONSTRAINTS")) {
            return ConvertUtils.asDBObject(dBObjectHierarchy.getConnection().getHost(), dBObjectHierarchy.getCatalog().getCatalogName(), dBObjectHierarchy.getSchema().getName(), (MdConstraint)dBObjectHierarchy.getPart(), persistenceManager);
        }
        return null;
    }

    public static ClobHelper getClobHelper(PersistableObject persistableObject) {
        ClobHelper clobHelper = null;
        if (persistableObject instanceof MdStoredProgram) {
            clobHelper = ((MdStoredProgram)persistableObject).getNativeSql();
        } else if (persistableObject instanceof MdView) {
            clobHelper = ((MdView)persistableObject).getNativeSql();
        } else if (persistableObject instanceof MdTrigger) {
            clobHelper = ((MdTrigger)persistableObject).getNativeSql();
        }
        return clobHelper;
    }

    public static TranslationDBObject asDBObject(String string, String string2, String string3, PersistableObject persistableObject) throws IOException {
        String string4 = ConvertUtils.getClobAsString(ConvertUtils.getClobHelper(persistableObject));
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(string, string2, string3, persistableObject.getObjectName(), null, TranslationObjectType.PROCEDURE_TYPE, (Object)persistableObject);
        TranslationDBObject translationDBObject = new TranslationDBObject(translationDBObjectReference, string4);
        return translationDBObject;
    }

    public static TranslationDBObject asTranslationDBObject(String string, String string2, String string3, MdTrigger mdTrigger) throws IOException {
        ClobHelper clobHelper = mdTrigger.getNativeSql();
        String string4 = ConvertUtils.getClobAsString(clobHelper);
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(string, string2, string3, mdTrigger.getTriggerName(), null, TranslationObjectType.TRIGGER_TYPE, (Object)mdTrigger);
        TranslationDBObject translationDBObject = new TranslationDBObject(translationDBObjectReference, string4);
        return translationDBObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TranslationDBObject asDBObject(String string, String string2, String string3, MdConstraint mdConstraint, PersistenceManager persistenceManager) throws IOException {
        MdConstraintDetail mdConstraintDetail;
        PersistenceUtility persistenceUtility;
        String string4 = "";
        String string5 = "";
        ClobHelper clobHelper = mdConstraint.getConstraintText();
        try (CloseableIterator closeableIterator = null;){
            persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
            closeableIterator = persistenceUtility.getConstraintDetails(mdConstraint.getKey());
            if (clobHelper == null && closeableIterator.hasNext()) {
                mdConstraintDetail = (MdConstraintDetail)closeableIterator.next();
                clobHelper = mdConstraintDetail.getConstraintText();
            }
            MdTable mdTable = MdTable.retrieveExistingInstance(persistenceManager, mdConstraint.getTableId());
            string5 = mdTable.getTableName();
        }
        string4 = ConvertUtils.getClobAsString(clobHelper);
        persistenceUtility = new TranslationDBObjectReference(string, string2, string3, string5, mdConstraint.getObjectName(), TranslationObjectType.CONSTRAINT_TYPE, (Object)mdConstraint);
        mdConstraintDetail = new TranslationDBObject((TranslationDBObjectReference)persistenceUtility, string4);
        return mdConstraintDetail;
    }

    public static String getMDType(TranslationObjectType translationObjectType) {
        return ConvertUtils.getDBObjectToMDTypeMap().get(translationObjectType);
    }

    public static TranslationObjectType getRosettaType(String string) {
        return ConvertUtils.getMdTypeToRosettaTypeMap().get(string);
    }

    private static HashMap<TranslationObjectType, String> getDBObjectToMDTypeMap() {
        if (s_dbObjectToMDTypeMap == null) {
            ConvertUtils.populateMaps();
        }
        return s_dbObjectToMDTypeMap;
    }

    private static HashMap<String, TranslationObjectType> getMdTypeToRosettaTypeMap() {
        if (s_mdTypeToRosettaTypeMap == null) {
            ConvertUtils.populateMaps();
        }
        return s_mdTypeToRosettaTypeMap;
    }

    private static void populateMaps() {
        ConvertUtils.addToMaps(TranslationObjectType.CONSTRAINT_TYPE, "MD_CONSTRAINTS");
        ConvertUtils.addToMaps(TranslationObjectType.DATABASE_TYPE, "MD_CATALOGS");
        ConvertUtils.addToMaps(TranslationObjectType.FUNCTION_TYPE, "MD_STORED_PROGRAMS");
        ConvertUtils.addToMaps(TranslationObjectType.GROUP_TYPE, "MD_GROUPS");
        ConvertUtils.addToMaps(TranslationObjectType.INDEX_TYPE, "MD_INDEXES");
        ConvertUtils.addToMaps(TranslationObjectType.OTHEROBJECT_TYPE, "MD_OTHER_OBJECTS");
        ConvertUtils.addToMaps(TranslationObjectType.PACKAGE_TYPE, "MD_PACKAGES");
        ConvertUtils.addToMaps(TranslationObjectType.PRIVILEGE_TYPE, "MD_PRIVILEGES");
        ConvertUtils.addToMaps(TranslationObjectType.PROCEDURE_TYPE, "MD_STORED_PROGRAMS");
        ConvertUtils.addToMaps(TranslationObjectType.SCHEMA_TYPE, "MD_SCHEMAS");
        ConvertUtils.addToMaps(TranslationObjectType.SEQUENCE_TYPE, "MD_SEQUENCES");
        ConvertUtils.addToMaps(TranslationObjectType.SYNONYM_TYPE, "MD_SYNONYMS");
        ConvertUtils.addToMaps(TranslationObjectType.TABLE_TYPE, "MD_TABLES");
        ConvertUtils.addToMaps(TranslationObjectType.TABLESPACE_TYPE, "MD_TABLESPACES");
        ConvertUtils.addToMaps(TranslationObjectType.TRIGGER_TYPE, "MD_TRIGGERS");
        ConvertUtils.addToMaps(TranslationObjectType.USER_TYPE, "MD_USERS");
        ConvertUtils.addToMaps(TranslationObjectType.USERDATATYPE_TYPE, "MD_USER_DEFINED_DATA_TYPES");
        ConvertUtils.addToMaps(TranslationObjectType.VIEW_TYPE, "MD_VIEWS");
    }

    private static void addToMaps(TranslationObjectType translationObjectType, String string) {
        if (s_dbObjectToMDTypeMap == null) {
            s_dbObjectToMDTypeMap = new HashMap();
        }
        if (s_mdTypeToRosettaTypeMap == null) {
            s_mdTypeToRosettaTypeMap = new HashMap();
        }
        s_dbObjectToMDTypeMap.put(translationObjectType, string);
        s_mdTypeToRosettaTypeMap.put(string, translationObjectType);
    }

    public static DBObjectId findObjectCopy(PersistenceManager persistenceManager, DBObjectId dBObjectId, String string, DBObjectId dBObjectId2) throws SQLException {
        return ConvertUtils.runFindQuery(persistenceManager, dBObjectId, string, dBObjectId2, QUERY_FIND_OBJECT_COPY);
    }

    public static PersistableObject findPersistableCopy(PersistenceManager persistenceManager, PersistableObject persistableObject, DBObjectId dBObjectId) throws SQLException, PersistenceException, NoSuchObjectException {
        return ConvertUtils.runPOQuery(persistenceManager, persistableObject.getKey(), persistableObject.getObjectType(), dBObjectId, QUERY_FIND_PERSISTABLE_OBJECT_COPY);
    }

    public static PersistableObject findPersistableOrigional(PersistenceManager persistenceManager, PersistableObject persistableObject, DBObjectId dBObjectId) throws SQLException, PersistenceException, NoSuchObjectException {
        return ConvertUtils.runPOQuery(persistenceManager, persistableObject.getKey(), persistableObject.getObjectType(), dBObjectId, QUERY_FIND_PERSISTABLE_OBJECT_ORIGIONAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistableObject runPOQuery(PersistenceManager persistenceManager, DBObjectId dBObjectId, String string, DBObjectId dBObjectId2, String string2) throws SQLException, PersistenceException, NoSuchObjectException {
        PersistableObject persistableObject = null;
        try (CloseableResultSet closeableResultSet = null;){
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(string2);
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            preparedStatement.setLong(3, dBObjectId2.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
            if (resultSet.next()) {
                DBObjectId dBObjectId3 = new DBObjectId(resultSet.getLong(1));
                String string3 = resultSet.getString(2);
                persistableObject = persistenceUtility.loadPersistableObject(dBObjectId3, string3);
            }
        }
        return persistableObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DBObjectId runFindQuery(PersistenceManager persistenceManager, DBObjectId dBObjectId, String string, DBObjectId dBObjectId2, String string2) throws SQLException {
        DBObjectId dBObjectId3 = null;
        try (CloseableResultSet closeableResultSet = null;){
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(string2);
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string);
            preparedStatement.setLong(4, dBObjectId2.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            if (resultSet.next()) {
                dBObjectId3 = new DBObjectId(resultSet.getLong(1));
            }
        }
        return dBObjectId3;
    }

    public static DBObjectId findOriginalObject(PersistenceManager persistenceManager, DBObjectId dBObjectId, String string, DBObjectId dBObjectId2) throws SQLException {
        return ConvertUtils.runFindQuery(persistenceManager, dBObjectId, string, dBObjectId2, QUERY_FIND_ORIGINAL_OBJECT);
    }

    public static MdView findViewCopy(MdView mdView, PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId dBObjectId2 = ConvertUtils.findObjectCopy(persistenceManager, mdView.getKey(), "MD_VIEWS", dBObjectId);
            if (dBObjectId2 == null) {
                throw new NoCopyFoundException("MD_VIEWS", mdView);
            }
            MdView mdView2 = MdView.retrieveExistingInstance(persistenceManager, dBObjectId2);
            return mdView2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public static MdTable findOriginalTable(MdTable mdTable, PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId dBObjectId2 = ConvertUtils.findOriginalObject(persistenceManager, mdTable.getKey(), "MD_TABLES", dBObjectId);
            if (dBObjectId2 == null) {
                throw new NoCopyFoundException("MD_TABLES", mdTable);
            }
            MdTable mdTable2 = MdTable.retrieveExistingInstance(persistenceManager, dBObjectId2);
            return mdTable2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public static MdConnection findOriginalConnection(MdConnection mdConnection, PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId dBObjectId2 = ConvertUtils.findOriginalObject(persistenceManager, mdConnection.getKey(), "MD_CONNECTIONS", dBObjectId);
            if (dBObjectId2 == null) {
                throw new NoCopyFoundException("MD_CONNECTIONS", mdConnection);
            }
            MdConnection mdConnection2 = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId2);
            return mdConnection2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public static MdConstraint findConstraintCopy(MdConstraint mdConstraint, PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId dBObjectId2 = ConvertUtils.findObjectCopy(persistenceManager, mdConstraint.getKey(), "MD_CONSTRAINTS", dBObjectId);
            if (dBObjectId2 == null) {
                throw new NoCopyFoundException("MD_CONSTRAINTS", mdConstraint);
            }
            MdConstraint mdConstraint2 = MdConstraint.retrieveExistingInstance(persistenceManager, dBObjectId2);
            return mdConstraint2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public static MdConstraint findOriginalConstraint(MdConstraint mdConstraint, PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId dBObjectId2 = ConvertUtils.findOriginalObject(persistenceManager, mdConstraint.getKey(), "MD_CONSTRAINTS", dBObjectId);
            if (dBObjectId2 == null) {
                throw new NoCopyFoundException("MD_CONSTRAINTS", mdConstraint);
            }
            MdConstraint mdConstraint2 = MdConstraint.retrieveExistingInstance(persistenceManager, dBObjectId2);
            return mdConstraint2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public static MdStoredProgram findProgramCopy(MdStoredProgram mdStoredProgram, PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId dBObjectId2 = ConvertUtils.findObjectCopy(persistenceManager, mdStoredProgram.getKey(), "MD_STORED_PROGRAMS", dBObjectId);
            if (dBObjectId2 == null) {
                throw new NoCopyFoundException("MD_STORED_PROGRAMS", mdStoredProgram);
            }
            MdStoredProgram mdStoredProgram2 = MdStoredProgram.retrieveExistingInstance(persistenceManager, dBObjectId2);
            return mdStoredProgram2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public static MdTrigger findTriggerCopy(MdTrigger mdTrigger, PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId dBObjectId2 = ConvertUtils.findObjectCopy(persistenceManager, mdTrigger.getKey(), "MD_TRIGGERS", dBObjectId);
            if (dBObjectId2 == null) {
                throw new NoCopyFoundException("MD_TRIGGERS", mdTrigger);
            }
            MdTrigger mdTrigger2 = MdTrigger.retrieveExistingInstance(persistenceManager, dBObjectId2);
            return mdTrigger2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public static String generateName(String string) {
        if (string.length() > ConvertUtils.getMaxOracleIdentifierLength()) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 12));
            String string2 = ConvertUtils.randomChars(6);
            stringBuffer.append(string2);
            stringBuffer.append(string.substring(string.length() - 12, string.length()));
            return stringBuffer.toString();
        }
        return string;
    }

    private static String randomChars(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = (int)(Math.random() * 26.0);
            boolean bl2 = bl = (int)(Math.random() * 10000.0) % 2 == 0;
            if (bl) {
                stringBuffer.append((char)(65 + n2));
                continue;
            }
            stringBuffer.append((char)(97 + n2));
        }
        return stringBuffer.toString();
    }

    public static CoalescedSchemaInfo[] getCoalascedSchema(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long l = -1L;
        ArrayList<CoalescedSchemaInfo> arrayList = new ArrayList<CoalescedSchemaInfo>();
        CoalescedSchemaInfo coalescedSchemaInfo = new CoalescedSchemaInfo();
        try {
            preparedStatement = persistenceManager.getPreparedStatement(QUERY_COALASCED_CATALOGS);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string;
                long l2 = resultSet.getLong(4);
                if (l != -1L) {
                    if (l2 != l) {
                        arrayList.add(coalescedSchemaInfo);
                        coalescedSchemaInfo = new CoalescedSchemaInfo();
                        l = l2;
                    }
                } else {
                    l = l2;
                }
                if ((string = resultSet.getString(1)).equals("MD_CATALOGS")) {
                    coalescedSchemaInfo.m_originalCatalogName = resultSet.getString(2);
                    coalescedSchemaInfo.m_derivedSchemaName = resultSet.getString(3);
                    continue;
                }
                coalescedSchemaInfo.m_originalSchemaName = resultSet.getString(2);
            }
            if (l != -1L) {
                arrayList.add(coalescedSchemaInfo);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return arrayList.toArray(new CoalescedSchemaInfo[arrayList.size()]);
    }

    public static DerivativesIterator getTransformedIdentifiers(PersistenceManager persistenceManager, DBObjectId dBObjectId) {
        String string = "DERIVED_TYPE != 'MD_CATALOGS' AND DERIVED_TYPE != 'MD_CONNECTIONS' AND DERIVED_TYPE != 'MD_SCHEMAS' AND NEW_IDENTIFIER != ORIGINAL_IDENTIFIER";
        return new DerivativesIterator(persistenceManager, dBObjectId, string);
    }

    public static String toDataTypeString(String string, Integer n, Integer n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (n != null && n != 0) {
            stringBuilder.append('(');
            stringBuilder.append(n);
            if (n2 != null && n2 != 0) {
                stringBuilder.append(", ");
                stringBuilder.append(n2);
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static void logDroppedIndexesConstraintClash(PersistenceManager persistenceManager, DBObjectId dBObjectId, DBObjectId dBObjectId2, Logger logger) throws PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = persistenceManager.getPreparedStatement(QUERY_INDEX_CONSTRAINT_CLASHES);
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setLong(2, dBObjectId2.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                logger.log(Level.INFO, "Convert.DROPPEDCONSTRAINTINDEX", new Object[]{string, string2});
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
    }

    public static void logRemovedDuplicateIndexes(PersistenceManager persistenceManager, DBObjectId dBObjectId, Logger logger) throws PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = persistenceManager.getPreparedStatement(QUERY_DROPPED_DUPLICATE_INDEXES);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                long l = resultSet.getLong(4);
                MdIndexe mdIndexe = null;
                try {
                    mdIndexe = MdIndexe.retrieveExistingInstance(persistenceManager, new DBObjectId(l));
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    MigrationLogUtil.logThrowable(Messages.getString("ConvertUtils.33") + string3, Messages.getString("ConvertUtils.34"), (Throwable)noSuchObjectException);
                }
                logger.log(Level.INFO, "Convert.DROPPEDDUPLICATEINDEX", new Object[]{string2, string, string3, new ClickableLogInfo(mdIndexe, Messages.getString("ConvertUtils.36"))});
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
    }

    public static void logDroppedNClobIndexes(PersistenceManager persistenceManager, DBObjectId dBObjectId, Logger logger) throws PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = persistenceManager.getPreparedStatement(QUERY_DROPPED_NCLOB_INDEXES);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                logger.log(Level.INFO, "Convert.NCLOBINDEXDROPPED", new Object[]{string, string2});
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
    }

    public static void logAutoChangedDataTypes(PersistenceManager persistenceManager, DBObjectId dBObjectId, Logger logger) throws PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = persistenceManager.getPreparedStatement(QUERY_AUTO_DATAYTPE_CHANGES);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                Integer n = new Integer(resultSet.getInt(4));
                if (resultSet.wasNull()) {
                    n = null;
                }
                Integer n2 = new Integer(resultSet.getInt(5));
                if (resultSet.wasNull()) {
                    n2 = null;
                }
                logger.log(Level.INFO, "Convert.DATATYPECHANGED", new Object[]{string, string2, ConvertUtils.toDataTypeString(string3, n, n2)});
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
    }

    public static String getChangedIdentifierName(String string, PersistenceManager persistenceManager, DBObjectId dBObjectId) {
        String string2 = null;
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(QUERY_NEW_IDENTIFIER);
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            string2 = resultSet.getString(1);
            if (resultSet.wasNull()) {
                string2 = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string2;
    }

    public static String getChangedIdentifierNameExceptConn(String string, PersistenceManager persistenceManager, DBObjectId dBObjectId) {
        String string2 = null;
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement("select new_identifier from md_derivatives where original_identifier = ? and DERIVED_CONNECTION_ID_FK = ? and derived_type <> 'MD_CONNECTIONS'");
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            string2 = resultSet.getString(1);
            if (resultSet.wasNull()) {
                string2 = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string2;
    }

    public static int getMaxOracleIdentifierLength() {
        if (MigrationConfig.getInstance((PropertyStorage)Preferences.getPreferences()).isOracle128ByteIdentifier()) {
            MAX_ORACLE_IDENTIFIER_LENGTH = 128;
            return 128;
        }
        return 30;
    }

    public static class CoalescedSchemaInfo {
        public String m_originalSchemaName;
        public String m_originalCatalogName;
        public String m_derivedSchemaName;

        public Object[] getDataAsObjectArray() {
            return new Object[]{this.m_originalCatalogName, this.m_originalSchemaName, this.m_derivedSchemaName, MigrationLogPhase.CONVERT};
        }
    }
}

