/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;

public class TableMetaData {
    private MdTable m_table;
    private ArrayList<MdColumn> m_columns;
    private ArrayList<MdConstraint> m_constraints;

    public TableMetaData(MdTable mdTable) {
        this(mdTable, null);
    }

    public TableMetaData(MdTable mdTable, MdColumn[] mdColumnArray) {
        this.setTable(mdTable);
        this.m_columns = new ArrayList();
        this.m_constraints = new ArrayList();
        if (mdColumnArray != null) {
            for (MdColumn mdColumn : mdColumnArray) {
                this.m_columns.add(mdColumn);
            }
        }
    }

    protected void setTable(MdTable mdTable) {
        this.m_table = mdTable;
    }

    public MdTable getTable() {
        return this.m_table;
    }

    public void addColumn(MdColumn mdColumn) {
        this.m_columns.add(mdColumn);
    }

    public void addConstraint(MdConstraint mdConstraint) {
        this.m_constraints.add(mdConstraint);
    }

    public MdColumn[] getColumns() {
        return this.m_columns.toArray(new MdColumn[this.m_columns.size()]);
    }

    public MdConstraint[] getConstraints() {
        return this.m_constraints.toArray(new MdConstraint[this.m_constraints.size()]);
    }

    public void loadUpDetails(PersistenceUtility persistenceUtility) throws PersistenceException {
        Object object;
        CloseableIterator closeableIterator = persistenceUtility.getColumnsForTableId(this.m_table.getKey());
        while (closeableIterator.hasNext()) {
            object = (MdColumn)closeableIterator.next();
            this.addColumn((MdColumn)object);
        }
        object = persistenceUtility.getConstraintsForTableId(this.m_table.getKey());
        while (object.hasNext()) {
            MdConstraint mdConstraint = (MdConstraint)object.next();
            this.addConstraint(mdConstraint);
        }
    }
}

