/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MigrGenerationOrder
extends PersistableObject {
    public static final String TABLE_NAME = "MIGR_GENERATION_ORDER";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";
    public static final String COLNAME_OBJECT_ID = "OBJECT_ID";
    public static final String COLNAME_OBJECT_TYPE = "OBJECT_TYPE";
    public static final String COLNAME_GENERATION_ORDER = "GENERATION_ORDER";

    public MigrGenerationOrder(DBObjectId dBObjectId, DBObjectId dBObjectId2, String string, Integer n) {
        this.setConnectionId(dBObjectId);
        this.setObjectId(dBObjectId2);
        this.setObjectType(string);
        this.setGenerationOrder(n);
    }

    public static MigrGenerationOrder getExistingInstance(DBObjectId dBObjectId) {
        MigrGenerationOrder migrGenerationOrder = new MigrGenerationOrder();
        migrGenerationOrder.setKey(dBObjectId);
        return migrGenerationOrder;
    }

    private MigrGenerationOrder() {
    }

    public static MigrGenerationOrder retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MigrGenerationOrder migrGenerationOrder = MigrGenerationOrder.getExistingInstance(dBObjectId);
        migrGenerationOrder.retrieve(persistenceManager);
        return migrGenerationOrder;
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setObjectId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_OBJECT_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setObjectType(String string) {
        Field field = new Field(COLNAME_OBJECT_TYPE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setGenerationOrder(Integer n) {
        Field field = new Field(COLNAME_GENERATION_ORDER, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public DBObjectId getConnectionId() {
        Field field = this.getField(COLNAME_CONNECTION_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public DBObjectId getObjectId() {
        Field field = this.getField(COLNAME_OBJECT_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    @Override
    public String getObjectType() {
        Field field = this.getField(COLNAME_OBJECT_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getGenerationOrder() {
        Field field = this.getField(COLNAME_GENERATION_ORDER);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setConnectionId(new DBObjectId(resultSet.getLong(COLNAME_CONNECTION_ID_FK)));
            this.setObjectId(new DBObjectId(resultSet.getLong(COLNAME_OBJECT_ID)));
            this.setObjectType(resultSet.getString(COLNAME_OBJECT_TYPE));
            this.setGenerationOrder(resultSet.getInt(COLNAME_GENERATION_ORDER));
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

