/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Collections;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.FullMigrateTaskUI;
import oracle.dbtools.migration.workbench.core.ui.FullMigrationChoiceDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.MessageDialog;

public class FullMigrateInitiator
extends AbstractMenuAction {
    public void launch() {
        String string = null;
        DBObject dBObject = this.getDBObject();
        if (dBObject != null) {
            string = dBObject.getConnectionName();
        }
        final FullMigrationChoiceDialog fullMigrationChoiceDialog = new FullMigrationChoiceDialog((Frame)Ide.getMainWindow(), string);
        fullMigrationChoiceDialog.pack();
        Dimension dimension = fullMigrationChoiceDialog.getSize();
        dimension.height += 50;
        fullMigrationChoiceDialog.setSize(dimension);
        fullMigrationChoiceDialog.setPreferredSize(dimension);
        fullMigrationChoiceDialog.setMinimumSize(dimension);
        boolean bl = WizardLauncher.runDialog((JDialog)((Object)fullMigrationChoiceDialog));
        if (!bl) {
            fullMigrationChoiceDialog.resetChecker();
            return;
        }
        MigrationPlugin migrationPlugin = fullMigrationChoiceDialog.getPlugin();
        if (migrationPlugin == null) {
            return;
        }
        try {
            RaptorTask raptorTask = null;
            final FullMigrateTaskUI fullMigrateTaskUI = null;
            try {
                raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    void cleanup() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                fullMigrationChoiceDialog.resetChecker();
                            }
                        });
                    }

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                        this.cleanup();
                    }

                    public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                        this.cleanup();
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        this.cleanup();
                    }
                });
                RaptorTaskManager.getInstance().addTask(raptorTask, Collections.singletonList(new ITaskViewer(){

                    public void addTaskUI(ITaskUI iTaskUI) {
                    }

                    public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                        return fullMigrateTaskUI;
                    }

                    public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                        return this.getTaskUI(raptorTaskDescriptor);
                    }

                    public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                    }

                    public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                    }

                    public void removeTaskUI(ITaskUI iTaskUI) {
                    }
                }));
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), Messages.getString("FullMigrateInitiator.0"), (Throwable)exception);
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("QM_ERROR_PLUGINEXCEPTION_MSG"), (String)MigrationAddinArb.getString("QM_ERROR_PLUGINEXCEPTION_TITLE"), (String)"help_migration_plugin_exception");
            MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), Messages.getString("FullMigrateInitiator.2"), (Throwable)exception);
            return;
        }
    }

    public void setArgs(String string) {
    }
}

