/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.db.DBException;

public class IncrementalCaptureController
implements Controller {
    public static final String INCREMENTAL_FLAG = "INCREMENTAL";

    public boolean handleEvent(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        ObjectAction objectAction = (ObjectAction)ideAction.getValue("ObjectAction.KEY");
        objectAction.getAction().setEnabled(false);
        objectAction.getMenuItem().setEnabled(false);
        String string = (String)context.getProperty("ObjectAction.CONN_NAME");
        if (string == null) {
            string = (String)context.getProperty("Connections.db_name");
        }
        if (string != null) {
            try {
                Connection connection = Connections.getInstance().getConnection(string);
                String string2 = connection.getMetaData().getURL();
                MigrationConnectionNode[] migrationConnectionNodeArray = CapturedDatabases.getInstance().findMatchingConnections(string2);
                if (migrationConnectionNodeArray.length > 0) {
                    objectAction.getAction().setEnabled(true);
                    objectAction.getMenuItem().setEnabled(true);
                    objectAction.setClassArgs(INCREMENTAL_FLAG);
                }
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return true;
    }
}

