/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.capture.CaptureCmd;
import oracle.dbtools.migration.capture.ListCapturedModelsCmd;
import oracle.dbtools.migration.command_line.DelCapturedCmd;
import oracle.dbtools.migration.command_line.DelConnCmd;
import oracle.dbtools.migration.command_line.DelConvertedCmd;
import oracle.dbtools.migration.command_line.DriverCmd;
import oracle.dbtools.migration.command_line.InfoCmd;
import oracle.dbtools.migration.command_line.InitCmd;
import oracle.dbtools.migration.command_line.ListConnCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MkConnCmd;
import oracle.dbtools.migration.command_line.QMCmd;
import oracle.dbtools.migration.command_line.RunSQLCmd;
import oracle.dbtools.migration.command_line.TranslateCmd;
import oracle.dbtools.migration.convert.ConvertCmd;
import oracle.dbtools.migration.convert.ListConvertedModelsCmd;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveCmd;
import oracle.dbtools.migration.generate.GenerateCmd;
import oracle.dbtools.migration.identifierMapping.IdentifierMappingCmd;
import oracle.dbtools.migration.workbench.core.ConnectionAwareDrillLink;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationCmdHook;
import oracle.dbtools.migration.workbench.core.MigrationDrillLink;
import oracle.dbtools.migration.workbench.core.MigrationHook;
import oracle.dbtools.migration.workbench.core.MigrationMenuManager;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryManager;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;
import oracle.dbtools.migration.workbench.core.PluginDescriptor;
import oracle.dbtools.migration.workbench.core.WizardDrillLink;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogPersistenceHandler;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.ConnectionsAdapter;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.celleditor.drilllinks.DrillLinkRegistry;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;

public class MigrationAddin
implements Addin {
    public static final Icon migrationIcon = MigrationAddinArb.getIcon("MIGRATION_ICON");
    public static Object s_lock = new Object();
    public static final String DATE_DELIMITER = "@";
    public static final String MIGRATION_MENU_ID = "MigrationMenu";
    public static final String ACTION_OFFLINE_DATA_MOVE = "MigrationOfflineDataMove";
    public static final String ACTION_DATA_MOVE = "MigrationDataMove";
    public static final String ACTION_QUICK_MIGRATE = "MigrationQuickMigrate";
    public static final String ACTION_DISCONNECT_REPO = "DisconnectMigrationRepository";
    public static final String ACTION_GENERATE_ORACLE_SCRIPTS = "GenerateOracleScripts";
    public static final String ACTION_CREATE_REPOSITORY = "CreateRepository";
    public static final String ACTION_DELETE_REPOSITORY = "DropRepository";
    public static final String ACTION_TRUNCATE_REPO = "TruncateRepository";
    public static final String ACTION_CREATE_OFFLINE_SCRIPTS = "CreateOfflineScripts";
    public static final String ACTION_READ_OFFLINE_OUTPUT = "ReadOfflineOutput";
    private static Map<String, PluginDescriptor> s_loadedPlugins = new HashMap<String, PluginDescriptor>();
    private static MigrationMenuManager s_migrationMenuManager;
    private static MigrationRepositoryManager s_repositoryManager;
    private static MigrationConfig s_migrationConfig;
    private static ConfigurationData s_configData;
    private static List<MigrationRepositoryStateListener> s_repositoryListeners;
    private static NavigatorWindow _navWindow;
    private static Logger m_logger;

    public static String removeSpaces(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            stringBuilder.append(stringTokenizer.nextToken());
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public static void registerPlugin(PluginDescriptor pluginDescriptor) {
        String string = pluginDescriptor.getClassName();
        if (!s_loadedPlugins.containsKey(string)) {
            s_loadedPlugins.put(string, pluginDescriptor);
        }
    }

    public void initialize() {
        this.registerDrillLinks();
        this.registerCmdLineActions();
        this.createConnectionsAdapter();
        this.registerLogHandlers();
        MigrationHook.getInstance();
        MigrationCmdHook.getInstance();
    }

    private void registerDrillLinks() {
        DrillLinkRegistry.getInstance().registerDrillLink(MigrationDrillLink.class);
        DrillLinkRegistry.getInstance().registerDrillLink(WizardDrillLink.class);
        DrillLinkRegistry.getInstance().registerDrillLink(ConnectionAwareDrillLink.class);
    }

    private void registerCmdLineActions() {
        MigrationCmdRegistry.registerMigrationCmd("capture", CaptureCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("qm", QMCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("convert", ConvertCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("idmap", IdentifierMappingCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("lscaptured", ListCapturedModelsCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("lsconverted", ListConvertedModelsCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("lsconn", ListConnCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("mkconn", MkConnCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("delconn", DelConnCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("delconverted", DelConvertedCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("delcaptured", DelCapturedCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("generate", GenerateCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("runsql", RunSQLCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("datamove", OfflineDataMoveCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("driver", DriverCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("init", InitCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("info", InfoCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("translate", TranslateCmd.class);
    }

    private void createConnectionsAdapter() {
        Connections.getInstance().addConnectionListener((ConnectionListener)new ConnectionsAdapter());
    }

    private void registerLogHandlers() {
        m_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle", "oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        Formatter formatter = new Formatter(){

            @Override
            public synchronized String format(LogRecord logRecord) {
                String string = this.formatMessage(logRecord);
                Object[] objectArray = logRecord.getParameters();
                List<LogInfo> list = MigrationLogUtil.searchParameterByType(objectArray, LogInfo.class);
                if (list.size() == 0) {
                    list = new ArrayList<LogInfo>(1);
                    list.add(new LogInfo(""));
                    if (objectArray == null) {
                        logRecord.setParameters(list.toArray());
                    } else {
                        Object[] objectArray2 = new Object[objectArray.length + 1];
                        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                        objectArray2[objectArray2.length - 1] = list.get(0);
                        logRecord.setParameters(objectArray2);
                    }
                }
                if (list.size() > 0 && MigrationLogUtil.getCurrentSession() != null) {
                    list.get(0).addSupplementaryInfo(new Object[]{"MigrationConnectionId", MigrationLogUtil.getCurrentSession()});
                }
                return string;
            }
        };
        m_logger.setUseParentHandlers(false);
        m_logger.setLevel(Level.INFO);
        MigrationLogPersistenceHandler migrationLogPersistenceHandler = MigrationLogPersistenceHandler.getInstance();
        migrationLogPersistenceHandler.setFormatter(formatter);
        m_logger.addHandler(migrationLogPersistenceHandler);
    }

    public static Map<String, PluginDescriptor> getPlugins() {
        Iterator<String> iterator = s_loadedPlugins.keySet().iterator();
        HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        while (iterator.hasNext()) {
            PluginDescriptor pluginDescriptor = s_loadedPlugins.get(iterator.next());
            String string = pluginDescriptor.getClassName();
            if (hashMap.get(string) != null) {
                PluginDescriptor pluginDescriptor2 = hashMap.get(string);
                pluginDescriptor2.addPlatform(pluginDescriptor.getPlatforms().get(0));
                hashMap.put(string, pluginDescriptor2);
                continue;
            }
            hashMap.put(string, pluginDescriptor);
        }
        return hashMap;
    }

    public static MigrationPlugin findPlugin(String string) {
        PluginDescriptor pluginDescriptor = s_loadedPlugins.get(string);
        if (pluginDescriptor == null) {
            m_logger.log(Level.SEVERE, MessageFormat.format(Messages.getString("MigrationAddin.19"), string));
            return null;
        }
        MigrationPlugin migrationPlugin = pluginDescriptor.getPlugin();
        if (migrationPlugin != null) {
            return migrationPlugin;
        }
        m_logger.log(Level.SEVERE, MessageFormat.format(Messages.getString("MigrationAddin.20"), string));
        return null;
    }

    public String getPluginClass(String string) {
        PluginDescriptor pluginDescriptor = s_loadedPlugins.get(string);
        if (pluginDescriptor != null) {
            return pluginDescriptor.getClassName();
        }
        return null;
    }

    public static MigrationPlugin getPlugin(String string) {
        MigrationPlugin migrationPlugin = null;
        MetaClass<? extends MigrationPlugin> metaClass = s_loadedPlugins.get(string).getClassLoader();
        if (metaClass != null) {
            try {
                migrationPlugin = (MigrationPlugin)metaClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                m_logger.log(Level.SEVERE, instantiationException.getLocalizedMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                m_logger.log(Level.SEVERE, illegalAccessException.getLocalizedMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                m_logger.log(Level.SEVERE, classNotFoundException.getLocalizedMessage(), classNotFoundException);
            }
        }
        return migrationPlugin;
    }

    public static MigrationMenuManager getMigrationMenuManager() {
        return s_migrationMenuManager;
    }

    private static MigrationRepositoryManager getRepositoryManager() {
        if (s_repositoryManager == null) {
            s_repositoryManager = new MigrationRepositoryManager();
        }
        return s_repositoryManager;
    }

    public static boolean isRepositoryOpen() {
        return MigrationAddin.getRepositoryManager().isConnected();
    }

    public static String getRepositoryConnectionName() {
        if (MigrationAddin.getRepositoryManager().isConnected()) {
            return MigrationAddin.getRepositoryManager().getName();
        }
        return null;
    }

    public static PersistenceManager getPersistenceManager() {
        MigrationRepositoryManager migrationRepositoryManager = MigrationAddin.getRepositoryManager();
        if (!migrationRepositoryManager.isConnected()) {
            return null;
        }
        return migrationRepositoryManager.getPersistenceManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnectRepository() {
        MigrationAddin.getRepositoryManager().closeConnections();
        s_repositoryManager = null;
        Object object = s_lock;
        synchronized (object) {
            if (s_repositoryListeners != null) {
                for (MigrationRepositoryStateListener migrationRepositoryStateListener : s_repositoryListeners) {
                    migrationRepositoryStateListener.repositoryClosed();
                }
            }
        }
    }

    public static boolean openRepository(final String string) {
        if (MigrationAddin.getRepositoryManager().isConnected() && MigrationAddin.getRepositoryManager().getName().equals(string)) {
            return true;
        }
        boolean bl = MigrationAddin.getRepositoryManager().openConnections(string);
        if (bl) {
            SwingWorker<String, Object> swingWorker = new SwingWorker<String, Object>(){

                @Override
                protected String doInBackground() throws Exception {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = s_lock;
                            synchronized (object) {
                                MigrationProjectsFolderNode.getInstance();
                                if (s_repositoryListeners != null) {
                                    for (MigrationRepositoryStateListener migrationRepositoryStateListener : s_repositoryListeners) {
                                        migrationRepositoryStateListener.repositoryOpened(string);
                                    }
                                }
                            }
                        }
                    });
                    return null;
                }
            };
            if (Ide.getMainWindow() != null) {
                swingWorker.run();
            }
        }
        return bl;
    }

    public static PersistenceManager getLogPersistenceConnection() {
        return MigrationAddin.getRepositoryManager().getLoggerPersistenceManager();
    }

    public static PersistenceManager getPersitenceManager() {
        return MigrationAddin.getRepositoryManager().getPersistenceManager();
    }

    public static MigrationPlugin getPluginForConnection(Connection connection) {
        MigrationPlugin migrationPlugin = null;
        Map<String, PluginDescriptor> map = MigrationAddin.getPlugins();
        Iterator<String> iterator = map.keySet().iterator();
        try {
            if (connection == null) {
                return null;
            }
            MigrationPlugin migrationPlugin2 = null;
            int n = -1;
            int n2 = -1;
            String string = null;
            String string2 = null;
            int n3 = 0;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                string2 = databaseMetaData.getDatabaseProductName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n2 = databaseMetaData.getDatabaseMinorVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = databaseMetaData.getDatabaseProductVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (iterator.hasNext()) {
                PluginDescriptor pluginDescriptor = map.get(iterator.next());
                if (pluginDescriptor == null) continue;
                ArrayList<String> arrayList = pluginDescriptor.getPlatforms();
                if (arrayList.size() > 0) {
                    for (String string3 : arrayList) {
                        if (string2.equals(string3)) {
                            string2 = pluginDescriptor.getName();
                        }
                        if (string3.indexOf(42) == -1 || !string2.matches(string3)) continue;
                        string2 = pluginDescriptor.getName();
                    }
                }
                if ("JDBC".equals(pluginDescriptor.getName())) {
                    migrationPlugin = pluginDescriptor.getPlugin();
                } else if (pluginDescriptor.getJdbcName() != null && "JDBC".equals(pluginDescriptor.getJdbcName())) {
                    migrationPlugin = pluginDescriptor.getPlugin();
                }
                Object object = pluginDescriptor.getPlatformSupportLevel(string2, n, n2, string);
                if (object == MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION) {
                    return pluginDescriptor.getPlugin();
                }
                if (object != MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES || n3 > pluginDescriptor.getJdbcVersionInt()) continue;
                n3 = pluginDescriptor.getJdbcVersionInt();
                migrationPlugin2 = pluginDescriptor.getPlugin();
            }
            if (migrationPlugin2 == null) {
                migrationPlugin2 = migrationPlugin;
            }
            return migrationPlugin2;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static MigrationConfig getMigrationConfig() {
        if (s_migrationConfig == null) {
            Preferences preferences = Preferences.getPreferences();
            s_migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
            s_migrationConfig.addStructureChangeListener(new MyChangeListener());
        }
        return s_migrationConfig;
    }

    public static ConfigurationData getConfigurationData() {
        if (s_configData == null) {
            Preferences preferences = Preferences.getPreferences();
            s_configData = ConfigurationData.getInstance((PropertyStorage)preferences);
        }
        return s_configData;
    }

    public static String getDefaultMigrationRepository() {
        return MigrationAddin.getMigrationConfig().getDefaultRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMigrationRepositoryStateListener(MigrationRepositoryStateListener migrationRepositoryStateListener) {
        Object object = s_lock;
        synchronized (object) {
            if (s_repositoryListeners == null) {
                s_repositoryListeners = Collections.synchronizedList(new ArrayList());
            }
            s_repositoryListeners.add(migrationRepositoryStateListener);
        }
    }

    public static NavigatorWindow getNavigatorWindow() {
        if (_navWindow == null) {
            _navWindow = MigrationProjectNavigatorManager.getInstance().getNavigatorWindow();
        }
        return _navWindow;
    }

    static {
        s_migrationConfig = null;
        s_configData = null;
        m_logger = null;
    }

    private static class MyChangeListener
    extends StructureChangeListener {
        private MyChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            ChangeInfo[] changeInfoArray;
            for (ChangeInfo changeInfo : changeInfoArray = structureChangeEvent.getChangeDetails()) {
                if (changeInfo.getChangeType() != 0 || !changeInfo.getPropertyName().equals("DefaultRepository")) continue;
                if (MigrationAddin.isRepositoryOpen()) {
                    MigrationAddin.disconnectRepository();
                }
                String string = changeInfo.getNewValueAsString();
                if (!Connections.getInstance().isConnectionOpen(string)) continue;
                MigrationAddin.openRepository(string);
                MigrationUtils.resetDateFormatter();
            }
        }
    }
}

