/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;

public class PluginDescriptor {
    private Logger LOGGER = Logger.getLogger(PluginDescriptor.class.getName());
    private MetaClass<? extends MigrationPlugin> m_class;
    private String m_name;
    private String m_jdbcName;
    private String m_ClassName;
    private String m_version;
    private String m_jdbcVersion;
    private boolean m_offlineAvailable = false;
    private MigrationPlugin m_plugin;
    private ArrayList<String> platforms = new ArrayList();

    public ArrayList<String> getPlatforms() {
        return this.platforms;
    }

    public void addPlatform(String string) {
        if (string != null && string.length() > 0) {
            this.platforms.add(string);
        }
    }

    public PluginDescriptor(String string, String string2, String string3, MetaClass<? extends MigrationPlugin> metaClass, String string4, String string5, String string6) {
        this.init(string, string2, string3, metaClass, string4, string5, string6);
    }

    public void init(String string, String string2, String string3, MetaClass<? extends MigrationPlugin> metaClass, String string4, String string5, String string6) {
        this.setMetaClass(metaClass);
        this.setName(string);
        this.setJdbcName(string2);
        this.setClassName(string3);
        this.setVersion(string4);
        this.setJdbcVersion(string5);
        this.setOffline(string6);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getJdbcName() {
        return this.m_jdbcName;
    }

    public void setJdbcName(String string) {
        this.m_jdbcName = string;
    }

    public MetaClass<? extends MigrationPlugin> getClassLoader() {
        return this.m_class;
    }

    public void setMetaClass(MetaClass<? extends MigrationPlugin> metaClass) {
        this.m_class = metaClass;
    }

    public String getClassName() {
        return this.m_ClassName;
    }

    public void setClassName(String string) {
        this.m_ClassName = string;
    }

    public MigrationPlugin getPlugin() {
        if (this.m_plugin == null) {
            this.m_plugin = this.setPlugin();
        }
        return this.m_plugin;
    }

    private MigrationPlugin setPlugin() {
        try {
            MigrationPlugin migrationPlugin;
            this.m_plugin = migrationPlugin = (MigrationPlugin)this.m_class.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.LOGGER.log(Level.SEVERE, instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.LOGGER.log(Level.SEVERE, illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.LOGGER.log(Level.SEVERE, classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        return this.m_plugin;
    }

    private void setJdbcVersion(String string) {
        this.m_jdbcVersion = string;
    }

    public String getJdbcVersion() {
        return this.m_jdbcVersion != null ? this.m_jdbcVersion : "";
    }

    private void setVersion(String string) {
        this.m_version = string;
    }

    public String getVersion() {
        return this.m_version != null ? this.m_version : "";
    }

    public boolean isOfflineAvailable() {
        return this.m_offlineAvailable;
    }

    private void setOffline(String string) {
        if (string != null) {
            this.m_offlineAvailable = true;
        }
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        int n3 = 0;
        String string3 = this.getJdbcName();
        String string4 = this.getJdbcVersion();
        if (string4 == null || string4.equals("")) {
            string4 = this.getVersion();
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.getName();
        }
        if (n > 0 && !string4.equals("")) {
            n3 = Integer.parseInt(string4);
        }
        if (!string3.toLowerCase().equals(string.toLowerCase())) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
        }
        if (n == n3) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES;
    }

    public int getJdbcVersionInt() {
        String string = this.getJdbcVersion();
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }
}

