/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.migration.workbench.core.navigator.AbstractMigrationNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationOverlayClient;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectConnectionRecognizer;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorContextMenu;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorWindow;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationFileFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationFileNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedObjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CatalogFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ConvertedModelsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IChildNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.SchemaFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.TSQLNode;
import oracle.dbtools.raptor.dialogs.BasicObjectModifier;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Node;

public class MigrationProjectNavigatorManager
extends AbstractMigrationNavigatorManager {
    public static final Logger LOGGER = Logger.getLogger(MigrationProjectNavigatorManager.class.getName());
    private static final String MIG_PRJ_NAV_LABEL = MigrationProjectNavigatorArb.getString("MIG_PRJ_NAV_LABEL");
    private static final String DEFAULT_NAME = "MigrationProjects";
    private static final String MIG_PRJ_NAV_WINDOW_ID = "MigrationProjectNavigatorWindow";
    public static final String MIG_NAV_SITE_KEY = "mig_nav";
    private static MigrationProjectNavigatorManager s_instance;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public static synchronized MigrationProjectNavigatorManager getInstance() {
        if (s_instance == null) {
            s_instance = new MigrationProjectNavigatorManager();
        }
        return s_instance;
    }

    private MigrationProjectNavigatorManager() {
    }

    protected NavigatorWindow createNavigatorWindow() {
        MigrationProjectNavigatorContextMenu.initRefreshAction();
        return new MigrationProjectNavigatorWindow(this.getViewId());
    }

    public ViewId getViewId() {
        return new ViewId(MIG_PRJ_NAV_WINDOW_ID, DEFAULT_NAME);
    }

    public void refreshElement(Element element) {
        Element element2 = element;
        final NavigatorTree navigatorTree = this.getNavigatorWindow().getTree();
        NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode(element2, navigatorTree.getRoot());
        MigrationOverlayClient.removeTracker();
        if (null == navigatorTreeNode) {
            navigatorTreeNode = navigatorTree.getRoot();
            element2 = navigatorTreeNode.getElement();
        }
        final List list = NavigatorContext.storeSelectionState((NavigatorTree)navigatorTree);
        if (element2 instanceof CapturedObjectsFolderNode) {
            element2 = ((IChildNode)element2).getParentElement();
        }
        final NavigatorTreeNode navigatorTreeNode2 = navigatorTree.findTreeNode(element2, navigatorTree.getRoot());
        final List list2 = NavigatorContext.storeExpansionState((NavigatorTree)navigatorTree, (NavigatorTreeNode)navigatorTreeNode2);
        if (element2 instanceof Node) {
            Node node = (Node)element2;
            try {
                if (node.isLoaded()) {
                    node.close();
                }
                node.open();
            }
            catch (IOException iOException) {
                MigrationProjectNavigatorManager.log(iOException);
            }
        }
        if (navigatorTreeNode2 != navigatorTreeNode) {
            navigatorTree.collapse(navigatorTreeNode2, true);
        }
        navigatorTree.expand(navigatorTreeNode2, false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigatorContext.restoreExpansionState((NavigatorTree)navigatorTree, (NavigatorTreeNode)navigatorTreeNode2, (List)list2);
                NavigatorContext.restoreSelectionState((NavigatorTree)navigatorTree, (List)list);
            }
        });
    }

    protected String[] getNavigatorSiteIDs() {
        return new String[]{MIG_NAV_SITE_KEY};
    }

    public void closeElement(Element element) {
        NavigatorTree navigatorTree = this.getNavigatorWindow().getTree();
        NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode(element, navigatorTree.getRoot());
        navigatorTree.collapse(navigatorTreeNode, true);
    }

    static {
        MigrationProjectNavigatorManager.getRegistry().registerRecognizer((ConnectionRecognizer)new MigrationProjectConnectionRecognizer());
        MigrationProjectNavigatorManager.getConvertedConnectionRegistry().registerRecognizer((ConnectionRecognizer)new MigrationProjectConnectionRecognizer());
        BasicObjectModifier.registerSupportedType(MigrationProjectsFolderNode.class);
        BasicObjectModifier.registerSupportedType(MigrationProjectNode.class);
        BasicObjectModifier.registerSupportedType(ApplicationFileFolderNode.class);
        BasicObjectModifier.registerSupportedType(ApplicationFileNode.class);
        BasicObjectModifier.registerSupportedType(CapturedObjectsFolderNode.class);
        BasicObjectModifier.registerSupportedType(CapturedNode.class);
        BasicObjectModifier.registerSupportedType(CatalogFolderNode.class);
        BasicObjectModifier.registerSupportedType(ConvertedModelsFolderNode.class);
        BasicObjectModifier.registerSupportedType(SchemaFolderNode.class);
        BasicObjectModifier.registerSupportedType(TSQLNode.class);
        BasicObjectModifier.registerSupportedType(MigrationConnectionNode.class);
    }
}

