/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.Color;
import oracle.dbtools.migration.translation.api.prefs.ConfigurationOptions;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public final class ConfigurationData
extends HashStructureAdapter {
    public static final String KEY = "IdeSettings4GenEditor1.0";
    private static final String COLORLIST = "ColorList";
    private static final ListStructure DEFAULT_COLORLIST = ListStructure.newInstance();
    private static final String DEFAULT_DATEFORMAT = "dd/mm/yyyy";
    private static final String DATEFORMAT = "DATEFORMAT";
    private static final String QUERYASSIGNMENT = "QUERYASSIGNMENT";
    private static final String VARPREFIX = "VARPREFIX";
    private static final String INPARAMPREFIX = "INPARAMPREFIX";
    private static final String SHOWAST = "SHOWAST";
    private static final String COMPOUNDTRIGGER = "COMPOUNDTRIGGER";
    private static final String NATIVEJOINS = "NATIVEJOINS";
    private static final String CHARS32K = "CHARS32K";
    private static final String FETCHFIRST = "FETCHFIRST";
    private static final String IDENTITYCOLS = "IDENTITYCOLS";
    private static final String IMPLICITRESULTSET = "IMPLICITRESULTSET";

    private ConfigurationData(HashStructure hashStructure) {
        super(hashStructure);
        DEFAULT_COLORLIST.clear();
        for (int i = 0; i < ConfigurationOptions.getLevelNumber(); ++i) {
            DEFAULT_COLORLIST.add((Object)this.getString(ConfigurationOptions.colors[i]));
        }
    }

    public static ConfigurationData getInstance(PropertyStorage propertyStorage) {
        return new ConfigurationData(ConfigurationData.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public ListStructure getColorList() {
        ListStructure listStructure = this._hash.getListStructure(COLORLIST);
        if (listStructure == null) {
            listStructure = DEFAULT_COLORLIST;
        }
        return listStructure;
    }

    public void setColorList(ListStructure listStructure) {
        this._hash.putListStructure(COLORLIST, listStructure);
    }

    private String getString(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return String.format("%1$d,%2$d,%3$d", n, n2, n3);
    }

    public String getDateFormat() {
        return this._hash.getString(DATEFORMAT, DEFAULT_DATEFORMAT);
    }

    public void setDateFormat(String string) {
        this._hash.putString(DATEFORMAT, string);
    }

    public String getQueryAssignment() {
        String string = this._hash.getString(QUERYASSIGNMENT);
        if (string == null) {
            string = "SELECT INTO assignment";
        }
        return string;
    }

    public void setQueryAssignment(String string) {
        this._hash.putString(QUERYASSIGNMENT, string);
    }

    public String getVarPrefix() {
        String string = this._hash.getString(VARPREFIX);
        if (string == null) {
            string = "v_";
        }
        return string.trim();
    }

    public void setVarPrefix(String string) {
        this._hash.putString(VARPREFIX, string);
    }

    public String getInParamPrefix() {
        String string = this._hash.getString(INPARAMPREFIX);
        if (string == null) {
            string = "iv_";
        }
        return string.trim();
    }

    public void setInParamPrefix(String string) {
        this._hash.putString(INPARAMPREFIX, string);
    }

    public boolean getShowAST() {
        return this._hash.getBoolean(SHOWAST);
    }

    public void setShowAST(boolean bl) {
        this._hash.putBoolean(SHOWAST, bl);
    }

    public boolean useCompoundTrigger() {
        boolean bl = false;
        if (this._hash.containsKey(COMPOUNDTRIGGER)) {
            bl = this._hash.getBoolean(COMPOUNDTRIGGER);
        }
        return bl;
    }

    public void setCompoundTrigger(boolean bl) {
        this._hash.putBoolean(COMPOUNDTRIGGER, bl);
    }

    public void setNativeJoins(boolean bl) {
        this._hash.putBoolean(NATIVEJOINS, bl);
    }

    public void set32KChars(boolean bl) {
        this._hash.putBoolean(CHARS32K, bl);
    }

    public void setFetchFirst(boolean bl) {
        this._hash.putBoolean(FETCHFIRST, bl);
    }

    public void setIdentityCols(boolean bl) {
        this._hash.putBoolean(IDENTITYCOLS, bl);
    }

    public void setImplicitResultSets(boolean bl) {
        this._hash.putBoolean(IMPLICITRESULTSET, bl);
    }

    public boolean getImplicitResultSets() {
        return this._hash.getBoolean(IMPLICITRESULTSET);
    }

    public boolean getIdentityCols() {
        return this._hash.getBoolean(IDENTITYCOLS);
    }

    public boolean getFetchFirst() {
        return this._hash.getBoolean(FETCHFIRST);
    }

    public boolean get32kChars() {
        return this._hash.getBoolean(CHARS32K);
    }

    public boolean getNativeJoins() {
        return this._hash.getBoolean(NATIVEJOINS);
    }

    public void setAll12c(boolean bl) {
        this.setNativeJoins(bl);
        this.set32KChars(bl);
        this.setIdentityCols(bl);
        this.setImplicitResultSets(bl);
    }
}

