/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.metadata.createRepository.CallRunScripts;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.metadata.createRepository.UpgradeRunner;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.repository.DeleteRepoProgressRunnable;
import oracle.dbtools.migration.workbench.core.repository.RepositoryDialog;
import oracle.dbtools.migration.workbench.core.repository.RepositoryException;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public final class RepositoryManager {
    public static final String CREATE_SCRIPT_NAME = "CREATE_REPOSITORY.sql";
    public static final String REMOVE_SCRIPT_NAME = "removeRepository.sql";
    public static final String PURGE_SCRIPT_NAME = "purgeRepository.sql";
    public static final int REPO_VERSION = 64;
    private static final String REPO_CREATE_SCRIPT = "CREATE_REPOSITORY.sql";
    RepositoryManager m_rman = null;
    private static DBObject m_dbObject;
    public static int FAILED_TO_GET_VERSION;
    private static final String UPGRADE_STUB = "upgrade_";
    private static final String UPGRADE_EXTENSION = ".sql";

    public void openRepositoryRegDialog(DBObject dBObject) {
        RepositoryDialog repositoryDialog = new RepositoryDialog(dBObject);
        m_dbObject = dBObject;
        repositoryDialog.setVisible(true);
    }

    private static String[] getAssociatedRepos() {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        String[] stringArray = migrationConfig.getRepositories();
        return stringArray;
    }

    public static void installRepository(DBObject dBObject) {
        RepositoryManager.findOrCreateRepositoryTables(dBObject.getConnectionName());
    }

    public static boolean removeRepository(String string) {
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            DeleteRepoProgressRunnable deleteRepoProgressRunnable = new DeleteRepoProgressRunnable(connection);
            if (connection != null) {
                deleteRepoProgressRunnable.setUseBuzyBar(false);
                deleteRepoProgressRunnable.updateBelowPanel(MigrationAddinArb.getString("REPOSITORY_REMOVING"));
                deleteRepoProgressRunnable.setTitle(MigrationAddinArb.getString("DELETE_REPO_PROGRESS_TITLE"));
                deleteRepoProgressRunnable.start(true);
                migrationConfig.removeRepository(string);
                return deleteRepoProgressRunnable.getStatus();
            }
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "RepositoryManager.CONNECTION_ERROR", string);
        }
        catch (Exception exception) {
            MigrationLogUtil.logThrowable(exception.getMessage(), new Object[0], (Throwable)exception);
        }
        return false;
    }

    public static void removeDbNameFromconfig(String string) {
        String[] stringArray;
        for (String string2 : stringArray = RepositoryManager.getAssociatedRepos()) {
            if (!string2.equals(string)) continue;
            MigrationAddin.getMigrationConfig().removeRepository(string2);
        }
    }

    public static boolean findOrCreateRepositoryTables(String string) {
        return RepositoryManager.findOrCreateRepositoryTables(string, true);
    }

    public static boolean findOrCreateRepositoryTables(String string, boolean bl) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        RunRepositoryScripts runRepositoryScripts = null;
        try {
            Object object;
            Connection connection = Connections.getInstance().getConnection(string);
            if (connection != null) {
                if (RepositoryManager.doesRepositoryExist(connection)) {
                    migrationConfig.addRepository(string);
                    String string2 = migrationConfig.getDefaultRepository();
                    migrationConfig.setDefaultRepository(string);
                    boolean bl2 = true;
                    if (string2 != null && string.equals(string2) && bl) {
                        bl2 = MigrationAddin.openRepository(string);
                    }
                    return bl2;
                }
                runRepositoryScripts = new RunRepositoryScripts(connection);
                if (bl) {
                    object = new CallRunScripts(runRepositoryScripts, 1);
                    ((CallRunScripts)object).setScript("CREATE_REPOSITORY.sql");
                    ((AbstractMigrationProgressRunnable)object).start(true);
                } else {
                    runRepositoryScripts.setMode(1);
                    runRepositoryScripts.setScript("CREATE_REPOSITORY.sql");
                    runRepositoryScripts.run();
                }
            } else {
                throw new Exception("null returned from getConnection()");
            }
            if (runRepositoryScripts.getSuccess().equals(Boolean.TRUE)) {
                migrationConfig.addRepository(string);
                object = migrationConfig.getDefaultRepository();
                migrationConfig.setDefaultRepository(string);
                if (object != null && string.equals(object)) {
                    MigrationAddin.disconnectRepository();
                    MigrationAddin.openRepository(string);
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesRepositoryExist(Connection connection) {
        if (connection == null) {
            return false;
        }
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select * from md_connections where 1=0");
            bl = true;
        }
        catch (SQLException sQLException) {
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(statement, resultSet);
                throw throwable;
            }
            CloseableResultSet.close(statement, resultSet);
        }
        CloseableResultSet.close(statement, resultSet);
        return bl;
    }

    public static boolean purgeRepository(Connection connection) {
        block4: {
            RunRepositoryScripts runRepositoryScripts = null;
            try {
                if (connection == null) break block4;
                if (RepositoryManager.doesRepositoryExist(connection)) {
                    runRepositoryScripts = new RunRepositoryScripts(connection);
                    CallRunScripts callRunScripts = new CallRunScripts(runRepositoryScripts, 4);
                    callRunScripts.setScript(PURGE_SCRIPT_NAME);
                    callRunScripts.start(true);
                    if (!runRepositoryScripts.wasCancelled() && runRepositoryScripts.getSuccess().equals(Boolean.TRUE)) {
                        String string = Connections.getInstance().getConnectionName(connection);
                        MigrationAddin.disconnectRepository();
                        MigrationAddin.openRepository(string);
                    }
                    break block4;
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public static void checkRepository(DBObject dBObject, ClassLoader classLoader) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        Connections connections = Connections.getInstance();
        Connection connection = null;
        try {
            connection = connections.getConnection(dBObject.getConnectionName());
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Throwable)dBException);
        }
        String string = dBObject.getConnectionName();
        if (!RepositoryManager.repoAssociated(string)) {
            migrationConfig.addRepository(string);
        }
        if (RepositoryManager.doesRepositoryExist(connection)) {
            if (RepositoryManager.checkRepoVersion(connection)) {
                if (RepositoryManager.checkRepoValid(connection)) {
                    return;
                }
                RepositoryManager.removeRepository(string);
                RepositoryManager.installRepository(dBObject);
            } else {
                int n = RepositoryManager.getCurentRepoVersion(connection);
                if (n < 64) {
                    RepositoryManager.upgradeRepository(dBObject.getConnectionName(), n, classLoader);
                }
            }
        } else {
            RepositoryManager.installRepository(dBObject);
        }
    }

    public static boolean upgradeRepository(String string, int n, ClassLoader classLoader) {
        int n2 = 64;
        RunRepositoryScripts runRepositoryScripts = null;
        ArrayList<String> arrayList = null;
        Connections connections = Connections.getInstance();
        Connection connection = null;
        try {
            arrayList = RepositoryManager.getUpgradeScripts(classLoader);
            connection = connections.getConnection(string);
        }
        catch (RepositoryException repositoryException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MIGRATION_REPO_UPG_SCRIPT_ERR"), null, null);
            return false;
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Throwable)dBException);
        }
        runRepositoryScripts = new RunRepositoryScripts(connection);
        UpgradeRunner upgradeRunner = new UpgradeRunner(n, n2, arrayList, runRepositoryScripts);
        try {
            upgradeRunner.start(true);
        }
        catch (Exception exception) {
            Logger.getLogger(RepositoryManager.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return false;
        }
        return !runRepositoryScripts.getSuccess().equals(Boolean.FALSE);
    }

    public static String findNextUpgradeScript(int n, ArrayList<String> arrayList) {
        for (String string : arrayList) {
            if (!string.startsWith(UPGRADE_STUB + n + "_")) continue;
            return string;
        }
        return null;
    }

    public static ArrayList<String> getUpgradeScripts(ClassLoader classLoader) throws RepositoryException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "oracle.dbtools.metadata.createRepository";
        try {
            for (URL uRL : FileUtils.getFilesInPackage((String)string, (ClassLoader)classLoader, (String)"sql")) {
                File file = new File(uRL.getFile());
                if (!file.getName().startsWith(UPGRADE_STUB) || !file.getName().endsWith(UPGRADE_EXTENSION)) continue;
                arrayList.add(file.getName());
            }
        }
        catch (Exception exception) {
            throw new RepositoryException();
        }
        return arrayList;
    }

    private static boolean checkRepoValid(Connection connection) {
        return RepositoryManager.getCurentRepoVersion(connection) <= 64;
    }

    private static boolean repoAssociated(String string) {
        String[] stringArray;
        for (String string2 : stringArray = RepositoryManager.getAssociatedRepos()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCurentRepoVersion(Connection connection) {
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (connection != null) {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT REVISION FROM MD_REPOVERSIONS");
                resultSet.next();
                n = resultSet.getInt("REVISION");
            }
        }
        catch (SQLException sQLException) {
            int n2 = FAILED_TO_GET_VERSION;
            return n2;
        }
        finally {
            CloseableResultSet.close(statement, resultSet);
        }
        return n;
    }

    private static boolean checkRepoVersion(Connection connection) {
        return RepositoryManager.getCurentRepoVersion(connection) == 64;
    }

    public static boolean gotUserPermission(DBObject dBObject) {
        String[] stringArray = new String[]{"TABLE", "VIEW", "SEQUENCE", "PROCEDURE", "TYPE"};
        String[] stringArray2 = RepositoryManager.getUserPrivileges(dBObject);
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].contains(stringArray[i])) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testUserPrivileges(DBObject dBObject, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        String string2 = "select PRIVILEGE from role_sys_privs PRIVILEGE LIKE '%:TYPE%' UNION select privilege from user_sys_privs WHERE PRIVILEGE LIKE '%TYPE%'";
        try {
            hashMap.clear();
            hashMap.put("OWNER", dBObject.getSchemaName());
            hashMap.put("TYPE", string);
            statement = dBObject.getConnection().prepareStatement(string2);
            DBUtil.bind((PreparedStatement)statement, hashMap);
            resultSet = statement.executeQuery();
            bl = resultSet.next();
        }
        catch (SQLException sQLException) {
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                return bl;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getUserPrivileges(Connection connection) {
        if (connection == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap hashMap = new HashMap();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select PRIVILEGE from role_sys_privs UNION select PRIVILEGE from user_sys_privs";
        try {
            Connections.getInstance().lock(connection);
            hashMap.clear();
            preparedStatement = connection.prepareStatement(string);
            DBUtil.bind((PreparedStatement)preparedStatement, hashMap);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("PRIVILEGE"));
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            Connections.getInstance().unlock(connection);
            try {
                resultSet.close();
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getUserPrivileges(DBObject dBObject) {
        return RepositoryManager.getUserPrivileges(dBObject.getConnection());
    }

    public static void renameConnection(String string, String string2) {
        RepositoryManager.removeDbNameFromconfig(string);
        MigrationAddin.getMigrationConfig().addRepository(string2);
        if (Connections.getInstance().isConnectionOpen(string2)) {
            MigrationAddin.openRepository(string2);
        }
    }

    static {
        FAILED_TO_GET_VERSION = 999;
    }
}

