/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;

public class IncrementalMigrationStorer
extends BasicMigrationStorer {
    private MdConnection m_connection;

    public IncrementalMigrationStorer(PersistenceManager persistenceManager, MdConnection mdConnection) {
        super(persistenceManager);
        this.setTargetMDConnection(mdConnection);
    }

    @Override
    public PersistableObject storeObject(PersistableObject persistableObject) throws PersistenceException {
        PersistableObject persistableObject2;
        if (persistableObject instanceof MdConnection) {
            return this.getTargetMDConnection();
        }
        if (persistableObject instanceof MdCatalog && MigrationUtils.catalogIsDummy(persistableObject2 = (MdCatalog)persistableObject)) {
            CloseableIterator<MgvAllCatalogsRec> closeableIterator = this.getPersistenceUtility().getCatalogsForConnectionId(this.m_connection.getKey());
            MgvAllCatalogsRec mgvAllCatalogsRec = (MgvAllCatalogsRec)closeableIterator.next();
            try {
                persistableObject2 = MdCatalog.retrieveExistingInstance(this.getPersistenceManager(), mgvAllCatalogsRec.getCatalogId());
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new PersistenceException(noSuchObjectException);
            }
            closeableIterator.close();
            return persistableObject2;
        }
        try {
            DBObjectId dBObjectId = this.checkExisting(persistableObject);
            if (dBObjectId != null) {
                try {
                    persistableObject2 = this.getPersistenceUtility().loadPersistableObject(dBObjectId, persistableObject.getObjectType());
                    return persistableObject2;
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    throw new PersistenceException(noSuchObjectException);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        return super.storeObject(persistableObject);
    }

    protected MdConnection getTargetMDConnection() {
        return this.m_connection;
    }

    protected void setTargetMDConnection(MdConnection mdConnection) {
        this.m_connection = mdConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBObjectId checkExisting(PersistableObject persistableObject) throws SQLException {
        ResultSet resultSet;
        block4: {
            DBObjectId dBObjectId;
            String string = persistableObject.getContainerFieldName();
            if (string == null) {
                return null;
            }
            String string2 = persistableObject.getObjectName();
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            String string3 = "SELECT ID FROM " + persistableObject.getObjectType() + " WHERE " + persistableObject.getContainerFieldName() + " = ? AND " + persistableObject.getObjectNameFieldName() + " = ?";
            PreparedStatement preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.getPersistenceManager().getPreparedStatement(string3);
                preparedStatement.setLong(1, persistableObject.getContainerId().getId());
                preparedStatement.setString(2, persistableObject.getObjectName());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                long l = resultSet.getLong(1);
                dBObjectId = new DBObjectId(l);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
            CloseableResultSet.close(null, resultSet);
            return dBObjectId;
        }
        CloseableResultSet.close(null, resultSet);
        return null;
    }
}

