/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListDataListener;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.dss.gridView.ConditionElement;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.RulesPanel;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.SliceOutOfRangeException;

public class CrosstabRulesPanel
extends RulesPanel
implements ActionListener,
PropertyChangeListener,
ListDataListener,
HelpContext {
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    private QDR m_qdr = new QDR();
    private CompositeDiscriminator m_compDisc;

    public CrosstabRulesPanel() {
    }

    public CrosstabRulesPanel(UIGridView gridView) {
        super(gridView);
        this._init();
    }

    public CrosstabRulesPanel(UIGridView gridView, String header) {
        this(gridView, header != null);
    }

    public CrosstabRulesPanel(UIGridView gridView, boolean header) {
        super(gridView, header);
        this._init();
    }

    public CrosstabRulesPanel(UIGridView gridView, Discriminator disc, String header) {
        this(gridView, disc, null, header != null);
    }

    public CrosstabRulesPanel(UIGridView gridView, Discriminator disc, boolean header) {
        this(gridView, disc, null, header);
    }

    public CrosstabRulesPanel(UIGridView gridView, Discriminator disc, ConditionElement valueCondition, boolean header) {
        super(gridView, disc, valueCondition, header);
        this._init();
    }

    public CrosstabRulesPanel(UIGridView gridView, String header, boolean isDefault) {
        this(gridView, header);
        this._init();
    }

    @Override
    public void setDataAccess(DataAccess access) {
        super.setDataAccess(access);
        try {
            QDR qdr = this.dataAccess.getValueQDR(0, 0, 0);
            if (qdr != null) {
                this.m_measureDim = qdr.getMeasureDim();
            }
            if (this.m_measureDim != null && this.m_measureDim.equals("")) {
                this.m_measureDim = null;
            }
            if (this.m_measureDim == null) {
                this.m_measureBox.setEnabled(false);
            }
            this.m_valueDisc = null;
            this.m_conditions = null;
            this.m_currentMeasure = null;
            this.m_compDisc = null;
            this.m_qdr = new QDR();
            this.m_qdrDisc = null;
            this.setDefaultConditions();
            if (this.conditionList != null) {
                this.conditionList.setListData(this.m_conditions);
                this.conditionList.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_editButton) {
            int idx = this.conditionList.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            String dimension = this.conditionList.getDimension(idx);
            Object memberData = this.conditionList.getMemberData(idx);
            Vector members = new Vector();
            if (memberData == null) {
                members = null;
            } else if (memberData instanceof Vector) {
                members = (Vector)memberData;
            } else {
                members.addElement(memberData);
            }
            if (dimension != null) {
                RulesPanel.DimensionDialog dialog = this.createDimensionDialog(this.rBundle.getString("Select Members"), dimension, members, idx, true, this.m_isTable);
                dialog.show();
            }
        }
    }

    @Override
    public Discriminator getDiscriminator() {
        if (this.dataAccess == null) {
            return null;
        }
        Vector pairs = new Vector();
        this.m_qdr = new QDR();
        if (!this.m_isHeaderFormat) {
            for (int i = 0; i < this.conditionList.getListSize(); ++i) {
                String dimension = this.conditionList.getDimension(i);
                Object data = this.conditionList.getMemberData(i);
                if (data == null) continue;
                QDRMember member = data instanceof Vector ? new QDRMember(3, data) : new QDRMember(0, data);
                this.m_qdr.addDimMemberPair(dimension, member);
            }
            if (this.m_valueIndex != -1) {
                this.processValueCondition();
            }
            this.m_qdrDisc.setQDR(this.m_qdr);
            if (this.m_valueDisc != null) {
                return new CompositeDiscriminator((Discriminator)this.m_qdrDisc, this.m_valueDisc, 0);
            }
            return this.m_qdrDisc;
        }
        this.m_qdrDisc = this.m_memberPanel.getDiscriminator();
        return this.m_qdrDisc;
    }

    public String getHelpContextID() {
        if (this.m_isHeaderFormat) {
            return this.getClass().getName() + "_" + "Header";
        }
        if (!this.hideValueCondition) {
            return this.getClass().getName() + "_" + "Databody";
        }
        return this.getClass().getName() + "_" + "Stoplight";
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    @Override
    protected void setDefaultConditions() {
        this.m_conditions = new Vector();
        try {
            QDR qdr = this.dataAccess.getValueQDR(0, 0, 0);
            if (qdr != null) {
                this.m_measureDim = qdr.getMeasureDim();
            }
            if (this.m_measureDim != null && this.m_measureDim.equals("")) {
                this.m_measureDim = null;
            }
            for (int i = 0; i < this.dataAccess.getEdgeCount(); ++i) {
                int layerCount = this.dataAccess.getLayerCount(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = this.dataAccess.getLayerMetadata(i, j, "layerName");
                    String dimension = null;
                    if (dimObj != null) {
                        dimension = dimObj.toString();
                    }
                    this.m_conditions.addElement(new ConditionElement(dimension, (String)null));
                    if (this.m_measureDim == null || !dimension.equals(this.m_measureDim)) continue;
                    this.m_measureIndex = this.m_conditions.size() - 1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_qdr = new QDR();
        this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        if (!this.m_isHeaderFormat && this.m_measureDim != null) {
            this.m_conditions.addElement(new ConditionElement(null));
            this.m_valueIndex = this.m_conditions.size() - 1;
        }
    }

    @Override
    protected String getMemberLabel(String dimension, String member) {
        if (dimension == null) {
            return null;
        }
        try {
            List list = this.dataAccess.getCorrespondingMemberMetadata(dimension, new String[]{member}, new String[]{this.getMemberLabelType()}, true);
            if (list != null) {
                if (list != null && list.size() > 0 && list.get(0) != null && ((Object[])list.get(0)).length > 0) {
                    return (String)((Object[])list.get(0))[0];
                }
                return member;
            }
            for (int i = 0; i < this.dataAccess.getEdgeCount(); ++i) {
                int layerCount = this.dataAccess.getLayerCount(i);
                int endslice = this.dataAccess.getEdgeExtent(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = this.dataAccess.getLayerMetadata(i, j, "layerName");
                    String dim = null;
                    if (dimObj != null) {
                        dim = dimObj.toString();
                    }
                    if (!dimension.equals(dim)) continue;
                    for (int startslice = 0; startslice != endslice; startslice += this.dataAccess.getMemberExtent(i, j, startslice)) {
                        if (this.dataAccess.getMemberStartLayer(i, j, startslice) != j) continue;
                        Object objValue = this.dataAccess.getMemberMetadata(i, j, startslice, "value");
                        String value = null;
                        if (objValue != null) {
                            value = objValue.toString();
                        }
                        if (value == null || !value.equals(member)) continue;
                        objValue = this.dataAccess.getMemberMetadata(i, j, startslice, this.memberLabelType);
                        if (objValue != null) {
                            value = objValue.toString();
                        }
                        if (value == null) {
                            return member;
                        }
                        return value;
                    }
                }
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return member;
    }

    @Override
    protected String printCondition(ConditionElement element) {
        String condition = null;
        String dimension = element.getDimension();
        if (element.getType() == 0) {
            condition = element.getData() != null ? this.getLayerLabel(dimension) + ": " + this.getMemberLabel(dimension, element.getData().toString()) : this.getLayerLabel(dimension) + ": " + this.rBundle.getString("Any");
        } else if (element.getType() == 1) {
            condition = this.getLayerLabel(dimension) + ": ";
            Vector data = (Vector)element.getData();
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    if (i != 0) {
                        condition = condition + ", ";
                    }
                    condition = condition + this.getMemberLabel(dimension, data.elementAt(i).toString());
                }
            }
        }
        return condition;
    }

    @Override
    protected void editDimensions(Vector members, int idx) {
        super.editDimensions(members, idx);
        if (this.m_isHeaderFormat) {
            return;
        }
        String dimension = this.conditionList.getDimension(idx);
        if (this.m_measureDim != null && dimension.equals(this.m_measureDim)) {
            Object value_condition = this.conditionList.getMemberData(this.m_valueIndex);
            if (members == null || members.size() > 1) {
                this.m_valueDisc = null;
                this.m_measureBox.setSelectedIndex(0);
                this.m_currentMeasure = null;
            } else {
                this.m_currentMeasure = (String)members.elementAt(0);
                this.m_measureBox.setSelectedIndex(this.m_measureVector.indexOf(this.m_currentMeasure) + 1);
                if (value_condition instanceof Vector) {
                    ((Vector)value_condition).setElementAt(this.m_currentMeasure, 0);
                    this.conditionList.setElementAt(new ConditionElement((Vector)value_condition), this.m_valueIndex);
                }
            }
        }
    }

    @Override
    protected void initFromDisc(Discriminator disc, ConditionElement valueCondition) {
        if (disc == null) {
            this.setDefaultConditions();
        } else {
            try {
                QDR qdr = this.dataAccess.getValueQDR(0, 0, 0);
                if (qdr != null) {
                    this.m_measureDim = qdr.getMeasureDim();
                }
                if (this.m_measureDim != null && this.m_measureDim.equals("")) {
                    this.m_measureDim = null;
                }
            }
            catch (Exception qdr) {
                // empty catch block
            }
            if (disc instanceof QDRDiscriminator) {
                this.m_qdrDisc = (QDRDiscriminator)disc;
                this.m_valueDisc = null;
            } else if (disc instanceof NumberValueDiscriminator) {
                this.m_qdrDisc = null;
                this.m_valueDisc = (NumberValueDiscriminator)disc;
            } else if (disc instanceof DateValueDiscriminator) {
                this.m_qdrDisc = null;
                this.m_valueDisc = (DateValueDiscriminator)disc;
            } else if (disc instanceof CompositeDiscriminator) {
                if (((CompositeDiscriminator)disc).getLeft() instanceof QDRDiscriminator) {
                    this.m_qdrDisc = (QDRDiscriminator)((CompositeDiscriminator)disc).getLeft();
                    this.m_valueDisc = ((CompositeDiscriminator)disc).getRight();
                } else {
                    this.m_valueDisc = (CompositeDiscriminator)disc;
                }
            }
            this.m_qdr = this.m_qdrDisc == null ? new QDR() : this.m_qdrDisc.getQDR();
            this.m_conditions = new Vector();
            try {
                for (int i = 0; i < this.dataAccess.getEdgeCount(); ++i) {
                    int layerCount = this.dataAccess.getLayerCount(i);
                    for (int j = 0; j < layerCount; ++j) {
                        QDRMember member;
                        Object dimObj = this.dataAccess.getLayerMetadata(i, j, "layerName");
                        String dimension = null;
                        if (dimObj != null) {
                            dimension = dimObj.toString();
                        }
                        if ((member = this.m_qdr.getDimMember(dimension)) == null) {
                            this.m_conditions.addElement(new ConditionElement(dimension, (Object)null));
                        } else {
                            this.m_conditions.addElement(new ConditionElement(dimension, member.getData()));
                        }
                        if (this.m_measureDim == null || !dimension.equals(this.m_measureDim)) continue;
                        this.m_measureIndex = this.m_conditions.size() - 1;
                        if (member == null || member.getType() != 0) continue;
                        this.m_currentMeasure = (String)member.getData();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (valueCondition != null) {
            this.m_conditions.addElement(valueCondition);
            this.m_valueIndex = this.m_conditions.size() - 1;
        } else if (!this.m_isHeaderFormat) {
            this.m_conditions.addElement(new ConditionElement(null));
            this.m_valueIndex = this.m_conditions.size() - 1;
        }
    }
}

