/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import oracle.dss.dataView.datacache.BaseCachedDataSource;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.RowColumnEdge;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class CachedDataSource
extends BaseCachedDataSource
implements CubeDataDirector {
    protected static final String[] DEFAULT_SUPPORTED_METADATAMAP = new String[]{"label", "mediumName", "shortName", "indent", "value", "dataType", "isTotal"};
    public static final String CACHED_DATA = "CachedData";
    public static final String EXTENT = "extent";
    public static final String LIMIT = "limit";

    public static CachedDataSource createCachedDataSource(DataAccess da, DataDirector dd) {
        CachedDataSource cached = new CachedDataSource();
        cached.initializeDataSource(da, dd, -1, -1);
        return cached;
    }

    public static CachedDataSource createCachedDataSource(DataAccess da, DataDirector dd, int rowLimit, int colLimit) {
        CachedDataSource cached = new CachedDataSource();
        cached.initializeDataSource(da, dd, rowLimit, colLimit);
        return cached;
    }

    public QDR getValueQDR(int row, int column, int flags) throws RowOutOfRangeException, ColumnOutOfRangeException {
        QDR qdr = this.createQDR();
        try {
            if (flags == 1) {
                this.addPageEdgeToQDR(qdr);
            }
            try {
                this.addEdgeToQDR(qdr, 0, column);
            }
            catch (SliceOutOfRangeException e) {
                throw new ColumnOutOfRangeException(e.getMessage());
            }
            try {
                if (this.m_edges[1] != null) {
                    this.addEdgeToQDR(qdr, 1, row);
                }
            }
            catch (SliceOutOfRangeException e1) {
                throw new RowOutOfRangeException(e1.getMessage());
            }
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return qdr;
    }

    public QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        boolean bAlreadyRetrieved;
        QDR qdr = this.m_edges[edge].getSliceQDR(slice);
        boolean bl = bAlreadyRetrieved = qdr != null;
        if (!bAlreadyRetrieved) {
            qdr = this.createQDR();
        }
        try {
            if (edge != 2 && flags == 1) {
                this.addPageEdgeToQDR(qdr);
            }
            if (!bAlreadyRetrieved) {
                this.addEdgeToQDR(qdr, edge, slice);
            }
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
            // empty catch block
        }
        return qdr;
    }

    public QDR getMemberQDR(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        int layerCount;
        boolean bAlreadyRetrieved;
        QDR qdr = null;
        qdr = this.m_edges[edge].getMemberQDR(layer, slice);
        boolean bl = bAlreadyRetrieved = qdr != null;
        if (!bAlreadyRetrieved) {
            qdr = this.createQDR();
        }
        if (edge != 2 && flags == 1) {
            this.addPageEdgeToQDR(qdr);
        }
        if (bAlreadyRetrieved) {
            return qdr;
        }
        int sliceMemberCount = this.getSliceMemberCount(edge, slice);
        if (sliceMemberCount < (layerCount = layer + 1)) {
            layerCount = sliceMemberCount;
        }
        for (int i = 0; i < layerCount; i += this.getMemberDepth(edge, i, slice)) {
            Object member = this.getMemberMetadata(edge, i, slice, "value");
            String layerName = (String)this.getLayerMetadata(edge, i, "layerName");
            qdr.addDimMemberPair(layerName, member == null ? null : member.toString());
        }
        return qdr;
    }

    public QDR getMemberQDR(int edge, int[] hPos, int memberLayer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge != 2) {
            return null;
        }
        QDR qdr = this.createQDR();
        int layerCount = hPos.length;
        if (memberLayer + 1 < layerCount) {
            layerCount = memberLayer + 1;
        }
        for (int i = 0; i < layerCount; ++i) {
            if (hPos[i] == -1) continue;
            String layer = (String)this.getLayerMetadata(edge, i, "layerName");
            Object member = this.getMemberMetadata(edge, hPos, i, hPos[i], "value");
            qdr.addDimMemberPair(layer, member == null ? null : member.toString());
        }
        return qdr;
    }

    public QDR getLayerQDR(int edge, int layer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        QDR qdr = this.createQDR();
        try {
            if (edge != 2 && flags == 1) {
                this.addPageEdgeToQDR(qdr);
            }
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        String dim = (String)this.getLayerMetadata(edge, layer, "layerName");
        qdr.addDimMemberPair(dim, new QDRMember(1));
        return qdr;
    }

    @Override
    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    @Override
    protected String getXMLObjectType() {
        return "DataCache";
    }

    @Override
    protected String getXMLObjectName() {
        return CACHED_DATA;
    }

    @Override
    protected Edge createRowColumnEdge(ObjectNode edgeNode, boolean outline, Data data, Map metadataMap, Map layerMap) {
        return new RowColumnEdge(edgeNode, outline, data, metadataMap, layerMap);
    }

    @Override
    protected Edge createRowColumnEdge(DataAccess da, boolean outline, int edge, Map metadataMap, Map layerMap, int limit) {
        return new RowColumnEdge(da, outline, edge, metadataMap, layerMap, limit);
    }

    @Override
    protected int getInitialRowCount() {
        return 1;
    }

    @Override
    protected int getEdgeExtent(ObjectNode edge) throws NoSuchPropertyException {
        return edge.getPropertyValueAsInteger(EXTENT);
    }

    @Override
    protected MetadataMap getDefaultSupportedMetadataMap() {
        return new MetadataMap(DEFAULT_SUPPORTED_METADATAMAP);
    }

    private void addPageEdgeToQDR(QDR qdr) throws EdgeOutOfRangeException, SliceOutOfRangeException, LayerOutOfRangeException {
        Edge page_edge = this.m_edges[2];
        if (page_edge == null) {
            return;
        }
        int[] hPos = page_edge.getCurrentHPos();
        for (int i = 0; i < hPos.length; ++i) {
            if (hPos[i] == -1) continue;
            String layerName = (String)page_edge.getLayerMetadata(i, "layerName");
            Object member = page_edge.getMemberMetadata(hPos, i, hPos[i], "value");
            qdr.addDimMemberPair(layerName, member == null ? null : member.toString());
        }
    }

    private void addEdgeToQDR(QDR qdr, int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, LayerOutOfRangeException {
        for (int layer = 0; layer < this.getLayerCount(edge); layer += this.getMemberDepth(edge, layer, slice)) {
            String layerName = (String)this.getLayerMetadata(edge, layer, "layerName");
            Object member = this.getMemberMetadata(edge, layer, slice, "value");
            qdr.addDimMemberPair(layerName, member == null ? null : member.toString());
        }
    }
}

