/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.io.Serializable;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.dss.dataView.Model;
import oracle.dss.gridView.GridView;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeComponentInfo;

public abstract class HeaderCell
extends AbstractPivotHeaderCell
implements Serializable {
    protected Model m_model = null;
    protected GridView m_gridView = null;
    protected int m_layer = 0;
    protected int m_slice = 0;
    protected int m_extent = 0;
    protected int m_depth = 0;
    protected transient EdgeComponentInfo info = new EdgeComponentInfo(0, 0, 0);

    public HeaderCell(GridView gridView, int layer, int depth, int slice, int extent) {
        this.m_gridView = gridView;
        this.m_model = gridView.getGridViewModel();
        this.m_layer = layer;
        this.m_depth = depth;
        this.m_slice = slice;
        this.m_extent = extent;
    }

    public int getDrillState() {
        try {
            Object value = null;
            if (this.m_gridView.isMetadataDrillSupported()) {
                value = this.m_model.getDataAccess().getMemberMetadata(this.getEdge(), this.m_layer, this.m_slice, "drillState");
            }
            if (value == null) {
                return 0;
            }
            return (Integer)value;
        }
        catch (DataException e) {
            this.m_model.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getDrillState");
            return 0;
        }
    }

    public void setData(Object data) {
    }

    public abstract Object getData();

    protected abstract int getEdge();
}

