/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalTheme;
import oracle.bali.ewt.olaf2.OracleLargeFontTheme;
import oracle.bali.ewt.olaf2.OracleTheme;

public class OracleLookAndFeel
extends PlasticXPLookAndFeel {
    public static final String OLAF2_ID = "Oracle2";
    public static final String OLAF2_NAME = "Oracle Look and Feel version 2";
    private static final OracleTheme _theme = OracleLookAndFeel._isEasternAsianLocale(Locale.getDefault()) ? new OracleLargeFontTheme() : new OracleTheme();
    private static final String _PREFIX = "oracle.bali.ewt.olaf2.Oracle";
    private static final Color _BORDER_COLOR;
    private static final Border _BOTTOM_BORDER;
    private static final ColorUIResource darkGrippy;

    public OracleLookAndFeel() {
        if (OracleLookAndFeel._getMyPlasticTheme() == null || OracleLookAndFeel._getMyPlasticTheme() == OracleLookAndFeel.createMyDefaultTheme() || OracleLookAndFeel._getMyPlasticTheme() == _theme) {
            OracleLookAndFeel.setPlasticTheme(_theme);
        }
        Options.setUseNarrowButtons(true);
        OracleLookAndFeel.setTabStyle("metal");
    }

    public static final String getCopyrightText() {
        return "JGoodies licensed from JGoodies Karsten Lentzsch Copyright (c) 2003 JGoodies Karsten Lentzsch. All rights reserved;";
    }

    @Override
    public String getID() {
        return OLAF2_ID;
    }

    @Override
    public String getName() {
        return OLAF2_NAME;
    }

    @Override
    public String getDescription() {
        return "The Oracle Look and Feel version 2";
    }

    public static OracleTheme getTheme(Locale locale) {
        if (OracleLookAndFeel._isEasternAsianLocale(locale)) {
            return new OracleLargeFontTheme();
        }
        return new OracleTheme();
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        UIDefaults.ProxyLazyValue menuBarBorder = new UIDefaults.ProxyLazyValue(OracleLookAndFeel.class.getName(), "getOlafMenuBarBorder");
        UIDefaults.ProxyLazyValue toolBarBorder = new UIDefaults.ProxyLazyValue(OracleLookAndFeel.class.getName(), "getOlafToolBarBorder");
        UIDefaults.ProxyLazyValue titledBorderBorder = new UIDefaults.ProxyLazyValue(OracleLookAndFeel.class.getName(), "getTitledBorderBorder", new Object[]{table});
        InsetsUIResource menuItemMargin = new InsetsUIResource(2, 0, 2, 0);
        InsetsUIResource menuMargin = new InsetsUIResource(2, 3, 2, 3);
        Object[] modifiedDefaults = new Object[]{"MenuBar.border", menuBarBorder, "ToolBar.border", toolBarBorder, "Button.defaultButtonFollowsFocus", Boolean.TRUE, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"}), "CheckBoxMenuItem.margin", menuItemMargin, "MenuItem.margin", menuItemMargin, "RadioButtonMenuItem.margin", menuItemMargin, "Menu.margin", menuMargin, "SplitPane.border", null, "TextArea.border", table.get("TextField.border"), "OptionPane.questionIcon", LookAndFeel.makeIcon(PlasticXPLookAndFeel.class, "icons/Question.png"), "OptionPane.errorIcon", LookAndFeel.makeIcon(PlasticXPLookAndFeel.class, "icons/Error.png"), "OptionPane.informationIcon", LookAndFeel.makeIcon(PlasticXPLookAndFeel.class, "icons/Inform.png"), "OptionPane.warningIcon", LookAndFeel.makeIcon(PlasticXPLookAndFeel.class, "icons/Warn.png"), "Tree.expandedIcon", OracleLookAndFeel.makeIcon(PlasticXPLookAndFeel.class, "icons/TreeExpanded.png"), "Tree.collapsedIcon", OracleLookAndFeel.makeIcon(PlasticXPLookAndFeel.class, "icons/TreeCollapsed.png"), "PivotTable.darkGrippy", darkGrippy, "TitledBorder.font", OracleLookAndFeel.getControlTextFont(), "TitledBorder.border", titledBorderBorder, "TitledBorder.borderColor", OracleLookAndFeel.getControlShadow(), "TextField.disabledBackground", OracleLookAndFeel.getControl(), "TextArea.disabledBackground", OracleLookAndFeel.getControl(), "PasswordField.disabledBackground", OracleLookAndFeel.getControl(), "FormattedTextField.disabledBackground", OracleLookAndFeel.getControl(), "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up", "ENTER", "approveSelection", "ctrl ENTER", "approveSelection"})};
        table.putDefaults(modifiedDefaults);
        this.initMacComponentDefaults(table);
    }

    private void initMacComponentDefaults(UIDefaults table) {
        if (!LookUtils.IS_OS_MAC) {
            return;
        }
        Object[] extraMacTextBindings = new Object[]{"meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "meta X", "cut-to-clipboard", "meta A", "select-all", "meta RIGHT", "caret-end-line", "meta LEFT", "caret-begin-line", "meta UP", "caret-begin", "meta DOWN", "caret-end", "shift meta RIGHT", "selection-end-line", "shift meta LEFT", "selection-begin-line", "shift meta UP", "selection-begin", "shift meta DOWN", "selection-end"};
        Object map = this.lookupDefault(table, "TextField.focusInputMap");
        if (map != null && map instanceof UIDefaults.LazyInputMap) {
            WrappedLazyInputMap fieldInputMap = new WrappedLazyInputMap((UIDefaults.LazyInputMap)map, extraMacTextBindings);
            WrappedLazyInputMap textAreaInputMap = new WrappedLazyInputMap((UIDefaults.LazyInputMap)this.lookupDefault(table, "TextArea.focusInputMap"), extraMacTextBindings);
            WrappedLazyInputMap textPaneInputMap = new WrappedLazyInputMap((UIDefaults.LazyInputMap)this.lookupDefault(table, "TextPane.focusInputMap"), extraMacTextBindings);
            WrappedLazyInputMap editorInputMap = new WrappedLazyInputMap((UIDefaults.LazyInputMap)this.lookupDefault(table, "EditorPane.focusInputMap"), extraMacTextBindings);
            WrappedLazyInputMap passwordInputMap = new WrappedLazyInputMap((UIDefaults.LazyInputMap)this.lookupDefault(table, "PasswordField.focusInputMap"), extraMacTextBindings);
            WrappedLazyInputMap formattedInputMap = new WrappedLazyInputMap((UIDefaults.LazyInputMap)this.lookupDefault(table, "FormattedTextField.focusInputMap"), extraMacTextBindings);
            Object[] modifiedMacDefaults = new Object[]{"TextField.focusInputMap", fieldInputMap, "TextArea.focusInputMap", textAreaInputMap, "TextPane.focusInputMap", textPaneInputMap, "EditorPane.focusInputMap", editorInputMap, "PasswordField.focusInputMap", passwordInputMap, "FormattedTextField.focusInputMap", formattedInputMap};
            table.putDefaults(modifiedMacDefaults);
        }
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        Object[] modifiedDefaults = new Object[]{"FormattedTextFieldUI", "oracle.bali.ewt.olaf2.OracleFormattedTextFieldUI", "FileChooserUI", "oracle.bali.ewt.olaf2.OracleFileChooserUI", "ListUI", "oracle.bali.ewt.olaf2.OracleListUI", "OptionPaneUI", "oracle.bali.ewt.olaf2.OracleOptionPaneUI", "PasswordFieldUI", "oracle.bali.ewt.olaf2.OraclePasswordFieldUI", "TextAreaUI", "oracle.bali.ewt.olaf2.OracleTextAreaUI", "TextFieldUI", "oracle.bali.ewt.olaf2.OracleTextFieldUI", "ButtonUI", "oracle.bali.ewt.olaf2.OracleButtonUI", "RadioButtonUI", "oracle.bali.ewt.olaf2.OracleRadioButtonUI", "CheckBoxUI", "oracle.bali.ewt.olaf2.OracleCheckBoxUI", "SplitPaneUI", "oracle.bali.ewt.olaf2.OracleSplitPaneUI", "ScrollBarUI", "oracle.bali.ewt.olaf2.OracleScrollBarUI", "LabelUI", "oracle.bali.ewt.olaf2.OracleLabelUI", "RootPaneUI", "oracle.bali.ewt.olaf2.OracleRootPaneUI", "ScrollPaneUI", "oracle.bali.ewt.olaf2.OracleScrollPaneUI"};
        table.putDefaults(modifiedDefaults);
        if ("metal".equalsIgnoreCase(OracleLookAndFeel.getTabStyle())) {
            table.put("TabbedPaneUI", "oracle.bali.ewt.olaf2.OracleTabbedPaneUI");
        }
    }

    public static Border getOlafMenuBarBorder() {
        Border outerBorder = _BOTTOM_BORDER;
        Border innerBorder = BorderFactory.createEmptyBorder(0, 1, 0, 1);
        return new BorderUIResource.CompoundBorderUIResource(outerBorder, innerBorder);
    }

    public static Border getOlafToolBarBorder() {
        Border outerBorder = _BOTTOM_BORDER;
        Border innerBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        return new BorderUIResource.CompoundBorderUIResource(outerBorder, innerBorder);
    }

    public static Border getTitledBorderBorder(UIDefaults table) {
        return new BorderUIResource.LineBorderUIResource(table.getColor("TitledBorder.borderColor"));
    }

    private static PlasticTheme _getMyPlasticTheme() {
        MetalTheme metaltheme = OracleLookAndFeel.getCurrentTheme();
        if (metaltheme instanceof PlasticTheme) {
            return (PlasticTheme)metaltheme;
        }
        return null;
    }

    private static boolean _isEasternAsianLocale(Locale locale) {
        boolean isEALocale = Locale.JAPAN.equals(locale) || Locale.KOREA.equals(locale) || Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale) || Locale.JAPANESE.equals(locale) || Locale.TRADITIONAL_CHINESE.equals(locale) || Locale.TAIWAN.equals(locale);
        return isEALocale;
    }

    private Object lookupDefault(UIDefaults table, Object key) {
        Set entrySet = table.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!key.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        OracleLookAndFeel.installTheme(_theme);
        if (OracleLookAndFeel._getMyPlasticTheme() == null) {
            OracleLookAndFeel.setPlasticTheme(_theme);
        }
        _BORDER_COLOR = new Color(150, 150, 150);
        _BOTTOM_BORDER = new MenuBarBorder();
        darkGrippy = new ColorUIResource(74, 77, 66);
    }

    private static class WrappedLazyInputMap
    implements UIDefaults.LazyValue {
        private final UIDefaults.LazyInputMap wrappedMap;
        private final Object[] bindings;

        public WrappedLazyInputMap(UIDefaults.LazyInputMap wrappedMap, Object[] bindings) {
            this.wrappedMap = wrappedMap;
            this.bindings = bindings;
        }

        @Override
        public Object createValue(UIDefaults table) {
            InputMap km = (InputMap)this.wrappedMap.createValue(table);
            if (km != null && this.bindings != null) {
                InputMap km2 = LookAndFeel.makeInputMap(this.bindings);
                for (KeyStroke key : km2.keys()) {
                    km.put(key, km2.get(key));
                }
            }
            return km;
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets _BORDER_INSETS = new Insets(0, 0, 1, 0);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(_BORDER_COLOR);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            return _BORDER_INSETS;
        }
    }
}

