/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRootPaneUI;

public final class OracleRootPaneUI
extends MetalRootPaneUI {
    private static final Dimension _RESIZE_SIZE = new Dimension(9, 9);
    private static final Dimension _EMPTY_SIZE = new Dimension(0, 0);
    private static final Stroke _THICK_STROKE = new BasicStroke(2.0f);
    private static final Stroke _THIN_STROKE = new BasicStroke(1.0f);
    private Window _window;
    private ResizeComponent _resizeComponent;
    private ContainerListener _conListener;
    private ComponentListener _compListener;
    private RootWindowListener _windowListener;

    public static ComponentUI createUI(JComponent comp) {
        return new OracleRootPaneUI();
    }

    @Override
    public void installUI(JComponent comp) {
        super.installUI(comp);
        this._installWindow(comp);
        comp.addPropertyChangeListener("ancestor", this._getWindowParentListener());
    }

    @Override
    public void uninstallUI(JComponent comp) {
        super.uninstallUI(comp);
        this._uninstallWindow(comp);
        comp.removePropertyChangeListener("ancestor", this._getWindowParentListener());
    }

    private void _installWindow(JComponent comp) {
        Container parent = comp.getParent();
        if (parent != null && (parent instanceof Frame || parent instanceof Dialog)) {
            this._window = (Window)parent;
            this._addResizeComponentToLayeredPane(((JRootPane)comp).getLayeredPane());
            comp.addContainerListener(this._getRootPaneContainerListener());
        }
    }

    private void _uninstallWindow(JComponent comp) {
        this._removeResizeComponentFromLayeredPane(((JRootPane)comp).getLayeredPane());
        comp.removeContainerListener(this._getRootPaneContainerListener());
        this._window = null;
    }

    private void _addResizeComponentToLayeredPane(JLayeredPane lPane) {
        ResizeComponent rc;
        if (lPane != null && (rc = this._getResizeComponent()).getParent() != lPane) {
            lPane.add((Component)rc, new Integer(-100));
            lPane.addComponentListener(this._getResizeCompListener());
        }
    }

    private void _removeResizeComponentFromLayeredPane(JLayeredPane lPane) {
        lPane.remove(this._getResizeComponent());
        lPane.removeComponentListener(this._getResizeCompListener());
    }

    private static Window _getWindowForEvent(MouseEvent ev) {
        Component source = (Component)ev.getSource();
        return source instanceof Window ? (Window)source : SwingUtilities.getWindowAncestor(source);
    }

    private ResizeComponent _getResizeComponent() {
        if (this._resizeComponent == null) {
            this._resizeComponent = new ResizeComponent();
        }
        return this._resizeComponent;
    }

    private ComponentListener _getResizeCompListener() {
        if (this._compListener == null) {
            this._compListener = new ResizeCompListener();
        }
        return this._compListener;
    }

    private boolean _isResizable() {
        int fState;
        Frame f = null;
        Dialog d = null;
        if (this._window instanceof Frame) {
            f = (Frame)this._window;
        } else if (this._window instanceof Dialog) {
            d = (Dialog)this._window;
        }
        if (f == null && d == null) {
            return false;
        }
        int n = fState = f != null ? f.getExtendedState() : 0;
        return f != null && f.isResizable() && (fState & 6) == 0 || d != null && d.isResizable();
    }

    private ContainerListener _getRootPaneContainerListener() {
        if (this._conListener == null) {
            this._conListener = new RootPaneContainerListener();
        }
        return this._conListener;
    }

    private RootWindowListener _getWindowParentListener() {
        if (this._windowListener == null) {
            this._windowListener = new RootWindowListener();
        }
        return this._windowListener;
    }

    private class RootWindowListener
    implements PropertyChangeListener {
        private RootWindowListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            OracleRootPaneUI.this._installWindow((JComponent)e.getSource());
        }
    }

    private class RootPaneContainerListener
    implements ContainerListener {
        private RootPaneContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof JLayeredPane && OracleRootPaneUI.this._window != null) {
                OracleRootPaneUI.this._addResizeComponentToLayeredPane((JLayeredPane)c);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof JLayeredPane) {
                OracleRootPaneUI.this._removeResizeComponentFromLayeredPane((JLayeredPane)c);
            }
        }
    }

    private class ResizeCompListener
    extends ComponentAdapter {
        private ResizeCompListener() {
        }

        @Override
        public void componentResized(ComponentEvent ce) {
            int width = ce.getComponent().getWidth();
            int height = ce.getComponent().getHeight();
            OracleRootPaneUI.this._getResizeComponent().setLocation(width - _RESIZE_SIZE.width, height - _RESIZE_SIZE.height);
        }
    }

    private class ResizeComponent
    extends JComponent {
        private int _dragX;
        private int _dragY;
        private int _dragWidth;
        private int _dragHeight;
        private int _minWidth;
        private int _minHeight;

        public ResizeComponent() {
            this.setSize(_RESIZE_SIZE);
            this.enableEvents(48L);
        }

        @Override
        public Cursor getCursor() {
            if (!OracleRootPaneUI.this._isResizable()) {
                return super.getCursor();
            }
            return Cursor.getPredefinedCursor(5);
        }

        @Override
        public Dimension getPreferredSize() {
            if (!OracleRootPaneUI.this._isResizable()) {
                return _EMPTY_SIZE;
            }
            return _RESIZE_SIZE;
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (!OracleRootPaneUI.this._isResizable()) {
                return;
            }
            switch (me.getID()) {
                case 501: {
                    this._handleMousePressed(me);
                    break;
                }
                case 502: {
                    this._handleMouseReleased(me);
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent me) {
            super.processMouseMotionEvent(me);
            if (!OracleRootPaneUI.this._isResizable()) {
                return;
            }
            if (me.getID() == 506) {
                this._handleMouseDragged(me);
            } else {
                this._handleMouseMoved(me);
            }
        }

        @Override
        public void paint(Graphics g) {
            if (!OracleRootPaneUI.this._isResizable()) {
                return;
            }
            super.paint(g);
        }

        @Override
        public int getWidth() {
            if (!OracleRootPaneUI.this._isResizable()) {
                return -1;
            }
            return super.getWidth();
        }

        @Override
        public int getHeight() {
            if (!OracleRootPaneUI.this._isResizable()) {
                return -1;
            }
            return super.getHeight();
        }

        @Override
        public void paintComponent(Graphics g) {
            Color dark = UIManager.getColor("controlShadow");
            Graphics2D g2 = (Graphics2D)g.create();
            int width = this.getWidth();
            int height = this.getHeight();
            for (int i = 1; i <= 3; ++i) {
                g2.setColor(dark);
                g2.setStroke(_THICK_STROKE);
                g2.drawLine(width - i * 3 + 2, height - 1, width - 1, height - i * 3 + 2);
                g2.setColor(Color.white);
                g2.setStroke(_THIN_STROKE);
                g2.drawLine(width - i * 3, height - 1, width - 1, height - i * 3);
            }
            g2.dispose();
        }

        private void _handleMousePressed(MouseEvent me) {
            Window w = OracleRootPaneUI._getWindowForEvent(me);
            Point p = SwingUtilities.convertPoint(this, me.getPoint(), w);
            this._dragX = p.x;
            this._dragWidth = w.getWidth();
            this._dragY = p.y;
            this._dragHeight = w.getHeight();
            Dimension dim = w.getMinimumSize();
            this._minWidth = Math.min(dim.width, this._dragWidth);
            this._minHeight = Math.min(dim.height, this._dragHeight);
        }

        private void _handleMouseReleased(MouseEvent me) {
            Window w = OracleRootPaneUI._getWindowForEvent(me);
            if (w != null && !w.isValid()) {
                w.validate();
                this.getRootPane().repaint();
            }
            this._minWidth = -1;
            this._minHeight = -1;
        }

        private void _handleMouseDragged(MouseEvent me) {
            Window w = OracleRootPaneUI._getWindowForEvent(me);
            Point p = SwingUtilities.convertPoint(this, me.getPoint(), w);
            int originalWidth = p.x;
            int width = originalWidth + (this._dragWidth - this._dragX);
            int originalHeight = p.y;
            int height = originalHeight + (this._dragHeight - this._dragY);
            width = Math.max(this._minWidth, width);
            height = Math.max(this._minHeight, height);
            w.setSize(width, height);
            if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                w.validate();
                this.getRootPane().repaint();
            }
        }

        private void _handleMouseMoved(MouseEvent me) {
            this.setCursor(this.getCursor());
        }
    }
}

