/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import oracle.javatools.db.Database;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeStackFrameInfo;

final class DebugProbeBackTrace {
    DebugProbe dp;
    int stackDepth;
    DebugProbeStackFrameInfo[] stackFrames;

    DebugProbeBackTrace(DebugProbe debugProbe) {
        this.dp = debugProbe;
    }

    void clear() {
        if (this.stackFrames != null) {
            for (int i = 0; i < this.stackDepth; ++i) {
                this.stackFrames[i].clear();
            }
        }
        this.stackDepth = 0;
        this.stackFrames = null;
    }

    static String code(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append(DebugProbeStackFrameInfo.code(string + "(" + i + ")"));
        }
        return stringBuffer.toString();
    }

    static int registerParameters(int n, CallableStatement callableStatement, int n2) throws Exception {
        for (int i = n - 1; i >= 0; --i) {
            n2 = DebugProbeStackFrameInfo.registerParameters(callableStatement, n2);
        }
        return n2;
    }

    int getParameters(int n, CallableStatement callableStatement, int n2) throws Exception {
        int n3;
        ArrayList<DebugProbeStackFrameInfo> arrayList = new ArrayList<DebugProbeStackFrameInfo>();
        int n4 = 1;
        for (n3 = n - 1; n3 >= 0; --n3) {
            DebugProbeStackFrameInfo debugProbeStackFrameInfo = new DebugProbeStackFrameInfo(this.dp, n3, n4);
            n2 = debugProbeStackFrameInfo.getParameters(callableStatement, n2);
            if (!debugProbeStackFrameInfo.location.isAnonymousBlock()) {
                arrayList.add(0, debugProbeStackFrameInfo);
            }
            ++n4;
        }
        this.stackDepth = n = arrayList.size();
        this.stackFrames = new DebugProbeStackFrameInfo[n];
        for (n3 = 0; n3 < n; ++n3) {
            this.stackFrames[n3] = (DebugProbeStackFrameInfo)arrayList.get(n3);
            this.stackFrames[n3].frameNumber = n3;
        }
        return n2;
    }

    String dump(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append("\n");
        for (int i = 0; i < this.stackDepth; ++i) {
            stringBuffer.append(this.stackFrames[i].dump(string + "  ", "stackFrames[" + i + "]"));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fill(Database database, int n) {
        if (this.stackFrames == null && this.dp.checkVersion(2, 1) && n > 0) {
            try {
                Connection connection = database.getConnection();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DECLARE\n");
                stringBuffer.append("  backtrace   DBMS_DEBUG.backtrace_table;\n");
                stringBuffer.append("begin\n");
                stringBuffer.append("  DBMS_DEBUG.print_backtrace(backtrace);\n");
                stringBuffer.append(DebugProbeBackTrace.code(n, "backtrace"));
                stringBuffer.append("end; ");
                String string = stringBuffer.toString();
                try (CallableStatement callableStatement = connection.prepareCall(string);){
                    DebugProbeBackTrace.registerParameters(n, callableStatement, 1);
                    callableStatement.execute();
                    this.getParameters(n, callableStatement, 1);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    DebugProbeStackFrameInfo[] listStack() {
        return this.stackFrames;
    }

    int getStackFrameCount() {
        return this.stackDepth;
    }

    DebugProbeStackFrameInfo getStackFrame(int n) {
        if (n < this.stackDepth) {
            return this.stackFrames[n];
        }
        return null;
    }
}

